/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.set;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.alter.set.AlterResourcePlanSetDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={806})
public class AlterResourcePlanSetAnalyzer
extends BaseSemanticAnalyzer {
    public AlterResourcePlanSetAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        String resourcePlanName = AlterResourcePlanSetAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        Integer queryParallelism = null;
        String defaultPool = null;
        block4: for (int i = 1; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            switch (child.getType()) {
                case 1011: {
                    if (child.getChildCount() != 1) {
                        throw new SemanticException("Expected one argument");
                    }
                    queryParallelism = Integer.parseInt(child.getChild(0).getText());
                    continue block4;
                }
                case 854: {
                    if (child.getChildCount() != 1) {
                        throw new SemanticException("Expected one argument");
                    }
                    defaultPool = WMUtils.poolPath(child.getChild(0));
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unexpected token in alter resource plan statement: " + child.getType());
                }
            }
        }
        AlterResourcePlanSetDesc desc = new AlterResourcePlanSetDesc(resourcePlanName, queryParallelism, defaultPool);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

