/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.pool.drop;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.pool.drop.AlterPoolDropTriggerDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={801})
public class AlterPoolDropTriggerAnalyzer
extends BaseSemanticAnalyzer {
    public AlterPoolDropTriggerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() != 3) {
            throw new SemanticException("Invalid syntax for alter pool add trigger: " + root.toStringTree());
        }
        String resourcePlanName = AlterPoolDropTriggerAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String poolPath = root.getChild(1).getType() == 1150 ? null : WMUtils.poolPath(root.getChild(1));
        String triggerName = AlterPoolDropTriggerAnalyzer.unescapeIdentifier(root.getChild(2).getText());
        AlterPoolDropTriggerDesc desc = new AlterPoolDropTriggerDesc(resourcePlanName, triggerName, poolPath);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

