/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class FooterBuffer {
    private ArrayList<Pair<WritableComparable, Writable>> buffer;
    private int cur;

    public void setCursor(int cur) {
        this.cur = cur;
    }

    public boolean initializeBuffer(JobConf job, RecordReader recordreader, int footerCount, WritableComparable key, Writable value) throws IOException {
        this.buffer = new ArrayList();
        while (this.buffer.size() < footerCount) {
            boolean notEOF = recordreader.next((Object)key, (Object)value);
            if (!notEOF) {
                return false;
            }
            WritableComparable left = (WritableComparable)ReflectionUtils.copy((Configuration)job, (Object)key, null);
            Writable right = (Writable)ReflectionUtils.copy((Configuration)job, (Object)value, null);
            Pair<WritableComparable, Writable> tem = Pair.of(left, right);
            this.buffer.add(tem);
        }
        this.cur = 0;
        return true;
    }

    public boolean updateBuffer(JobConf job, RecordReader recordreader, WritableComparable key, Writable value) throws IOException {
        key = (WritableComparable)ReflectionUtils.copy((Configuration)job, (Object)this.buffer.get(this.cur).getKey(), (Object)key);
        value = (Writable)ReflectionUtils.copy((Configuration)job, (Object)this.buffer.get(this.cur).getValue(), (Object)value);
        boolean notEOF = recordreader.next((Object)this.buffer.get(this.cur).getLeft(), (Object)this.buffer.get(this.cur).getValue());
        if (notEOF) {
            ++this.cur;
            this.cur %= this.buffer.size();
        }
        return notEOF;
    }
}

