/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;

public final class TopNKeyFilter {
    private final int topN;
    private Comparator<? extends KeyWrapper> comparator;
    private KeyWrapper[] sortedTopItems;
    private int size = 0;
    private long repeated = 0L;
    private long added = 0L;
    private long total = 0L;
    private long eff = 0L;
    private final Set<KeyWrapper> topNKeySet;

    public TopNKeyFilter(int topN, Comparator<? extends KeyWrapper> comparator) {
        this.comparator = comparator;
        this.sortedTopItems = new KeyWrapper[topN + 1];
        this.topN = topN;
        this.topNKeySet = new HashSet<KeyWrapper>();
    }

    private int compareWithBoundary(KeyWrapper kw) {
        return this.comparator.compare(kw, this.sortedTopItems[this.topN - 1]);
    }

    public final boolean canForward(KeyWrapper kw) {
        ++this.total;
        if (this.topN > 0 && this.size == this.topN) {
            int comp = this.compareWithBoundary(kw);
            if (comp == 0) {
                ++this.eff;
                return true;
            }
            if (comp > 0) {
                ++this.eff;
                return false;
            }
        }
        if (this.topNKeySet.contains(kw)) {
            ++this.repeated;
            return true;
        }
        int pos = Arrays.binarySearch(this.sortedTopItems, 0, this.size, kw, this.comparator);
        if (pos >= 0) {
            ++this.repeated;
            return true;
        }
        if ((pos = -pos - 1) >= this.topN) {
            return false;
        }
        KeyWrapper oldElement = this.sortedTopItems[pos];
        System.arraycopy(this.sortedTopItems, pos, this.sortedTopItems, pos + 1, this.size - pos);
        this.sortedTopItems[pos] = kw.copyKey();
        this.topNKeySet.remove(oldElement);
        this.topNKeySet.add(this.sortedTopItems[pos]);
        ++this.added;
        if (this.size < this.topN) {
            ++this.size;
        }
        return true;
    }

    public void clear() {
        this.size = 0;
        this.repeated = 0L;
        this.added = 0L;
        this.total = 0L;
        Arrays.fill(this.sortedTopItems, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopNKeyFilter{");
        sb.append("id=").append(super.toString());
        sb.append(", topN=").append(this.topN);
        sb.append(", repeated=").append(this.repeated);
        sb.append(", added=").append(this.added);
        sb.append(", eff=").append(this.eff);
        sb.append(", total=").append(this.total);
        sb.append(", forwardingRatio=").append(this.forwardingRatio());
        sb.append('}');
        return sb.toString();
    }

    @VisibleForTesting
    long getEffectiveBoundaryChecks() {
        return this.eff;
    }

    @VisibleForTesting
    long getRepeated() {
        return this.repeated;
    }

    @VisibleForTesting
    long getKeySetSize() {
        return this.topNKeySet.size();
    }

    public float forwardingRatio() {
        if (this.total == 0L) {
            return 0.0f;
        }
        return (float)(this.repeated + this.added) / (float)this.total;
    }

    public long getTotal() {
        return this.total;
    }
}

