/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

public class MapJoinObjectSerDeContext {
    private final ObjectInspector standardOI;
    private final AbstractSerDe serde;
    private final boolean hasFilter;

    public MapJoinObjectSerDeContext(AbstractSerDe serde, boolean hasFilter) throws SerDeException {
        this.serde = serde;
        this.hasFilter = hasFilter;
        this.standardOI = ObjectInspectorUtils.getStandardObjectInspector(serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    public ObjectInspector getStandardOI() {
        return this.standardOI;
    }

    public AbstractSerDe getSerDe() {
        return this.serde;
    }

    public boolean hasFilterTag() {
        return this.hasFilter;
    }

    public String stringify() {
        StandardStructObjectInspector standardStructOI = (StandardStructObjectInspector)this.standardOI;
        List<? extends StructField> structFields = standardStructOI.getAllStructFieldRefs();
        ArrayList<String> typeInfoStrings = new ArrayList<String>();
        for (StructField structField : structFields) {
            ObjectInspector fieldOI = structField.getFieldObjectInspector();
            typeInfoStrings.add(fieldOI.getTypeName());
        }
        return "[types " + ((Object)typeInfoStrings).toString() + ", serde=" + this.serde.getClass().getName() + ", hasFilter=" + this.hasFilter + "]";
    }

    public String toString() {
        return "MapJoinObjectSerDeContext [standardOI=" + this.standardOI + ", serde=" + this.serde + ", hasFilter=" + this.hasFilter + "]";
    }
}

