/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Atlas Meta Data Dump Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AtlasDumpWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String srcDB;
    private final Path stagingDir;
    private final boolean bootstrap;
    private final Path prevAtlasDumpDir;
    private final transient ReplicationMetricCollector metricCollector;

    public AtlasDumpWork(String srcDB, Path stagingDir, boolean bootstrap, Path prevAtlasDumpDir, ReplicationMetricCollector metricCollector) {
        this.srcDB = srcDB;
        this.stagingDir = stagingDir;
        this.bootstrap = bootstrap;
        this.prevAtlasDumpDir = prevAtlasDumpDir;
        this.metricCollector = metricCollector;
    }

    public boolean isBootstrap() {
        return this.bootstrap;
    }

    public Path getPrevAtlasDumpDir() {
        return this.prevAtlasDumpDir;
    }

    public String getSrcDB() {
        return this.srcDB;
    }

    public Path getStagingDir() {
        return this.stagingDir;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }
}

