/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.DirCopyWork;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirCopyTask
extends Task<DirCopyWork>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DirCopyTask.class);

    private boolean createAndSetPathOwner(Path destPath, Path sourcePath) throws IOException {
        FileStatus status;
        FileSystem targetFs = destPath.getFileSystem((Configuration)this.conf);
        boolean createdDir = false;
        if (!targetFs.exists(destPath)) {
            if (!targetFs.mkdirs(destPath)) {
                throw new IOException(ErrorMsg.REPL_FILE_SYSTEM_OPERATION_RETRY.format(destPath + " is not a directory or unable to create one"));
            }
            createdDir = true;
        }
        try {
            status = sourcePath.getFileSystem((Configuration)this.conf).getFileStatus(sourcePath);
        }
        catch (FileNotFoundException e) {
            LOG.warn("source path missing " + sourcePath);
            return createdDir;
        }
        LOG.info("Setting permission for path dest {} from source {} owner {} : {} : {}", new Object[]{destPath, sourcePath, status.getOwner(), status.getGroup(), status.getPermission()});
        destPath.getFileSystem((Configuration)this.conf).setOwner(destPath, status.getOwner(), status.getGroup());
        destPath.getFileSystem((Configuration)this.conf).setPermission(destPath, status.getPermission());
        return createdDir;
    }

    private boolean setTargetPathOwner(Path targetPath, Path sourcePath, UserGroupInformation proxyUser) throws IOException, InterruptedException {
        if (proxyUser == null) {
            return this.createAndSetPathOwner(targetPath, sourcePath);
        }
        return (Boolean)proxyUser.doAs(() -> this.createAndSetPathOwner(targetPath, sourcePath));
    }

    private boolean checkIfPathExist(Path sourcePath, UserGroupInformation proxyUser) throws Exception {
        if (proxyUser == null) {
            return sourcePath.getFileSystem((Configuration)this.conf).exists(sourcePath);
        }
        return (Boolean)proxyUser.doAs(() -> sourcePath.getFileSystem((Configuration)this.conf).exists(sourcePath));
    }

    @Override
    public int execute() {
        String distCpDoAsUser = this.conf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> {
                Path targetPath;
                Path sourcePath;
                UserGroupInformation proxyUser;
                block9: {
                    Integer n2;
                    block10: {
                        proxyUser = null;
                        sourcePath = ((DirCopyWork)this.work).getFullyQualifiedSourcePath();
                        targetPath = ((DirCopyWork)this.work).getFullyQualifiedTargetPath();
                        try {
                            if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_ADD_RAW_RESERVED_NAMESPACE)) {
                                sourcePath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).getFullyQualifiedSourcePath().toUri());
                                targetPath = DirCopyTask.reservedRawPath(((DirCopyWork)this.work).getFullyQualifiedTargetPath().toUri());
                            }
                            UserGroupInformation ugi = Utils.getUGI();
                            String currentUser = ugi.getShortUserName();
                            if (distCpDoAsUser != null && !currentUser.equals(distCpDoAsUser)) {
                                proxyUser = UserGroupInformation.createProxyUser((String)distCpDoAsUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                            }
                            this.setTargetPathOwner(targetPath, sourcePath, proxyUser);
                            try {
                                if (this.checkIfPathExist(sourcePath, proxyUser)) break block9;
                                LOG.info("Source path is missing. Ignoring exception.");
                                n2 = 0;
                                if (proxyUser == null) break block10;
                            }
                            catch (Exception ex) {
                                LOG.warn("Source path missing check failed. ", (Throwable)ex);
                                throw new IOException(ex);
                            }
                        }
                        catch (Throwable throwable) {
                            if (proxyUser != null) {
                                FileSystem.closeAllForUGI(proxyUser);
                            }
                            throw throwable;
                        }
                        FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                    }
                    return n2;
                }
                FileUtils.distCp(sourcePath.getFileSystem((Configuration)this.conf), Collections.singletonList(sourcePath), targetPath, false, proxyUser, this.conf, ShimLoader.getHadoopShims());
                Integer n = 0;
                if (proxyUser != null) {
                    FileSystem.closeAllForUGI((UserGroupInformation)proxyUser);
                }
                return n;
            });
        }
        catch (Exception e) {
            LOG.error("Replication failed ", (Throwable)e);
            SecurityException ex = new SecurityException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), e);
            this.setException(ex);
            return ReplUtils.handleException(true, ex, ((DirCopyWork)this.work).getDumpDirectory(), ((DirCopyWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    private static Path reservedRawPath(URI uri) {
        return new Path(uri.getScheme(), uri.getAuthority(), "/.reserved/raw/" + uri.getPath());
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    @Override
    public String getName() {
        return "DIR_COPY_TASK";
    }

    @Override
    public boolean canExecuteInParallel() {
        return true;
    }
}

