/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.repl.util.StringConvertibleObject;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="HDFS Copy Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DirCopyWork
implements Serializable,
StringConvertibleObject {
    private static final String URI_SEPARATOR = "#";
    private static final long serialVersionUID = 1L;
    private Path fullyQualifiedSourcePath;
    private Path fullyQualifiedTargetPath;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public DirCopyWork(ReplicationMetricCollector metricCollector, String dumpDirectory) {
        this.metricCollector = metricCollector;
        this.dumpDirectory = dumpDirectory;
    }

    public DirCopyWork(Path fullyQualifiedSourcePath, Path fullyQualifiedTargetPath) {
        this.fullyQualifiedSourcePath = fullyQualifiedSourcePath;
        this.fullyQualifiedTargetPath = fullyQualifiedTargetPath;
    }

    public String toString() {
        return "DirCopyWork{fullyQualifiedSourcePath=" + this.getFullyQualifiedSourcePath() + ", fullyQualifiedTargetPath=" + this.getFullyQualifiedTargetPath() + '}';
    }

    public Path getFullyQualifiedSourcePath() {
        return this.fullyQualifiedSourcePath;
    }

    public Path getFullyQualifiedTargetPath() {
        return this.fullyQualifiedTargetPath;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    @Override
    public String convertToString() {
        StringBuilder objInStr = new StringBuilder();
        objInStr.append(this.fullyQualifiedSourcePath).append(URI_SEPARATOR).append(this.fullyQualifiedTargetPath);
        return objInStr.toString();
    }

    @Override
    public void loadFromString(String objectInStr) {
        String[] paths = objectInStr.split(URI_SEPARATOR);
        this.fullyQualifiedSourcePath = new Path(paths[0]);
        this.fullyQualifiedTargetPath = new Path(paths[1]);
    }
}

