/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.atlas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AttributeTransform;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.type.AtlasType;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRequestBuilder.class);
    public static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    static final String ATLAS_TYPE_HIVE_DB = "hive_db";
    static final String ATLAS_TYPE_HIVE_SD = "hive_storagedesc";
    static final String QUALIFIED_NAME_FORMAT = "%s@%s";
    private static final String ATTRIBUTE_NAME_CLUSTER_NAME = ".clusterName";
    private static final String ATTRIBUTE_NAME_NAME = ".name";
    private static final String ATTRIBUTE_NAME_REPLICATED_TO = "replicatedTo";
    private static final String ATTRIBUTE_NAME_REPLICATED_FROM = "replicatedFrom";
    private static final String ATTRIBUTE_NAME_LOCATION = ".location";
    private static final String HIVE_DB_CLUSTER_NAME = "hive_db.clusterName";
    private static final String HIVE_DB_NAME = "hive_db.name";
    private static final String HIVE_DB_LOCATION = "hive_db.location";
    private static final String HIVE_SD_LOCATION = "hive_storagedesc.location";
    private static final String TRANSFORM_ENTITY_SCOPE = "__entity";
    private static final String REPLICATED_TAG_NAME = "%s_replicated";

    public AtlasExportRequest createExportRequest(AtlasReplInfo atlasReplInfo, String srcAtlasServer) {
        List<AtlasObjectId> itemsToExport = this.getItemsToExport(atlasReplInfo, srcAtlasServer);
        Map<String, Object> options = this.getOptions(atlasReplInfo);
        return this.createRequest(itemsToExport, options);
    }

    private List<AtlasObjectId> getItemsToExport(AtlasReplInfo atlasReplInfo, String srcAtlasServerName) {
        ArrayList<AtlasObjectId> atlasObjectIds = new ArrayList<AtlasObjectId>();
        String qualifiedName = this.getQualifiedName(srcAtlasServerName, atlasReplInfo.getSrcDB());
        atlasObjectIds.add(new AtlasObjectId(ATLAS_TYPE_HIVE_DB, ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName));
        return atlasObjectIds;
    }

    private AtlasExportRequest createRequest(final List<AtlasObjectId> itemsToExport, final Map<String, Object> options) {
        AtlasExportRequest request = new AtlasExportRequest(){
            {
                this.setItemsToExport(itemsToExport);
                this.setOptions(options);
            }
        };
        LOG.debug("createRequest: {}" + request);
        return request;
    }

    private Map<String, Object> getOptions(AtlasReplInfo atlasReplInfo) {
        String targetCluster = atlasReplInfo.getTgtCluster();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("fetchType", "incremental");
        options.put("changeMarker", atlasReplInfo.getTimeStamp());
        options.put("skipLineage", true);
        if (targetCluster != null && !targetCluster.isEmpty()) {
            options.put(ATTRIBUTE_NAME_REPLICATED_TO, targetCluster);
        }
        return options;
    }

    public AtlasObjectId getItemToExport(String srcCluster, String srcDB) {
        String qualifiedName = this.getQualifiedName(srcCluster, srcDB);
        return new AtlasObjectId(ATLAS_TYPE_HIVE_DB, ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName);
    }

    private String getQualifiedName(String clusterName, String srcDb) {
        String qualifiedName = String.format(QUALIFIED_NAME_FORMAT, srcDb.toLowerCase(), clusterName);
        LOG.debug("Atlas getQualifiedName: {}", (Object)qualifiedName);
        return qualifiedName;
    }

    public AtlasImportRequest createImportRequest(String sourceDataSet, String targetDataSet, String sourceClusterName, String targetClusterName, String sourceFsEndpoint, String targetFsEndpoint) {
        AtlasImportRequest request = new AtlasImportRequest();
        this.addTransforms(request.getOptions(), sourceClusterName, targetClusterName, sourceDataSet, targetDataSet, sourceFsEndpoint, targetFsEndpoint);
        this.addReplicatedFrom(request.getOptions(), sourceClusterName);
        LOG.debug("Atlas metadata import request: {}" + request);
        return request;
    }

    private void addTransforms(Map<String, String> options, String srcClusterName, String tgtClusterName, String sourceDataSet, String targetDataSet, String sourcefsEndpoint, String targetFsEndpoint) {
        ArrayList<AttributeTransform> transforms = new ArrayList<AttributeTransform>();
        String sanitizedSourceClusterName = this.sanitizeForClassificationName(srcClusterName);
        this.addClassificationTransform(transforms, String.format(REPLICATED_TAG_NAME, sanitizedSourceClusterName));
        this.addClearReplicationAttributesTransform(transforms);
        this.addClusterRenameTransform(transforms, srcClusterName, tgtClusterName);
        if (!sourceDataSet.equals(targetDataSet)) {
            this.addDataSetRenameTransform(transforms, sourceDataSet, targetDataSet);
        }
        this.addLocationTransform(transforms, sourcefsEndpoint, targetFsEndpoint);
        options.put("transformers", AtlasType.toJson(transforms));
    }

    private void addLocationTransform(List<AttributeTransform> transforms, String srcFsUri, String tgtFsUri) {
        transforms.add(this.create(HIVE_DB_LOCATION, "STARTS_WITH_IGNORE_CASE: " + srcFsUri, HIVE_DB_LOCATION, "REPLACE_PREFIX: = :" + srcFsUri + "=" + tgtFsUri));
        transforms.add(this.create(HIVE_SD_LOCATION, "STARTS_WITH_IGNORE_CASE: " + srcFsUri, HIVE_SD_LOCATION, "REPLACE_PREFIX: = :" + srcFsUri + "=" + tgtFsUri));
    }

    private void addDataSetRenameTransform(List<AttributeTransform> transforms, String sourceDataSet, String targetDataSet) {
        transforms.add(this.create(HIVE_DB_NAME, "EQUALS: " + sourceDataSet, HIVE_DB_NAME, "SET: " + targetDataSet));
    }

    private void addClusterRenameTransform(List<AttributeTransform> transforms, String srcClusterName, String tgtClustername) {
        transforms.add(this.create(HIVE_DB_CLUSTER_NAME, "EQUALS: " + srcClusterName, HIVE_DB_CLUSTER_NAME, "SET: " + tgtClustername));
    }

    private void addReplicatedFrom(Map<String, String> options, String sourceClusterName) {
        options.put(ATTRIBUTE_NAME_REPLICATED_FROM, sourceClusterName);
    }

    private void addClassificationTransform(List<AttributeTransform> transforms, String classificationName) {
        transforms.add(this.create(TRANSFORM_ENTITY_SCOPE, "topLevel: ", TRANSFORM_ENTITY_SCOPE, "ADD_CLASSIFICATION: " + classificationName));
    }

    private String sanitizeForClassificationName(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        return s.replace('-', '_').replace(' ', '_');
    }

    private void addClearReplicationAttributesTransform(List<AttributeTransform> transforms) {
        HashMap<String, String> actions = new HashMap<String, String>();
        actions.put("__entity.replicatedTo", "CLEAR:");
        actions.put("__entity.replicatedFrom", "CLEAR:");
        transforms.add(new AttributeTransform(null, actions));
    }

    private AttributeTransform create(String conditionLhs, String conditionRhs, String actionLhs, String actionRhs) {
        return new AttributeTransform(Collections.singletonMap(conditionLhs, conditionRhs), Collections.singletonMap(actionLhs, actionRhs));
    }
}

