/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.util.FileListStreamer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileList
implements AutoCloseable,
Iterator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(FileList.class);
    private static int fileListStreamerID = 0;
    private static final String FILE_LIST_STREAMER_PREFIX = "file-list-streamer-";
    private LinkedBlockingQueue<String> cache;
    private volatile boolean thresholdHit = false;
    private int thresholdPoint;
    private float thresholdFactor = 0.9f;
    private Path backingFile;
    private FileListStreamer fileListStreamer;
    private String nextElement;
    private boolean noMoreElement;
    private HiveConf conf;
    private BufferedReader backingFileReader;

    public FileList(Path backingFile, int cacheSize, HiveConf conf) {
        this.backingFile = backingFile;
        this.conf = conf;
        if (cacheSize > 0) {
            this.cache = new LinkedBlockingQueue(cacheSize);
            this.fileListStreamer = new FileListStreamer(this.cache, backingFile, conf);
            this.thresholdPoint = this.getThreshold(cacheSize);
            LOG.debug("File list backed by {} can be used for write operation.", (Object)backingFile);
        } else {
            this.thresholdHit = true;
        }
    }

    @VisibleForTesting
    FileList(Path backingFile, FileListStreamer fileListStreamer, LinkedBlockingQueue<String> cache, HiveConf conf) {
        this.backingFile = backingFile;
        this.fileListStreamer = fileListStreamer;
        this.cache = cache;
        this.conf = conf;
        this.thresholdPoint = this.getThreshold(cache.remainingCapacity());
    }

    public void add(String entry) throws SemanticException {
        if (this.thresholdHit && !this.fileListStreamer.isAlive()) {
            throw new SemanticException("List is not getting saved anymore to file " + this.backingFile.toString());
        }
        try {
            this.cache.put(entry);
        }
        catch (InterruptedException e) {
            throw new SemanticException(e);
        }
        if (!this.thresholdHit && this.cache.size() >= this.thresholdPoint) {
            this.initStoreToFile(this.cache.size());
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.thresholdHit) {
            return this.cache != null && !this.cache.isEmpty();
        }
        if (this.nextElement != null) {
            return true;
        }
        if (this.noMoreElement) {
            return false;
        }
        this.nextElement = this.readNextLine();
        if (this.nextElement == null) {
            this.noMoreElement = true;
        }
        return !this.noMoreElement;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more element in the list backed by " + this.backingFile);
        }
        String retVal = this.nextElement;
        this.nextElement = null;
        return this.thresholdHit ? retVal : this.cache.poll();
    }

    private synchronized void initStoreToFile(int cacheSize) {
        if (!this.thresholdHit) {
            this.fileListStreamer.setName(FileList.getNextID());
            this.fileListStreamer.setDaemon(true);
            this.fileListStreamer.start();
            this.thresholdHit = true;
            LOG.info("Started streaming the list elements to file: {}, cache size {}", (Object)this.backingFile, (Object)cacheSize);
        }
    }

    private String readNextLine() {
        String nextElement = null;
        try {
            FileSystem fs;
            if (this.backingFileReader == null && (fs = FileSystem.get((URI)this.backingFile.toUri(), (Configuration)this.conf)).exists(this.backingFile)) {
                this.backingFileReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.backingFile)));
            }
            nextElement = this.backingFileReader == null ? null : this.backingFileReader.readLine();
        }
        catch (IOException e) {
            LOG.error("Unable to read list from backing file " + this.backingFile, (Throwable)e);
        }
        return nextElement;
    }

    @Override
    public void close() throws IOException {
        if (this.thresholdHit && this.fileListStreamer != null) {
            this.fileListStreamer.close();
        }
        if (this.backingFileReader != null) {
            this.backingFileReader.close();
        }
        LOG.info("Completed close for File List backed by:{}, thresholdHit:{} ", (Object)this.backingFile, (Object)this.thresholdHit);
    }

    private static String getNextID() {
        if (Integer.MAX_VALUE == fileListStreamerID) {
            fileListStreamerID = 0;
        }
        return FILE_LIST_STREAMER_PREFIX + ++fileListStreamerID;
    }

    public int getThreshold(int cacheSize) {
        boolean copyAtLoad = this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        return copyAtLoad ? 0 : (int)((float)cacheSize * this.thresholdFactor);
    }
}

