/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListStreamer
extends Thread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileListStreamer.class);
    private static final long TIMEOUT_IN_SECS = 5L;
    private volatile boolean signalTostop;
    private LinkedBlockingQueue<String> cache;
    private Path backingFile;
    private Configuration conf;
    private BufferedWriter backingFileWriter;
    private volatile boolean valid = true;
    private final Object COMPLETION_LOCK = new Object();
    private volatile boolean completed = false;

    public FileListStreamer(LinkedBlockingQueue<String> cache, Path backingFile, Configuration conf) {
        this.cache = cache;
        this.backingFile = backingFile;
        this.conf = conf;
    }

    BufferedWriter lazyInitWriter() throws IOException {
        FileSystem fs = FileSystem.get((URI)this.backingFile.toUri(), (Configuration)this.conf);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(this.backingFile)));
        LOG.info("Initialized a file based store to save a list at: {}", (Object)this.backingFile);
        return writer;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.signalTostop = true;
        Object object = this.COMPLETION_LOCK;
        synchronized (object) {
            while (this.motiveToWait()) {
                try {
                    this.COMPLETION_LOCK.wait(TimeUnit.SECONDS.toMillis(5L));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.isValid()) {
            throw new IOException("File list is not in a valid state:" + this.backingFile);
        }
    }

    private boolean motiveToWait() {
        return !this.completed && this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.backingFileWriter = this.lazyInitWriter();
        }
        catch (IOException e) {
            this.valid = false;
            throw new RuntimeException("Unable to initialize the file list streamer", e);
        }
        boolean exThrown = false;
        while (!(exThrown || this.signalTostop && this.cache.isEmpty())) {
            try {
                String nextEntry = this.cache.poll(5L, TimeUnit.SECONDS);
                if (nextEntry == null) continue;
                this.backingFileWriter.write(nextEntry);
                this.backingFileWriter.newLine();
                LOG.debug("Writing entry {} to file list backed by {}", (Object)nextEntry, (Object)this.backingFile);
            }
            catch (Exception iEx) {
                if (iEx instanceof InterruptedException) continue;
                this.valid = false;
                LOG.error("Exception while saving the list to file " + this.backingFile, (Throwable)iEx);
                exThrown = true;
            }
        }
        try {
            this.closeBackingFile();
            this.completed = true;
        }
        finally {
            Object object = this.COMPLETION_LOCK;
            synchronized (object) {
                this.COMPLETION_LOCK.notify();
            }
        }
        LOG.info("Completed the file list streamer backed by: {}", (Object)this.backingFile);
    }

    private void closeBackingFile() {
        try {
            this.backingFileWriter.close();
            LOG.debug("Closed the file list backing file: {}", (Object)this.backingFile);
        }
        catch (IOException e) {
            LOG.error("Exception while closing the file list backing file", (Throwable)e);
            this.valid = false;
        }
    }

    @VisibleForTesting
    boolean isInitialized() {
        return this.backingFileWriter != null;
    }
}

