/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.coordinator.LlapCoordinator;
import org.apache.hadoop.hive.llap.impl.LlapProtocolClientImpl;
import org.apache.hadoop.hive.llap.security.LlapTokenClient;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.tez.LlapProtocolClientProxy;
import org.apache.hadoop.hive.llap.tezplugins.LlapContainerLauncher;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskCommunicator;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskSchedulerService;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.serviceplugins.api.ContainerLauncherDescriptor;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.apache.tez.serviceplugins.api.TaskCommunicatorDescriptor;
import org.apache.tez.serviceplugins.api.TaskSchedulerDescriptor;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize
public class TezSessionState
implements TezSession {
    protected static final Logger LOG = LoggerFactory.getLogger((String)TezSessionState.class.getName());
    private static final String TEZ_DIR = "_tez_session_dir";
    public static final String LLAP_SERVICE = "LLAP";
    private static final String LLAP_SCHEDULER = LlapTaskSchedulerService.class.getName();
    private static final String LLAP_LAUNCHER = LlapContainerLauncher.class.getName();
    private static final String LLAP_TASK_COMMUNICATOR = LlapTaskCommunicator.class.getName();
    protected final HiveConf conf;
    private Path tezScratchDir;
    protected LocalResource appJarLr;
    private TezClient session;
    private Future<TezClient> sessionFuture;
    private SessionState.LogHelper console;
    @JsonProperty(value="sessionId")
    private String sessionId;
    protected final DagUtils utils;
    @JsonProperty(value="queueName")
    private String queueName;
    @JsonProperty(value="defaultQueue")
    private boolean defaultQueue = false;
    @JsonProperty(value="user")
    private String user;
    private AtomicReference<String> ownerThread = new AtomicReference<Object>(null);
    private TezSession.HiveResources resources;
    @JsonProperty(value="doAsEnabled")
    private boolean doAsEnabled;
    private boolean isLegacyLlapMode;
    protected WmContext wmContext;
    protected KillQuery killQuery;
    private static final Cache<String, String> shaCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public TezSessionState(DagUtils utils, HiveConf conf) {
        this.utils = utils;
        this.conf = conf;
    }

    public String toString() {
        return "sessionId=" + this.sessionId + ", queueName=" + this.queueName + ", user=" + this.user + ", doAs=" + this.doAsEnabled + ", isOpen=" + this.isOpen() + ", isDefault=" + this.defaultQueue;
    }

    public TezSessionState(String sessionId, HiveConf conf) {
        this(DagUtils.getInstance(), conf);
        this.sessionId = sessionId;
    }

    @Override
    public boolean isOpening() {
        if (this.session != null || this.sessionFuture == null) {
            return false;
        }
        try {
            TezClient session = this.sessionFuture.get(0L, TimeUnit.NANOSECONDS);
            if (session == null) {
                return false;
            }
            this.session = session;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            return false;
        }
        catch (TimeoutException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        if (this.session != null) {
            return true;
        }
        if (this.sessionFuture == null) {
            return false;
        }
        try {
            TezClient session = this.sessionFuture.get(0L, TimeUnit.NANOSECONDS);
            if (session == null) {
                return false;
            }
            this.session = session;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException | TimeoutException e) {
            return false;
        }
        return true;
    }

    public static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void open() throws IOException, LoginException, URISyntaxException, TezException {
        this.open(false);
    }

    @Override
    public boolean reconnect(String applicationId, long amAgeMs) throws IOException, LoginException, URISyntaxException, TezException {
        this.queueName = this.conf.get("tez.queue.name");
        this.doAsEnabled = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        this.user = Utils.getUGI().getShortUserName();
        Path scratchDir = this.reconnectTezDir(this.sessionId, null);
        if (scratchDir == null) {
            LOG.warn("Cannot find the original session scratchDir, will create a new one");
            scratchDir = this.createTezDir(this.sessionId, null);
        }
        this.tezScratchDir = scratchDir;
        scratchDir = this.reconnectTezDir(this.sessionId, "resources");
        if (scratchDir == null) {
            LOG.warn("Cannot find the original resources scratchDir, will create a new one");
            scratchDir = this.createTezDir(this.sessionId, "resources");
        }
        this.resources = new TezSession.HiveResources(scratchDir);
        LOG.info("Created new resources: " + this.resources);
        this.ensureLocalResources(this.conf, null);
        Map<String, LocalResource> commonLocalResources = this.addExecJarAndLocalResources();
        boolean llapMode = this.addLlapJarsIfNeeded(commonLocalResources);
        TezConfiguration tezConfig = this.createTezConfig();
        tezConfig.set("tez.staging-dir", this.tezScratchDir.toUri().toString());
        Credentials llapCredentials = this.createLlapCredentials(llapMode, tezConfig);
        ServicePluginsDescriptor spd = TezSessionState.createServicePluginDescriptor(llapMode, tezConfig);
        TezClient session = this.createTezClientObject(tezConfig, commonLocalResources, this.conf, llapCredentials, spd);
        this.session = session = session.getClient(applicationId);
        return true;
    }

    protected boolean isLlapMode() {
        return "llap".equalsIgnoreCase(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE));
    }

    protected final TezClient createTezClientObject(TezConfiguration tezConfig, Map<String, LocalResource> commonLocalResources, HiveConf hiveConf, Credentials llapCredentials, ServicePluginsDescriptor spd) {
        String tezJobNameFormat = HiveConf.getVar(hiveConf, HiveConf.ConfVars.HIVETEZJOBNAME);
        return TezClient.newBuilder((String)String.format(tezJobNameFormat, this.sessionId), (TezConfiguration)tezConfig).setIsSession(true).setLocalResources(commonLocalResources).setCredentials(llapCredentials).setServicePluginDescriptor(spd).build();
    }

    @Override
    public void open(String[] additionalFilesNotFromConf) throws IOException, LoginException, URISyntaxException, TezException {
        this.openInternal(additionalFilesNotFromConf, false, null, null, false);
    }

    @Override
    public void open(TezSession.HiveResources resources) throws LoginException, IOException, URISyntaxException, TezException {
        this.openInternal(null, false, null, resources, false);
    }

    @Override
    public void open(boolean isPoolInit) throws LoginException, IOException, URISyntaxException, TezException {
        String[] noFiles = null;
        this.openInternal(noFiles, false, null, null, isPoolInit);
    }

    @Override
    public void beginOpen(String[] additionalFiles, SessionState.LogHelper console) throws IOException, LoginException, URISyntaxException, TezException {
        this.openInternal(additionalFiles, true, console, null, false);
    }

    protected void openInternal(String[] additionalFilesNotFromConf, boolean isAsync, SessionState.LogHelper console, TezSession.HiveResources resources, boolean isPoolInit) throws IOException, LoginException, URISyntaxException, TezException {
        this.initQueueAndUser();
        this.tezScratchDir = this.createTezDir(this.sessionId, null);
        if (resources != null) {
            this.resources = resources;
            LOG.info("Setting resources to " + resources);
        } else {
            this.resources = new TezSession.HiveResources(this.createTezDir(this.sessionId, "resources"));
            this.ensureLocalResources(this.conf, additionalFilesNotFromConf);
            LOG.info("Created new resources: " + resources);
        }
        final Map<String, LocalResource> commonLocalResources = this.addExecJarAndLocalResources();
        boolean llapMode = this.addLlapJarsIfNeeded(commonLocalResources);
        HashMap amEnv = new HashMap();
        MRHelpers.updateEnvBasedOnMRAMEnv((Configuration)this.conf, amEnv);
        final TezConfiguration tezConfig = this.createTezConfig();
        tezConfig.set("tez.staging-dir", this.tezScratchDir.toUri().toString());
        Credentials llapCredentials = this.createLlapCredentials(llapMode, tezConfig);
        ServicePluginsDescriptor spd = TezSessionState.createServicePluginDescriptor(llapMode, tezConfig);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
            int n = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
            n = Math.max(tezConfig.getInt("tez.am.session.min.held-containers", 0), n);
            tezConfig.setInt("tez.am.session.min.held-containers", n);
        }
        final TezClient session = this.createTezClientObject(tezConfig, commonLocalResources, this.conf, llapCredentials, spd);
        LOG.info("Opening new Tez Session (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")");
        TezJobMonitor.initShutdownHook();
        if (!isAsync) {
            this.startSessionAndContainers(session, this.conf, commonLocalResources, tezConfig, false);
            this.setTezClient(session);
        } else {
            FutureTask<TezClient> sessionFuture = new FutureTask<TezClient>(new Callable<TezClient>(){

                @Override
                public TezClient call() throws Exception {
                    TezClient result = null;
                    try {
                        result = TezSessionState.this.startSessionAndContainers(session, TezSessionState.this.conf, commonLocalResources, tezConfig, true);
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to start Tez session", t);
                        throw t instanceof Exception ? (Exception)t : new Exception(t);
                    }
                    if (Thread.interrupted()) {
                        LOG.info("Interrupted while starting Tez session");
                        TezSessionState.closeAndIgnoreExceptions(result);
                        return null;
                    }
                    return result;
                }
            });
            new Thread(sessionFuture, "Tez session start thread").start();
            this.console = console;
            this.sessionFuture = sessionFuture;
        }
    }

    private Map<String, LocalResource> addExecJarAndLocalResources() throws IOException, LoginException, URISyntaxException {
        HashMap<String, LocalResource> commonLocalResources = new HashMap<String, LocalResource>();
        this.appJarLr = this.createJarLocalResource(this.utils.getExecJarPathLocal(this.conf));
        commonLocalResources.put(DagUtils.getBaseName(this.appJarLr), this.appJarLr);
        for (LocalResource lr : this.resources.localizedResources) {
            commonLocalResources.put(DagUtils.getBaseName(lr), lr);
        }
        return commonLocalResources;
    }

    protected static ServicePluginsDescriptor createServicePluginDescriptor(boolean llapMode, TezConfiguration tezConfig) throws IOException {
        if (!llapMode) {
            return ServicePluginsDescriptor.create((boolean)true);
        }
        UserPayload servicePluginPayload = TezUtils.createUserPayloadFromConf((Configuration)tezConfig);
        return ServicePluginsDescriptor.create((boolean)true, (TaskSchedulerDescriptor[])new TaskSchedulerDescriptor[]{(TaskSchedulerDescriptor)TaskSchedulerDescriptor.create((String)LLAP_SERVICE, (String)LLAP_SCHEDULER).setUserPayload(servicePluginPayload)}, (ContainerLauncherDescriptor[])new ContainerLauncherDescriptor[]{ContainerLauncherDescriptor.create((String)LLAP_SERVICE, (String)LLAP_LAUNCHER)}, (TaskCommunicatorDescriptor[])new TaskCommunicatorDescriptor[]{(TaskCommunicatorDescriptor)TaskCommunicatorDescriptor.create((String)LLAP_SERVICE, (String)LLAP_TASK_COMMUNICATOR).setUserPayload(servicePluginPayload)});
    }

    protected final Credentials createLlapCredentials(boolean llapMode, TezConfiguration tezConfig) throws IOException {
        String protoPath;
        if (!this.isKerberosEnabled((Configuration)tezConfig)) {
            return null;
        }
        Credentials llapCredentials = new Credentials();
        if (llapMode) {
            llapCredentials.addToken(LlapTokenIdentifier.KIND_NAME, TezSessionState.getLlapToken(this.user, (Configuration)tezConfig));
        }
        if ((protoPath = this.conf.getVar(HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH)) != null && !protoPath.isEmpty()) {
            TokenCache.obtainTokensForFileSystems((Credentials)llapCredentials, (Path[])new Path[]{new Path(protoPath)}, (Configuration)tezConfig);
        }
        return llapCredentials;
    }

    protected final TezConfiguration createTezConfig() throws IOException {
        TezConfiguration tezConfig = new TezConfiguration(true);
        tezConfig.addResource((Configuration)this.conf);
        this.setupTezParamsBasedOnMR(tezConfig);
        this.conf.stripHiddenConfigurations((Configuration)tezConfig);
        this.setupSessionAcls((Configuration)tezConfig, this.conf);
        return tezConfig;
    }

    protected final boolean addLlapJarsIfNeeded(Map<String, LocalResource> commonLocalResources) throws IOException, LoginException {
        if (!this.isLlapMode()) {
            return false;
        }
        this.addJarLRByClass(LlapTaskSchedulerService.class, commonLocalResources);
        this.addJarLRByClass(LlapProtocolClientImpl.class, commonLocalResources);
        this.addJarLRByClass(LlapProtocolClientProxy.class, commonLocalResources);
        this.addJarLRByClass(RegistryOperations.class, commonLocalResources);
        return true;
    }

    protected final void initQueueAndUser() throws LoginException, IOException {
        String confQueueName = this.conf.get("tez.queue.name");
        if (this.queueName != null && !this.queueName.equals(confQueueName)) {
            LOG.warn("Resetting a queue name that was already set: was " + this.queueName + ", now " + confQueueName);
        }
        this.queueName = confQueueName;
        this.doAsEnabled = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        UserGroupInformation ugi = Utils.getUGI();
        this.user = ugi.getShortUserName();
        LOG.info("User of session id " + this.sessionId + " is " + this.user);
    }

    private boolean isKerberosEnabled(Configuration conf) {
        try {
            return UserGroupInformation.getLoginUser().hasKerberosCredentials() && HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_USE_KERBEROS);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Token<LlapTokenIdentifier> getLlapToken(String user, Configuration conf) throws IOException {
        SessionState session = SessionState.get();
        boolean isInHs2 = session != null && session.isHiveServerQuery();
        Token<LlapTokenIdentifier> token = null;
        LlapCoordinator coordinator = null;
        if (isInHs2) {
            coordinator = LlapCoordinator.getInstance();
            if (coordinator == null) {
                throw new IOException("LLAP coordinator not initialized; cannot get LLAP tokens");
            }
            token = coordinator.getLocalTokenClient(conf, user).createToken(null, null, false);
        } else {
            token = new LlapTokenClient(conf).getDelegationToken(null);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Obtained a LLAP token: " + token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TezClient startSessionAndContainers(TezClient session, HiveConf conf, Map<String, LocalResource> commonLocalResources, TezConfiguration tezConfig, boolean isOnThread) throws TezException, IOException {
        session.start();
        boolean isSuccessful = false;
        try {
            block10: {
                if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
                    int n = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
                    LOG.info("Prewarming " + n + " containers  (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")");
                    PreWarmVertex prewarmVertex = this.utils.createPreWarmVertex(tezConfig, n, commonLocalResources);
                    try {
                        session.preWarm(prewarmVertex);
                    }
                    catch (IOException ie) {
                        if (!isOnThread && ie.getMessage().contains("Interrupted while waiting")) {
                            LOG.warn("Hive Prewarm threw an exception ", (Throwable)ie);
                        }
                        throw ie;
                    }
                }
                try {
                    session.waitTillReady();
                }
                catch (InterruptedException ie) {
                    if (!isOnThread) break block10;
                    throw new IOException(ie);
                }
            }
            isSuccessful = true;
            conf.unset("tez.queue.name");
            TezClient tezClient = session;
            return tezClient;
        }
        finally {
            if (isOnThread && !isSuccessful) {
                TezSessionState.closeAndIgnoreExceptions(session);
            }
        }
    }

    private static void closeAndIgnoreExceptions(TezClient session) {
        try {
            session.stop();
        }
        catch (SessionNotRunning sessionNotRunning) {
        }
        catch (IOException | TezException ex) {
            LOG.info("Failed to close Tez session after failure to initialize: " + ex.getMessage());
        }
    }

    @Override
    public void endOpen() throws InterruptedException, CancellationException {
        if (this.session != null || this.sessionFuture == null) {
            return;
        }
        try {
            TezClient session = this.sessionFuture.get();
            if (session == null) {
                throw new RuntimeException("Initialization was interrupted");
            }
            this.setTezClient(session);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupTezParamsBasedOnMR(TezConfiguration conf) {
        String env = conf.get("yarn.app.mapreduce.am.admin.user.env");
        if (conf.get("yarn.app.mapreduce.am.env") != null) {
            String string = env = env == null ? conf.get("yarn.app.mapreduce.am.env") : env + "," + conf.get("yarn.app.mapreduce.am.env");
        }
        if (env != null) {
            conf.setIfUnset("tez.am.launch.env", env);
        }
        conf.setIfUnset("tez.am.launch.cmd-opts", MRHelpers.getJavaOptsForMRAM((Configuration)conf));
        String queueName = conf.get("mapreduce.job.queuename", "default");
        conf.setIfUnset("tez.queue.name", queueName);
        int amMemMB = conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        conf.setIfUnset("tez.am.resource.memory.mb", "" + amMemMB);
        int amCores = conf.getInt("yarn.app.mapreduce.am.resource.cpu-vcores", 1);
        conf.setIfUnset("tez.am.resource.cpu.vcores", "" + amCores);
        conf.setIfUnset("tez.am.max.app.attempts", "" + conf.getInt("mapreduce.am.max-attempts", 2));
        conf.setIfUnset("tez.am.view-acls", conf.get("mapreduce.job.acl-view-job", " "));
        conf.setIfUnset("tez.am.modify-acls", conf.get("mapreduce.job.acl-modify-job", " "));
        ArrayList<Map> maps = new ArrayList<Map>(2);
        maps.add(DeprecatedKeys.getMRToTezRuntimeParamMap());
        maps.add(DeprecatedKeys.getMRToDAGParamMap());
        boolean preferTez = true;
        for (Map map : maps) {
            for (Map.Entry dep : map.entrySet()) {
                if (conf.get((String)dep.getKey()) == null) continue;
                String mrValue = conf.get((String)dep.getKey());
                String tezValue = conf.get((String)dep.getValue());
                conf.unset((String)dep.getKey());
                if (tezValue == null) {
                    conf.set((String)dep.getValue(), mrValue, "TRANSLATED_TO_TEZ");
                } else if (!preferTez) {
                    conf.set((String)dep.getValue(), mrValue, "TRANSLATED_TO_TEZ_AND_MR_OVERRIDE");
                }
                LOG.debug("Config: mr(unset):" + (String)dep.getKey() + ", mr initial value=" + mrValue + ", tez(original):" + (String)dep.getValue() + "=" + tezValue + ", tez(final):" + (String)dep.getValue() + "=" + conf.get((String)dep.getValue()));
            }
        }
    }

    private void setupSessionAcls(Configuration tezConf, HiveConf hiveConf) throws IOException {
        String user = SessionState.getUserFromAuthenticator();
        UserGroupInformation loginUserUgi = UserGroupInformation.getLoginUser();
        String loginUser = loginUserUgi == null ? null : loginUserUgi.getShortUserName();
        boolean addHs2User = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVETEZHS2USERACCESS);
        String viewStr = Utilities.getAclStringWithHiveModification(tezConf, "tez.am.view-acls", addHs2User, user, loginUser);
        String modifyStr = Utilities.getAclStringWithHiveModification(tezConf, "tez.am.modify-acls", addHs2User, user, loginUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Tez Session access for sessionId={} with viewAclString={}, modifyStr={}", new Object[]{SessionState.get().getSessionId(), viewStr, modifyStr});
        }
        tezConf.set("tez.am.view-acls", viewStr);
        tezConf.set("tez.am.modify-acls", modifyStr);
    }

    @Override
    public void ensureLocalResources(Configuration conf, String[] newFilesNotFromConf) throws IOException, LoginException, URISyntaxException, TezException {
        if (this.resources == null) {
            throw new AssertionError((Object)("Ensure called on an unitialized (or closed) session " + this.sessionId));
        }
        String dir = this.resources.dagResourcesDir.toString();
        this.resources.localizedResources.clear();
        List<LocalResource> lrs = this.utils.localizeTempFilesFromConf(dir, conf);
        if (lrs != null) {
            this.resources.localizedResources.addAll(lrs);
        }
        Map<String, LocalResource> newResources = null;
        if (newFilesNotFromConf != null && newFilesNotFromConf.length > 0) {
            boolean hasResources;
            boolean bl = hasResources = !this.resources.additionalFilesNotFromConf.isEmpty();
            if (hasResources) {
                for (String s : newFilesNotFromConf) {
                    hasResources = this.resources.additionalFilesNotFromConf.keySet().contains(s);
                    if (!hasResources) break;
                }
            }
            if (!hasResources) {
                String[] skipFilesFromConf = DagUtils.getTempFilesFromConf(conf);
                newResources = this.utils.localizeTempFiles(dir, conf, newFilesNotFromConf, skipFilesFromConf);
                if (newResources != null) {
                    this.resources.localizedResources.addAll(newResources.values());
                    this.resources.additionalFilesNotFromConf.putAll(newResources);
                }
            } else {
                this.resources.localizedResources.addAll(this.resources.additionalFilesNotFromConf.values());
            }
        }
        if (this.session != null) {
            if (newResources != null && !newResources.isEmpty()) {
                this.session.addAppMasterLocalFiles(DagUtils.createTezLrMap(null, newResources.values()));
            }
            if (!this.resources.localizedResources.isEmpty()) {
                this.session.addAppMasterLocalFiles(DagUtils.getResourcesUpdatableForAm(this.resources.localizedResources));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean keepDagFilesDir) throws Exception {
        block14: {
            this.console = null;
            this.appJarLr = null;
            try {
                if (this.session != null) {
                    LOG.info("Closing Tez Session");
                    this.closeClient(this.session);
                    this.session = null;
                    break block14;
                }
                if (this.sessionFuture == null) break block14;
                this.sessionFuture.cancel(true);
                TezClient asyncSession = null;
                try {
                    asyncSession = this.sessionFuture.get();
                }
                catch (CancellationException | ExecutionException exception) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.sessionFuture = null;
                if (asyncSession != null) {
                    LOG.info("Closing Tez Session");
                    this.closeClient(asyncSession);
                }
            }
            finally {
                try {
                    this.cleanupScratchDir();
                }
                finally {
                    if (!keepDagFilesDir) {
                        this.cleanupDagResources();
                    }
                }
            }
        }
    }

    private void closeClient(TezClient client) throws TezException, IOException {
        try {
            client.stop();
        }
        catch (SessionNotRunning sessionNotRunning) {
            // empty catch block
        }
    }

    protected final void cleanupScratchDir() throws IOException {
        if (this.tezScratchDir != null) {
            FileSystem fs = this.tezScratchDir.getFileSystem((Configuration)this.conf);
            fs.delete(this.tezScratchDir, true);
            this.tezScratchDir = null;
        }
    }

    protected final void cleanupDagResources() throws IOException {
        LOG.info("Attemting to clean up resources for " + this.sessionId + ": " + this.resources);
        if (this.resources != null) {
            FileSystem fs = this.resources.dagResourcesDir.getFileSystem((Configuration)this.conf);
            fs.delete(this.resources.dagResourcesDir, true);
            this.resources = null;
        }
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    protected final void setTezClient(TezClient session) {
        this.session = session;
    }

    @Override
    public TezClient getTezClient() {
        if (this.session == null && this.sessionFuture != null) {
            if (!this.sessionFuture.isDone()) {
                this.console.printInfo("Waiting for Tez session and AM to be ready...");
            }
            try {
                this.session = this.sessionFuture.get();
            }
            catch (InterruptedException e) {
                this.console.printInfo("Interrupted while waiting for the session");
                Thread.currentThread().interrupt();
                return null;
            }
            catch (ExecutionException e) {
                this.console.printInfo("Failed to get session");
                throw new RuntimeException(e);
            }
            catch (CancellationException e) {
                this.console.printInfo("Cancelled while waiting for the session");
                return null;
            }
        }
        return this.session;
    }

    @Override
    public LocalResource getAppJarLr() {
        return this.appJarLr;
    }

    private Path createTezDir(String sessionId, String suffix) throws IOException {
        Path tezDir = this.getScratchDirPath(sessionId, suffix, false);
        FileSystem fs = tezDir.getFileSystem((Configuration)this.conf);
        FsPermission fsPermission = new FsPermission(HiveConf.getVar(this.conf, HiveConf.ConfVars.SCRATCHDIRPERMISSION));
        fs.mkdirs(tezDir, fsPermission);
        tezDir = DagUtils.validateTargetDir(tezDir, this.conf).getPath();
        return tezDir;
    }

    private Path reconnectTezDir(String sessionId, String suffix) throws IOException {
        Path dir = this.getScratchDirPath(sessionId, suffix, false);
        FileStatus dirFs = DagUtils.validateTargetDir(dir, this.conf);
        if (dirFs != null) {
            return dirFs.getPath();
        }
        dir = this.getScratchDirPath(sessionId, suffix, true);
        if (dir == null) {
            return null;
        }
        dirFs = DagUtils.validateTargetDir(dir, this.conf);
        return dirFs != null ? dirFs.getPath() : null;
    }

    private Path getScratchDirPath(String sessionId, String suffix, boolean isAlternative) {
        SessionState sessionState = SessionState.get();
        if (sessionState == null && isAlternative) {
            return null;
        }
        String hdfsScratchDir = isAlternative || sessionState == null ? HiveConf.getVar(this.conf, HiveConf.ConfVars.SCRATCHDIR) : sessionState.getHdfsScratchDirURIString();
        Path tezDir = new Path(hdfsScratchDir, TEZ_DIR);
        return new Path(tezDir, sessionId + (suffix == null ? "" : "-" + suffix));
    }

    protected final LocalResource createJarLocalResource(String localJarPath) throws IOException, LoginException, IllegalArgumentException {
        FileStatus destDirStatus = this.utils.getHiveJarDirectory(this.conf);
        assert (destDirStatus != null);
        Path destDirPath = destDirStatus.getPath();
        Path localFile = new Path(localJarPath);
        String sha = this.getSha(localFile);
        String destFileName = localFile.getName();
        destFileName = FilenameUtils.removeExtension((String)destFileName) + "-" + sha + '.' + FilenameUtils.getExtension((String)destFileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The destination file name for [" + localJarPath + "] is " + destFileName);
        }
        Path destFile = new Path(destDirPath.toString() + "/" + destFileName);
        return this.utils.localizeResource(localFile, destFile, LocalResourceType.FILE, this.conf);
    }

    private String getKey(FileStatus fileStatus) {
        return fileStatus.getPath() + ":" + fileStatus.getLen() + ":" + fileStatus.getModificationTime();
    }

    private void addJarLRByClassName(String className, Map<String, LocalResource> lrMap) throws IOException, LoginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot find " + className + " in classpath", e);
        }
        this.addJarLRByClass(clazz, lrMap);
    }

    private void addJarLRByClass(Class<?> clazz, Map<String, LocalResource> lrMap) throws IOException, LoginException {
        File jar = new File(Utilities.jarFinderGetJar(clazz));
        String localJarPath = jar.toURI().toURL().toExternalForm();
        LocalResource jarLr = this.createJarLocalResource(localJarPath);
        lrMap.put(DagUtils.getBaseName(jarLr), jarLr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSha(Path localFile) throws IOException, IllegalArgumentException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        FileStatus fileStatus = localFs.getFileStatus(localFile);
        String key = this.getKey(fileStatus);
        String sha256 = shaCache.getIfPresent(key);
        if (sha256 == null) {
            try (FSDataInputStream is = null;){
                is = localFs.open(localFile);
                long start = System.currentTimeMillis();
                sha256 = DigestUtils.sha256Hex((InputStream)is);
                long end = System.currentTimeMillis();
                LOG.info("Computed sha: {} for file: {} of length: {} in {} ms", new Object[]{sha256, localFile, LlapUtil.humanReadableByteCount(fileStatus.getLen()), end - start});
                shaCache.put(key, sha256);
            }
        }
        return sha256;
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void setDefault() {
        this.defaultQueue = true;
    }

    @Override
    public boolean isDefault() {
        return this.defaultQueue;
    }

    @Override
    public HiveConf getConf() {
        return this.conf;
    }

    @Override
    public List<LocalResource> getLocalizedResources() {
        if (this.resources == null) {
            return new ArrayList<LocalResource>();
        }
        return new ArrayList<LocalResource>(this.resources.localizedResources);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean getDoAsEnabled() {
        return this.doAsEnabled;
    }

    @Override
    public void unsetOwnerThread() {
        if (this.ownerThread.getAndSet(null) == null) {
            throw new AssertionError((Object)"Not in use");
        }
    }

    @Override
    public void setOwnerThread() {
        String newName = Thread.currentThread().getName();
        do {
            String oldName;
            if ((oldName = this.ownerThread.get()) != null) {
                throw new AssertionError((Object)("Tez session is already in use from " + oldName + "; cannot use from " + newName));
            }
        } while (!this.ownerThread.compareAndSet(null, newName));
    }

    @Override
    public void setLegacyLlapMode(boolean value) {
        this.isLegacyLlapMode = value;
    }

    @Override
    public boolean getLegacyLlapMode() {
        return this.isLegacyLlapMode;
    }

    @Override
    public void returnToSessionManager() throws Exception {
        TezSessionPoolManager.getInstance().returnSession(this);
    }

    @Override
    public TezSession reopen() throws Exception {
        return TezSessionPoolManager.getInstance().reopen(this);
    }

    @Override
    public void destroy() throws Exception {
        TezSessionPoolManager.getInstance().destroy(this);
    }

    @Override
    public WmContext getWmContext() {
        return this.wmContext;
    }

    @Override
    public void setWmContext(WmContext wmContext) {
        this.wmContext = wmContext;
    }

    @Override
    public void setKillQuery(KillQuery killQuery) {
        this.killQuery = killQuery;
    }

    @Override
    public TezSession.HiveResources extractHiveResources() {
        TezSession.HiveResources result = this.resources;
        this.resources = null;
        return result;
    }

    @Override
    public Path replaceHiveResources(TezSession.HiveResources resources, boolean isAsync) {
        Path dir = null;
        if (this.resources != null) {
            dir = this.resources.dagResourcesDir;
            if (!isAsync) {
                try {
                    dir.getFileSystem((Configuration)this.conf).delete(dir, true);
                }
                catch (Exception ex) {
                    LOG.error("Failed to delete the old resources directory " + dir + "; ignoring " + ex.getLocalizedMessage());
                }
                dir = null;
            }
        }
        this.resources = resources;
        return dir;
    }

    @Override
    public boolean killQuery(String reason) throws HiveException {
        if (this.killQuery == null || this.wmContext == null) {
            return false;
        }
        String queryId = this.wmContext.getQueryId();
        if (queryId == null) {
            return false;
        }
        LOG.info("Killing the query {}: {}", (Object)queryId, (Object)reason);
        this.killQuery.killQuery(queryId, reason, this.conf, true);
        return true;
    }
}

