/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;

public class VectorUDFMapIndexStringScalar
extends VectorUDFMapIndexBaseScalar {
    private byte[] key;

    public VectorUDFMapIndexStringScalar() {
    }

    public VectorUDFMapIndexStringScalar(int mapColumnNum, byte[] key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + new String(this.key);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    @Override
    public int findScalarInMap(MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        BytesColumnVector keyColVector = (BytesColumnVector)mapColumnVector.keys;
        byte[][] keyVector = keyColVector.vector;
        int[] keyStart = keyColVector.start;
        int[] keyLength = keyColVector.length;
        for (int i = 0; i < count; ++i) {
            int keyOffset = offset + i;
            if (!StringExpr.equal(this.key, 0, this.key.length, keyVector[keyOffset], keyStart[keyOffset], keyLength[keyOffset])) continue;
            return offset + i;
        }
        return -1;
    }
}

