/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorStreamingLongSum
extends VectorPTFEvaluatorBase {
    protected boolean isNull;
    protected long sum;

    public VectorPTFEvaluatorStreamingLongSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outputColVector.vector;
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                this.isNull = false;
                long repeatedValue = longColVector.vector[0];
                for (int i = 0; i < size; ++i) {
                    this.sum += repeatedValue;
                    outputVector[i] = this.sum;
                }
            } else {
                if (this.isNull) {
                    outputColVector.isNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[0] = this.sum;
                }
                outputColVector.isRepeating = true;
            }
        } else if (longColVector.noNulls) {
            this.isNull = false;
            long[] vector = longColVector.vector;
            for (int i = 0; i < size; ++i) {
                this.sum += vector[i];
                outputVector[i] = this.sum;
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (this.isNull) {
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[i] = this.sum;
                }
                if (++i < size) continue;
                return;
            }
            this.isNull = false;
            long[] vector = longColVector.vector;
            this.sum += vector[i];
            outputVector[i++] = this.sum;
            while (i < size) {
                if (!batchIsNull[i]) {
                    this.sum += vector[i];
                    outputVector[i] = this.sum;
                } else {
                    outputVector[i] = this.sum;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public void resetEvaluator() {
        this.isNull = true;
        this.sum = 0L;
    }
}

