/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.BucketNumExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorReduceSinkObjectHashOperator
extends VectorReduceSinkCommonOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkObjectHashOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean isEmptyBuckets;
    protected int[] reduceSinkBucketColumnMap;
    protected TypeInfo[] reduceSinkBucketTypeInfos;
    protected VectorExpression[] reduceSinkBucketExpressions;
    protected boolean isEmptyPartitions;
    protected int[] reduceSinkPartitionColumnMap;
    protected TypeInfo[] reduceSinkPartitionTypeInfos;
    private boolean isSingleReducer;
    protected VectorExpression[] reduceSinkPartitionExpressions;
    private transient boolean isKeyInitialized;
    protected transient ByteStream.Output keyOutput;
    protected transient VectorSerializeRow<BinarySortableSerializeWrite> keyVectorSerializeRow;
    private transient int numBuckets;
    private transient ObjectInspector[] bucketObjectInspectors;
    private transient VectorExtractRow bucketVectorExtractRow;
    private transient Object[] bucketFieldValues;
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient VectorExtractRow partitionVectorExtractRow;
    private transient Object[] partitionFieldValues;
    private transient Random nonPartitionRandom;
    private transient BiFunction<Object[], ObjectInspector[], Integer> hashFunc;
    private transient BucketNumExpression bucketExpr = null;

    protected VectorReduceSinkObjectHashOperator() {
    }

    public VectorReduceSinkObjectHashOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkObjectHashOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
        LOG.info((Object)("VectorReduceSinkObjectHashOperator constructor vectorReduceSinkInfo " + this.vectorReduceSinkInfo));
        Preconditions.checkState(!this.vectorReduceSinkInfo.getUseUniformHash());
        this.isEmptyBuckets = this.vectorDesc.getIsEmptyBuckets();
        if (!this.isEmptyBuckets) {
            this.reduceSinkBucketColumnMap = this.vectorReduceSinkInfo.getReduceSinkBucketColumnMap();
            this.reduceSinkBucketTypeInfos = this.vectorReduceSinkInfo.getReduceSinkBucketTypeInfos();
            this.reduceSinkBucketExpressions = this.vectorReduceSinkInfo.getReduceSinkBucketExpressions();
        }
        this.isEmptyPartitions = this.vectorDesc.getIsEmptyPartitions();
        if (!this.isEmptyPartitions) {
            this.reduceSinkPartitionColumnMap = this.vectorReduceSinkInfo.getReduceSinkPartitionColumnMap();
            this.reduceSinkPartitionTypeInfos = this.vectorReduceSinkInfo.getReduceSinkPartitionTypeInfos();
            this.reduceSinkPartitionExpressions = this.vectorReduceSinkInfo.getReduceSinkPartitionExpressions();
        }
        this.isSingleReducer = ((ReduceSinkDesc)this.conf).getNumReducers() == 1;
    }

    private ObjectInspector[] getObjectInspectorArray(TypeInfo[] typeInfos) {
        int size = typeInfos.length;
        ObjectInspector[] objectInspectors = new ObjectInspector[size];
        for (int i = 0; i < size; ++i) {
            ObjectInspector standardWritableObjectInspector;
            TypeInfo typeInfo = typeInfos[i];
            objectInspectors[i] = standardWritableObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
        }
        return objectInspectors;
    }

    private void evaluateBucketExpr(VectorizedRowBatch batch, int rowNum, int bucketNum) throws HiveException {
        this.bucketExpr.setRowNum(rowNum);
        this.bucketExpr.setBucketNum(bucketNum);
        this.bucketExpr.evaluate(batch);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.reduceSinkBucketExpressions, hconf);
        VectorExpression.doTransientInit(this.reduceSinkPartitionExpressions, hconf);
        if (!this.isEmptyKey) {
            this.keyOutput = new ByteStream.Output();
            this.keyBinarySortableSerializeWrite.set(this.keyOutput);
            this.keyVectorSerializeRow = new VectorSerializeRow<BinarySortableSerializeWrite>(this.keyBinarySortableSerializeWrite);
            this.keyVectorSerializeRow.init(this.reduceSinkKeyTypeInfos, this.reduceSinkKeyColumnMap);
        }
        if (this.isEmptyBuckets) {
            this.numBuckets = 0;
        } else {
            this.numBuckets = ((ReduceSinkDesc)this.conf).getNumBuckets();
            this.bucketObjectInspectors = this.getObjectInspectorArray(this.reduceSinkBucketTypeInfos);
            this.bucketVectorExtractRow = new VectorExtractRow();
            this.bucketVectorExtractRow.init(this.reduceSinkBucketTypeInfos, this.reduceSinkBucketColumnMap);
            this.bucketFieldValues = new Object[this.reduceSinkBucketTypeInfos.length];
        }
        if (this.isEmptyPartitions) {
            this.nonPartitionRandom = new Random(12345L);
        } else {
            this.partitionObjectInspectors = this.getObjectInspectorArray(this.reduceSinkPartitionTypeInfos);
            this.partitionVectorExtractRow = new VectorExtractRow();
            this.partitionVectorExtractRow.init(this.reduceSinkPartitionTypeInfos, this.reduceSinkPartitionColumnMap);
            this.partitionFieldValues = new Object[this.reduceSinkPartitionTypeInfos.length];
        }
        BiFunction<Object[], ObjectInspector[], Integer> biFunction = this.hashFunc = this.bucketingVersion == 2 && !this.vectorDesc.getIsAcidChange() ? ObjectInspectorUtils::getBucketHashCode : ObjectInspectorUtils::getBucketHashCodeOld;
        if (this.reduceSinkKeyExpressions != null) {
            for (VectorExpression ve : this.reduceSinkKeyExpressions) {
                if (!(ve instanceof BucketNumExpression)) continue;
                this.bucketExpr = (BucketNumExpression)ve;
                break;
            }
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            ++this.batchCounter;
            if (batch.size == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (!this.isKeyInitialized) {
                this.isKeyInitialized = true;
                if (this.isEmptyKey) {
                    this.initializeEmptyKey(tag);
                }
            }
            if (this.reduceSinkKeyExpressions != null) {
                for (VectorExpression ve : this.reduceSinkKeyExpressions) {
                    if (ve instanceof BucketNumExpression) continue;
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkValueExpressions != null) {
                for (VectorExpression ve : this.reduceSinkValueExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkBucketExpressions != null) {
                for (VectorExpression ve : this.reduceSinkBucketExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkPartitionExpressions != null) {
                for (VectorExpression ve : this.reduceSinkPartitionExpressions) {
                    ve.evaluate(batch);
                }
            }
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            int size = batch.size;
            for (int logical = 0; logical < size; ++logical) {
                int hashCode;
                int batchIndex;
                int n = batchIndex = selectedInUse ? selected[logical] : logical;
                if (this.isEmptyPartitions) {
                    hashCode = this.isSingleReducer ? 0 : this.nonPartitionRandom.nextInt();
                } else {
                    this.partitionVectorExtractRow.extractRow(batch, batchIndex, this.partitionFieldValues);
                    hashCode = this.hashFunc.apply(this.partitionFieldValues, this.partitionObjectInspectors);
                }
                if (!this.isEmptyBuckets) {
                    this.bucketVectorExtractRow.extractRow(batch, batchIndex, this.bucketFieldValues);
                    int bucketNum = ObjectInspectorUtils.getBucketNumber(this.hashFunc.apply(this.bucketFieldValues, this.bucketObjectInspectors), this.numBuckets);
                    if (this.bucketExpr != null) {
                        this.evaluateBucketExpr(batch, batchIndex, bucketNum);
                    }
                    hashCode = hashCode * 31 + bucketNum;
                }
                this.postProcess(batch, batchIndex, tag, hashCode);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void processKey(VectorizedRowBatch batch, int batchIndex, int tag) throws HiveException {
        if (this.isEmptyKey) {
            return;
        }
        try {
            this.keyBinarySortableSerializeWrite.reset();
            this.keyVectorSerializeRow.serializeWrite(batch, batchIndex);
            int keyLength = this.keyOutput.getLength();
            if (tag == -1 || this.reduceSkipTag) {
                this.keyWritable.set(this.keyOutput.getData(), 0, keyLength);
            } else {
                this.keyWritable.setSize(keyLength + 1);
                System.arraycopy(this.keyOutput.getData(), 0, this.keyWritable.get(), 0, keyLength);
                this.keyWritable.get()[keyLength] = this.reduceTagByte;
            }
            this.keyWritable.setDistKeyLength(keyLength);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void processValue(VectorizedRowBatch batch, int batchIndex) throws HiveException {
        if (this.isEmptyValue) {
            return;
        }
        try {
            this.valueLazyBinarySerializeWrite.reset();
            this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
            this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void postProcess(VectorizedRowBatch batch, int batchIndex, int tag, int hashCode) throws HiveException {
        try {
            this.processKey(batch, batchIndex, tag);
            this.keyWritable.setHashCode(hashCode);
            this.processValue(batch, batchIndex);
            this.collect(this.keyWritable, this.valueBytesWritable);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

