/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@Deprecated
public class IndexPredicateAnalyzer {
    private final Set<String> udfNames = new HashSet<String>();
    private final Map<String, Set<String>> columnToUDFs = new HashMap<String, Set<String>>();
    private FieldValidator fieldValidator;
    private boolean acceptsFields;

    public void setFieldValidator(FieldValidator fieldValidator) {
        this.fieldValidator = fieldValidator;
    }

    public void addComparisonOp(String udfName) {
        this.udfNames.add(udfName);
    }

    public void clearAllowedColumnNames() {
        this.columnToUDFs.clear();
    }

    public void allowColumnName(String columnName) {
        this.columnToUDFs.put(columnName, this.udfNames);
    }

    public void addComparisonOp(String columnName, String ... udfs) {
        Set<String> allowed = this.columnToUDFs.get(columnName);
        if (allowed == null || allowed == this.udfNames) {
            this.columnToUDFs.put(columnName, new HashSet<String>(Arrays.asList(udfs)));
        } else {
            allowed.addAll(Arrays.asList(udfs));
        }
    }

    public ExprNodeDesc analyzePredicate(ExprNodeDesc predicate, final List<IndexSearchCondition> searchConditions) {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        NodeProcessor nodeProcessor = new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                Node ancestor;
                Iterator iterator = stack.iterator();
                while (iterator.hasNext() && nd != (ancestor = (Node)iterator.next())) {
                    if (FunctionRegistry.isOpAnd((ExprNodeDesc)ancestor)) continue;
                    return nd;
                }
                return IndexPredicateAnalyzer.this.analyzeExpr((ExprNodeGenericFuncDesc)nd, searchConditions, nodeOutputs);
            }
        };
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(nodeProcessor, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(predicate);
        HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        ExprNodeDesc residualPredicate = (ExprNodeDesc)nodeOutput.get(predicate);
        return residualPredicate;
    }

    private static ExprNodeDesc getColumnExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeColumnDesc) {
            return expr;
        }
        ExprNodeGenericFuncDesc funcDesc = null;
        if (expr instanceof ExprNodeGenericFuncDesc) {
            funcDesc = (ExprNodeGenericFuncDesc)expr;
        }
        if (null == funcDesc) {
            return expr;
        }
        GenericUDF udf = funcDesc.getGenericUDF();
        if ((udf instanceof GenericUDFBridge || udf instanceof GenericUDFToBinary || udf instanceof GenericUDFToString || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp) && funcDesc.getChildren().size() == 1 && funcDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
            return expr.getChildren().get(0);
        }
        return expr;
    }

    private ExprNodeDesc analyzeExpr(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) throws SemanticException {
        ExprNodeConstantDesc constantDesc;
        ExprNodeColumnDesc columnDesc;
        ExprNodeDesc[] extracted;
        GenericUDF genericUDF;
        if (FunctionRegistry.isOpAnd(expr)) {
            assert (nodeOutputs.length >= 2);
            ArrayList<ExprNodeDesc> residuals = new ArrayList<ExprNodeDesc>();
            for (Object residual : nodeOutputs) {
                if (null == residual) continue;
                residuals.add((ExprNodeDesc)residual);
            }
            if (residuals.size() == 0) {
                return null;
            }
            if (residuals.size() == 1) {
                return (ExprNodeDesc)residuals.get(0);
            }
            if (residuals.size() > 1) {
                return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), residuals);
            }
        }
        if (!((genericUDF = expr.getGenericUDF()) instanceof GenericUDFBaseCompare)) {
            return expr;
        }
        ExprNodeDesc expr1 = (ExprNodeDesc)nodeOutputs[0];
        ExprNodeDesc expr2 = (ExprNodeDesc)nodeOutputs[1];
        if (expr1.getTypeInfo().equals(expr2.getTypeInfo())) {
            expr1 = IndexPredicateAnalyzer.getColumnExpr(expr1);
            expr2 = IndexPredicateAnalyzer.getColumnExpr(expr2);
        }
        if ((extracted = ExprNodeDescUtils.extractComparePair(expr1, expr2)) == null || extracted.length > 2 && !this.acceptsFields) {
            return expr;
        }
        if (extracted[0] instanceof ExprNodeConstantDesc) {
            genericUDF = genericUDF.flip();
            columnDesc = (ExprNodeColumnDesc)extracted[1];
            constantDesc = (ExprNodeConstantDesc)extracted[0];
        } else {
            columnDesc = (ExprNodeColumnDesc)extracted[0];
            constantDesc = (ExprNodeConstantDesc)extracted[1];
        }
        Set<String> allowed = this.columnToUDFs.get(columnDesc.getColumn());
        if (allowed == null) {
            return expr;
        }
        String udfName = genericUDF.getUdfName();
        if (!allowed.contains(genericUDF.getUdfName())) {
            return expr;
        }
        String[] fields = null;
        if (extracted.length > 2) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)extracted[2];
            if (!this.isValidField(fieldDesc)) {
                return expr;
            }
            fields = ExprNodeDescUtils.extractFields(fieldDesc);
        }
        ArrayList<ExprNodeDesc> list = new ArrayList<ExprNodeDesc>();
        list.add(expr1);
        list.add(expr2);
        ExprNodeGenericFuncDesc indexExpr = new ExprNodeGenericFuncDesc(expr.getTypeInfo(), expr.getGenericUDF(), list);
        searchConditions.add(new IndexSearchCondition(columnDesc, udfName, constantDesc, indexExpr, expr, fields));
        return fields == null ? null : expr;
    }

    private boolean isValidField(ExprNodeFieldDesc field) {
        return this.fieldValidator == null || this.fieldValidator.validate(field);
    }

    public ExprNodeGenericFuncDesc translateSearchConditions(List<IndexSearchCondition> searchConditions) {
        ExprNodeGenericFuncDesc expr = null;
        for (IndexSearchCondition searchCondition : searchConditions) {
            if (expr == null) {
                expr = searchCondition.getIndexExpr();
                continue;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            children.add(searchCondition.getIndexExpr());
            expr = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
        }
        return expr;
    }

    public ExprNodeGenericFuncDesc translateOriginalConditions(List<IndexSearchCondition> searchConditions) {
        ExprNodeGenericFuncDesc expr = null;
        for (IndexSearchCondition searchCondition : searchConditions) {
            if (expr == null) {
                expr = searchCondition.getOriginalExpr();
                continue;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            children.add(searchCondition.getOriginalExpr());
            expr = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
        }
        return expr;
    }

    public void setAcceptsFields(boolean acceptsFields) {
        this.acceptsFields = acceptsFields;
    }

    public static IndexPredicateAnalyzer createAnalyzer(boolean equalOnly) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual");
        if (equalOnly) {
            return analyzer;
        }
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan");
        return analyzer;
    }

    public static interface FieldValidator {
        public boolean validate(ExprNodeFieldDesc var1);
    }
}

