/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public interface AcidInputFormat<KEY extends WritableComparable, VALUE>
extends InputFormat<KEY, VALUE>,
InputFormatChecker {
    public RowReader<VALUE> getReader(InputSplit var1, Options var2) throws IOException;

    public RawReader<VALUE> getRawReader(Configuration var1, boolean var2, int var3, ValidWriteIdList var4, Path var5, Path[] var6, Map<String, String> var7) throws IOException;

    public static interface AcidRecordReader<K, V>
    extends RecordReader<K, V> {
        public RecordIdentifier getRecordIdentifier();
    }

    public static interface RawReader<V>
    extends RecordReader<RecordIdentifier, V> {
        public ObjectInspector getObjectInspector();

        public boolean isDelete(V var1);
    }

    public static interface RowReader<V>
    extends RecordReader<RecordIdentifier, V> {
        public ObjectInspector getObjectInspector();
    }

    public static class Options {
        private final Configuration conf;
        private Reporter reporter;

        public Options(Configuration conf) {
            this.conf = conf;
        }

        public Options reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public Reporter getReporter() {
            return this.reporter;
        }
    }

    public static final class DeltaMetaData
    implements Writable {
        private long minWriteId;
        private long maxWriteId;
        private List<Integer> stmtIds;
        private long visibilityTxnId;

        public DeltaMetaData() {
            this(0L, 0L, new ArrayList<Integer>(), 0L);
        }

        DeltaMetaData(long minWriteId, long maxWriteId, List<Integer> stmtIds, long visibilityTxnId) {
            this.minWriteId = minWriteId;
            this.maxWriteId = maxWriteId;
            if (stmtIds == null) {
                throw new IllegalArgumentException("stmtIds == null");
            }
            this.stmtIds = stmtIds;
            this.visibilityTxnId = visibilityTxnId;
        }

        long getMinWriteId() {
            return this.minWriteId;
        }

        long getMaxWriteId() {
            return this.maxWriteId;
        }

        List<Integer> getStmtIds() {
            return this.stmtIds;
        }

        long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.minWriteId);
            out.writeLong(this.maxWriteId);
            out.writeInt(this.stmtIds.size());
            for (Integer id : this.stmtIds) {
                out.writeInt(id);
            }
            out.writeLong(this.visibilityTxnId);
        }

        public void readFields(DataInput in) throws IOException {
            this.minWriteId = in.readLong();
            this.maxWriteId = in.readLong();
            this.stmtIds.clear();
            int numStatements = in.readInt();
            for (int i = 0; i < numStatements; ++i) {
                this.stmtIds.add(in.readInt());
            }
            this.visibilityTxnId = in.readLong();
        }

        String getName() {
            assert (this.stmtIds.isEmpty()) : "use getName(int)";
            return AcidUtils.addVisibilitySuffix(AcidUtils.deleteDeltaSubdir(this.minWriteId, this.maxWriteId), this.visibilityTxnId);
        }

        String getName(int stmtId) {
            assert (!this.stmtIds.isEmpty()) : "use getName()";
            return AcidUtils.addVisibilitySuffix(AcidUtils.deleteDeltaSubdir(this.minWriteId, this.maxWriteId, stmtId), this.visibilityTxnId);
        }

        public String toString() {
            return "Delta(?," + this.minWriteId + "," + this.maxWriteId + "," + this.stmtIds + "," + this.visibilityTxnId + ")";
        }
    }
}

