/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ArrowBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.holders.DecimalHolder;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.arrow.ArrowColumnarBatchSerDe;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.RootAllocatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class Serializer {
    private final int MAX_BUFFERED_ROWS;
    private static final byte[] EMPTY_BYTES = new byte[0];
    @VisibleForTesting
    final VectorizedRowBatch vectorizedRowBatch;
    private final VectorAssignRow vectorAssignRow;
    private int batchSize;
    private BufferAllocator allocator;
    private List<TypeInfo> fieldTypeInfos;
    private List<String> fieldNames;
    private int fieldSize;
    private boolean useHybridCalendar;
    private final NullableMapVector rootVector;
    private final DecimalHolder decimalHolder = new DecimalHolder();
    private static final IntAndVectorsConsumer boolNullSetter = (i, arrowVector, hiveVector) -> ((BitVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer boolValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((BitVector)arrowVector).set(i, (int)((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer byteNullSetter = (i, arrowVector, hiveVector) -> ((TinyIntVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer byteValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((TinyIntVector)arrowVector).set(i, (byte)((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer shortNullSetter = (i, arrowVector, hiveVector) -> ((SmallIntVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer shortValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((SmallIntVector)arrowVector).set(i, (short)((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer intNullSetter = (i, arrowVector, hiveVector) -> ((IntVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer intValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((IntVector)arrowVector).set(i, (int)((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer longNullSetter = (i, arrowVector, hiveVector) -> ((BigIntVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer longValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((BigIntVector)arrowVector).set(i, ((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer floatNullSetter = (i, arrowVector, hiveVector) -> ((Float4Vector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer floatValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((Float4Vector)arrowVector).set(i, (float)((DoubleColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer doubleNullSetter = (i, arrowVector, hiveVector) -> ((Float8Vector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer doubleValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((Float8Vector)arrowVector).set(i, ((DoubleColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer stringNullSetter = (i, arrowVector, hiveVector) -> ((VarCharVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer stringValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        BytesColumnVector bytesVector = (BytesColumnVector)hiveVector;
        ((VarCharVector)arrowVector).setSafe(i, bytesVector.vector[j], bytesVector.start[j], bytesVector.length[j]);
    };
    private static final IntAndVectorsConsumer charNullSetter = (i, arrowVector, hiveVector) -> ((VarCharVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer charValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        BytesColumnVector bytesVector = (BytesColumnVector)hiveVector;
        VarCharVector varCharVector = (VarCharVector)arrowVector;
        byte[] bytes = bytesVector.vector[j];
        int length = bytesVector.length[j];
        int start = bytesVector.start[j];
        if (bytes == null) {
            bytes = EMPTY_BYTES;
            start = 0;
            length = 0;
        }
        CharTypeInfo charTypeInfo = (CharTypeInfo)typeInfo;
        int paddedLength = charTypeInfo.getLength();
        byte[] paddedBytes = StringExpr.padRight(bytes, start, length, paddedLength);
        varCharVector.setSafe(i, paddedBytes, 0, paddedBytes.length);
    };
    private static final IntAndVectorsConsumer dateNullSetter = (i, arrowVector, hiveVector) -> ((DateDayVector)arrowVector).setNull(i);
    private final IntIntAndVectorsConsumer dateValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        DateColumnVector dateColumnVector = (DateColumnVector)hiveVector;
        if (this.useHybridCalendar && dateColumnVector.isUsingProlepticCalendar()) {
            dateColumnVector.changeCalendar(false, true);
        }
        ((DateDayVector)arrowVector).set(i, (int)dateColumnVector.vector[j]);
    };
    private static final IntAndVectorsConsumer timestampNullSetter = (i, arrowVector, hiveVector) -> ((TimeStampMicroTZVector)arrowVector).setNull(i);
    private final IntIntAndVectorsConsumer timestampValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)arrowVector;
        TimestampColumnVector timestampColumnVector = (TimestampColumnVector)hiveVector;
        if (this.useHybridCalendar && timestampColumnVector.usingProlepticCalendar()) {
            timestampColumnVector.changeCalendar(false, true);
        }
        long secondInMillis = timestampColumnVector.getTime(j);
        long nanos = timestampColumnVector.getNanos(j);
        long secondInMicros = (secondInMillis - nanos / 1000000L) * 1000L;
        long subSecondInMicros = nanos / 1000L;
        if (secondInMillis > 0L && secondInMicros < 0L || secondInMillis < 0L && secondInMicros > 0L) {
            timeStampMicroTZVector.setNull(i);
        } else {
            timeStampMicroTZVector.set(i, secondInMicros + subSecondInMicros);
        }
    };
    private static final IntAndVectorsConsumer binaryNullSetter = (i, arrowVector, hiveVector) -> ((VarBinaryVector)arrowVector).setNull(i);
    private static final IntIntAndVectorsConsumer binaryValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        BytesColumnVector bytesVector = (BytesColumnVector)hiveVector;
        ((VarBinaryVector)arrowVector).setSafe(i, bytesVector.vector[j], bytesVector.start[j], bytesVector.length[j]);
    };
    private static final IntAndVectorsConsumer decimalNullSetter = (i, arrowVector, hiveVector) -> ((DecimalVector)arrowVector).setNull(i);
    private final IntIntAndVectorsConsumer decimalValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        DecimalVector decimalVector = (DecimalVector)arrowVector;
        int scale = decimalVector.getScale();
        decimalVector.set(i, ((DecimalColumnVector)hiveVector).vector[j].getHiveDecimal().bigDecimalValue().setScale(scale));
        HiveDecimalWritable writable = ((DecimalColumnVector)hiveVector).vector[j];
        this.decimalHolder.precision = writable.precision();
        this.decimalHolder.scale = scale;
        try (ArrowBuf arrowBuf = this.allocator.buffer(16);){
            this.decimalHolder.buffer = arrowBuf;
            BigInteger bigInteger = new BigInteger(writable.getInternalStorage()).multiply(BigInteger.TEN.pow(scale - writable.scale()));
            decimalVector.set(i, new BigDecimal(bigInteger, scale));
        }
    };
    private static final IntIntAndVectorsConsumer decimal64ValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        DecimalVector decimalVector = (DecimalVector)arrowVector;
        int scale = decimalVector.getScale();
        HiveDecimalWritable decimalHolder = new HiveDecimalWritable();
        decimalHolder.setFromLongAndScale(((Decimal64ColumnVector)hiveVector).vector[j], scale);
        decimalVector.set(i, decimalHolder.getHiveDecimal().bigDecimalValue().setScale(scale));
    };
    private static final IntAndVectorsConsumer intervalYearMonthNullSetter = (i, arrowVector, hiveVector) -> ((IntervalYearVector)arrowVector).setNull(i);
    private static IntIntAndVectorsConsumer intervalYearMonthValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> ((IntervalYearVector)arrowVector).set(i, (int)((LongColumnVector)hiveVector).vector[j]);
    private static final IntAndVectorsConsumer intervalDayTimeNullSetter = (i, arrowVector, hiveVector) -> ((IntervalDayVector)arrowVector).setNull(i);
    private static IntIntAndVectorsConsumer intervalDayTimeValueSetter = (i, j, arrowVector, hiveVector, typeInfo) -> {
        IntervalDayVector intervalDayVector = (IntervalDayVector)arrowVector;
        IntervalDayTimeColumnVector intervalDayTimeColumnVector = (IntervalDayTimeColumnVector)hiveVector;
        long totalSeconds = intervalDayTimeColumnVector.getTotalSeconds(j);
        long days = totalSeconds / 86400L;
        long millis = (totalSeconds - days * 86400L) * 1000L + intervalDayTimeColumnVector.getNanos(j) / 1000000L;
        intervalDayVector.set(i, (int)days, (int)millis);
    };

    public Serializer(Configuration conf, String attemptId, List<TypeInfo> typeInfos, List<String> fieldNames) {
        this.fieldTypeInfos = typeInfos;
        this.fieldNames = fieldNames;
        long childAllocatorLimit = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVE_ARROW_BATCH_ALLOCATOR_LIMIT);
        this.useHybridCalendar = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_USE_HYBRID_CALENDAR);
        long childAllocatorReservation = 0L;
        this.allocator = RootAllocatorFactory.INSTANCE.getRootAllocator(conf).newChildAllocator(attemptId, childAllocatorReservation, childAllocatorLimit);
        this.rootVector = NullableMapVector.empty(null, (BufferAllocator)this.allocator);
        this.vectorizedRowBatch = null;
        this.vectorAssignRow = null;
        this.MAX_BUFFERED_ROWS = 0;
    }

    Serializer(ArrowColumnarBatchSerDe serDe) throws SerDeException {
        this.MAX_BUFFERED_ROWS = HiveConf.getIntVar(serDe.conf, HiveConf.ConfVars.HIVE_ARROW_BATCH_SIZE);
        long childAllocatorLimit = HiveConf.getLongVar(serDe.conf, HiveConf.ConfVars.HIVE_ARROW_BATCH_ALLOCATOR_LIMIT);
        this.useHybridCalendar = HiveConf.getBoolVar(serDe.conf, HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_USE_HYBRID_CALENDAR);
        ArrowColumnarBatchSerDe.LOG.info("ArrowColumnarBatchSerDe max number of buffered columns: " + this.MAX_BUFFERED_ROWS);
        String childAllocatorName = Thread.currentThread().getName();
        long childAllocatorReservation = 0L;
        this.allocator = serDe.rootAllocator.newChildAllocator(childAllocatorName, childAllocatorReservation, childAllocatorLimit);
        StructTypeInfo structTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(serDe.rowObjectInspector);
        this.fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        this.fieldNames = structTypeInfo.getAllStructFieldNames();
        this.fieldSize = this.fieldTypeInfos.size();
        this.rootVector = NullableMapVector.empty(null, (BufferAllocator)this.allocator);
        this.vectorizedRowBatch = new VectorizedRowBatch(this.fieldSize);
        for (int fieldIndex = 0; fieldIndex < this.fieldSize; ++fieldIndex) {
            ColumnVector columnVector;
            this.vectorizedRowBatch.cols[fieldIndex] = columnVector = VectorizedBatchUtil.createColumnVector(this.fieldTypeInfos.get(fieldIndex));
            columnVector.init();
        }
        this.vectorizedRowBatch.ensureSize(this.MAX_BUFFERED_ROWS);
        this.vectorAssignRow = new VectorAssignRow();
        try {
            this.vectorAssignRow.init(serDe.rowObjectInspector);
        }
        catch (HiveException e) {
            throw new SerDeException(e);
        }
    }

    public ArrowWrapperWritable emptyBatch() {
        this.rootVector.setValueCount(0);
        for (int fieldIndex = 0; fieldIndex < this.fieldTypeInfos.size(); ++fieldIndex) {
            TypeInfo fieldTypeInfo = this.fieldTypeInfos.get(fieldIndex);
            String fieldName = this.fieldNames.get(fieldIndex);
            FieldType fieldType = Serializer.toFieldType(fieldTypeInfo);
            FieldVector arrowVector = this.rootVector.addOrGet(fieldName, fieldType, FieldVector.class);
            arrowVector.setInitialCapacity(0);
            arrowVector.allocateNew();
        }
        VectorSchemaRoot vectorSchemaRoot = new VectorSchemaRoot((FieldVector)this.rootVector);
        return new ArrowWrapperWritable(vectorSchemaRoot, this.allocator, this.rootVector);
    }

    public ArrowWrapperWritable serializeBatch(VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        this.rootVector.setValueCount(0);
        for (int fieldIndex = 0; fieldIndex < vectorizedRowBatch.projectionSize; ++fieldIndex) {
            int projectedColumn = vectorizedRowBatch.projectedColumns[fieldIndex];
            ColumnVector hiveVector = vectorizedRowBatch.cols[projectedColumn];
            TypeInfo fieldTypeInfo = this.fieldTypeInfos.get(fieldIndex);
            String fieldName = this.fieldNames.get(fieldIndex);
            FieldType fieldType = Serializer.toFieldType(fieldTypeInfo);
            FieldVector arrowVector = this.rootVector.addOrGet(fieldName, fieldType, FieldVector.class);
            arrowVector.setInitialCapacity(isNative ? vectorizedRowBatch.size : this.batchSize);
            arrowVector.allocateNew();
            this.write(arrowVector, hiveVector, fieldTypeInfo, isNative ? vectorizedRowBatch.size : this.batchSize, vectorizedRowBatch, isNative);
        }
        if (!isNative) {
            vectorizedRowBatch.reset();
            this.rootVector.setValueCount(this.batchSize);
        } else {
            this.rootVector.setValueCount(vectorizedRowBatch.size);
        }
        this.batchSize = 0;
        VectorSchemaRoot vectorSchemaRoot = new VectorSchemaRoot((FieldVector)this.rootVector);
        return new ArrowWrapperWritable(vectorSchemaRoot, this.allocator, this.rootVector);
    }

    private static FieldType toFieldType(TypeInfo typeInfo) {
        return new FieldType(true, Serializer.toArrowType(typeInfo), null);
    }

    private static ArrowType toArrowType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return Types.MinorType.BIT.getType();
                    }
                    case BYTE: {
                        return Types.MinorType.TINYINT.getType();
                    }
                    case SHORT: {
                        return Types.MinorType.SMALLINT.getType();
                    }
                    case INT: {
                        return Types.MinorType.INT.getType();
                    }
                    case LONG: {
                        return Types.MinorType.BIGINT.getType();
                    }
                    case FLOAT: {
                        return Types.MinorType.FLOAT4.getType();
                    }
                    case DOUBLE: {
                        return Types.MinorType.FLOAT8.getType();
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        return Types.MinorType.VARCHAR.getType();
                    }
                    case DATE: {
                        return Types.MinorType.DATEDAY.getType();
                    }
                    case TIMESTAMP: {
                        return new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC");
                    }
                    case BINARY: {
                        return Types.MinorType.VARBINARY.getType();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        return new ArrowType.Decimal(decimalTypeInfo.precision(), decimalTypeInfo.scale());
                    }
                    case INTERVAL_YEAR_MONTH: {
                        return Types.MinorType.INTERVALYEAR.getType();
                    }
                    case INTERVAL_DAY_TIME: {
                        return Types.MinorType.INTERVALDAY.getType();
                    }
                }
                throw new IllegalArgumentException();
            }
            case LIST: {
                return ArrowType.List.INSTANCE;
            }
            case STRUCT: {
                return ArrowType.Struct.INSTANCE;
            }
            case MAP: {
                return ArrowType.List.INSTANCE;
            }
        }
        throw new IllegalArgumentException();
    }

    private void write(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                this.writePrimitive(arrowVector, hiveVector, typeInfo, size, vectorizedRowBatch, isNative);
                break;
            }
            case LIST: {
                this.writeList((ListVector)arrowVector, (ListColumnVector)hiveVector, (ListTypeInfo)typeInfo, size, vectorizedRowBatch, isNative);
                break;
            }
            case STRUCT: {
                this.writeStruct((MapVector)arrowVector, (StructColumnVector)hiveVector, (StructTypeInfo)typeInfo, size, vectorizedRowBatch, isNative);
                break;
            }
            case UNION: {
                this.writeUnion(arrowVector, hiveVector, typeInfo, size, vectorizedRowBatch, isNative);
                break;
            }
            case MAP: {
                this.writeMap((ListVector)arrowVector, (MapColumnVector)hiveVector, (MapTypeInfo)typeInfo, size, vectorizedRowBatch, isNative);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void writeMap(ListVector arrowVector, MapColumnVector hiveVector, MapTypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        ListTypeInfo structListTypeInfo = ArrowColumnarBatchSerDe.toStructListTypeInfo(typeInfo);
        ListColumnVector structListVector = ArrowColumnarBatchSerDe.toStructListVector(hiveVector);
        this.write((FieldVector)arrowVector, structListVector, structListTypeInfo, size, vectorizedRowBatch, isNative);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int selectedIndex = rowIndex;
            if (vectorizedRowBatch.selectedInUse) {
                selectedIndex = vectorizedRowBatch.selected[rowIndex];
            }
            if (hiveVector.isNull[selectedIndex]) {
                BitVectorHelper.setValidityBit((ArrowBuf)arrowVector.getValidityBuffer(), (int)rowIndex, (int)0);
                continue;
            }
            BitVectorHelper.setValidityBitToOne((ArrowBuf)arrowVector.getValidityBuffer(), (int)rowIndex);
        }
    }

    private void writeUnion(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
        List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
        UnionColumnVector hiveUnionVector = (UnionColumnVector)hiveVector;
        ColumnVector[] hiveObjectVectors = hiveUnionVector.fields;
        int tag = hiveUnionVector.tags[0];
        ColumnVector hiveObjectVector = hiveObjectVectors[tag];
        TypeInfo objectTypeInfo = objectTypeInfos.get(tag);
        this.write(arrowVector, hiveObjectVector, objectTypeInfo, size, vectorizedRowBatch, isNative);
    }

    private void writeStruct(MapVector arrowVector, StructColumnVector hiveVector, StructTypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        ArrayList<String> fieldNames = typeInfo.getAllStructFieldNames();
        ArrayList<TypeInfo> fieldTypeInfos = typeInfo.getAllStructFieldTypeInfos();
        ColumnVector[] hiveFieldVectors = hiveVector.fields;
        int fieldSize = fieldTypeInfos.size();
        for (int fieldIndex = 0; fieldIndex < fieldSize; ++fieldIndex) {
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(fieldIndex);
            ColumnVector hiveFieldVector = hiveFieldVectors[fieldIndex];
            String fieldName = (String)fieldNames.get(fieldIndex);
            FieldVector arrowFieldVector = arrowVector.addOrGet(fieldName, Serializer.toFieldType((TypeInfo)fieldTypeInfos.get(fieldIndex)), FieldVector.class);
            arrowFieldVector.setInitialCapacity(size);
            arrowFieldVector.allocateNew();
            this.write(arrowFieldVector, hiveFieldVector, fieldTypeInfo, size, vectorizedRowBatch, isNative);
        }
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            if (hiveVector.isNull[rowIndex]) {
                BitVectorHelper.setValidityBit((ArrowBuf)arrowVector.getValidityBuffer(), (int)rowIndex, (int)0);
                continue;
            }
            BitVectorHelper.setValidityBitToOne((ArrowBuf)arrowVector.getValidityBuffer(), (int)rowIndex);
        }
    }

    private static VectorizedRowBatch correctSelectedAndSize(VectorizedRowBatch sourceVrb, MultiValuedColumnVector multiValuedColumnVector) {
        VectorizedRowBatch vrb = new VectorizedRowBatch(sourceVrb.numCols, sourceVrb.size);
        vrb.cols = sourceVrb.cols;
        vrb.endOfFile = sourceVrb.endOfFile;
        vrb.projectedColumns = sourceVrb.projectedColumns;
        vrb.projectionSize = sourceVrb.projectionSize;
        vrb.selectedInUse = sourceVrb.selectedInUse;
        vrb.setPartitionInfo(sourceVrb.getDataColumnCount(), sourceVrb.getPartitionColumnCount());
        int correctedSize = 0;
        int[] srcVrbSelected = sourceVrb.selected;
        for (int i = 0; i < sourceVrb.size; ++i) {
            correctedSize = (int)((long)correctedSize + multiValuedColumnVector.lengths[srcVrbSelected[i]]);
        }
        int newIndex = 0;
        int[] selectedOffsetsCorrected = new int[correctedSize];
        for (int i = 0; i < sourceVrb.size; ++i) {
            long elementIndex = multiValuedColumnVector.offsets[srcVrbSelected[i]];
            long elementSize = multiValuedColumnVector.lengths[srcVrbSelected[i]];
            int j = 0;
            while ((long)j < elementSize) {
                selectedOffsetsCorrected[newIndex++] = (int)(elementIndex + (long)j);
                ++j;
            }
        }
        vrb.selected = selectedOffsetsCorrected;
        vrb.size = correctedSize;
        return vrb;
    }

    private void writeList(ListVector arrowVector, ListColumnVector hiveVector, ListTypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        int OFFSET_WIDTH = 4;
        TypeInfo elementTypeInfo = typeInfo.getListElementTypeInfo();
        ColumnVector hiveElementVector = hiveVector.child;
        FieldVector arrowElementVector = (FieldVector)arrowVector.addOrGetVector(Serializer.toFieldType(elementTypeInfo)).getVector();
        VectorizedRowBatch correctedVrb = vectorizedRowBatch;
        int correctedSize = hiveVector.childCount;
        if (vectorizedRowBatch.selectedInUse) {
            correctedVrb = Serializer.correctSelectedAndSize(vectorizedRowBatch, hiveVector);
            correctedSize = correctedVrb.size;
        }
        arrowElementVector.setInitialCapacity(correctedSize);
        arrowElementVector.allocateNew();
        this.write(arrowElementVector, hiveElementVector, elementTypeInfo, correctedSize, correctedVrb, isNative);
        int nextOffset = 0;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int selectedIndex = rowIndex;
            if (vectorizedRowBatch.selectedInUse) {
                selectedIndex = vectorizedRowBatch.selected[rowIndex];
            }
            if (hiveVector.isNull[selectedIndex]) {
                arrowVector.getOffsetBuffer().setInt(rowIndex * 4, nextOffset);
                continue;
            }
            arrowVector.getOffsetBuffer().setInt(rowIndex * 4, nextOffset);
            nextOffset += (int)hiveVector.lengths[selectedIndex];
            arrowVector.setNotNull(rowIndex);
        }
        arrowVector.getOffsetBuffer().setInt(size * 4, nextOffset);
    }

    private void writePrimitive(FieldVector arrowVector, ColumnVector hiveVector, TypeInfo typeInfo, int size, VectorizedRowBatch vectorizedRowBatch, boolean isNative) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        switch (primitiveCategory) {
            case BOOLEAN: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, boolNullSetter, boolValueSetter, typeInfo);
                    return;
                }
                BitVector bitVector = (BitVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        boolNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    boolValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case BYTE: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, byteNullSetter, byteValueSetter, typeInfo);
                    return;
                }
                TinyIntVector tinyIntVector = (TinyIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        byteNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    byteValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case SHORT: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, shortNullSetter, shortValueSetter, typeInfo);
                    return;
                }
                SmallIntVector smallIntVector = (SmallIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        shortNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    shortValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case INT: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, intNullSetter, intValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    intValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case LONG: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, longNullSetter, longValueSetter, typeInfo);
                    return;
                }
                BigIntVector bigIntVector = (BigIntVector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        longNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    longValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case FLOAT: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, floatNullSetter, floatValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        floatNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    floatValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case DOUBLE: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, doubleNullSetter, doubleValueSetter, typeInfo);
                    return;
                }
                Float8Vector float8Vector = (Float8Vector)arrowVector;
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        doubleNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    doubleValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case CHAR: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, charNullSetter, charValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        charNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    charValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case STRING: 
            case VARCHAR: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, stringNullSetter, stringValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        stringNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    stringValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case DATE: {
                ((DateColumnVector)hiveVector).setUsingProlepticCalendar(true);
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, dateNullSetter, this.dateValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        dateNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    this.dateValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case TIMESTAMP: {
                ((TimestampColumnVector)hiveVector).setUsingProlepticCalendar(true);
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, timestampNullSetter, this.timestampValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        timestampNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    this.timestampValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case BINARY: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, binaryNullSetter, binaryValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        binaryNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    binaryValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case DECIMAL: {
                if (isNative) {
                    if (hiveVector instanceof DecimalColumnVector) {
                        Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, decimalNullSetter, this.decimalValueSetter, typeInfo);
                    } else {
                        Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, decimalNullSetter, decimal64ValueSetter, typeInfo);
                    }
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        decimalNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    if (hiveVector instanceof DecimalColumnVector) {
                        this.decimalValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                        continue;
                    }
                    if (hiveVector instanceof Decimal64ColumnVector) {
                        decimal64ValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported vector column type: " + hiveVector.getClass().getName());
                }
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, intervalYearMonthNullSetter, intervalYearMonthValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intervalYearMonthNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    intervalYearMonthValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            case INTERVAL_DAY_TIME: {
                if (isNative) {
                    Serializer.writeGeneric(arrowVector, hiveVector, size, vectorizedRowBatch.selectedInUse, vectorizedRowBatch.selected, intervalDayTimeNullSetter, intervalDayTimeValueSetter, typeInfo);
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    if (hiveVector.isNull[i]) {
                        intervalDayTimeNullSetter.accept(i, arrowVector, hiveVector);
                        continue;
                    }
                    intervalDayTimeValueSetter.accept(i, i, arrowVector, hiveVector, typeInfo);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    ArrowWrapperWritable serialize(Object obj, ObjectInspector objInspector) {
        if (obj == null) {
            return this.serializeBatch(this.vectorizedRowBatch, false);
        }
        ArrayList<Object> standardObjects = new ArrayList<Object>();
        ObjectInspectorUtils.copyToStandardObject(standardObjects, obj, (StructObjectInspector)objInspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.vectorAssignRow.assignRow(this.vectorizedRowBatch, this.batchSize, standardObjects, this.fieldSize);
        ++this.batchSize;
        if (this.batchSize == this.MAX_BUFFERED_ROWS) {
            return this.serializeBatch(this.vectorizedRowBatch, false);
        }
        return null;
    }

    private static void writeGeneric(FieldVector fieldVector, ColumnVector hiveVector, int size, boolean selectedInUse, int[] selected, IntAndVectorsConsumer nullSetter, IntIntAndVectorsConsumer valueSetter, TypeInfo typeInfo) {
        boolean[] inputIsNull = hiveVector.isNull;
        int[] sel = selected;
        if (hiveVector.isRepeating) {
            if (hiveVector.noNulls || !inputIsNull[0]) {
                for (int i = 0; i < size; ++i) {
                    valueSetter.accept(i, 0, fieldVector, hiveVector, typeInfo);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    nullSetter.accept(i, fieldVector, hiveVector);
                }
            }
            return;
        }
        if (hiveVector.noNulls) {
            if (selectedInUse) {
                for (int logical = 0; logical < size; ++logical) {
                    int batchIndex = sel[logical];
                    valueSetter.accept(logical, batchIndex, fieldVector, hiveVector, typeInfo);
                }
            } else {
                for (int batchIndex = 0; batchIndex < size; ++batchIndex) {
                    valueSetter.accept(batchIndex, batchIndex, fieldVector, hiveVector, typeInfo);
                }
            }
        } else if (selectedInUse) {
            for (int logical = 0; logical < size; ++logical) {
                int batchIndex = sel[logical];
                if (inputIsNull[batchIndex]) {
                    nullSetter.accept(logical, fieldVector, hiveVector);
                    continue;
                }
                valueSetter.accept(logical, batchIndex, fieldVector, hiveVector, typeInfo);
            }
        } else {
            for (int batchIndex = 0; batchIndex < size; ++batchIndex) {
                if (inputIsNull[batchIndex]) {
                    nullSetter.accept(batchIndex, fieldVector, hiveVector);
                    continue;
                }
                valueSetter.accept(batchIndex, batchIndex, fieldVector, hiveVector, typeInfo);
            }
        }
    }

    private static interface IntIntAndVectorsConsumer {
        public void accept(int var1, int var2, FieldVector var3, ColumnVector var4, TypeInfo var5);
    }

    private static interface IntAndVectorsConsumer {
        public void accept(int var1, FieldVector var2, ColumnVector var3);
    }
}

