/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.merge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcFileStripeMergeInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.InputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Merge File Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class MergeFileWork
extends MapWork {
    private static final Logger LOG = LoggerFactory.getLogger(MergeFileWork.class);
    private List<Path> inputPaths;
    private Path outputDir;
    private boolean hasDynamicPartitions;
    private boolean isListBucketingAlterTableConcatenate;
    private ListBucketingCtx listBucketingCtx;
    private String srcTblInputFormat;
    private Class<? extends InputFormat> internalInputFormat;

    public MergeFileWork(List<Path> inputPaths, Path outputDir, String srcTblInputFormat, TableDesc tbl) {
        this(inputPaths, outputDir, false, srcTblInputFormat, tbl);
    }

    public MergeFileWork(List<Path> inputPaths, Path outputDir, boolean hasDynamicPartitions, String srcTblInputFormat, TableDesc tbl) {
        this.inputPaths = inputPaths;
        this.outputDir = outputDir;
        this.hasDynamicPartitions = hasDynamicPartitions;
        this.srcTblInputFormat = srcTblInputFormat;
        PartitionDesc partDesc = new PartitionDesc();
        if (srcTblInputFormat.equals(OrcInputFormat.class.getName())) {
            this.internalInputFormat = OrcFileStripeMergeInputFormat.class;
        } else if (srcTblInputFormat.equals(RCFileInputFormat.class.getName())) {
            this.internalInputFormat = RCFileBlockMergeInputFormat.class;
        }
        partDesc.setInputFileFormatClass(this.internalInputFormat);
        partDesc.setTableDesc(tbl);
        for (Path path : this.inputPaths) {
            this.addPathToPartitionInfo(path, partDesc);
        }
        this.isListBucketingAlterTableConcatenate = false;
    }

    public List<Path> getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(List<Path> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return this.getInputformatClass().getName();
    }

    public Class<? extends InputFormat> getInputformatClass() {
        return CombineHiveInputFormat.class;
    }

    @Override
    public boolean isGatheringStats() {
        return false;
    }

    public boolean hasDynamicPartitions() {
        return this.hasDynamicPartitions;
    }

    public void setHasDynamicPartitions(boolean hasDynamicPartitions) {
        this.hasDynamicPartitions = hasDynamicPartitions;
    }

    @Override
    public void resolveDynamicPartitionStoredAsSubDirsMerge(HiveConf conf, Path path, TableDesc tblDesc, List<String> aliases, PartitionDesc partDesc) {
        super.resolveDynamicPartitionStoredAsSubDirsMerge(conf, path, tblDesc, aliases, partDesc);
        partDesc.setInputFileFormatClass(this.internalInputFormat);
        this.inputPaths.add(path);
    }

    public void resolveConcatenateMerge(HiveConf conf) {
        this.isListBucketingAlterTableConcatenate = this.listBucketingCtx == null ? false : this.listBucketingCtx.isSkewedStoredAsDir();
        LOG.info("isListBucketingAlterTableConcatenate : " + this.isListBucketingAlterTableConcatenate);
        if (this.isListBucketingAlterTableConcatenate) {
            assert (this.inputPaths != null && this.inputPaths.size() == 1) : "alter table ... concatenate should only have one directory inside inputpaths";
            Path dirPath = this.inputPaths.get(0);
            try {
                FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
                List<FileStatus> status = HiveStatsUtils.getFileStatusRecurse(dirPath, this.listBucketingCtx.getSkewedColNames().size(), inpFs);
                ArrayList<Path> newInputPath = new ArrayList<Path>();
                boolean succeed = true;
                for (FileStatus s : status) {
                    if (s.isDir()) {
                        newInputPath.add(s.getPath());
                        continue;
                    }
                    succeed = false;
                }
                assert (succeed || !succeed && newInputPath.isEmpty()) : "This partition has  inconsistent file structure: it is stored-as-subdir and expected all files in the same depth of subdirectories.";
                if (succeed) {
                    this.inputPaths.clear();
                    this.inputPaths.addAll(newInputPath);
                }
            }
            catch (IOException e) {
                String msg = "Fail to get filesystem for directory name : " + dirPath.toUri();
                throw new RuntimeException(msg, e);
            }
        }
    }

    public ListBucketingCtx getListBucketingCtx() {
        return this.listBucketingCtx;
    }

    public void setListBucketingCtx(ListBucketingCtx listBucketingCtx) {
        this.listBucketingCtx = listBucketingCtx;
    }

    public boolean isListBucketingAlterTableConcatenate() {
        return this.isListBucketingAlterTableConcatenate;
    }

    @Explain(displayName="input format")
    public String getSourceTableInputFormat() {
        return this.srcTblInputFormat;
    }

    public void setSourceTableInputFormat(String srcTblInputFormat) {
        this.srcTblInputFormat = srcTblInputFormat;
    }

    @Explain(displayName="merge level")
    public String getMergeLevel() {
        if (this.srcTblInputFormat != null) {
            if (this.srcTblInputFormat.equals(OrcInputFormat.class.getName())) {
                return "stripe";
            }
            if (this.srcTblInputFormat.equals(RCFileInputFormat.class.getName())) {
                return "block";
            }
        }
        return null;
    }
}

