/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.Progressable;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.AcidStats;
import org.apache.orc.impl.OrcAcidUtils;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.SchemaEvolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcRecordUpdater
implements RecordUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(OrcRecordUpdater.class);
    static final String ACID_KEY_INDEX_NAME = "hive.acid.key.index";
    static final int INSERT_OPERATION = 0;
    static final int UPDATE_OPERATION = 1;
    static final int DELETE_OPERATION = 2;
    static final int OPERATION = 0;
    static final int ORIGINAL_WRITEID = 1;
    static final int BUCKET = 2;
    static final int ROW_ID = 3;
    static final int CURRENT_WRITEID = 4;
    public static final int ROW = 5;
    static final int FIELDS = 6;
    static final int DELTA_BUFFER_SIZE = 16384;
    static final long DELTA_STRIPE_SIZE = 0x1000000L;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final AcidOutputFormat.Options options;
    private final AcidUtils.AcidOperationalProperties acidOperationalProperties;
    private final Path path;
    private Path deleteEventPath;
    private final FileSystem fs;
    private OrcFile.WriterOptions writerOptions;
    private OrcFile.WriterOptions deleteWriterOptions;
    private Writer writer = null;
    private boolean writerClosed = false;
    private Writer deleteEventWriter = null;
    private final FSDataOutputStream flushLengths;
    private final OrcStruct item;
    private final IntWritable operation = new IntWritable();
    private final LongWritable currentWriteId = new LongWritable(-1L);
    private final LongWritable originalWriteId = new LongWritable(-1L);
    private final IntWritable bucket = new IntWritable();
    private final LongWritable rowId = new LongWritable();
    private long insertedRows = 0L;
    private long rowCountDelta = 0L;
    private long bufferedRows = 0L;
    private final KeyIndexBuilder indexBuilder = new KeyIndexBuilder("insert");
    private KeyIndexBuilder deleteEventIndexBuilder;
    private StructField recIdField = null;
    private StructField rowIdField = null;
    private StructField originalWriteIdField = null;
    private StructField bucketField = null;
    private StructObjectInspector rowInspector;
    private StructObjectInspector recIdInspector;
    private LongObjectInspector rowIdInspector;
    private LongObjectInspector origWriteIdInspector;
    private IntObjectInspector bucketInspector;

    static int getOperation(OrcStruct struct) {
        return ((IntWritable)struct.getFieldValue(0)).get();
    }

    static long getCurrentTransaction(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(4)).get();
    }

    static long getOriginalTransaction(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(1)).get();
    }

    static int getBucket(OrcStruct struct) {
        return ((IntWritable)struct.getFieldValue(2)).get();
    }

    static long getRowId(OrcStruct struct) {
        return ((LongWritable)struct.getFieldValue(3)).get();
    }

    static OrcStruct getRow(OrcStruct struct) {
        if (struct == null) {
            return null;
        }
        return (OrcStruct)struct.getFieldValue(5);
    }

    static StructObjectInspector createEventObjectInspector(ObjectInspector rowInspector) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        fields.add(new OrcStruct.Field("operation", PrimitiveObjectInspectorFactory.writableIntObjectInspector, 0));
        fields.add(new OrcStruct.Field("originalTransaction", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 1));
        fields.add(new OrcStruct.Field("bucket", PrimitiveObjectInspectorFactory.writableIntObjectInspector, 2));
        fields.add(new OrcStruct.Field("rowId", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 3));
        fields.add(new OrcStruct.Field("currentTransaction", PrimitiveObjectInspectorFactory.writableLongObjectInspector, 4));
        fields.add(new OrcStruct.Field("row", rowInspector, 5));
        return new OrcStruct.OrcStructInspector(fields);
    }

    private static TypeDescription createEventSchemaFromTableProperties(Properties tableProps) {
        TypeDescription rowSchema = OrcRecordUpdater.getTypeDescriptionFromTableProperties(tableProps);
        if (rowSchema == null) {
            return null;
        }
        return SchemaEvolution.createEventSchema(rowSchema);
    }

    private static TypeDescription getTypeDescriptionFromTableProperties(Properties tableProperties) {
        TypeDescription schema = null;
        if (tableProperties != null) {
            String columnNameProperty = tableProperties.getProperty("columns");
            String columnTypeProperty = tableProperties.getProperty("columns.types");
            if (!Strings.isNullOrEmpty(columnNameProperty) && !Strings.isNullOrEmpty(columnTypeProperty)) {
                List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
                ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
                schema = TypeDescription.createStruct();
                for (int i = 0; i < columnNames.size(); ++i) {
                    schema.addField((String)columnNames.get(i), OrcInputFormat.convertTypeInfo((TypeInfo)columnTypes.get(i)));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ORC schema = " + schema);
        }
        return schema;
    }

    OrcRecordUpdater(Path partitionRoot, AcidOutputFormat.Options options) throws IOException {
        Configuration hc;
        this.options = options;
        this.acidOperationalProperties = options.getTableProperties() != null ? AcidUtils.getAcidOperationalProperties(options.getTableProperties()) : AcidUtils.getAcidOperationalProperties(options.getConfiguration());
        assert (this.acidOperationalProperties.isSplitUpdate()) : "HIVE-17089?!";
        BucketCodec bucketCodec = BucketCodec.V1;
        if (options.getConfiguration() != null && ((hc = options.getConfiguration()).getBoolean(HiveConf.ConfVars.HIVE_IN_TEST.name(), false) || hc.getBoolean(HiveConf.ConfVars.HIVE_IN_TEZ_TEST.name(), false))) {
            bucketCodec = BucketCodec.getCodec(hc.getInt(HiveConf.ConfVars.TESTMODE_BUCKET_CODEC_VERSION.name(), BucketCodec.V1.getVersion()));
        }
        this.bucket.set(bucketCodec.encode(options));
        this.path = AcidUtils.createFilename(partitionRoot, options);
        this.deleteEventWriter = null;
        this.deleteEventPath = null;
        FileSystem fs = options.getFilesystem();
        if (fs == null) {
            fs = partitionRoot.getFileSystem(options.getConfiguration());
        }
        this.fs = fs;
        if (options.getMinimumWriteId() != options.getMaximumWriteId() && !options.isWritingBase()) {
            this.flushLengths = fs.create(OrcAcidUtils.getSideFile(this.path), false, 8, (Progressable)options.getReporter());
            this.flushLengths.writeLong(0L);
            OrcInputFormat.SHIMS.hflush(this.flushLengths);
        } else {
            this.flushLengths = null;
        }
        this.writerOptions = null;
        if (options.isWritingBase()) {
            if (options instanceof OrcOptions) {
                this.writerOptions = ((OrcOptions)options).getOrcOptions();
            }
            if (this.writerOptions == null) {
                this.writerOptions = OrcFile.writerOptions(options.getTableProperties(), options.getConfiguration());
            }
        } else {
            AcidOutputFormat.Options optionsCloneForDelta = options.clone();
            if (optionsCloneForDelta instanceof OrcOptions) {
                this.writerOptions = ((OrcOptions)optionsCloneForDelta).getOrcOptions();
            }
            if (this.writerOptions == null) {
                this.writerOptions = OrcFile.writerOptions(optionsCloneForDelta.getTableProperties(), optionsCloneForDelta.getConfiguration());
            }
            if (this.acidOperationalProperties.isSplitUpdate()) {
                AcidOutputFormat.Options deleteOptions = options.clone().writingDeleteDelta(true);
                this.deleteEventPath = AcidUtils.createFilename(partitionRoot, deleteOptions);
                this.deleteWriterOptions = OrcFile.writerOptions(optionsCloneForDelta.getTableProperties(), optionsCloneForDelta.getConfiguration());
                this.deleteWriterOptions.inspector(OrcRecordUpdater.createEventObjectInspector(this.findRecId(options.getInspector(), options.getRecordIdColumn())));
                this.deleteWriterOptions.setSchema(OrcRecordUpdater.createEventSchemaFromTableProperties(options.getTableProperties()));
            }
            int baseBufferSizeValue = this.writerOptions.getBufferSize();
            long baseStripeSizeValue = this.writerOptions.getStripeSize();
            int ratio = (int)OrcConf.BASE_DELTA_RATIO.getLong(options.getConfiguration());
            this.writerOptions.bufferSize(baseBufferSizeValue / ratio);
            this.writerOptions.stripeSize(baseStripeSizeValue / (long)ratio);
            this.writerOptions.blockPadding(false);
            if (optionsCloneForDelta.getConfiguration().getBoolean(HiveConf.ConfVars.HIVE_ORC_DELTA_STREAMING_OPTIMIZATIONS_ENABLED.varname, false)) {
                this.writerOptions.encodingStrategy(OrcFile.EncodingStrategy.SPEED);
                this.writerOptions.rowIndexStride(0);
                this.writerOptions.getConfiguration().set(OrcConf.DICTIONARY_KEY_SIZE_THRESHOLD.getAttribute(), "-1.0");
            }
        }
        if (!HiveConf.getBoolVar(options.getConfiguration(), HiveConf.ConfVars.HIVETESTMODEACIDKEYIDXSKIP)) {
            this.writerOptions.fileSystem(fs).callback(this.indexBuilder);
        }
        this.rowInspector = (StructObjectInspector)options.getInspector();
        this.writerOptions.inspector(OrcRecordUpdater.createEventObjectInspector(this.findRecId(options.getInspector(), options.getRecordIdColumn())));
        this.writerOptions.setSchema(OrcRecordUpdater.createEventSchemaFromTableProperties(options.getTableProperties()));
        this.item = new OrcStruct(6);
        this.item.setFieldValue(0, this.operation);
        this.item.setFieldValue(4, this.currentWriteId);
        this.item.setFieldValue(1, this.originalWriteId);
        this.item.setFieldValue(2, this.bucket);
        this.item.setFieldValue(3, this.rowId);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    private ObjectInspector findRecId(ObjectInspector inspector, int rowIdColNum) {
        if (!(inspector instanceof StructObjectInspector)) {
            throw new RuntimeException("Serious problem, expected a StructObjectInspector, but got a " + inspector.getClass().getName());
        }
        if (rowIdColNum < 0) {
            return inspector;
        }
        RecIdStrippingObjectInspector newInspector = new RecIdStrippingObjectInspector(inspector, rowIdColNum);
        this.recIdField = newInspector.getRecId();
        List<? extends StructField> fields = ((StructObjectInspector)this.recIdField.getFieldObjectInspector()).getAllStructFieldRefs();
        this.originalWriteIdField = fields.get(0);
        this.origWriteIdInspector = (LongObjectInspector)this.originalWriteIdField.getFieldObjectInspector();
        this.bucketField = fields.get(1);
        this.bucketInspector = (IntObjectInspector)this.bucketField.getFieldObjectInspector();
        this.rowIdField = fields.get(2);
        this.rowIdInspector = (LongObjectInspector)this.rowIdField.getFieldObjectInspector();
        this.recIdInspector = (StructObjectInspector)this.recIdField.getFieldObjectInspector();
        return newInspector;
    }

    private void addSimpleEvent(int operation, long currentWriteId, long rowId, Object row) throws IOException {
        this.operation.set(operation);
        this.currentWriteId.set(currentWriteId);
        Integer currentBucket = null;
        long originalWriteId = currentWriteId;
        if (operation == 2 || operation == 1) {
            Object rowIdValue = this.rowInspector.getStructFieldData(row, this.recIdField);
            originalWriteId = this.origWriteIdInspector.get(this.recIdInspector.getStructFieldData(rowIdValue, this.originalWriteIdField));
            rowId = this.rowIdInspector.get(this.recIdInspector.getStructFieldData(rowIdValue, this.rowIdField));
            currentBucket = this.setBucket(this.bucketInspector.get(this.recIdInspector.getStructFieldData(rowIdValue, this.bucketField)), operation);
        }
        this.rowId.set(rowId);
        this.originalWriteId.set(originalWriteId);
        this.item.setFieldValue(0, new IntWritable(operation));
        this.item.setFieldValue(5, operation == 2 ? null : row);
        this.indexBuilder.addKey(operation, originalWriteId, this.bucket.get(), rowId);
        this.initWriter();
        this.writer.addRow(this.item);
        this.restoreBucket(currentBucket, operation);
    }

    private void addSplitUpdateEvent(int operation, long currentWriteId, long rowId, Object row) throws IOException {
        if (operation == 0) {
            this.addSimpleEvent(operation, currentWriteId, rowId, row);
            return;
        }
        this.operation.set(operation);
        this.currentWriteId.set(currentWriteId);
        Object rowValue = this.rowInspector.getStructFieldData(row, this.recIdField);
        long originalWriteId = this.origWriteIdInspector.get(this.recIdInspector.getStructFieldData(rowValue, this.originalWriteIdField));
        rowId = this.rowIdInspector.get(this.recIdInspector.getStructFieldData(rowValue, this.rowIdField));
        Integer currentBucket = null;
        if (operation == 2 || operation == 1) {
            currentBucket = this.setBucket(this.bucketInspector.get(this.recIdInspector.getStructFieldData(rowValue, this.bucketField)), operation);
            if (this.deleteEventWriter == null) {
                this.deleteEventIndexBuilder = new KeyIndexBuilder("delete");
                this.deleteEventWriter = OrcFile.createWriter(this.deleteEventPath, this.deleteWriterOptions.callback(this.deleteEventIndexBuilder));
                AcidUtils.OrcAcidVersion.setAcidVersionInDataFile(this.deleteEventWriter);
                if (this.options.isWriteVersionFile()) {
                    AcidUtils.OrcAcidVersion.writeVersionFile(this.deleteEventPath.getParent(), this.fs);
                }
            }
            this.rowId.set(rowId);
            this.originalWriteId.set(originalWriteId);
            this.item.setFieldValue(0, new IntWritable(2));
            this.item.setFieldValue(5, null);
            this.deleteEventIndexBuilder.addKey(2, originalWriteId, this.bucket.get(), rowId);
            this.deleteEventWriter.addRow(this.item);
            this.restoreBucket(currentBucket, operation);
        }
        if (operation == 1) {
            this.addSimpleEvent(0, currentWriteId, this.insertedRows++, row);
        }
    }

    @Override
    public void insert(long currentWriteId, Object row) throws IOException {
        if (this.currentWriteId.get() != currentWriteId) {
            this.insertedRows = 0L;
        }
        if (this.acidOperationalProperties.isSplitUpdate()) {
            this.addSplitUpdateEvent(0, currentWriteId, this.insertedRows++, row);
        } else {
            this.addSimpleEvent(0, currentWriteId, this.insertedRows++, row);
        }
        ++this.rowCountDelta;
        ++this.bufferedRows;
    }

    @Override
    public void update(long currentWriteId, Object row) throws IOException {
        if (this.currentWriteId.get() != currentWriteId) {
            this.insertedRows = 0L;
        }
        if (this.acidOperationalProperties.isSplitUpdate()) {
            this.addSplitUpdateEvent(1, currentWriteId, -1L, row);
        } else {
            this.addSimpleEvent(1, currentWriteId, -1L, row);
        }
    }

    @Override
    public void delete(long currentWriteId, Object row) throws IOException {
        if (this.currentWriteId.get() != currentWriteId) {
            this.insertedRows = 0L;
        }
        if (this.acidOperationalProperties.isSplitUpdate()) {
            this.addSplitUpdateEvent(2, currentWriteId, -1L, row);
        } else {
            this.addSimpleEvent(2, currentWriteId, -1L, row);
        }
        --this.rowCountDelta;
    }

    @Override
    public void flush() throws IOException {
        this.initWriter();
        if (this.flushLengths == null) {
            this.writer.writeIntermediateFooter();
        } else {
            long len = this.writer.writeIntermediateFooter();
            this.flushLengths.writeLong(len);
            OrcInputFormat.SHIMS.hflush(this.flushLengths);
        }
        this.bufferedRows = 0L;
        assert (this.deleteEventWriter == null) : "unexpected delete writer for " + this.path;
    }

    @Override
    public void close(boolean abort) throws IOException {
        if (abort) {
            if (this.flushLengths == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Close on abort for path: {}.. Deleting..", (Object)this.path);
                }
                this.fs.delete(this.path, false);
            }
        } else if (!this.writerClosed) {
            if (this.acidOperationalProperties.isSplitUpdate()) {
                if (this.indexBuilder.acidStats.inserts > 0L) {
                    if (this.writer != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Closing writer for path: {} acid stats: {}", (Object)this.path, (Object)this.indexBuilder.acidStats);
                        }
                        this.writer.close();
                    }
                } else if (this.options.isWritingBase()) {
                    LOG.debug("Empty file has been created for overwrite: {}", (Object)this.path);
                    OrcFile.createWriter(this.path, this.writerOptions).close();
                } else {
                    LOG.debug("No insert events in path: {}.. Deleting..", (Object)this.path);
                    this.fs.delete(this.path, false);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initializing writer before close (to create empty buckets) for path: {}", (Object)this.path);
                }
                this.initWriter();
                this.writer.close();
            }
            if (this.deleteEventWriter != null) {
                if (this.deleteEventIndexBuilder.acidStats.deletes > 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing delete event writer for path: {} acid stats: {}", (Object)this.path, (Object)this.indexBuilder.acidStats);
                    }
                    this.deleteEventWriter.close();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No delete events in path: {}.. Deleting..", (Object)this.path);
                    }
                    this.fs.delete(this.deleteEventPath, false);
                }
            }
        }
        if (this.flushLengths != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing and deleting flush length file for path: {}", (Object)this.path);
            }
            this.flushLengths.close();
            this.fs.delete(OrcAcidUtils.getSideFile(this.path), false);
        }
        this.writer = null;
        this.deleteEventWriter = null;
        this.writerClosed = true;
    }

    private void initWriter() throws IOException {
        if (this.writer == null) {
            this.writer = OrcFile.createWriter(this.path, this.writerOptions);
            AcidUtils.OrcAcidVersion.setAcidVersionInDataFile(this.writer);
            if (this.options.isWriteVersionFile()) {
                try {
                    AcidUtils.OrcAcidVersion.writeVersionFile(this.path.getParent(), this.fs);
                }
                catch (Exception e) {
                    LOG.trace("Ignore; might have been created by another concurrent writer, writing to a different bucket within this delta/base directory", (Throwable)e);
                }
            }
        }
    }

    @Override
    public SerDeStats getStats() {
        SerDeStats stats = new SerDeStats();
        stats.setRowCount(this.rowCountDelta);
        return stats;
    }

    @Override
    public long getBufferedRowCount() {
        return this.bufferedRows;
    }

    static RecordIdentifier[] parseKeyIndex(Reader reader) {
        if (!reader.hasMetadataValue(ACID_KEY_INDEX_NAME)) {
            return null;
        }
        ByteBuffer val = reader.getMetadataValue(ACID_KEY_INDEX_NAME).duplicate();
        return OrcRecordUpdater.parseKeyIndex(val);
    }

    static RecordIdentifier[] parseKeyIndex(OrcTail orcTail) {
        for (OrcProto.UserMetadataItem item : orcTail.getFooter().getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(ACID_KEY_INDEX_NAME)) continue;
            return OrcRecordUpdater.parseKeyIndex(item.getValue().asReadOnlyByteBuffer().duplicate());
        }
        return null;
    }

    private static RecordIdentifier[] parseKeyIndex(ByteBuffer val) {
        String[] stripes;
        try {
            CharsetDecoder utf8Decoder = UTF8.newDecoder();
            stripes = utf8Decoder.decode(val).toString().split(";");
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Bad string encoding for hive.acid.key.index", e);
        }
        RecordIdentifier[] result = new RecordIdentifier[stripes.length];
        for (int i = 0; i < stripes.length; ++i) {
            if (stripes[i].length() == 0) continue;
            String[] parts = stripes[i].split(",");
            result[i] = new RecordIdentifier();
            result[i].setValues(Long.parseLong(parts[0]), Integer.parseInt(parts[1]), Long.parseLong(parts[2]));
        }
        return result;
    }

    private void restoreBucket(Integer currentBucket, int operation) {
        if (currentBucket != null) {
            this.setBucket(currentBucket, operation);
        }
    }

    private int setBucket(int bucketProperty, int operation) {
        assert (operation == 1 || operation == 2);
        int currentBucketProperty = this.bucket.get();
        this.bucket.set(bucketProperty);
        return currentBucketProperty;
    }

    @Override
    public Path getUpdatedFilePath() {
        return this.path;
    }

    private static class RecIdStrippingObjectInspector
    extends StructObjectInspector {
        private StructObjectInspector wrapped;
        List<StructField> fields;
        StructField recId;

        RecIdStrippingObjectInspector(ObjectInspector oi, int rowIdColNum) {
            if (!(oi instanceof StructObjectInspector)) {
                throw new RuntimeException("Serious problem, expected a StructObjectInspector, but got a " + oi.getClass().getName());
            }
            this.wrapped = (StructObjectInspector)oi;
            List<? extends StructField> wrappedFields = this.wrapped.getAllStructFieldRefs();
            this.fields = new ArrayList<StructField>(this.wrapped.getAllStructFieldRefs().size());
            for (int i = 0; i < wrappedFields.size(); ++i) {
                if (i == rowIdColNum) {
                    this.recId = wrappedFields.get(i);
                    continue;
                }
                this.fields.add(wrappedFields.get(i));
            }
        }

        @Override
        public List<? extends StructField> getAllStructFieldRefs() {
            return this.fields;
        }

        @Override
        public StructField getStructFieldRef(String fieldName) {
            return this.wrapped.getStructFieldRef(fieldName);
        }

        @Override
        public Object getStructFieldData(Object data, StructField fieldRef) {
            return this.wrapped.getStructFieldData(data, fieldRef);
        }

        @Override
        public List<Object> getStructFieldsDataAsList(Object data) {
            return this.wrapped.getStructFieldsDataAsList(data);
        }

        @Override
        public String getTypeName() {
            return this.wrapped.getTypeName();
        }

        @Override
        public ObjectInspector.Category getCategory() {
            return this.wrapped.getCategory();
        }

        StructField getRecId() {
            return this.recId;
        }
    }

    static class KeyIndexBuilder
    implements OrcFile.WriterCallback {
        private final String builderName;
        StringBuilder lastKey = new StringBuilder();
        long lastTransaction;
        int lastBucket;
        long lastRowId;
        AcidStats acidStats = new AcidStats();
        private long numKeysCurrentStripe = 0L;

        KeyIndexBuilder(String name) {
            this.builderName = name;
        }

        @Override
        public void preStripeWrite(OrcFile.WriterContext context) throws IOException {
            this.lastKey.append(this.lastTransaction);
            this.lastKey.append(',');
            this.lastKey.append(this.lastBucket);
            this.lastKey.append(',');
            this.lastKey.append(this.lastRowId);
            this.lastKey.append(';');
            this.numKeysCurrentStripe = 0L;
        }

        @Override
        public void preFooterWrite(OrcFile.WriterContext context) throws IOException {
            if (this.numKeysCurrentStripe > 0L) {
                this.preStripeWrite(context);
            }
            context.getWriter().addUserMetadata(OrcRecordUpdater.ACID_KEY_INDEX_NAME, UTF8.encode(this.lastKey.toString()));
            context.getWriter().addUserMetadata("hive.acid.stats", UTF8.encode(this.acidStats.serialize()));
        }

        void addKey(int op, long transaction, int bucket, long rowId) {
            switch (op) {
                case 0: {
                    ++this.acidStats.inserts;
                    break;
                }
                case 1: {
                    ++this.acidStats.updates;
                    break;
                }
                case 2: {
                    ++this.acidStats.deletes;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation " + op);
                }
            }
            this.lastTransaction = transaction;
            this.lastBucket = bucket;
            this.lastRowId = rowId;
            ++this.numKeysCurrentStripe;
        }
    }

    static final class OrcOptions
    extends AcidOutputFormat.Options {
        OrcFile.WriterOptions orcOptions = null;

        OrcOptions(Configuration conf) {
            super(conf);
        }

        OrcOptions orcOptions(OrcFile.WriterOptions opts) {
            this.orcOptions = opts;
            return this;
        }

        OrcFile.WriterOptions getOrcOptions() {
            return this.orcOptions;
        }
    }
}

