/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.common.type.CalendarUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.ParquetTimestampUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public enum ETypeConverter {
    EDOUBLE_CONVERTER((Class)Double.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                double absValue = value < 0.0 ? value * -1.0 : value;
                                int exponent = Math.getExponent(value);
                                if (absValue >= minValue && absValue <= maxValue && exponent <= 127 && exponent >= -126) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
                                decimalWritable.setFromDouble(value);
                                parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(decimalWritable, (DecimalTypeInfo)hiveTypeInfo));
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    @Override
                    public void addDouble(double value) {
                        parent.set(index, (Writable)new DoubleWritable(value));
                    }
                };
            }
            return new PrimitiveConverter(){

                @Override
                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBOOLEAN_CONVERTER((Class)Boolean.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                @Override
                public void addBoolean(boolean value) {
                    parent.set(index, (Writable)new BooleanWritable(value));
                }
            };
        }
    }
    ,
    EFLOAT_CONVERTER((Class)Float.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "double": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                parent.set(index, (Writable)new DoubleWritable(value));
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
                                decimalWritable.setFromDouble(value);
                                parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(decimalWritable, (DecimalTypeInfo)hiveTypeInfo));
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    @Override
                    public void addFloat(float value) {
                        parent.set(index, (Writable)new FloatWritable(value));
                    }
                };
            }
            return new PrimitiveConverter(){

                @Override
                public void addFloat(float value) {
                    parent.set(index, (Writable)new FloatWritable(value));
                }
            };
        }
    }
    ,
    EINT32_CONVERTER((Class)Integer.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Integer.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Integer.MAX_VALUE);
                switch (typeName) {
                    case "bigint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "float": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(value), (DecimalTypeInfo)hiveTypeInfo));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    @Override
                    public void addInt(int value) {
                        if ((long)value >= minValue && (long)value <= maxValue) {
                            parent.set(index, (Writable)new IntWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                @Override
                public void addInt(int value) {
                    if (value >= (ETypeConverter.isUnsignedInteger(type) ? 0 : Integer.MIN_VALUE)) {
                        parent.set(index, (Writable)new IntWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EINT64_CONVERTER((Class)Long.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Long.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Long.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(value), (DecimalTypeInfo)hiveTypeInfo));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    @Override
                    public void addLong(long value) {
                        if (value >= minValue) {
                            parent.set(index, (Writable)new LongWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                @Override
                public void addLong(long value) {
                    if (value >= (ETypeConverter.isUnsignedInteger(type) ? 0L : Long.MIN_VALUE)) {
                        parent.set(index, (Writable)new LongWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EBINARY_CONVERTER((Class)Binary.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<BytesWritable>(type, parent, index){

                @Override
                protected BytesWritable convert(Binary binary) {
                    return new BytesWritable(binary.getBytes());
                }
            };
        }
    }
    ,
    ESTRING_CONVERTER((Class)String.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<Text>(type, parent, index){

                @Override
                protected Text convert(Binary binary) {
                    return new Text(binary.getBytes());
                }
            };
        }
    }
    ,
    EDECIMAL_CONVERTER((Class)BigDecimal.class){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.floatValue());
                            }

                            @Override
                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.floatValue());
                            }

                            @Override
                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.floatValue());
                            }

                            private void setValue(double doubleValue, float floatValue) {
                                double absDoubleValue;
                                double d = absDoubleValue = doubleValue < 0.0 ? doubleValue * -1.0 : doubleValue;
                                if (absDoubleValue >= minValue && absDoubleValue <= maxValue || absDoubleValue == 0.0) {
                                    parent.set(index, (Writable)new FloatWritable(floatValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(decimalWritable.doubleValue()));
                            }

                            @Override
                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(hiveDecimal.doubleValue()));
                            }

                            @Override
                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(hiveDecimal.doubleValue()));
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.longValue());
                            }

                            @Override
                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.longValue());
                            }

                            @Override
                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.longValue());
                            }

                            private void setValue(double doubleValue, long longValue) {
                                if (doubleValue >= minValue && doubleValue <= maxValue && doubleValue % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new LongWritable(longValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "int": 
                    case "smallint": 
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            @Override
                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.intValue());
                            }

                            @Override
                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.intValue());
                            }

                            @Override
                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create(value, this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.intValue());
                            }

                            private void setValue(double doubleValue, int intValue) {
                                if (doubleValue >= minValue && doubleValue <= maxValue && doubleValue % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable(intValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                }
                return new BinaryConverter<HiveDecimalWritable>(type, parent, index, hiveTypeInfo){

                    @Override
                    protected HiveDecimalWritable convert(Binary binary) {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
                        return HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(binary.getBytes(), logicalType.getScale()), (DecimalTypeInfo)hiveTypeInfo);
                    }

                    @Override
                    public void addInt(int value) {
                        this.addDecimal(value);
                    }

                    @Override
                    public void addLong(long value) {
                        this.addDecimal(value);
                    }

                    private void addDecimal(long value) {
                        DecimalTypeInfo decimalInfo = (DecimalTypeInfo)hiveTypeInfo;
                        HiveDecimal hiveDecimal = HiveDecimal.create(value, decimalInfo.scale());
                        HiveDecimalWritable result = HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(hiveDecimal), (DecimalTypeInfo)hiveTypeInfo);
                        parent.set(index, (Writable)result);
                    }
                };
            }
            return new BinaryConverter<HiveDecimalWritable>(type, parent, index){

                @Override
                protected HiveDecimalWritable convert(Binary binary) {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
                    return new HiveDecimalWritable(binary.getBytes(), logicalType.getScale());
                }
            };
        }
    }
    ,
    ETIMESTAMP_CONVERTER((Class)TimestampWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<TimestampWritableV2>(type, parent, index){

                @Override
                protected TimestampWritableV2 convert(Binary binary) {
                    NanoTime nt = NanoTime.fromBinary(binary);
                    Map<String, String> metadata = parent.getMetadata();
                    boolean skipConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname));
                    boolean legacyConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_LEGACY_CONVERSION_ENABLED.varname));
                    Timestamp ts = NanoTimeUtils.getTimestamp(nt, skipConversion, DataWritableReadSupport.getWriterTimeZoneId(metadata), legacyConversion);
                    return new TimestampWritableV2(ts);
                }
            };
        }
    }
    ,
    EINT64_TIMESTAMP_CONVERTER((Class)TimestampWritableV2.class){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                @Override
                public void addLong(long value) {
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
                    Timestamp timestamp = ParquetTimestampUtils.getTimestamp(value, logicalType.getUnit(), logicalType.isAdjustedToUTC());
                    parent.set(index, (Writable)new TimestampWritableV2(timestamp));
                }
            };
        }
    }
    ,
    EDATE_CONVERTER((Class)DateWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                @Override
                public void addInt(int value) {
                    Map<String, String> metadata = parent.getMetadata();
                    Boolean skipProlepticConversion = DataWritableReadSupport.getWriterDateProleptic(metadata);
                    if (skipProlepticConversion == null) {
                        skipProlepticConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_DATE_PROLEPTIC_GREGORIAN_DEFAULT.varname));
                    }
                    parent.set(index, (Writable)new DateWritableV2(skipProlepticConversion != false ? value : CalendarUtils.convertDateToProleptic(value)));
                }
            };
        }
    };

    final Class<?> _type;

    private ETypeConverter(Class<?> type) {
        this._type = type;
    }

    private Class<?> getType() {
        return this._type;
    }

    abstract PrimitiveConverter getConverter(PrimitiveType var1, int var2, ConverterParent var3, TypeInfo var4);

    public static PrimitiveConverter getNewConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
        Optional<PrimitiveConverter> converter;
        if (type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
            return ETIMESTAMP_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        if (type.getLogicalTypeAnnotation() != null && (converter = type.getLogicalTypeAnnotation().accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter>(){

            @Override
            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(EDECIMAL_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            @Override
            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(ESTRING_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            @Override
            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(EDATE_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            @Override
            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(EINT64_TIMESTAMP_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }
        })).isPresent()) {
            return converter.get();
        }
        Class<?> javaType = type.getPrimitiveTypeName().javaType;
        for (ETypeConverter eConverter : ETypeConverter.values()) {
            if (eConverter.getType() != javaType) continue;
            return eConverter.getConverter(type, index, parent, hiveTypeInfo);
        }
        throw new IllegalArgumentException("Converter not found ... for type : " + type);
    }

    public static boolean isUnsignedInteger(PrimitiveType type) {
        Optional<Boolean> isUnsignedInteger;
        if (type.getLogicalTypeAnnotation() != null && (isUnsignedInteger = type.getLogicalTypeAnnotation().accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            @Override
            public Optional<Boolean> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                return Optional.of(!intLogicalType.isSigned());
            }
        })).isPresent()) {
            return isUnsignedInteger.get();
        }
        return false;
    }

    private static long getMinValue(PrimitiveType type, String typeName, long defaultValue) {
        if (ETypeConverter.isUnsignedInteger(type)) {
            return 0L;
        }
        switch (typeName) {
            case "int": {
                return Integer.MIN_VALUE;
            }
            case "smallint": {
                return -32768L;
            }
            case "tinyint": {
                return -128L;
            }
        }
        return defaultValue;
    }

    private static long getMaxValue(String typeName, long defaultValue) {
        switch (typeName) {
            case "int": {
                return Integer.MAX_VALUE;
            }
            case "smallint": {
                return 32767L;
            }
            case "tinyint": {
                return 127L;
            }
        }
        return defaultValue;
    }

    private static double getMinValue(String typeName, double defaultValue) {
        switch (typeName) {
            case "bigint": {
                return -9.223372036854776E18;
            }
            case "int": {
                return -2.147483648E9;
            }
            case "smallint": {
                return -32768.0;
            }
            case "tinyint": {
                return -128.0;
            }
            case "float": {
                return 1.4E-45f;
            }
        }
        return defaultValue;
    }

    private static double getMaxValue(String typeName, double defaultValue) {
        switch (typeName) {
            case "bigint": {
                return 9.223372036854776E18;
            }
            case "int": {
                return 2.147483647E9;
            }
            case "smallint": {
                return 32767.0;
            }
            case "tinyint": {
                return 127.0;
            }
            case "float": {
                return 3.4028234663852886E38;
            }
        }
        return defaultValue;
    }

    public static abstract class BinaryConverter<T extends Writable>
    extends PrimitiveConverter {
        protected final PrimitiveType type;
        private final ConverterParent parent;
        private final int index;
        private final TypeInfo hiveTypeInfo;
        private ArrayList<T> lookupTable;

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
            this.type = type;
            this.parent = parent;
            this.index = index;
            this.hiveTypeInfo = hiveTypeInfo;
        }

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index) {
            this(type, parent, index, null);
        }

        protected abstract T convert(Binary var1);

        @Override
        public boolean hasDictionarySupport() {
            return true;
        }

        @Override
        public void setDictionary(Dictionary dictionary) {
            int length = dictionary.getMaxId() + 1;
            this.lookupTable = new ArrayList();
            for (int i = 0; i < length; ++i) {
                this.lookupTable.add(this.convert(dictionary.decodeToBinary(i)));
            }
        }

        @Override
        public void addValueFromDictionary(int dictionaryId) {
            this.parent.set(this.index, (Writable)this.lookupTable.get(dictionaryId));
        }

        @Override
        public void addBinary(Binary value) {
            this.parent.set(this.index, (Writable)this.convert(value));
        }
    }
}

