/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMaterializedViewsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewsRegistry.class);
    private static final String CLASS_NAME = HiveMaterializedViewsRegistry.class.getName();
    private static final HiveMaterializedViewsRegistry SINGLETON = new HiveMaterializedViewsRegistry();
    private final ConcurrentMap<String, ConcurrentMap<String, RelOptMaterialization>> materializedViews = new ConcurrentHashMap<String, ConcurrentMap<String, RelOptMaterialization>>();
    private AtomicBoolean initialized = new AtomicBoolean(false);

    private HiveMaterializedViewsRegistry() {
    }

    public static HiveMaterializedViewsRegistry get() {
        return SINGLETON;
    }

    public void init() {
        try {
            HiveConf conf = new HiveConf();
            conf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
            this.init(Hive.get(conf));
        }
        catch (HiveException e) {
            LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
        }
    }

    public void init(Hive db) {
        boolean dummy = db.getConf().get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (dummy) {
            this.initialized.set(true);
            LOG.info("Using dummy materialized views registry");
        } else {
            long period = HiveConf.getTimeVar(db.getConf(), HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_REFRESH, TimeUnit.SECONDS);
            ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveMaterializedViewsRegistry-%d").build());
            pool.scheduleAtFixedRate(new Loader(db), 0L, period, TimeUnit.SECONDS);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public RelOptMaterialization createMaterialization(HiveConf conf, Table materializedViewTable) {
        RelNode queryRel;
        String viewQuery = materializedViewTable.getViewExpandedText();
        RelNode viewScan = HiveMaterializedViewsRegistry.createMaterializedViewScan(conf, materializedViewTable);
        if (viewScan == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error creating view replacement");
            return null;
        }
        try {
            queryRel = ParseUtils.parseQuery(conf, viewQuery);
        }
        catch (Exception e) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error parsing original query; " + e);
            return null;
        }
        return new RelOptMaterialization(viewScan, queryRel, null, viewScan.getTable().getQualifiedName());
    }

    public void createMaterializedView(HiveConf conf, Table materializedViewTable) {
        RelOptMaterialization materialization;
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " ignored; it is not rewrite enabled");
            return;
        }
        ConcurrentMap<String, RelOptMaterialization> dbMap = new ConcurrentHashMap();
        ConcurrentMap prevDbMap = this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), dbMap);
        if (prevDbMap != null) {
            dbMap = prevDbMap;
        }
        if ((materialization = this.createMaterialization(conf, materializedViewTable)) == null) {
            return;
        }
        dbMap.put(materializedViewTable.getTableName(), materialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created materialized view for rewriting: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void refreshMaterializedView(HiveConf conf, final Table oldMaterializedViewTable, Table materializedViewTable) {
        RelOptMaterialization newMaterialization;
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            this.dropMaterializedView(oldMaterializedViewTable);
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " dropped; it is not rewrite enabled");
            return;
        }
        ConcurrentMap<String, RelOptMaterialization> dbMap = new ConcurrentHashMap();
        ConcurrentMap prevDbMap = this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), dbMap);
        if (prevDbMap != null) {
            dbMap = prevDbMap;
        }
        if ((newMaterialization = this.createMaterialization(conf, materializedViewTable)) == null) {
            return;
        }
        dbMap.compute(materializedViewTable.getTableName(), new BiFunction<String, RelOptMaterialization, RelOptMaterialization>(){

            @Override
            public RelOptMaterialization apply(String tableName, RelOptMaterialization existingMaterialization) {
                if (existingMaterialization == null) {
                    return newMaterialization;
                }
                Table existingMaterializedViewTable = HiveMaterializedViewsRegistry.extractTable(existingMaterialization);
                if (existingMaterializedViewTable.equals(oldMaterializedViewTable)) {
                    return newMaterialization;
                }
                return existingMaterialization;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Materialized view refreshed: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void dropMaterializedView(final Table materializedViewTable) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(materializedViewTable.getDbName());
        if (dbMap != null) {
            dbMap.computeIfPresent(materializedViewTable.getTableName(), new BiFunction<String, RelOptMaterialization, RelOptMaterialization>(){

                @Override
                public RelOptMaterialization apply(String tableName, RelOptMaterialization oldMaterialization) {
                    if (HiveMaterializedViewsRegistry.extractTable(oldMaterialization).equals(materializedViewTable)) {
                        return null;
                    }
                    return oldMaterialization;
                }
            });
        }
    }

    public void dropMaterializedView(String dbName, String tableName) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(dbName);
        if (dbMap != null) {
            dbMap.remove(tableName);
        }
    }

    List<RelOptMaterialization> getRewritingMaterializedViews() {
        ArrayList<RelOptMaterialization> result = new ArrayList<RelOptMaterialization>();
        this.materializedViews.forEach((dbName, mvs) -> result.addAll(mvs.values()));
        return result;
    }

    RelOptMaterialization getRewritingMaterializedView(String dbName, String viewName) {
        if (this.materializedViews.get(dbName) != null) {
            return (RelOptMaterialization)((ConcurrentMap)this.materializedViews.get(dbName)).get(viewName);
        }
        return null;
    }

    private static RelNode createMaterializedViewScan(HiveConf conf, Table viewTable) {
        HiveTableScan tableRel;
        RelDataType rowType;
        ColumnInfo colInfo;
        String colName;
        StructObjectInspector rowObjectInspector;
        RelOptPlanner planner = CalcitePlanner.createPlanner(conf);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl()));
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        RowResolver rr = new RowResolver();
        try {
            rowObjectInspector = (StructObjectInspector)viewTable.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            return null;
        }
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (int i = 0; i < fields.size(); ++i) {
            colName = fields.get(i).getFieldName();
            colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), null, false);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
        }
        ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
        ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
        for (FieldSchema part_col : viewTable.getPartCols()) {
            colName = part_col.getName();
            colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), null, true);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
            partitionColumns.add(colInfo);
        }
        try {
            rowType = TypeConverter.getType(cluster, rr, null);
        }
        catch (CalciteSemanticException e) {
            return null;
        }
        ArrayList<String> fullyQualifiedTabName = new ArrayList<String>();
        if (viewTable.getDbName() != null && !viewTable.getDbName().isEmpty()) {
            fullyQualifiedTabName.add(viewTable.getDbName());
        }
        fullyQualifiedTabName.add(viewTable.getTableName());
        if (HiveMaterializedViewsRegistry.obtainTableType(viewTable) == TableType.DRUID) {
            String address = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
            String dataSource = viewTable.getParameters().get("druid.datasource");
            HashSet<String> metrics = new HashSet<String>();
            ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
            ArrayList<String> druidColNames = new ArrayList<String>();
            RelDataTypeFactory dtFactory = cluster.getRexBuilder().getTypeFactory();
            for (RelDataTypeField field : rowType.getFieldList()) {
                if ("__time".equals(field.getName())) {
                    druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                } else {
                    druidColTypes.add(field.getType());
                }
                druidColNames.add(field.getName());
                if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                metrics.add(field.getName());
            }
            List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
            rowType = dtFactory.createStructType(druidColTypes, druidColNames);
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, null, new HashMap<String, Table>(), new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
            HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
            tableRel = DruidQuery.create((RelOptCluster)cluster, (RelTraitSet)cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, ImmutableList.of(scan), ImmutableMap.of());
        } else {
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, null, new HashMap<String, Table>(), new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            tableRel = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
        }
        return tableRel;
    }

    private static TableType obtainTableType(Table tabMetaData) {
        if (tabMetaData.getStorageHandler() != null) {
            String storageHandlerStr = tabMetaData.getStorageHandler().toString();
            if (storageHandlerStr.equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                return TableType.DRUID;
            }
            if (storageHandlerStr.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                return TableType.JDBC;
            }
        }
        return TableType.NATIVE;
    }

    private static Table extractTable(RelOptMaterialization materialization) {
        RelOptHiveTable cachedMaterializedViewTable = materialization.tableRel instanceof Project ? (RelOptHiveTable)materialization.tableRel.getInput(0).getTable() : (RelOptHiveTable)materialization.tableRel.getTable();
        return cachedMaterializedViewTable.getHiveTableMD();
    }

    private static enum TableType {
        DRUID,
        NATIVE,
        JDBC;

    }

    private class Loader
    implements Runnable {
        private final Hive db;

        private Loader(Hive db) {
            this.db = db;
        }

        @Override
        public void run() {
            SessionState ss = new SessionState(this.db.getConf());
            ss.setIsHiveServerQuery(true);
            SessionState.start(ss);
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(CLASS_NAME, "MaterializedViewsRegistryRefresh");
            try {
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    for (Table mvTable : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        RelOptMaterialization existingMV = HiveMaterializedViewsRegistry.this.getRewritingMaterializedView(mvTable.getDbName(), mvTable.getTableName());
                        if (existingMV != null) {
                            Table existingMVTable = HiveMaterializedViewsRegistry.extractTable(existingMV);
                            if (existingMVTable.getCreateTime() >= mvTable.getCreateTime() && (existingMVTable.getCreateTime() != mvTable.getCreateTime() || existingMVTable.getCreationMetadata().getMaterializationTime() > mvTable.getCreationMetadata().getMaterializationTime())) continue;
                            HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), existingMVTable, mvTable);
                            continue;
                        }
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), null, mvTable);
                    }
                    LOG.info("Materialized views registry has been refreshed");
                } else {
                    for (Table mvTable : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), null, mvTable);
                    }
                    HiveMaterializedViewsRegistry.this.initialized.set(true);
                    LOG.info("Materialized views registry has been initialized");
                }
            }
            catch (HiveException e) {
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    LOG.error("Problem connecting to the metastore when refreshing the view registry", (Throwable)e);
                }
                LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
            }
            perfLogger.PerfLogEnd(CLASS_NAME, "MaterializedViewsRegistryRefresh");
        }
    }
}

