/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRexExecutorImpl
extends RexExecutorImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HiveRexExecutorImpl.class);
    private final RelOptCluster cluster;

    public HiveRexExecutorImpl(RelOptCluster cluster) {
        super(null);
        this.cluster = cluster;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        RexNodeConverter rexNodeConverter = new RexNodeConverter(this.cluster);
        for (RexNode rexNode : constExps) {
            ExprNodeConverter converter;
            ExprNodeDesc expr = (ExprNodeDesc)rexNode.accept((RexVisitor)(converter = new ExprNodeConverter("", null, null, null, new HashSet<Integer>(), this.cluster.getTypeFactory())));
            if (expr instanceof ExprNodeGenericFuncDesc) {
                ExprNodeDesc constant = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)expr);
                if (constant != null) {
                    try {
                        reducedValues.add(rexNodeConverter.convert(constant));
                    }
                    catch (Exception e) {
                        LOG.warn(e.getMessage());
                        reducedValues.add(rexNode);
                    }
                    continue;
                }
                reducedValues.add(rexNode);
                continue;
            }
            reducedValues.add(rexNode);
        }
    }
}

