/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class FilterSelectivityEstimator
extends RexVisitorImpl<Double> {
    private final RelNode childRel;
    private final double childCardinality;
    private final RelMetadataQuery mq;

    public FilterSelectivityEstimator(RelNode childRel, RelMetadataQuery mq) {
        super(true);
        this.mq = mq;
        this.childRel = childRel;
        this.childCardinality = mq.getRowCount(childRel);
    }

    public Double estimateSelectivity(RexNode predicate) {
        return (Double)predicate.accept((RexVisitor)this);
    }

    public Double visitInputRef(RexInputRef inputRef) {
        if (inputRef.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            return 0.5;
        }
        return null;
    }

    public Double visitCall(RexCall call) {
        if (!this.deep) {
            return 1.0;
        }
        if (this.isPartitionPredicate((RexNode)call, this.childRel)) {
            return 1.0;
        }
        Double selectivity = null;
        SqlKind op = this.getOp(call);
        switch (op) {
            case AND: {
                selectivity = this.computeConjunctionSelectivity(call);
                break;
            }
            case OR: {
                selectivity = this.computeDisjunctionSelectivity(call);
                break;
            }
            case NOT: 
            case NOT_EQUALS: {
                selectivity = this.computeNotEqualitySelectivity(call);
                break;
            }
            case IS_NOT_NULL: {
                if (this.childRel instanceof HiveTableScan) {
                    double noOfNulls = this.getMaxNulls(call, (HiveTableScan)this.childRel);
                    double totalNoOfTuples = this.mq.getRowCount(this.childRel);
                    if (totalNoOfTuples >= noOfNulls) {
                        selectivity = (totalNoOfTuples - noOfNulls) / Math.max(totalNoOfTuples, 1.0);
                        break;
                    }
                    throw new RuntimeException("Invalid Stats number of null > no of tuples");
                }
                selectivity = this.computeNotEqualitySelectivity(call);
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                selectivity = 0.3333333333333333;
                break;
            }
            case IN: {
                selectivity = this.computeFunctionSelectivity(call);
                if (selectivity == null) break;
                if ((selectivity = Double.valueOf(selectivity * (double)(call.operands.size() - 1))) <= 0.0) {
                    selectivity = 0.1;
                    break;
                }
                if (!(selectivity >= 1.0)) break;
                selectivity = 1.0;
                break;
            }
            default: {
                selectivity = this.computeFunctionSelectivity(call);
            }
        }
        return selectivity;
    }

    private Double computeNotEqualitySelectivity(RexCall call) {
        Double tmpNDV = this.getMaxNDV(call);
        if (tmpNDV == null) {
            return null;
        }
        if (tmpNDV > 1.0) {
            return (tmpNDV - 1.0) / tmpNDV;
        }
        return 1.0;
    }

    private Double computeFunctionSelectivity(RexCall call) {
        Double tmpNDV = this.getMaxNDV(call);
        if (tmpNDV == null) {
            return null;
        }
        return 1.0 / tmpNDV;
    }

    private Double computeDisjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode dje : call.getOperands()) {
            Double tmpCardinality;
            Double tmpSelectivity = (Double)dje.accept((RexVisitor)this);
            if (tmpSelectivity == null) {
                tmpSelectivity = 0.99;
            }
            tmpSelectivity = (tmpCardinality = Double.valueOf(this.childCardinality * tmpSelectivity)) > 1.0 && tmpCardinality < this.childCardinality ? Double.valueOf(1.0 - tmpCardinality / this.childCardinality) : Double.valueOf(1.0);
            selectivity *= tmpSelectivity.doubleValue();
        }
        if (selectivity < 0.0) {
            selectivity = 0.0;
        }
        return 1.0 - selectivity;
    }

    private Double computeConjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode cje : call.getOperands()) {
            Double tmpSelectivity = (Double)cje.accept((RexVisitor)this);
            if (tmpSelectivity == null) continue;
            selectivity *= tmpSelectivity.doubleValue();
        }
        return selectivity;
    }

    private long getMaxNulls(RexCall call, HiveTableScan t) {
        long tmpNoNulls = 0L;
        long maxNoNulls = 0L;
        Set<Integer> iRefSet = HiveCalciteUtil.getInputRefs((RexNode)call);
        List<ColStatistics> colStats = t.getColStat(new ArrayList<Integer>(iRefSet));
        for (ColStatistics cs : colStats) {
            tmpNoNulls = cs.getNumNulls();
            if (tmpNoNulls <= maxNoNulls) continue;
            maxNoNulls = tmpNoNulls;
        }
        return maxNoNulls;
    }

    private Double getMaxNDV(RexCall call) {
        double maxNDV = 1.0;
        for (RexNode op : call.getOperands()) {
            Double tmpNDV;
            if (op instanceof RexInputRef) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, this.mq, ((RexInputRef)op).getIndex());
                if (tmpNDV == null) {
                    return null;
                }
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
                continue;
            }
            RelOptUtil.InputReferencedVisitor irv = new RelOptUtil.InputReferencedVisitor();
            irv.apply(op);
            for (Integer childProjIndx : irv.inputPosReferenced) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, this.mq, childProjIndx);
                if (tmpNDV == null) {
                    return null;
                }
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
            }
        }
        return maxNDV;
    }

    private boolean isPartitionPredicate(RexNode expr, RelNode r) {
        if (r instanceof Project) {
            expr = RelOptUtil.pushFilterPastProject((RexNode)expr, (Project)((Project)r));
            return this.isPartitionPredicate(expr, ((Project)r).getInput());
        }
        if (r instanceof Filter) {
            return this.isPartitionPredicate(expr, ((Filter)r).getInput());
        }
        if (r instanceof HiveTableScan) {
            RelOptHiveTable table = (RelOptHiveTable)((HiveTableScan)r).getTable();
            ImmutableBitSet cols = RelOptUtil.InputFinder.bits((RexNode)expr);
            return table.containsPartitionColumnsOnly(cols);
        }
        return false;
    }

    private SqlKind getOp(RexCall call) {
        SqlKind op = call.getKind();
        if (call.getKind().equals((Object)SqlKind.OTHER_FUNCTION) && SqlTypeUtil.inBooleanFamily((RelDataType)call.getType())) {
            String opName;
            SqlOperator sqlOp = call.getOperator();
            String string = opName = sqlOp != null ? sqlOp.getName() : "";
            if (opName.equalsIgnoreCase("in")) {
                op = SqlKind.IN;
            }
        }
        return op;
    }

    public Double visitLiteral(RexLiteral literal) {
        if (literal.isAlwaysFalse() || RexUtil.isNull((RexNode)literal)) {
            return 0.0;
        }
        if (literal.isAlwaysTrue()) {
            return 1.0;
        }
        assert (false);
        return null;
    }
}

