/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QBExpr {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.parse.QBExpr");
    private Opcode opcode;
    private QBExpr qbexpr1;
    private QBExpr qbexpr2;
    private QB qb;
    private String alias;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = StringInternUtils.internIfNotNull(alias);
    }

    public QBExpr(String alias) {
        this.setAlias(alias);
    }

    public QBExpr(QB qb) {
        this.opcode = Opcode.NULLOP;
        this.qb = qb;
    }

    public QBExpr(Opcode opcode, QBExpr qbexpr1, QBExpr qbexpr2) {
        this.opcode = opcode;
        this.qbexpr1 = qbexpr1;
        this.qbexpr2 = qbexpr2;
    }

    public void setQB(QB qb) {
        this.qb = qb;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public void setQBExpr1(QBExpr qbexpr) {
        this.qbexpr1 = qbexpr;
    }

    public void setQBExpr2(QBExpr qbexpr) {
        this.qbexpr2 = qbexpr;
    }

    public QB getQB() {
        return this.qb;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public QBExpr getQBExpr1() {
        return this.qbexpr1;
    }

    public QBExpr getQBExpr2() {
        return this.qbexpr2;
    }

    public void print(String msg) {
        if (this.opcode == Opcode.NULLOP) {
            LOG.info(msg + "start qb = " + this.qb);
            this.qb.print(msg + " ");
            LOG.info(msg + "end qb = " + this.qb);
        } else {
            LOG.info(msg + "start qbexpr1 = " + this.qbexpr1);
            this.qbexpr1.print(msg + " ");
            LOG.info(msg + "end qbexpr1 = " + this.qbexpr1);
            LOG.info(msg + "start qbexpr2 = " + this.qbexpr2);
            this.qbexpr2.print(msg + " ");
            LOG.info(msg + "end qbexpr2 = " + this.qbexpr2);
        }
    }

    public boolean isSimpleSelectQuery() {
        if (this.qb != null) {
            return this.qb.isSimpleSelectQuery();
        }
        return this.qbexpr1.isSimpleSelectQuery() && this.qbexpr2.isSimpleSelectQuery();
    }

    public boolean containsQueryWithoutSourceTable() {
        if (this.qb != null) {
            return this.qb.containsQueryWithoutSourceTable();
        }
        return this.qbexpr1.containsQueryWithoutSourceTable() || this.qbexpr2.containsQueryWithoutSourceTable();
    }

    public static enum Opcode {
        NULLOP,
        UNION,
        INTERSECT,
        INTERSECTALL,
        EXCEPT,
        EXCEPTALL,
        DIFF;

    }
}

