/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TypeCheckProcFactoryUtils {
    static ArrayList<ExprNodeDesc> rewriteInToOR(ArrayList<ExprNodeDesc> inOperands) throws SemanticException {
        ExprNodeDesc columnDesc = inOperands.get(0);
        ArrayList<ExprNodeDesc> orOperands = new ArrayList<ExprNodeDesc>();
        for (int i = 1; i < inOperands.size(); ++i) {
            ExprNodeDesc andExpr = TypeCheckProcFactoryUtils.buildEqualsArr(columnDesc, inOperands.get(i));
            if (andExpr == null) {
                return null;
            }
            orOperands.add(andExpr);
        }
        return orOperands;
    }

    private static ExprNodeDesc buildEqualsArr(ExprNodeDesc columnDesc, ExprNodeDesc exprNodeDesc) throws SemanticException {
        List<ExprNodeDesc> lNodes = TypeCheckProcFactoryUtils.asListOfNodes(columnDesc);
        List<ExprNodeDesc> rNodes = TypeCheckProcFactoryUtils.asListOfNodes(exprNodeDesc);
        if (lNodes == null || rNodes == null) {
            return null;
        }
        if (lNodes.size() != rNodes.size()) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_STRUCT.getMsg(columnDesc + " and " + exprNodeDesc));
        }
        ArrayList<ExprNodeDesc> ret = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < lNodes.size(); ++i) {
            ret.add(TypeCheckProcFactoryUtils.buildEquals(lNodes.get(i), rNodes.get(i)));
        }
        return TypeCheckProcFactoryUtils.buildAnd(ret);
    }

    private static ExprNodeGenericFuncDesc buildEquals(ExprNodeDesc columnDesc, ExprNodeDesc valueDesc) {
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqual(), "=", Lists.newArrayList(columnDesc, valueDesc));
    }

    private static ExprNodeDesc buildAnd(List<ExprNodeDesc> values) {
        if (values.size() == 1) {
            return values.get(0);
        }
        return new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), "and", values);
    }

    private static List<ExprNodeDesc> asListOfNodes(ExprNodeDesc desc) {
        ExprNodeDesc valueDesc = desc;
        if (ExprNodeDescUtils.isStructUDF(desc)) {
            List<ExprNodeDesc> valueChilds = ((ExprNodeGenericFuncDesc)valueDesc).getChildren();
            for (ExprNodeDesc exprNodeDesc : valueChilds) {
                if (TypeCheckProcFactoryUtils.isSafeExpression(exprNodeDesc)) continue;
                return null;
            }
            return valueChilds;
        }
        if (ExprNodeDescUtils.isConstantStruct(valueDesc)) {
            ExprNodeConstantDesc valueConstDesc = (ExprNodeConstantDesc)valueDesc;
            List oldValues = (List)valueConstDesc.getValue();
            StructTypeInfo structTypeInfo = (StructTypeInfo)valueConstDesc.getTypeInfo();
            ArrayList<TypeInfo> structFieldInfos = structTypeInfo.getAllStructFieldTypeInfos();
            ArrayList<ExprNodeDesc> ret = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < oldValues.size(); ++i) {
                ret.add(new ExprNodeConstantDesc(structFieldInfos.get(i), oldValues.get(i)));
            }
            return ret;
        }
        if (TypeCheckProcFactoryUtils.isSafeExpression(desc)) {
            return Lists.newArrayList(desc);
        }
        return null;
    }

    private static boolean isSafeExpression(ExprNodeDesc desc) {
        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc;
        TypeInfo typeInfo = desc.getTypeInfo();
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        if (TypeCheckProcFactoryUtils.isConstantOrColumn(desc)) {
            return true;
        }
        if (desc instanceof ExprNodeGenericFuncDesc && FunctionRegistry.isConsistentWithinQuery((exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)desc).getGenericUDF())) {
            for (ExprNodeDesc child : exprNodeGenericFuncDesc.getChildren()) {
                if (TypeCheckProcFactoryUtils.isSafeExpression(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isConstantOrColumn(ExprNodeDesc desc) {
        return desc instanceof ExprNodeColumnDesc || desc instanceof ExprNodeConstantDesc;
    }
}

