/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;

class BootStrapReplicationSpecFunction
implements HiveWrapper.Tuple.Function<ReplicationSpec> {
    private final Hive db;
    private final long currentNotificationId;

    BootStrapReplicationSpecFunction(Hive db, long currentNotificationId) {
        this.db = db;
        this.currentNotificationId = currentNotificationId;
    }

    @Override
    public ReplicationSpec fromMetaStore() throws HiveException {
        try {
            long currentReplicationState = this.currentNotificationId > 0L ? this.currentNotificationId : this.db.getMSC().getCurrentNotificationEventId().getEventId();
            ReplicationSpec replicationSpec = new ReplicationSpec(true, false, "replv2", "will-be-set", false, false);
            replicationSpec.setCurrentReplicationState(String.valueOf(currentReplicationState));
            return replicationSpec;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }
}

