/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.log;

import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.BootstrapLoadBegin;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.BootstrapLoadEnd;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.BootstrapLoadFunction;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.BootstrapLoadTable;

public class BootstrapLoadLogger
extends ReplLogger<String> {
    private String dbName;
    private String dumpDir;
    private long numTables;
    private long numFunctions;
    private long tableSeqNo;
    private long functionSeqNo;

    public BootstrapLoadLogger(String dbName, String dumpDir, long numTables, long numFunctions) {
        this.dbName = dbName;
        this.dumpDir = dumpDir;
        this.numTables = numTables;
        this.numFunctions = numFunctions;
        this.tableSeqNo = 0L;
        this.functionSeqNo = 0L;
    }

    @Override
    public void startLog() {
        new BootstrapLoadBegin(this.dbName, this.dumpDir, this.numTables, this.numFunctions).log(ReplState.LogTag.START);
    }

    @Override
    public void tableLog(String tableName, TableType tableType) {
        ++this.tableSeqNo;
        new BootstrapLoadTable(this.dbName, tableName, tableType, this.tableSeqNo, this.numTables).log(ReplState.LogTag.TABLE_LOAD);
    }

    @Override
    public void functionLog(String funcName) {
        ++this.functionSeqNo;
        new BootstrapLoadFunction(this.dbName, funcName, this.functionSeqNo, this.numFunctions).log(ReplState.LogTag.FUNCTION_LOAD);
    }

    @Override
    public void endLog(String lastReplId) {
        new BootstrapLoadEnd(this.dbName, this.numTables, this.numFunctions, this.dumpDir, lastReplId).log(ReplState.LogTag.END);
    }
}

