/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class AddUniqueConstraintHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        List<SQLUniqueConstraint> uks;
        AddUniqueConstraintMessage msg = this.deserializer.getAddUniqueConstraintMessage(context.dmd.getPayload());
        try {
            uks = msg.getUniqueConstraints();
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", e);
            }
            throw (SemanticException)e;
        }
        ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
        if (uks.isEmpty()) {
            return tasks;
        }
        String actualDbName = context.isDbNameEmpty() ? uks.get(0).getTable_db() : context.dbName;
        String actualTblName = uks.get(0).getTable_name();
        TableName tName = TableName.fromString(actualTblName, null, actualDbName);
        for (SQLUniqueConstraint uk : uks) {
            uk.setTable_db(actualDbName);
            uk.setTable_name(actualTblName);
        }
        Constraints constraints = new Constraints(null, null, null, uks, null, null);
        AlterTableAddConstraintDesc addConstraintsDesc = new AlterTableAddConstraintDesc(tName, context.eventOnlyReplicationSpec(), constraints);
        Task<DDLWork> addConstraintsTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, addConstraintsDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        tasks.add(addConstraintsTask);
        context.log.debug("Added add constrains task : {}:{}", (Object)addConstraintsTask.getId(), (Object)actualTblName);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(addConstraintsTask);
    }
}

