/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadTask;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHandler
extends AbstractMessageHandler {
    private static final long DEFAULT_WRITE_ID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(TableHandler.class);

    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            ArrayList importTasks = new ArrayList();
            boolean isExternal = false;
            boolean isLocationSet = false;
            String parsedLocation = null;
            DumpType eventType = context.dmd.getDumpType();
            Tuple tuple = this.extract(context);
            MetaData rv = EximUtil.getMetaDataFromLocation(context.location, context.hiveConf);
            if (tuple.isExternalTable) {
                isLocationSet = true;
                isExternal = true;
                Table table = new Table(rv.getTable());
                parsedLocation = ReplExternalTables.externalTableLocation(context.hiveConf, table.getSd().getLocation());
            }
            context.nestedContext.setConf(context.hiveConf);
            EximUtil.SemanticAnalyzerWrapperContext x = new EximUtil.SemanticAnalyzerWrapperContext(context.hiveConf, context.db, this.readEntitySet, this.writeEntitySet, importTasks, context.log, context.nestedContext);
            x.setEventType(eventType);
            if (TableType.VIRTUAL_VIEW.name().equals(rv.getTable().getTableType())) {
                importTasks.add(ReplLoadTask.createViewTask(rv, context.dbName, context.hiveConf, context.getDumpDirectory(), context.getMetricCollector()));
            } else {
                ImportSemanticAnalyzer.prepareImport(false, isLocationSet, isExternal, false, context.precursor != null, parsedLocation, null, context.dbName, null, context.location, x, this.updatedMetadata, context.getTxnMgr(), tuple.writeId, rv, context.getDumpDirectory(), context.getMetricCollector());
            }
            Task<? extends Serializable> openTxnTask = x.getOpenTxnTask();
            if (openTxnTask != null && !importTasks.isEmpty()) {
                for (Task task : importTasks) {
                    openTxnTask.addDependentTask(task);
                }
                importTasks.add(openTxnTask);
            }
            return importTasks;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private Tuple extract(MessageHandler.Context context) throws SemanticException {
        try {
            String tableType = null;
            long writeId = 0L;
            switch (context.dmd.getDumpType()) {
                case EVENT_CREATE_TABLE: 
                case EVENT_ADD_PARTITION: {
                    Path metadataPath = new Path(context.location, "_metadata");
                    MetaData rv = EximUtil.readMetaData(metadataPath.getFileSystem((Configuration)context.hiveConf), metadataPath);
                    tableType = rv.getTable().getTableType();
                    break;
                }
                case EVENT_ALTER_TABLE: {
                    AlterTableMessage alterTableMessage = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
                    tableType = alterTableMessage.getTableObjAfter().getTableType();
                    writeId = alterTableMessage.getWriteId();
                    break;
                }
                case EVENT_ALTER_PARTITION: {
                    AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
                    tableType = msg.getTableObj().getTableType();
                    writeId = msg.getWriteId();
                    break;
                }
            }
            boolean isExternalTable = tableType != null && TableType.EXTERNAL_TABLE.equals((Object)Enum.valueOf(TableType.class, tableType));
            return new Tuple(isExternalTable, writeId);
        }
        catch (Exception e) {
            LOG.error("failed to determine if the table associated with the event is external or not", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    private static final class Tuple {
        private final boolean isExternalTable;
        private final long writeId;

        private Tuple(boolean isExternalTable, long writeId) {
            this.isExternalTable = isExternalTable;
            this.writeId = writeId;
        }
    }
}

