/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricSink;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicationMetricCollector {
    private ReplicationMetric replicationMetric;
    private MetricCollector metricCollector;
    private boolean isEnabled;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationMetricCollector.class);

    public ReplicationMetricCollector(String dbName, Metadata.ReplicationType replicationType, String stagingDir, long dumpExecutionId, HiveConf conf) {
        String policy = conf.get("scheduled.query.schedulename");
        long executionId = conf.getLong("scheduled.query.executionid", 0L);
        if (!StringUtils.isEmpty(policy) && executionId > 0L) {
            this.isEnabled = true;
            this.metricCollector = MetricCollector.getInstance().init(conf);
            MetricSink.getInstance().init(conf);
            Metadata metadata = new Metadata(dbName, replicationType, stagingDir);
            this.replicationMetric = new ReplicationMetric(executionId, policy, dumpExecutionId, metadata);
        }
    }

    public void reportStageStart(String stageName, Map<String, Long> metricMap) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage Started {}, {}, {}", new Object[]{stageName, metricMap.size(), metricMap});
            Progress progress = this.replicationMetric.getProgress();
            progress.setStatus(Status.IN_PROGRESS);
            Stage stage = new Stage(stageName, Status.IN_PROGRESS, System.currentTimeMillis());
            for (Map.Entry<String, Long> metric : metricMap.entrySet()) {
                stage.addMetric(new Metric(metric.getKey(), metric.getValue()));
            }
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    public void reportStageEnd(String stageName, Status status, long lastReplId) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage ended {}, {}, {}", new Object[]{stageName, status, lastReplId});
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(System.currentTimeMillis());
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            Metadata metadata = this.replicationMetric.getMetadata();
            metadata.setLastReplId(lastReplId);
            this.replicationMetric.setMetadata(metadata);
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageEnd(String stageName, Status status, String errorLogPath) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage Ended {}, {}", (Object)stageName, (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(System.currentTimeMillis());
            stage.setErrorLogPath(errorLogPath);
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageEnd(String stageName, Status status) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage Ended {}, {}", (Object)stageName, (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(System.currentTimeMillis());
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageProgress(String stageName, String metricName, long count) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage progress {}, {}, {}", new Object[]{stageName, metricName, count});
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            Metric metric = stage.getMetricByName(metricName);
            metric.setCurrentCount(metric.getCurrentCount() + count);
            if (metric.getCurrentCount() > metric.getTotalCount()) {
                metric.setTotalCount(metric.getCurrentCount());
            }
            stage.addMetric(metric);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    public void reportEnd(Status status) throws SemanticException {
        if (this.isEnabled) {
            LOG.info("End {}", (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            progress.setStatus(status);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }
}

