/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorFileSinkDesc;

@Explain(displayName="File Output Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class FileSinkDesc
extends AbstractOperatorDesc
implements IStatsGatherDesc {
    private static final long serialVersionUID = 1L;
    private DPSortState dpSortState;
    private Path dirName;
    private String statsKeyPref;
    private TableDesc tableInfo;
    private boolean compressed;
    private int destTableId;
    private String compressCodec;
    private String compressType;
    private boolean multiFileSpray;
    private boolean temporary;
    private boolean materialization;
    private boolean canBeMerged;
    private int totalFiles;
    private List<ExprNodeDesc> partitionCols;
    private int numFiles;
    private DynamicPartitionCtx dpCtx;
    private String staticSpec;
    private boolean gatherStats;
    private transient boolean removedReduceSinkBucketSort;
    private boolean linkedFileSink = false;
    private transient List<FileSinkDesc> linkedFileSinkDesc;
    private boolean statsReliable;
    private ListBucketingCtx lbCtx;
    private String statsTmpDir;
    private AcidUtils.Operation writeType = AcidUtils.Operation.NOT_ACID;
    private long tableWriteId = 0L;
    private int statementId = -1;
    private transient Table table;
    private Path destPath;
    private boolean isHiveServerQuery;
    private Long mmWriteId;
    private boolean isMerge;
    private boolean isMmCtas;
    private Set<FileStatus> filesToFetch = null;
    private boolean isUsingBatchingSerDe = false;
    private boolean isInsertOverwrite = false;
    private boolean isDirectInsert = false;
    private boolean isQuery = false;
    private boolean isCTASorCM = false;

    public FileSinkDesc() {
    }

    public FileSinkDesc(Path dirName, TableDesc tableInfo, boolean compressed, int destTableId, boolean multiFileSpray, boolean canBeMerged, int numFiles, int totalFiles, List<ExprNodeDesc> partitionCols, DynamicPartitionCtx dpCtx, Path destPath, Long mmWriteId, boolean isMmCtas, boolean isInsertOverwrite, boolean isQuery, boolean isCTASorCM, boolean isDirectInsert) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = destTableId;
        this.multiFileSpray = multiFileSpray;
        this.canBeMerged = canBeMerged;
        this.numFiles = numFiles;
        this.totalFiles = totalFiles;
        this.partitionCols = partitionCols;
        this.dpCtx = dpCtx;
        this.dpSortState = DPSortState.NONE;
        this.destPath = destPath;
        this.mmWriteId = mmWriteId;
        this.isMmCtas = isMmCtas;
        this.isInsertOverwrite = isInsertOverwrite;
        this.isQuery = isQuery;
        this.isCTASorCM = isCTASorCM;
        this.isDirectInsert = isDirectInsert;
    }

    public FileSinkDesc(Path dirName, TableDesc tableInfo, boolean compressed) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = 0;
        this.multiFileSpray = false;
        this.canBeMerged = false;
        this.numFiles = 1;
        this.totalFiles = 1;
        this.partitionCols = null;
        this.dpSortState = DPSortState.NONE;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileSinkDesc ret = new FileSinkDesc(this.dirName, this.tableInfo, this.compressed, this.destTableId, this.multiFileSpray, this.canBeMerged, this.numFiles, this.totalFiles, this.partitionCols, this.dpCtx, this.destPath, this.mmWriteId, this.isMmCtas, this.isInsertOverwrite, this.isQuery, this.isCTASorCM, this.isDirectInsert);
        ret.setCompressCodec(this.compressCodec);
        ret.setCompressType(this.compressType);
        ret.setGatherStats(this.gatherStats);
        ret.setStaticSpec(this.staticSpec);
        ret.setStatsAggPrefix(this.statsKeyPref);
        ret.setLinkedFileSink(this.linkedFileSink);
        ret.setLinkedFileSinkDesc(this.linkedFileSinkDesc);
        ret.setStatsReliable(this.statsReliable);
        ret.setDpSortState(this.dpSortState);
        ret.setWriteType(this.writeType);
        ret.setTableWriteId(this.tableWriteId);
        ret.setStatementId(this.statementId);
        ret.setStatsTmpDir(this.statsTmpDir);
        ret.setIsMerge(this.isMerge);
        ret.setFilesToFetch(this.filesToFetch);
        ret.setIsQuery(this.isQuery);
        ret.setIsCTASorCM(this.isCTASorCM);
        ret.setIsDirectInsert(this.isDirectInsert);
        return ret;
    }

    public void setFilesToFetch(Set<FileStatus> filesToFetch) {
        this.filesToFetch = filesToFetch;
    }

    public void setIsCTASorCM(boolean isCTASorCM) {
        this.isCTASorCM = isCTASorCM;
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean getIsQuery() {
        return this.isQuery;
    }

    public Set<FileStatus> getFilesToFetch() {
        return this.filesToFetch;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public boolean isUsingBatchingSerDe() {
        return this.isUsingBatchingSerDe;
    }

    public void setIsUsingBatchingSerDe(boolean isUsingBatchingSerDe) {
        this.isUsingBatchingSerDe = isUsingBatchingSerDe;
    }

    public void setIsDirectInsert(boolean isDirectInsert) {
        this.isDirectInsert = isDirectInsert;
    }

    public boolean isDirectInsert() {
        return this.isDirectInsert;
    }

    @Explain(displayName="directory", explainLevels={Explain.Level.EXTENDED})
    public Path getDirName() {
        return this.dirName;
    }

    @Signature
    public String getDirNameString() {
        return this.dirName.toString();
    }

    public void setDirName(Path dirName) {
        this.dirName = dirName;
    }

    public Path getFinalDirName() {
        return this.linkedFileSink ? this.dirName.getParent() : this.dirName;
    }

    public Path getMergeInputDirName() {
        Path root = this.getFinalDirName();
        if (this.isMmTable()) {
            return new Path(root, AcidUtils.deltaSubdir(this.tableWriteId, this.tableWriteId, this.statementId));
        }
        return root;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TableDesc getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableDesc tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Explain(displayName="compressed")
    @Signature
    public boolean getCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Explain(displayName="GlobalTableId", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public int getDestTableId() {
        return this.destTableId;
    }

    public void setDestTableId(int destTableId) {
        this.destTableId = destTableId;
    }

    public String getCompressCodec() {
        return this.compressCodec;
    }

    public void setCompressCodec(String intermediateCompressorCodec) {
        this.compressCodec = intermediateCompressorCodec;
    }

    public String getCompressType() {
        return this.compressType;
    }

    public void setCompressType(String intermediateCompressType) {
        this.compressType = intermediateCompressType;
    }

    @Explain(displayName="MultiFileSpray", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public boolean isMultiFileSpray() {
        return this.multiFileSpray;
    }

    public void setMultiFileSpray(boolean multiFileSpray) {
        this.multiFileSpray = multiFileSpray;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isMmTable() {
        if (this.getTable() != null) {
            return AcidUtils.isInsertOnlyTable(this.table.getParameters());
        }
        return AcidUtils.isInsertOnlyTable(this.getTableInfo().getProperties());
    }

    public boolean isFullAcidTable() {
        if (this.getTable() != null) {
            return AcidUtils.isFullAcidTable(this.table);
        }
        return AcidUtils.isTablePropertyTransactional(this.getTableInfo().getProperties()) && !AcidUtils.isInsertOnlyTable(this.getTableInfo().getProperties());
    }

    public boolean isCompactionTable() {
        return this.getTable() != null ? AcidUtils.isCompactionTable(this.table.getParameters()) : AcidUtils.isCompactionTable(this.getTableInfo().getProperties());
    }

    public boolean isMaterialization() {
        return this.materialization;
    }

    public void setMaterialization(boolean materialization) {
        this.materialization = materialization;
    }

    public boolean canBeMerged() {
        return this.canBeMerged;
    }

    public void setCanBeMerged(boolean canBeMerged) {
        this.canBeMerged = canBeMerged;
    }

    @Explain(displayName="TotalFiles", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public int getTotalFiles() {
        return this.totalFiles;
    }

    public void setTotalFiles(int totalFiles) {
        this.totalFiles = totalFiles;
    }

    public List<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(List<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    @Explain(displayName="NumFilesPerFileSink", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public void setDynPartCtx(DynamicPartitionCtx dpc) {
        this.dpCtx = dpc;
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dpCtx;
    }

    public void setStaticSpec(String staticSpec) {
        this.staticSpec = staticSpec;
    }

    @Explain(displayName="Static Partition Specification", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public String getStaticSpec() {
        return this.staticSpec;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Override
    @Explain(displayName="GatherStats", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    @Override
    @Explain(displayName="Stats Publishing Key Prefix", explainLevels={Explain.Level.EXTENDED})
    @Signature
    public String getStatsAggPrefix() {
        return this.statsKeyPref;
    }

    public void setStatsAggPrefix(String k) {
        this.statsKeyPref = k.endsWith("/") ? k : k + "/";
    }

    public boolean isLinkedFileSink() {
        return this.linkedFileSink;
    }

    public void setLinkedFileSink(boolean linkedFileSink) {
        this.linkedFileSink = linkedFileSink;
    }

    public Path getParentDir() {
        return this.dirName.getParent();
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public void setLbCtx(ListBucketingCtx lbCtx) {
        this.lbCtx = lbCtx;
    }

    public List<FileSinkDesc> getLinkedFileSinkDesc() {
        return this.linkedFileSinkDesc;
    }

    public void setLinkedFileSinkDesc(List<FileSinkDesc> linkedFileSinkDesc) {
        this.linkedFileSinkDesc = linkedFileSinkDesc;
    }

    public boolean isRemovedReduceSinkBucketSort() {
        return this.removedReduceSinkBucketSort;
    }

    public void setRemovedReduceSinkBucketSort(boolean removedReduceSinkBucketSort) {
        this.removedReduceSinkBucketSort = removedReduceSinkBucketSort;
    }

    public DPSortState getDpSortState() {
        return this.dpSortState;
    }

    @Explain(displayName="Dp Sort State")
    public String getDpSortStateString() {
        return this.getDpSortState() == DPSortState.NONE ? null : this.getDpSortState().toString();
    }

    public void setDpSortState(DPSortState dpSortState) {
        this.dpSortState = dpSortState;
    }

    public void setWriteType(AcidUtils.Operation type) {
        this.writeType = type;
    }

    public AcidUtils.Operation getWriteType() {
        return this.writeType;
    }

    @Explain(displayName="Write Type")
    public String getWriteTypeString() {
        return this.getWriteType() == AcidUtils.Operation.NOT_ACID ? null : this.getWriteType().toString();
    }

    public void setTableWriteId(long id) {
        this.tableWriteId = id;
    }

    public long getTableWriteId() {
        return this.tableWriteId;
    }

    public void setStatementId(int id) {
        this.statementId = id;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public Path getDestPath() {
        return this.destPath;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public String getTmpStatsDir() {
        return this.statsTmpDir;
    }

    public void setStatsTmpDir(String statsCollectionTempDir) {
        this.statsTmpDir = statsCollectionTempDir;
    }

    public void setMmWriteId(Long mmWriteId) {
        this.mmWriteId = mmWriteId;
    }

    public void setIsMerge(boolean b) {
        this.isMerge = b;
    }

    public boolean isMerge() {
        return this.isMerge;
    }

    public boolean isMmCtas() {
        return this.isMmCtas;
    }

    public boolean isCTASorCM() {
        return this.isCTASorCM;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="File Sink Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public FileSinkOperatorExplainVectorization getFileSinkVectorization() {
        VectorFileSinkDesc vectorFileSinkDesc = (VectorFileSinkDesc)this.getVectorDesc();
        if (vectorFileSinkDesc == null) {
            return null;
        }
        return new FileSinkOperatorExplainVectorization(vectorFileSinkDesc);
    }

    public void setInsertOverwrite(boolean isInsertOverwrite) {
        this.isInsertOverwrite = isInsertOverwrite;
    }

    public boolean getInsertOverwrite() {
        return this.isInsertOverwrite;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            FileSinkDesc otherDesc = (FileSinkDesc)other;
            return Objects.equals(this.getDirName(), otherDesc.getDirName()) && Objects.equals(this.getTableInfo(), otherDesc.getTableInfo()) && this.getCompressed() == otherDesc.getCompressed() && this.getDestTableId() == otherDesc.getDestTableId() && this.isMultiFileSpray() == otherDesc.isMultiFileSpray() && this.getTotalFiles() == otherDesc.getTotalFiles() && this.getNumFiles() == otherDesc.getNumFiles() && Objects.equals(this.getStaticSpec(), otherDesc.getStaticSpec()) && this.isGatherStats() == otherDesc.isGatherStats() && Objects.equals(this.getStatsAggPrefix(), otherDesc.getStatsAggPrefix());
        }
        return false;
    }

    public class FileSinkOperatorExplainVectorization
    extends OperatorExplainVectorization {
        public FileSinkOperatorExplainVectorization(VectorFileSinkDesc vectorFileSinkDesc) {
            super(vectorFileSinkDesc, false);
        }
    }

    public static enum DPSortState {
        NONE,
        PARTITION_SORTED,
        PARTITION_BUCKET_SORTED;

    }
}

