/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 885, null, null),
    LOAD("LOAD", 944, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 888, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 913, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1022, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1023, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1024, new Privilege[]{Privilege.SELECT}, null),
    CREATEDATABASE("CREATEDATABASE", 827, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 867, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1092, null, null, true, false),
    LOCKDB("LOCKDATABASE", 945, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1148, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 871, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 860, null, null),
    DESCFUNCTION("DESCFUNCTION", 859, null, null),
    MSCK("MSCK", 951, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 758, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 779, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 777, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 778, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{756, 755}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{788, 786}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 776, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{767, 791}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{760, 790}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 784, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 761, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 785, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{775, 768}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 773, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 781, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 754, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", 780, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", 753, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 764, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 811, null, null),
    CACHE_METADATA("CACHE_METADATA", 817, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 762, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 749, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWDATABASES("SHOWDATABASES", 1055, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1061, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1053, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1072, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1073, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1064, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1065, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1057, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1060, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1058, 1056}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1054, null, null),
    SHOWVIEWS("SHOWVIEWS", 1062, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1059, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 828, null, null),
    DROPFUNCTION("DROPFUNCTION", 868, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1015, null, null),
    CREATEMACRO("CREATEMACRO", 829, null, null),
    DROPMACRO("DROPMACRO", 869, null, null),
    CREATEVIEW("CREATEVIEW", 832, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 834, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 872, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 874, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 798, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{793, 792}, null, null),
    LOCKTABLE("LOCKTABLE", 946, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1149, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 830, null, null),
    DROPROLE("DROPROLE", 870, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 901, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1031, null, null),
    SHOW_GRANT("SHOW_GRANT", 1067, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 903, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1032, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1068, 1066, 1052}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1070, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1069, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 770, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 750, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 771, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 751, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 831, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1139, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1010, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERDATABASE("ALTERDATABASE", 748, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 747, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{745, 746}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCDATABASE("DESCDATABASE", 858, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 772, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 752, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 782, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 783, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 774, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 769, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 766, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 759, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 787, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 794, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 789, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 765, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1063, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1074, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1080, null, null, false, false),
    COMMIT("COMMIT", 825, null, null, true, true),
    ROLLBACK("ROLLBACK", 1037, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1050, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 738, null, null, false, false),
    KILL_QUERY("KILL QUERY", 934, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 836, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1071, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{808, 804, 806, 807, 803, 802, 805}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 876, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 838, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 810, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 878, null, null, false, false),
    CREATE_POOL("CREATE POOL", 835, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{799, 800, 801}, null, null, false, false),
    DROP_POOL("DROP POOL", 875, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 833, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 795, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 873, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 837, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 809, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 877, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

