/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

public class CommandProcessorException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int responseCode;
    private final int hiveErrorCode;
    private final String errorMessage;
    private final String sqlState;
    private final Throwable exception;

    public CommandProcessorException(int responseCode) {
        this(responseCode, -1, null, null, null);
    }

    public CommandProcessorException(String errorMessage) {
        this(errorMessage, null);
    }

    public CommandProcessorException(Throwable exception) {
        this(exception.getMessage(), exception);
    }

    public CommandProcessorException(String errorMessage, Throwable exception) {
        this(1, -1, errorMessage, null, exception);
    }

    public CommandProcessorException(int responseCode, int hiveErrorCode, String errorMessage, String sqlState, Throwable exception) {
        this.responseCode = responseCode;
        this.hiveErrorCode = hiveErrorCode;
        this.errorMessage = errorMessage;
        this.sqlState = sqlState;
        this.exception = exception;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getCauseMessage() {
        return this.getCause() == null ? "" : this.getCause().getMessage();
    }

    public int getErrorCode() {
        return this.hiveErrorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String toString() {
        return "(responseCode = " + this.responseCode + ", errorMessage = " + this.errorMessage + ", " + (this.hiveErrorCode > 0 ? "hiveErrorCode = " + this.hiveErrorCode + ", " : "") + "SQLState = " + this.sqlState + (this.exception == null ? "" : ", exception = " + this.exception.getMessage()) + ")";
    }
}

