/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class AlterPartitionEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(AlterPartitionEvent.class);
    private String COMMAND_STR = "alter table %s partition %s";

    public AlterPartitionEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.ALTERPARTITION_FILEFORMAT, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> AlterPartitionEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterPartitionEvent event = (PreAlterPartitionEvent)this.preEventContext;
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, event.getDbName(), event.getTableName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== AlterPartitionEvent.getInputHObjs()" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        String newUri;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> AlterPartitionEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterPartitionEvent event = (PreAlterPartitionEvent)this.preEventContext;
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, event.getDbName(), event.getTableName()));
        Partition newPartition = event.getNewPartition();
        String string = newUri = newPartition != null ? this.getSdLocation(newPartition.getSd()) : "";
        if (StringUtils.isNotEmpty(newUri)) {
            ret.add(this.getHivePrivilegeObjectDfsUri(newUri));
        }
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, event.getTableName(), newPartition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== AlterPartitionEvent.getOutputHObjs()" + ret));
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, String tbl, Partition partition) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = StringUtils.isNotEmpty(tbl) ? " " + tbl : "";
            String partionStr = partition != null ? partition.toString() : "";
            ret = String.format(cmdStr, tblName, partionStr);
        }
        return ret;
    }
}

