/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class CreateTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(CreateTableEvent.class);
    private String COMMAND_STR = "create table";

    public CreateTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.CREATETABLE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        return Collections.emptyList();
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> CreateTableEvent.getOutputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreCreateTableEvent event = (PreCreateTableEvent)this.preEventContext;
        Table table = event.getTable();
        String uri = this.getSdLocation(table.getSd());
        ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, table.getDbName(), null, null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null, table.getOwner(), table.getOwnerType()));
        ret.add(this.getHivePrivilegeObject(table));
        if (StringUtils.isNotEmpty(uri)) {
            ret.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI, null, uri));
        }
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== CreateTableEvent.getOutputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = tbl.getTableName();
            ret = ret + (StringUtils.isNotEmpty(tblName) ? " " + tblName : "");
        }
        return ret;
    }
}

