/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Calendar;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="year", value="_FUNC_(param) - Returns the year component of the date/timestamp/interval", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\n2. A date value\n3. A timestamp value\n4. A year-month interval valueExample:\n   > SELECT _FUNC_('2009-07-30') FROM src LIMIT 1;\n  2009")
@VectorizedExpressions(value={VectorUDFYearDate.class, VectorUDFYearString.class, VectorUDFYearTimestamp.class})
@NDV(maxNdv=20L)
public class UDFYear
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private final IntWritable output = new IntWritable();
    private final Calendar calendar = DateTimeMath.getProlepticGregorianCalendarUTC();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        switch (((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory()) {
            case INTERVAL_YEAR_MONTH: {
                this.inputTypes[0] = PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH;
                this.converters[0] = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPLOCALTZ: 
            case VOID: {
                this.obtainDateConverter(arguments, 0, this.inputTypes, this.converters);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getFuncName());
                sb.append(" does not take ");
                sb.append((Object)((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory());
                sb.append(" type");
                throw new UDFArgumentTypeException(0, sb.toString());
            }
        }
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        switch (this.inputTypes[0]) {
            case INTERVAL_YEAR_MONTH: {
                HiveIntervalYearMonth intervalYearMonth = this.getIntervalYearMonthValue(arguments, 0, this.inputTypes, this.converters);
                if (intervalYearMonth == null) {
                    return null;
                }
                this.output.set(intervalYearMonth.getYears());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPLOCALTZ: 
            case VOID: {
                Date date = this.getDateValue(arguments, 0, this.inputTypes, this.converters);
                if (date == null) {
                    return null;
                }
                this.calendar.setTimeInMillis(date.toEpochMilli());
                this.output.set(this.calendar.get(1));
            }
        }
        return this.output;
    }

    @Override
    protected String getFuncName() {
        return "year";
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

