/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.Validator;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.wm.CounterLimit;
import org.apache.hadoop.hive.ql.wm.CustomCounterLimit;
import org.apache.hadoop.hive.ql.wm.Expression;
import org.apache.hadoop.hive.ql.wm.FileSystemCounterLimit;
import org.apache.hadoop.hive.ql.wm.TimeCounterLimit;
import org.apache.hadoop.hive.ql.wm.TriggerExpression;
import org.apache.hadoop.hive.ql.wm.VertexCounterLimit;

public class ExpressionFactory {
    /*
     * WARNING - void declaration
     */
    public static Expression fromString(String expression) {
        long counterValue;
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        ParseDriver driver = new ParseDriver();
        ASTNode node = null;
        try {
            node = driver.parseTriggerExpression(expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + expression, e);
        }
        if (node.getChildCount() == 2 && node.getChild(1).getType() == -1) {
            node = (ASTNode)node.getChild(0);
        }
        if (node.getType() != 1137) {
            throw new IllegalArgumentException("Expected trigger expression, got: " + node.toStringTree());
        }
        if (node.getChildCount() != 3) {
            throw new IllegalArgumentException("Only single > condition supported: " + expression);
        }
        if (node.getChild(1).getType() != 21) {
            throw new IllegalArgumentException("Invalid predicate in expression");
        }
        String counterName = node.getChild(0).getText();
        String counterValueStr = PlanUtils.stripQuotes(node.getChild(2).getText().toLowerCase());
        if (counterName.isEmpty()) {
            throw new IllegalArgumentException("Counter name cannot be empty!");
        }
        for (FileSystemCounterLimit.FSCounter fSCounter : FileSystemCounterLimit.FSCounter.values()) {
            void counterValue2;
            if (!counterName.toUpperCase().endsWith(fSCounter.name())) continue;
            try {
                long counterValue22 = ExpressionFactory.getCounterValue(counterValueStr, new Validator.SizeValidator());
                if (counterValue22 < 0L) {
                    throw new IllegalArgumentException("Illegal value for counter limit. Expected a positive long value.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid counter value: " + counterValueStr);
            }
            FileSystemCounterLimit fsCounterLimit = FileSystemCounterLimit.fromName(counterName, (long)counterValue2);
            return ExpressionFactory.createExpression(fsCounterLimit);
        }
        for (Enum enum_ : TimeCounterLimit.TimeCounter.values()) {
            void counterValue3;
            if (!counterName.equalsIgnoreCase(enum_.name())) continue;
            try {
                long counterValue32 = ExpressionFactory.getCounterValue(counterValueStr, new Validator.TimeValidator(TimeUnit.MILLISECONDS));
                if (counterValue32 < 0L) {
                    throw new IllegalArgumentException("Illegal value for counter limit. Expected a positive long value.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid counter value: " + counterValueStr);
            }
            TimeCounterLimit timeCounterLimit = new TimeCounterLimit(TimeCounterLimit.TimeCounter.valueOf(counterName.toUpperCase()), (long)counterValue3);
            return ExpressionFactory.createExpression(timeCounterLimit);
        }
        for (Enum enum_ : VertexCounterLimit.VertexCounter.values()) {
            void counterValue4;
            if (!counterName.equalsIgnoreCase(enum_.name())) continue;
            try {
                long counterValue42 = ExpressionFactory.getCounterValue(counterValueStr, null);
                if (counterValue42 < 0L) {
                    throw new IllegalArgumentException("Illegal value for counter limit. Expected a positive long value.");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid counter value: " + counterValueStr);
            }
            VertexCounterLimit vertexCounterLimit = new VertexCounterLimit(VertexCounterLimit.VertexCounter.valueOf(counterName.toUpperCase()), (long)counterValue4);
            return ExpressionFactory.createExpression(vertexCounterLimit);
        }
        try {
            counterValue = ExpressionFactory.getCounterValue(counterValueStr, null);
            if (counterValue < 0L) {
                throw new IllegalArgumentException("Illegal value for counter limit. Expected a positive long value.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid counter value: " + counterValueStr);
        }
        CustomCounterLimit customCounterLimit = new CustomCounterLimit(counterName, counterValue);
        return ExpressionFactory.createExpression(customCounterLimit);
    }

    private static long getCounterValue(String counterValueStr, Validator validator) throws NumberFormatException {
        long counter;
        try {
            counter = Long.parseLong(counterValueStr);
        }
        catch (NumberFormatException e) {
            if (validator != null) {
                if (validator instanceof Validator.SizeValidator) {
                    return HiveConf.toSizeBytes(counterValueStr);
                }
                if (validator instanceof Validator.TimeValidator) {
                    return HiveConf.toTime(counterValueStr, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS);
                }
            }
            throw e;
        }
        return counter;
    }

    static Expression createExpression(CounterLimit counterLimit) {
        return new TriggerExpression(counterLimit, Expression.Predicate.GREATER_THAN);
    }
}

