/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.http.CrossOriginFilter;
import org.apache.hive.http.AdminAuthorizedServlet;
import org.apache.hive.http.ConfServlet;
import org.apache.hive.http.JMXJsonServlet;
import org.apache.hive.http.Log4j2ConfiguratorServlet;
import org.apache.hive.http.ProfileOutputServlet;
import org.apache.hive.http.ProfileServlet;
import org.apache.hive.http.StackServlet;
import org.apache.hive.http.security.PamAuthenticator;
import org.apache.hive.http.security.PamConstraint;
import org.apache.hive.http.security.PamConstraintMapping;
import org.apache.hive.http.security.PamLoginService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    public static final String CONF_CONTEXT_ATTRIBUTE = "hive.conf";
    public static final String ADMINS_ACL = "admins.acl";
    private XFrameOption xFrameOption;
    private boolean xFrameOptionIsEnabled;
    public static final String HTTP_HEADER_PREFIX = "hadoop.http.header.";
    private static final String X_FRAME_OPTIONS = "X-FRAME-OPTIONS";
    static final String X_XSS_PROTECTION = "X-XSS-Protection:1; mode=block";
    static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options:nosniff";
    private static final String HTTP_HEADER_REGEX = "hadoop\\.http\\.header\\.([a-zA-Z\\-_]+)";
    private static final Pattern PATTERN_HTTP_HEADER_REGEX = Pattern.compile("hadoop\\.http\\.header\\.([a-zA-Z\\-_]+)");
    private final String name;
    private String appDir;
    private WebAppContext webAppContext;
    private Server webServer;

    private HttpServer(Builder b) throws IOException {
        this.name = b.name;
        this.xFrameOptionIsEnabled = b.xFrameEnabled;
        this.xFrameOption = b.xFrameOption;
        this.createWebServer(b);
    }

    public void start() throws Exception {
        this.webServer.start();
        LOG.info("Started HttpServer[{}] on port {}", (Object)this.name, (Object)this.getPort());
    }

    public void stop() throws Exception {
        this.webServer.stop();
    }

    public int getPort() {
        return ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
    }

    @InterfaceAudience.LimitedPrivate(value={"hive"})
    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    @InterfaceAudience.LimitedPrivate(value={"hive"})
    public static boolean isInstrumentationAccessAllowedStrict(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (!adminAccess) {
            return false;
        }
        boolean access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        return access;
    }

    public static boolean hasAccess(String remoteUser, String user, ServletContext ctx, HttpServletRequest request) throws IOException {
        return StringUtils.equalsIgnoreCase(remoteUser, user) || HttpServer.hasAdministratorAccess(ctx, request, null);
    }

    static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            if (response != null) {
                response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            }
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer.userHasAdministratorAccess(servletContext, remoteUser)) {
            if (response != null) {
                response.sendError(401, "User " + remoteUser + " is unauthorized to access this page.");
            }
            return false;
        }
        return true;
    }

    static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    WebAppContext createWebAppContext(Builder b) {
        WebAppContext ctx = new WebAppContext();
        this.setContextAttributes(ctx.getServletContext(), b.contextAttrs);
        ctx.getServletContext().getSessionCookieConfig().setHttpOnly(true);
        ctx.setDisplayName(b.name);
        ctx.setContextPath("/");
        ctx.setWar(this.appDir + "/" + b.name);
        return ctx;
    }

    void setupSpnegoFilter(Builder b) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kerberos.principal", SecurityUtil.getServerPrincipal((String)b.spnegoPrincipal, (String)b.host));
        params.put("kerberos.keytab", b.spnegoKeytab);
        params.put("type", "kerberos");
        FilterHolder holder = new FilterHolder();
        holder.setClassName(AuthenticationFilter.class.getName());
        holder.setInitParameters(params);
        ServletHandler handler = this.webAppContext.getServletHandler();
        handler.addFilterWithMapping(holder, "/*", 31);
    }

    private void setupCORSFilter(Builder b) {
        FilterHolder holder = new FilterHolder();
        holder.setClassName(CrossOriginFilter.class.getName());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("allowed-origins", b.allowedOrigins);
        params.put("allowed-methods", b.allowedMethods);
        params.put("allowed-headers", b.allowedHeaders);
        holder.setInitParameters(params);
        ServletHandler handler = this.webAppContext.getServletHandler();
        handler.addFilterWithMapping(holder, "/*", 31);
    }

    Connector createChannelConnector(int queueSize, Builder b) {
        ServerConnector connector;
        HttpConfiguration conf = new HttpConfiguration();
        conf.setRequestHeaderSize(65536);
        HttpConnectionFactory http = new HttpConnectionFactory(conf);
        if (!b.useSSL) {
            connector = new ServerConnector(this.webServer, new ConnectionFactory[]{http});
        } else {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(b.keyStorePath);
            sslContextFactory.setKeyStoreType(b.keyStoreType == null || b.keyStoreType.isEmpty() ? KeyStore.getDefaultType() : b.keyStoreType);
            sslContextFactory.setKeyManagerFactoryAlgorithm(b.keyManagerFactoryAlgorithm == null || b.keyManagerFactoryAlgorithm.isEmpty() ? KeyManagerFactory.getDefaultAlgorithm() : b.keyManagerFactoryAlgorithm);
            HashSet<String> excludedSSLProtocols = Sets.newHashSet(Splitter.on(",").trimResults().omitEmptyStrings().split(Strings.nullToEmpty(b.conf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST))));
            sslContextFactory.addExcludeProtocols(excludedSSLProtocols.toArray(new String[excludedSSLProtocols.size()]));
            sslContextFactory.setKeyStorePassword(b.keyStorePassword);
            connector = new ServerConnector(this.webServer, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{http});
        }
        connector.setAcceptQueueSize(queueSize);
        connector.setReuseAddress(true);
        connector.setHost(b.host);
        connector.setPort(b.port);
        return connector;
    }

    void setupPam(Builder b, Handler handler) {
        PamLoginService loginService = new PamLoginService();
        this.webServer.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        PamConstraint constraint = new PamConstraint();
        PamConstraintMapping mapping = new PamConstraintMapping(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        security.setAuthenticator((Authenticator)b.pamAuthenticator);
        security.setLoginService((LoginService)loginService);
        security.setHandler(handler);
        this.webServer.setHandler((Handler)security);
    }

    void setContextAttributes(ContextHandler.Context ctx, Map<String, Object> contextAttrs) {
        for (Map.Entry<String, Object> e : contextAttrs.entrySet()) {
            ctx.setAttribute(e.getKey(), e.getValue());
        }
    }

    private void createWebServer(Builder b) throws IOException {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (b.maxThreads > 0) {
            threadPool.setMaxThreads(b.maxThreads);
        }
        threadPool.setDaemon(true);
        threadPool.setName(b.name + "-web");
        this.webServer = new Server((ThreadPool)threadPool);
        this.appDir = this.getWebAppsPath(b.name);
        this.webAppContext = this.createWebAppContext(b);
        if (b.useSPNEGO) {
            this.setupSpnegoFilter(b);
        }
        if (b.enableCORS) {
            this.setupCORSFilter(b);
        }
        Map<String, String> xFrameParams = this.setHeaders();
        if (b.xFrameEnabled) {
            this.setupXframeFilter(b, xFrameParams);
        }
        if (b.disableDirListing) {
            HttpServer.disableDirectoryListingOnServlet((ServletContextHandler)this.webAppContext);
        }
        this.initializeWebServer(b, threadPool.getMaxThreads());
    }

    private void initializeWebServer(Builder b, int queueSize) throws IOException {
        LowResourceMonitor low = new LowResourceMonitor(this.webServer);
        low.setLowResourcesIdleTimeout(10000);
        this.webServer.addBean((Object)low);
        Connector connector = this.createChannelConnector(queueSize, b);
        this.webServer.addConnector(connector);
        RewriteHandler rwHandler = new RewriteHandler();
        rwHandler.setRewriteRequestURI(true);
        rwHandler.setRewritePathInfo(false);
        RewriteRegexRule rootRule = new RewriteRegexRule();
        rootRule.setRegex("^/$");
        rootRule.setReplacement(b.contextRootRewriteTarget);
        rootRule.setTerminating(true);
        rwHandler.addRule((Rule)rootRule);
        rwHandler.setHandler((Handler)this.webAppContext);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)rwHandler);
        this.webServer.setHandler((Handler)contexts);
        if (b.usePAM) {
            this.setupPam(b, (Handler)contexts);
        }
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("conflog", "/conflog", Log4j2ConfiguratorServlet.class);
        String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
        if (asyncProfilerHome != null && !asyncProfilerHome.trim().isEmpty()) {
            this.addServlet("prof", "/prof", ProfileServlet.class);
            Path tmpDir = Paths.get(ProfileServlet.OUTPUT_DIR, new String[0]);
            if (Files.notExists(tmpDir, new LinkOption[0])) {
                Files.createDirectories(tmpDir, new FileAttribute[0]);
            }
            ServletContextHandler genCtx = new ServletContextHandler((HandlerContainer)contexts, "/prof-output");
            this.setContextAttributes(genCtx.getServletContext(), b.contextAttrs);
            genCtx.addServlet(ProfileOutputServlet.class, "/*");
            genCtx.setResourceBase(tmpDir.toAbsolutePath().toString());
            genCtx.setDisplayName("prof-output");
        } else {
            LOG.info("ASYNC_PROFILER_HOME env or -Dasync.profiler.home not specified. Disabling /prof endpoint..");
        }
        for (Pair p : b.servlets) {
            this.addServlet((String)p.getFirst(), "/" + (String)p.getFirst(), (Class)p.getSecond());
        }
        ServletContextHandler staticCtx = new ServletContextHandler((HandlerContainer)contexts, "/static");
        staticCtx.setResourceBase(this.appDir + "/static");
        staticCtx.addServlet(DefaultServlet.class, "/*");
        staticCtx.setDisplayName("static");
        HttpServer.disableDirectoryListingOnServlet(staticCtx);
        String logDir = this.getLogDir(b.conf);
        if (logDir != null) {
            ServletContextHandler logCtx = new ServletContextHandler((HandlerContainer)contexts, "/logs");
            this.setContextAttributes(logCtx.getServletContext(), b.contextAttrs);
            logCtx.addServlet(AdminAuthorizedServlet.class, "/*");
            logCtx.setResourceBase(logDir);
            logCtx.setDisplayName("logs");
        }
    }

    private Map<String, String> setHeaders() {
        HashMap<String, String> xFrameParams = new HashMap<String, String>();
        xFrameParams.putAll(this.getDefaultHeaders());
        if (this.xFrameOptionIsEnabled) {
            xFrameParams.put("hadoop.http.header.X-FRAME-OPTIONS", this.xFrameOption.toString());
        }
        return xFrameParams;
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] splitVal = X_CONTENT_TYPE_OPTIONS.split(":");
        headers.put(HTTP_HEADER_PREFIX + splitVal[0], splitVal[1]);
        splitVal = X_XSS_PROTECTION.split(":");
        headers.put(HTTP_HEADER_PREFIX + splitVal[0], splitVal[1]);
        return headers;
    }

    private void setupXframeFilter(Builder b, Map<String, String> params) {
        FilterHolder holder = new FilterHolder();
        holder.setClassName(QuotingInputFilter.class.getName());
        holder.setInitParameters(params);
        ServletHandler handler = this.webAppContext.getServletHandler();
        handler.addFilterWithMapping(holder, "/*", 31);
    }

    String getLogDir(Configuration conf) {
        String logDir = conf.get("hive.log.dir");
        if (logDir == null) {
            logDir = System.getProperty("hive.log.dir");
        }
        if (logDir != null) {
            return logDir;
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        for (Logger logger : context.getLoggers()) {
            for (Appender appender : logger.getAppenders().values()) {
                String fileName;
                OutputStreamManager manager;
                if (!(appender instanceof AbstractOutputStreamAppender) || !((manager = ((AbstractOutputStreamAppender)appender).getManager()) instanceof FileManager) || (fileName = ((FileManager)manager).getFileName()) == null) continue;
                return fileName.substring(0, fileName.lastIndexOf(47));
            }
        }
        return null;
    }

    String getWebAppsPath(String appName) throws FileNotFoundException {
        String relativePath = "hive-webapps/" + appName;
        URL url = this.getClass().getClassLoader().getResource(relativePath);
        if (url == null) {
            throw new FileNotFoundException(relativePath + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    private static void disableDirectoryListingOnServlet(ServletContextHandler contextHandler) {
        contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
    }

    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;
        private Map<String, String> headerMap;

        public void init(FilterConfig config) throws ServletException {
            this.config = config;
            this.initHttpHeaderMap();
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            this.headerMap.forEach((k, v) -> httpResponse.addHeader(k, v));
            chain.doFilter((ServletRequest)quoted, (ServletResponse)httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ServletContextHandler.Context sContext = (ServletContextHandler.Context)this.config.getServletContext();
            String mime = sContext.getMimeType(path);
            return mime == null ? null : mime;
        }

        private void initHttpHeaderMap() {
            Enumeration params = this.config.getInitParameterNames();
            this.headerMap = new HashMap<String, String>();
            while (params.hasMoreElements()) {
                String key = (String)params.nextElement();
                Matcher m = PATTERN_HTTP_HEADER_REGEX.matcher(key);
                if (!m.matches()) continue;
                String headerKey = m.group(1);
                this.headerMap.put(headerKey, this.config.getInitParameter(key));
            }
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars((String)this.rawIterator.nextElement());
                    }
                };
            }

            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars((String)this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars((String)name)));
            }

            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars((String)name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars((String)unquoteValue[i]);
                }
                return result;
            }

            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map raw = this.rawRequest.getParameterMap();
                for (Map.Entry item : raw.entrySet()) {
                    String[] rawValue = (String[])item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars((String)rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars((String)((String)item.getKey())), cookedValue);
                }
                return result;
            }

            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars((String)url));
            }

            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars((String)this.rawRequest.getServerName());
            }
        }
    }

    public static enum XFrameOption {
        DENY("DENY"),
        SAMEORIGIN("SAMEORIGIN"),
        ALLOWFROM("ALLOW-FROM");

        private final String name;

        private XFrameOption(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private static XFrameOption getEnum(String value) {
            Preconditions.checkState(value != null && !value.isEmpty());
            for (XFrameOption xoption : XFrameOption.values()) {
                if (!value.equals(xoption.toString())) continue;
                return xoption;
            }
            throw new IllegalArgumentException("Unexpected value in xFrameOption.");
        }
    }

    public static class Builder {
        private final String name;
        private String host;
        private int port;
        private int maxThreads;
        private HiveConf conf;
        private final Map<String, Object> contextAttrs = new HashMap<String, Object>();
        private String keyStorePassword;
        private String keyStorePath;
        private String keyStoreType;
        private String keyManagerFactoryAlgorithm;
        private String spnegoPrincipal;
        private String spnegoKeytab;
        private boolean useSPNEGO;
        private boolean useSSL;
        private boolean usePAM;
        private boolean enableCORS;
        private String allowedOrigins;
        private String allowedMethods;
        private String allowedHeaders;
        private PamAuthenticator pamAuthenticator;
        private String contextRootRewriteTarget = "/index.html";
        private boolean xFrameEnabled;
        private XFrameOption xFrameOption = XFrameOption.SAMEORIGIN;
        private final List<Pair<String, Class<? extends HttpServlet>>> servlets = new LinkedList<Pair<String, Class<? extends HttpServlet>>>();
        private boolean disableDirListing = false;

        public Builder(String name) {
            Preconditions.checkArgument(name != null && !name.isEmpty(), "Name must be specified");
            this.name = name;
        }

        public HttpServer build() throws IOException {
            return new HttpServer(this);
        }

        public Builder setConf(HiveConf origConf) {
            this.conf = new HiveConf(origConf);
            origConf.stripHiddenConfigurations(this.conf);
            this.setContextAttribute(HttpServer.CONF_CONTEXT_ATTRIBUTE, (Object)this.conf);
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder setAdmins(String admins) {
            if (admins != null) {
                this.setContextAttribute(HttpServer.ADMINS_ACL, new AccessControlList(admins));
            }
            return this;
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
            return this;
        }

        public Builder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder setUsePAM(boolean usePAM) {
            this.usePAM = usePAM;
            return this;
        }

        public Builder setPAMAuthenticator(PamAuthenticator pamAuthenticator) {
            this.pamAuthenticator = pamAuthenticator;
            return this;
        }

        public Builder setUseSPNEGO(boolean useSPNEGO) {
            this.useSPNEGO = useSPNEGO;
            return this;
        }

        public Builder setEnableCORS(boolean enableCORS) {
            this.enableCORS = enableCORS;
            return this;
        }

        public Builder setAllowedOrigins(String allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        public Builder setAllowedMethods(String allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public Builder setAllowedHeaders(String allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public Builder setSPNEGOPrincipal(String principal) {
            this.spnegoPrincipal = principal;
            return this;
        }

        public Builder setSPNEGOKeytab(String keytab) {
            this.spnegoKeytab = keytab;
            return this;
        }

        public Builder setContextAttribute(String name, Object value) {
            this.contextAttrs.put(name, value);
            return this;
        }

        public Builder setContextRootRewriteTarget(String contextRootRewriteTarget) {
            this.contextRootRewriteTarget = contextRootRewriteTarget;
            return this;
        }

        public Builder addServlet(String endpoint, Class<? extends HttpServlet> servlet) {
            this.servlets.add((Pair<String, Class<? extends HttpServlet>>)new Pair((Object)endpoint, servlet));
            return this;
        }

        public Builder configureXFrame(boolean xFrameEnabled) {
            this.xFrameEnabled = xFrameEnabled;
            return this;
        }

        public Builder setXFrameOption(String option) {
            this.xFrameOption = XFrameOption.getEnum(option);
            return this;
        }

        public void setDisableDirListing(boolean disableDirListing) {
            this.disableDirListing = disableDirListing;
        }
    }
}

