/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveProtoEventsCleanerTask
implements MetastoreTaskThread {
    public static final Logger LOG = LoggerFactory.getLogger(HiveProtoEventsCleanerTask.class);
    private final String[] eventsSubDirs = new String[]{"query_data", "dag_meta", "dag_data", "app_data"};
    private List<Path> eventsBasePaths = new ArrayList<Path>();
    private Configuration conf;
    private long ttl;
    private static String expiredDatePtn = null;
    private static final SystemClock clock = SystemClock.getInstance();
    private static final PathFilter expiredDatePartitionsFilter = new PathFilter(){

        public boolean accept(Path path) {
            String dirName = path.getName();
            return dirName.startsWith("date=") && dirName.compareTo(expiredDatePtn) <= 0;
        }
    };

    public void setConf(Configuration conf) {
        this.conf = conf;
        String hiveEventsDir = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH);
        if (StringUtils.isBlank(hiveEventsDir)) {
            return;
        }
        Path hiveEventsBasePath = new Path(hiveEventsDir);
        Path baseDir = hiveEventsBasePath.getParent();
        for (String subDir : this.eventsSubDirs) {
            this.eventsBasePaths.add(new Path(baseDir, subDir));
        }
        assert (this.eventsBasePaths.get(0).equals((Object)hiveEventsBasePath));
        this.ttl = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_PROTO_EVENTS_TTL, TimeUnit.MILLISECONDS);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_PROTO_EVENTS_CLEAN_FREQ, unit);
    }

    @Override
    public void run() {
        if (this.eventsBasePaths.isEmpty()) {
            return;
        }
        HiveProtoEventsCleanerTask.computeExpiredDatePtn(this.ttl);
        for (Path basePath : this.eventsBasePaths) {
            this.cleanupDir(basePath);
        }
    }

    private static void computeExpiredDatePtn(long ttl) {
        LocalDate expiredDate = LocalDateTime.ofEpochSecond((clock.getTime() - ttl) / 1000L, 0, ZoneOffset.UTC).toLocalDate();
        expiredDatePtn = "date=" + DateTimeFormatter.ISO_LOCAL_DATE.format(expiredDate);
    }

    private void cleanupDir(Path eventsBasePath) {
        LOG.debug("Trying to delete expired proto events from " + eventsBasePath);
        try {
            FileStatus[] statuses;
            FileSystem fs = FileSystem.get((URI)eventsBasePath.toUri(), (Configuration)this.conf);
            if (!fs.exists(eventsBasePath)) {
                return;
            }
            for (FileStatus dir : statuses = fs.listStatus(eventsBasePath, expiredDatePartitionsFilter)) {
                try {
                    this.deleteDirByOwner(fs, dir);
                    LOG.info("Deleted expired proto events dir: " + dir.getPath());
                }
                catch (IOException ioe) {
                    LOG.error("Error deleting expired proto events dir " + dir.getPath(), (Throwable)ioe);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error while trying to delete expired proto events from " + eventsBasePath, (Throwable)e);
        }
    }

    private void deleteDirByOwner(FileSystem fs, final FileStatus eventsDir) throws IOException {
        String owner = eventsDir.getOwner();
        if (owner.equals(System.getProperty("user.name"))) {
            fs.delete(eventsDir.getPath(), true);
        } else {
            LOG.info("Deleting " + eventsDir.getPath() + " as user " + owner);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)owner, (UserGroupInformation)UserGroupInformation.getLoginUser());
            try {
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        try (FileSystem doAsFs = FileSystem.newInstance((URI)eventsDir.getPath().toUri(), (Configuration)HiveProtoEventsCleanerTask.this.conf);){
                            doAsFs.delete(eventsDir.getPath(), true);
                        }
                        return null;
                    }
                });
            }
            catch (InterruptedException ie) {
                LOG.error("Could not delete " + eventsDir.getPath() + " for UGI: " + ugi, (Throwable)ie);
            }
        }
    }
}

