/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Partition
implements TBase<Partition, _Fields>,
Serializable,
Cloneable,
Comparable<Partition> {
    private static final TStruct STRUCT_DESC = new TStruct("Partition");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 6);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 7);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 12, 8);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 9);
    private static final TField WRITE_ID_FIELD_DESC = new TField("writeId", 10, 10);
    private static final TField IS_STATS_COMPLIANT_FIELD_DESC = new TField("isStatsCompliant", 2, 11);
    private static final TField COL_STATS_FIELD_DESC = new TField("colStats", 12, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PartitionStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PartitionTupleSchemeFactory();
    @Nullable
    private List<String> values;
    @Nullable
    private String dbName;
    @Nullable
    private String tableName;
    private int createTime;
    private int lastAccessTime;
    @Nullable
    private StorageDescriptor sd;
    @Nullable
    private Map<String, String> parameters;
    @Nullable
    private PrincipalPrivilegeSet privileges;
    @Nullable
    private String catName;
    private long writeId;
    private boolean isStatsCompliant;
    @Nullable
    private ColumnStatistics colStats;
    private static final int __CREATETIME_ISSET_ID = 0;
    private static final int __LASTACCESSTIME_ISSET_ID = 1;
    private static final int __WRITEID_ISSET_ID = 2;
    private static final int __ISSTATSCOMPLIANT_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.PRIVILEGES, _Fields.CAT_NAME, _Fields.WRITE_ID, _Fields.IS_STATS_COMPLIANT, _Fields.COL_STATS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Partition() {
        this.writeId = -1L;
    }

    public Partition(List<String> values, String dbName, String tableName, int createTime, int lastAccessTime, StorageDescriptor sd, Map<String, String> parameters) {
        this();
        this.values = values;
        this.dbName = StringUtils.intern(dbName);
        this.tableName = StringUtils.intern(tableName);
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
        this.sd = sd;
        this.parameters = StringUtils.intern(parameters);
    }

    public Partition(Partition other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetValues()) {
            ArrayList<String> __this__values = new ArrayList<String>(other.values);
            this.values = __this__values;
        }
        if (other.isSetDbName()) {
            this.dbName = StringUtils.intern(other.dbName);
        }
        if (other.isSetTableName()) {
            this.tableName = StringUtils.intern(other.tableName);
        }
        this.createTime = other.createTime;
        this.lastAccessTime = other.lastAccessTime;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>(other.parameters);
            this.parameters = __this__parameters;
        }
        if (other.isSetPrivileges()) {
            this.privileges = new PrincipalPrivilegeSet(other.privileges);
        }
        if (other.isSetCatName()) {
            this.catName = StringUtils.intern(other.catName);
        }
        this.writeId = other.writeId;
        this.isStatsCompliant = other.isStatsCompliant;
        if (other.isSetColStats()) {
            this.colStats = new ColumnStatistics(other.colStats);
        }
    }

    @Override
    public Partition deepCopy() {
        return new Partition(this);
    }

    @Override
    public void clear() {
        this.values = null;
        this.dbName = null;
        this.tableName = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.setLastAccessTimeIsSet(false);
        this.lastAccessTime = 0;
        this.sd = null;
        this.parameters = null;
        this.privileges = null;
        this.catName = null;
        this.writeId = -1L;
        this.setIsStatsCompliantIsSet(false);
        this.isStatsCompliant = false;
        this.colStats = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    @Nullable
    public Iterator<String> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(String elem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(elem);
    }

    @Nullable
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<String> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = StringUtils.intern(dbName);
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = StringUtils.intern(tableName);
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetCreateTime() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
    }

    public void unsetLastAccessTime() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetLastAccessTime() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setLastAccessTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    @Nullable
    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(@Nullable StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(StringUtils.intern(key), StringUtils.intern(val));
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = StringUtils.intern(parameters);
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    @Nullable
    public PrincipalPrivilegeSet getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(@Nullable PrincipalPrivilegeSet privileges) {
        this.privileges = privileges;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean value) {
        if (!value) {
            this.privileges = null;
        }
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = StringUtils.intern(catName);
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    public long getWriteId() {
        return this.writeId;
    }

    public void setWriteId(long writeId) {
        this.writeId = writeId;
        this.setWriteIdIsSet(true);
    }

    public void unsetWriteId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetWriteId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setWriteIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    public boolean isIsStatsCompliant() {
        return this.isStatsCompliant;
    }

    public void setIsStatsCompliant(boolean isStatsCompliant) {
        this.isStatsCompliant = isStatsCompliant;
        this.setIsStatsCompliantIsSet(true);
    }

    public void unsetIsStatsCompliant() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetIsStatsCompliant() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setIsStatsCompliantIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    @Nullable
    public ColumnStatistics getColStats() {
        return this.colStats;
    }

    public void setColStats(@Nullable ColumnStatistics colStats) {
        this.colStats = colStats;
    }

    public void unsetColStats() {
        this.colStats = null;
    }

    public boolean isSetColStats() {
        return this.colStats != null;
    }

    public void setColStatsIsSet(boolean value) {
        if (!value) {
            this.colStats = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case CREATE_TIME: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case LAST_ACCESS_TIME: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case SD: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case PRIVILEGES: {
                if (value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((PrincipalPrivilegeSet)value);
                break;
            }
            case CAT_NAME: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case WRITE_ID: {
                if (value == null) {
                    this.unsetWriteId();
                    break;
                }
                this.setWriteId((Long)value);
                break;
            }
            case IS_STATS_COMPLIANT: {
                if (value == null) {
                    this.unsetIsStatsCompliant();
                    break;
                }
                this.setIsStatsCompliant((Boolean)value);
                break;
            }
            case COL_STATS: {
                if (value == null) {
                    this.unsetColStats();
                    break;
                }
                this.setColStats((ColumnStatistics)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUES: {
                return this.getValues();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case CREATE_TIME: {
                return this.getCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.getLastAccessTime();
            }
            case SD: {
                return this.getSd();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
            case PRIVILEGES: {
                return this.getPrivileges();
            }
            case CAT_NAME: {
                return this.getCatName();
            }
            case WRITE_ID: {
                return this.getWriteId();
            }
            case IS_STATS_COMPLIANT: {
                return this.isIsStatsCompliant();
            }
            case COL_STATS: {
                return this.getColStats();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUES: {
                return this.isSetValues();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case CREATE_TIME: {
                return this.isSetCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.isSetLastAccessTime();
            }
            case SD: {
                return this.isSetSd();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
            case PRIVILEGES: {
                return this.isSetPrivileges();
            }
            case CAT_NAME: {
                return this.isSetCatName();
            }
            case WRITE_ID: {
                return this.isSetWriteId();
            }
            case IS_STATS_COMPLIANT: {
                return this.isSetIsStatsCompliant();
            }
            case COL_STATS: {
                return this.isSetColStats();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            return this.equals((Partition)that);
        }
        return false;
    }

    public boolean equals(Partition that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!this.parameters.equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_privileges = this.isSetPrivileges();
        boolean that_present_privileges = that.isSetPrivileges();
        if (this_present_privileges || that_present_privileges) {
            if (!this_present_privileges || !that_present_privileges) {
                return false;
            }
            if (!this.privileges.equals(that.privileges)) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_writeId = this.isSetWriteId();
        boolean that_present_writeId = that.isSetWriteId();
        if (this_present_writeId || that_present_writeId) {
            if (!this_present_writeId || !that_present_writeId) {
                return false;
            }
            if (this.writeId != that.writeId) {
                return false;
            }
        }
        boolean this_present_isStatsCompliant = this.isSetIsStatsCompliant();
        boolean that_present_isStatsCompliant = that.isSetIsStatsCompliant();
        if (this_present_isStatsCompliant || that_present_isStatsCompliant) {
            if (!this_present_isStatsCompliant || !that_present_isStatsCompliant) {
                return false;
            }
            if (this.isStatsCompliant != that.isStatsCompliant) {
                return false;
            }
        }
        boolean this_present_colStats = this.isSetColStats();
        boolean that_present_colStats = that.isSetColStats();
        if (this_present_colStats || that_present_colStats) {
            if (!this_present_colStats || !that_present_colStats) {
                return false;
            }
            if (!this.colStats.equals(that.colStats)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetValues() ? 131071 : 524287);
        if (this.isSetValues()) {
            hashCode = hashCode * 8191 + this.values.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + this.createTime;
        hashCode = hashCode * 8191 + this.lastAccessTime;
        hashCode = hashCode * 8191 + (this.isSetSd() ? 131071 : 524287);
        if (this.isSetSd()) {
            hashCode = hashCode * 8191 + this.sd.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParameters() ? 131071 : 524287);
        if (this.isSetParameters()) {
            hashCode = hashCode * 8191 + this.parameters.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPrivileges() ? 131071 : 524287);
        if (this.isSetPrivileges()) {
            hashCode = hashCode * 8191 + this.privileges.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetWriteId() ? 131071 : 524287);
        if (this.isSetWriteId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.writeId);
        }
        hashCode = hashCode * 8191 + (this.isSetIsStatsCompliant() ? 131071 : 524287);
        if (this.isSetIsStatsCompliant()) {
            hashCode = hashCode * 8191 + (this.isStatsCompliant ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetColStats() ? 131071 : 524287);
        if (this.isSetColStats()) {
            hashCode = hashCode * 8191 + this.colStats.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(Partition other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetValues(), other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, other.values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo(this.dbName, other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo(this.tableName, other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCreateTime(), other.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo(this.createTime, other.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLastAccessTime(), other.isSetLastAccessTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastAccessTime() && (lastComparison = TBaseHelper.compareTo(this.lastAccessTime, other.lastAccessTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSd(), other.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo(this.sd, other.sd)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParameters(), other.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, other.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPrivileges(), other.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrivileges() && (lastComparison = TBaseHelper.compareTo(this.privileges, other.privileges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo(this.catName, other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetWriteId(), other.isSetWriteId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteId() && (lastComparison = TBaseHelper.compareTo(this.writeId, other.writeId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsStatsCompliant(), other.isSetIsStatsCompliant());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsStatsCompliant() && (lastComparison = TBaseHelper.compareTo(this.isStatsCompliant, other.isStatsCompliant)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColStats(), other.isSetColStats());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColStats() && (lastComparison = TBaseHelper.compareTo(this.colStats, other.colStats)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        Partition.scheme(iprot).read(iprot, (Partition)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        Partition.scheme(oprot).write(oprot, (Partition)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        if (this.isSetPrivileges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("privileges:");
            if (this.privileges == null) {
                sb.append("null");
            } else {
                sb.append(this.privileges);
            }
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (this.isSetWriteId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("writeId:");
            sb.append(this.writeId);
            first = false;
        }
        if (this.isSetIsStatsCompliant()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("isStatsCompliant:");
            sb.append(this.isStatsCompliant);
            first = false;
        }
        if (this.isSetColStats()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("colStats:");
            if (this.colStats == null) {
                sb.append("null");
            } else {
                sb.append(this.colStats);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sd != null) {
            this.sd.validate();
        }
        if (this.privileges != null) {
            this.privileges.validate();
        }
        if (this.colStats != null) {
            this.colStats.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LAST_ACCESS_TIME, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, new StructMetaData(12, StorageDescriptor.class)));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.PRIVILEGES, new FieldMetaData("privileges", 2, new StructMetaData(12, PrincipalPrivilegeSet.class)));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WRITE_ID, new FieldMetaData("writeId", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IS_STATS_COMPLIANT, new FieldMetaData("isStatsCompliant", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COL_STATS, new FieldMetaData("colStats", 2, new StructMetaData(12, ColumnStatistics.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Partition.class, metaDataMap);
    }

    private static class PartitionTupleScheme
    extends TupleScheme<Partition> {
        private PartitionTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, Partition struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetValues()) {
                optionals.set(0);
            }
            if (struct.isSetDbName()) {
                optionals.set(1);
            }
            if (struct.isSetTableName()) {
                optionals.set(2);
            }
            if (struct.isSetCreateTime()) {
                optionals.set(3);
            }
            if (struct.isSetLastAccessTime()) {
                optionals.set(4);
            }
            if (struct.isSetSd()) {
                optionals.set(5);
            }
            if (struct.isSetParameters()) {
                optionals.set(6);
            }
            if (struct.isSetPrivileges()) {
                optionals.set(7);
            }
            if (struct.isSetCatName()) {
                optionals.set(8);
            }
            if (struct.isSetWriteId()) {
                optionals.set(9);
            }
            if (struct.isSetIsStatsCompliant()) {
                optionals.set(10);
            }
            if (struct.isSetColStats()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetValues()) {
                oprot.writeI32(struct.values.size());
                for (String string : struct.values) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetTableName()) {
                oprot.writeString(struct.tableName);
            }
            if (struct.isSetCreateTime()) {
                oprot.writeI32(struct.createTime);
            }
            if (struct.isSetLastAccessTime()) {
                oprot.writeI32(struct.lastAccessTime);
            }
            if (struct.isSetSd()) {
                struct.sd.write(oprot);
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetPrivileges()) {
                struct.privileges.write(oprot);
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetWriteId()) {
                oprot.writeI64(struct.writeId);
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeBool(struct.isStatsCompliant);
            }
            if (struct.isSetColStats()) {
                struct.colStats.write(oprot);
            }
        }

        @Override
        public void read(TProtocol prot, Partition struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                TList _list267 = iprot.readListBegin((byte)11);
                struct.values = new ArrayList(_list267.size);
                for (int _i269 = 0; _i269 < _list267.size; ++_i269) {
                    String _elem268 = iprot.readString();
                    struct.values.add(_elem268);
                }
                struct.setValuesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.dbName = StringUtils.intern(iprot.readString());
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.tableName = StringUtils.intern(iprot.readString());
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(3)) {
                struct.createTime = iprot.readI32();
                struct.setCreateTimeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.lastAccessTime = iprot.readI32();
                struct.setLastAccessTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.sd = new StorageDescriptor();
                struct.sd.read(iprot);
                struct.setSdIsSet(true);
            }
            if (incoming.get(6)) {
                TMap _map270 = iprot.readMapBegin((byte)11, (byte)11);
                struct.parameters = new HashMap(2 * _map270.size);
                for (int _i273 = 0; _i273 < _map270.size; ++_i273) {
                    String _key271 = iprot.readString();
                    String _val272 = iprot.readString();
                    struct.parameters.put(_key271, _val272);
                }
                struct.parameters = StringUtils.intern(struct.parameters);
                struct.setParametersIsSet(true);
            }
            if (incoming.get(7)) {
                struct.privileges = new PrincipalPrivilegeSet();
                struct.privileges.read(iprot);
                struct.setPrivilegesIsSet(true);
            }
            if (incoming.get(8)) {
                struct.catName = StringUtils.intern(iprot.readString());
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(9)) {
                struct.writeId = iprot.readI64();
                struct.setWriteIdIsSet(true);
            }
            if (incoming.get(10)) {
                struct.isStatsCompliant = iprot.readBool();
                struct.setIsStatsCompliantIsSet(true);
            }
            if (incoming.get(11)) {
                struct.colStats = new ColumnStatistics();
                struct.colStats.read(iprot);
                struct.setColStatsIsSet(true);
            }
        }
    }

    private static class PartitionTupleSchemeFactory
    implements SchemeFactory {
        private PartitionTupleSchemeFactory() {
        }

        public PartitionTupleScheme getScheme() {
            return new PartitionTupleScheme();
        }
    }

    private static class PartitionStandardScheme
    extends StandardScheme<Partition> {
        private PartitionStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, Partition struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list256 = iprot.readListBegin();
                            struct.values = new ArrayList(_list256.size);
                            for (int _i258 = 0; _i258 < _list256.size; ++_i258) {
                                String _elem257 = iprot.readString();
                                struct.values.add(_elem257);
                            }
                            iprot.readListEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = StringUtils.intern(iprot.readString());
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.tableName = StringUtils.intern(iprot.readString());
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.createTime = iprot.readI32();
                            struct.setCreateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.lastAccessTime = iprot.readI32();
                            struct.setLastAccessTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.sd = new StorageDescriptor();
                            struct.sd.read(iprot);
                            struct.setSdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 13) {
                            TMap _map259 = iprot.readMapBegin();
                            struct.parameters = new HashMap(2 * _map259.size);
                            for (int _i262 = 0; _i262 < _map259.size; ++_i262) {
                                String _key260 = iprot.readString();
                                String _val261 = iprot.readString();
                                struct.parameters.put(_key260, _val261);
                            }
                            iprot.readMapEnd();
                            struct.parameters = StringUtils.intern(struct.parameters);
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.privileges = new PrincipalPrivilegeSet();
                            struct.privileges.read(iprot);
                            struct.setPrivilegesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.catName = StringUtils.intern(iprot.readString());
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.writeId = iprot.readI64();
                            struct.setWriteIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.isStatsCompliant = iprot.readBool();
                            struct.setIsStatsCompliantIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 12) {
                            struct.colStats = new ColumnStatistics();
                            struct.colStats.read(iprot);
                            struct.setColStatsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, Partition struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.values.size()));
                for (String string : struct.values) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
            oprot.writeI32(struct.createTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
            oprot.writeI32(struct.lastAccessTime);
            oprot.writeFieldEnd();
            if (struct.sd != null) {
                oprot.writeFieldBegin(SD_FIELD_DESC);
                struct.sd.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.privileges != null && struct.isSetPrivileges()) {
                oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
                struct.privileges.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetWriteId()) {
                oprot.writeFieldBegin(WRITE_ID_FIELD_DESC);
                oprot.writeI64(struct.writeId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeFieldBegin(IS_STATS_COMPLIANT_FIELD_DESC);
                oprot.writeBool(struct.isStatsCompliant);
                oprot.writeFieldEnd();
            }
            if (struct.colStats != null && struct.isSetColStats()) {
                oprot.writeFieldBegin(COL_STATS_FIELD_DESC);
                struct.colStats.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PartitionStandardSchemeFactory
    implements SchemeFactory {
        private PartitionStandardSchemeFactory() {
        }

        public PartitionStandardScheme getScheme() {
            return new PartitionStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        DB_NAME(2, "dbName"),
        TABLE_NAME(3, "tableName"),
        CREATE_TIME(4, "createTime"),
        LAST_ACCESS_TIME(5, "lastAccessTime"),
        SD(6, "sd"),
        PARAMETERS(7, "parameters"),
        PRIVILEGES(8, "privileges"),
        CAT_NAME(9, "catName"),
        WRITE_ID(10, "writeId"),
        IS_STATS_COMPLIANT(11, "isStatsCompliant"),
        COL_STATS(12, "colStats");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return TABLE_NAME;
                }
                case 4: {
                    return CREATE_TIME;
                }
                case 5: {
                    return LAST_ACCESS_TIME;
                }
                case 6: {
                    return SD;
                }
                case 7: {
                    return PARAMETERS;
                }
                case 8: {
                    return PRIVILEGES;
                }
                case 9: {
                    return CAT_NAME;
                }
                case 10: {
                    return WRITE_ID;
                }
                case 11: {
                    return IS_STATS_COMPLIANT;
                }
                case 12: {
                    return COL_STATS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

