/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.SerdeType;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SerDeInfo
implements TBase<SerDeInfo, _Fields>,
Serializable,
Cloneable,
Comparable<SerDeInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("SerDeInfo");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField SERIALIZATION_LIB_FIELD_DESC = new TField("serializationLib", 11, 2);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 3);
    private static final TField DESCRIPTION_FIELD_DESC = new TField("description", 11, 4);
    private static final TField SERIALIZER_CLASS_FIELD_DESC = new TField("serializerClass", 11, 5);
    private static final TField DESERIALIZER_CLASS_FIELD_DESC = new TField("deserializerClass", 11, 6);
    private static final TField SERDE_TYPE_FIELD_DESC = new TField("serdeType", 8, 7);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new SerDeInfoStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new SerDeInfoTupleSchemeFactory();
    @Nullable
    private String name;
    @Nullable
    private String serializationLib;
    @Nullable
    private Map<String, String> parameters;
    @Nullable
    private String description;
    @Nullable
    private String serializerClass;
    @Nullable
    private String deserializerClass;
    @Nullable
    private SerdeType serdeType;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DESCRIPTION, _Fields.SERIALIZER_CLASS, _Fields.DESERIALIZER_CLASS, _Fields.SERDE_TYPE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SerDeInfo() {
    }

    public SerDeInfo(String name, String serializationLib, Map<String, String> parameters) {
        this();
        this.name = StringUtils.intern(name);
        this.serializationLib = StringUtils.intern(serializationLib);
        this.parameters = StringUtils.intern(parameters);
    }

    public SerDeInfo(SerDeInfo other) {
        if (other.isSetName()) {
            this.name = StringUtils.intern(other.name);
        }
        if (other.isSetSerializationLib()) {
            this.serializationLib = StringUtils.intern(other.serializationLib);
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>(other.parameters);
            this.parameters = __this__parameters;
        }
        if (other.isSetDescription()) {
            this.description = other.description;
        }
        if (other.isSetSerializerClass()) {
            this.serializerClass = StringUtils.intern(other.serializerClass);
        }
        if (other.isSetDeserializerClass()) {
            this.deserializerClass = StringUtils.intern(other.deserializerClass);
        }
        if (other.isSetSerdeType()) {
            this.serdeType = other.serdeType;
        }
    }

    @Override
    public SerDeInfo deepCopy() {
        return new SerDeInfo(this);
    }

    @Override
    public void clear() {
        this.name = null;
        this.serializationLib = null;
        this.parameters = null;
        this.description = null;
        this.serializerClass = null;
        this.deserializerClass = null;
        this.serdeType = null;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = StringUtils.intern(name);
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    @Nullable
    public String getSerializationLib() {
        return this.serializationLib;
    }

    public void setSerializationLib(@Nullable String serializationLib) {
        this.serializationLib = StringUtils.intern(serializationLib);
    }

    public void unsetSerializationLib() {
        this.serializationLib = null;
    }

    public boolean isSetSerializationLib() {
        return this.serializationLib != null;
    }

    public void setSerializationLibIsSet(boolean value) {
        if (!value) {
            this.serializationLib = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(StringUtils.intern(key), StringUtils.intern(val));
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = StringUtils.intern(parameters);
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void unsetDescription() {
        this.description = null;
    }

    public boolean isSetDescription() {
        return this.description != null;
    }

    public void setDescriptionIsSet(boolean value) {
        if (!value) {
            this.description = null;
        }
    }

    @Nullable
    public String getSerializerClass() {
        return this.serializerClass;
    }

    public void setSerializerClass(@Nullable String serializerClass) {
        this.serializerClass = StringUtils.intern(serializerClass);
    }

    public void unsetSerializerClass() {
        this.serializerClass = null;
    }

    public boolean isSetSerializerClass() {
        return this.serializerClass != null;
    }

    public void setSerializerClassIsSet(boolean value) {
        if (!value) {
            this.serializerClass = null;
        }
    }

    @Nullable
    public String getDeserializerClass() {
        return this.deserializerClass;
    }

    public void setDeserializerClass(@Nullable String deserializerClass) {
        this.deserializerClass = StringUtils.intern(deserializerClass);
    }

    public void unsetDeserializerClass() {
        this.deserializerClass = null;
    }

    public boolean isSetDeserializerClass() {
        return this.deserializerClass != null;
    }

    public void setDeserializerClassIsSet(boolean value) {
        if (!value) {
            this.deserializerClass = null;
        }
    }

    @Nullable
    public SerdeType getSerdeType() {
        return this.serdeType;
    }

    public void setSerdeType(@Nullable SerdeType serdeType) {
        this.serdeType = serdeType;
    }

    public void unsetSerdeType() {
        this.serdeType = null;
    }

    public boolean isSetSerdeType() {
        return this.serdeType != null;
    }

    public void setSerdeTypeIsSet(boolean value) {
        if (!value) {
            this.serdeType = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case SERIALIZATION_LIB: {
                if (value == null) {
                    this.unsetSerializationLib();
                    break;
                }
                this.setSerializationLib((String)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case DESCRIPTION: {
                if (value == null) {
                    this.unsetDescription();
                    break;
                }
                this.setDescription((String)value);
                break;
            }
            case SERIALIZER_CLASS: {
                if (value == null) {
                    this.unsetSerializerClass();
                    break;
                }
                this.setSerializerClass((String)value);
                break;
            }
            case DESERIALIZER_CLASS: {
                if (value == null) {
                    this.unsetDeserializerClass();
                    break;
                }
                this.setDeserializerClass((String)value);
                break;
            }
            case SERDE_TYPE: {
                if (value == null) {
                    this.unsetSerdeType();
                    break;
                }
                this.setSerdeType((SerdeType)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case SERIALIZATION_LIB: {
                return this.getSerializationLib();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
            case SERIALIZER_CLASS: {
                return this.getSerializerClass();
            }
            case DESERIALIZER_CLASS: {
                return this.getDeserializerClass();
            }
            case SERDE_TYPE: {
                return this.getSerdeType();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case SERIALIZATION_LIB: {
                return this.isSetSerializationLib();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
            case DESCRIPTION: {
                return this.isSetDescription();
            }
            case SERIALIZER_CLASS: {
                return this.isSetSerializerClass();
            }
            case DESERIALIZER_CLASS: {
                return this.isSetDeserializerClass();
            }
            case SERDE_TYPE: {
                return this.isSetSerdeType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof SerDeInfo) {
            return this.equals((SerDeInfo)that);
        }
        return false;
    }

    public boolean equals(SerDeInfo that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_serializationLib = this.isSetSerializationLib();
        boolean that_present_serializationLib = that.isSetSerializationLib();
        if (this_present_serializationLib || that_present_serializationLib) {
            if (!this_present_serializationLib || !that_present_serializationLib) {
                return false;
            }
            if (!this.serializationLib.equals(that.serializationLib)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!this.parameters.equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_description = this.isSetDescription();
        boolean that_present_description = that.isSetDescription();
        if (this_present_description || that_present_description) {
            if (!this_present_description || !that_present_description) {
                return false;
            }
            if (!this.description.equals(that.description)) {
                return false;
            }
        }
        boolean this_present_serializerClass = this.isSetSerializerClass();
        boolean that_present_serializerClass = that.isSetSerializerClass();
        if (this_present_serializerClass || that_present_serializerClass) {
            if (!this_present_serializerClass || !that_present_serializerClass) {
                return false;
            }
            if (!this.serializerClass.equals(that.serializerClass)) {
                return false;
            }
        }
        boolean this_present_deserializerClass = this.isSetDeserializerClass();
        boolean that_present_deserializerClass = that.isSetDeserializerClass();
        if (this_present_deserializerClass || that_present_deserializerClass) {
            if (!this_present_deserializerClass || !that_present_deserializerClass) {
                return false;
            }
            if (!this.deserializerClass.equals(that.deserializerClass)) {
                return false;
            }
        }
        boolean this_present_serdeType = this.isSetSerdeType();
        boolean that_present_serdeType = that.isSetSerdeType();
        if (this_present_serdeType || that_present_serdeType) {
            if (!this_present_serdeType || !that_present_serdeType) {
                return false;
            }
            if (!this.serdeType.equals(that.serdeType)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetName() ? 131071 : 524287);
        if (this.isSetName()) {
            hashCode = hashCode * 8191 + this.name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSerializationLib() ? 131071 : 524287);
        if (this.isSetSerializationLib()) {
            hashCode = hashCode * 8191 + this.serializationLib.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParameters() ? 131071 : 524287);
        if (this.isSetParameters()) {
            hashCode = hashCode * 8191 + this.parameters.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDescription() ? 131071 : 524287);
        if (this.isSetDescription()) {
            hashCode = hashCode * 8191 + this.description.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSerializerClass() ? 131071 : 524287);
        if (this.isSetSerializerClass()) {
            hashCode = hashCode * 8191 + this.serializerClass.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDeserializerClass() ? 131071 : 524287);
        if (this.isSetDeserializerClass()) {
            hashCode = hashCode * 8191 + this.deserializerClass.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSerdeType() ? 131071 : 524287);
        if (this.isSetSerdeType()) {
            hashCode = hashCode * 8191 + this.serdeType.getValue();
        }
        return hashCode;
    }

    @Override
    public int compareTo(SerDeInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetName(), other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo(this.name, other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSerializationLib(), other.isSetSerializationLib());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSerializationLib() && (lastComparison = TBaseHelper.compareTo(this.serializationLib, other.serializationLib)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParameters(), other.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, other.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDescription(), other.isSetDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDescription() && (lastComparison = TBaseHelper.compareTo(this.description, other.description)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSerializerClass(), other.isSetSerializerClass());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSerializerClass() && (lastComparison = TBaseHelper.compareTo(this.serializerClass, other.serializerClass)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDeserializerClass(), other.isSetDeserializerClass());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDeserializerClass() && (lastComparison = TBaseHelper.compareTo(this.deserializerClass, other.deserializerClass)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSerdeType(), other.isSetSerdeType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSerdeType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.serdeType), (Comparable)((Object)other.serdeType))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        SerDeInfo.scheme(iprot).read(iprot, (SerDeInfo)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        SerDeInfo.scheme(oprot).write(oprot, (SerDeInfo)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerDeInfo(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("serializationLib:");
        if (this.serializationLib == null) {
            sb.append("null");
        } else {
            sb.append(this.serializationLib);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        if (this.isSetDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("description:");
            if (this.description == null) {
                sb.append("null");
            } else {
                sb.append(this.description);
            }
            first = false;
        }
        if (this.isSetSerializerClass()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("serializerClass:");
            if (this.serializerClass == null) {
                sb.append("null");
            } else {
                sb.append(this.serializerClass);
            }
            first = false;
        }
        if (this.isSetDeserializerClass()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("deserializerClass:");
            if (this.deserializerClass == null) {
                sb.append("null");
            } else {
                sb.append(this.deserializerClass);
            }
            first = false;
        }
        if (this.isSetSerdeType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("serdeType:");
            if (this.serdeType == null) {
                sb.append("null");
            } else {
                sb.append(this.serdeType);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SERIALIZATION_LIB, new FieldMetaData("serializationLib", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.DESCRIPTION, new FieldMetaData("description", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SERIALIZER_CLASS, new FieldMetaData("serializerClass", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DESERIALIZER_CLASS, new FieldMetaData("deserializerClass", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SERDE_TYPE, new FieldMetaData("serdeType", 2, new EnumMetaData(16, SerdeType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SerDeInfo.class, metaDataMap);
    }

    private static class SerDeInfoTupleScheme
    extends TupleScheme<SerDeInfo> {
        private SerDeInfoTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, SerDeInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetName()) {
                optionals.set(0);
            }
            if (struct.isSetSerializationLib()) {
                optionals.set(1);
            }
            if (struct.isSetParameters()) {
                optionals.set(2);
            }
            if (struct.isSetDescription()) {
                optionals.set(3);
            }
            if (struct.isSetSerializerClass()) {
                optionals.set(4);
            }
            if (struct.isSetDeserializerClass()) {
                optionals.set(5);
            }
            if (struct.isSetSerdeType()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetName()) {
                oprot.writeString(struct.name);
            }
            if (struct.isSetSerializationLib()) {
                oprot.writeString(struct.serializationLib);
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry _iter125 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter125.getKey());
                    oprot.writeString((String)_iter125.getValue());
                }
            }
            if (struct.isSetDescription()) {
                oprot.writeString(struct.description);
            }
            if (struct.isSetSerializerClass()) {
                oprot.writeString(struct.serializerClass);
            }
            if (struct.isSetDeserializerClass()) {
                oprot.writeString(struct.deserializerClass);
            }
            if (struct.isSetSerdeType()) {
                oprot.writeI32(struct.serdeType.getValue());
            }
        }

        @Override
        public void read(TProtocol prot, SerDeInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.name = StringUtils.intern(iprot.readString());
                struct.setNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.serializationLib = StringUtils.intern(iprot.readString());
                struct.setSerializationLibIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map126 = iprot.readMapBegin((byte)11, (byte)11);
                struct.parameters = new HashMap(2 * _map126.size);
                for (int _i129 = 0; _i129 < _map126.size; ++_i129) {
                    String _key127 = iprot.readString();
                    String _val128 = iprot.readString();
                    struct.parameters.put(_key127, _val128);
                }
                struct.parameters = StringUtils.intern(struct.parameters);
                struct.setParametersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.description = iprot.readString();
                struct.setDescriptionIsSet(true);
            }
            if (incoming.get(4)) {
                struct.serializerClass = StringUtils.intern(iprot.readString());
                struct.setSerializerClassIsSet(true);
            }
            if (incoming.get(5)) {
                struct.deserializerClass = StringUtils.intern(iprot.readString());
                struct.setDeserializerClassIsSet(true);
            }
            if (incoming.get(6)) {
                struct.serdeType = SerdeType.findByValue(iprot.readI32());
                struct.setSerdeTypeIsSet(true);
            }
        }
    }

    private static class SerDeInfoTupleSchemeFactory
    implements SchemeFactory {
        private SerDeInfoTupleSchemeFactory() {
        }

        public SerDeInfoTupleScheme getScheme() {
            return new SerDeInfoTupleScheme();
        }
    }

    private static class SerDeInfoStandardScheme
    extends StandardScheme<SerDeInfo> {
        private SerDeInfoStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, SerDeInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.name = StringUtils.intern(iprot.readString());
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.serializationLib = StringUtils.intern(iprot.readString());
                            struct.setSerializationLibIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map120 = iprot.readMapBegin();
                            struct.parameters = new HashMap(2 * _map120.size);
                            for (int _i123 = 0; _i123 < _map120.size; ++_i123) {
                                String _key121 = iprot.readString();
                                String _val122 = iprot.readString();
                                struct.parameters.put(_key121, _val122);
                            }
                            iprot.readMapEnd();
                            struct.parameters = StringUtils.intern(struct.parameters);
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.description = iprot.readString();
                            struct.setDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.serializerClass = StringUtils.intern(iprot.readString());
                            struct.setSerializerClassIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.deserializerClass = StringUtils.intern(iprot.readString());
                            struct.setDeserializerClassIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.serdeType = SerdeType.findByValue(iprot.readI32());
                            struct.setSerdeTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, SerDeInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.serializationLib != null) {
                oprot.writeFieldBegin(SERIALIZATION_LIB_FIELD_DESC);
                oprot.writeString(struct.serializationLib);
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry _iter124 : struct.parameters.entrySet()) {
                    oprot.writeString((String)_iter124.getKey());
                    oprot.writeString((String)_iter124.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.description != null && struct.isSetDescription()) {
                oprot.writeFieldBegin(DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.description);
                oprot.writeFieldEnd();
            }
            if (struct.serializerClass != null && struct.isSetSerializerClass()) {
                oprot.writeFieldBegin(SERIALIZER_CLASS_FIELD_DESC);
                oprot.writeString(struct.serializerClass);
                oprot.writeFieldEnd();
            }
            if (struct.deserializerClass != null && struct.isSetDeserializerClass()) {
                oprot.writeFieldBegin(DESERIALIZER_CLASS_FIELD_DESC);
                oprot.writeString(struct.deserializerClass);
                oprot.writeFieldEnd();
            }
            if (struct.serdeType != null && struct.isSetSerdeType()) {
                oprot.writeFieldBegin(SERDE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.serdeType.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SerDeInfoStandardSchemeFactory
    implements SchemeFactory {
        private SerDeInfoStandardSchemeFactory() {
        }

        public SerDeInfoStandardScheme getScheme() {
            return new SerDeInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        SERIALIZATION_LIB(2, "serializationLib"),
        PARAMETERS(3, "parameters"),
        DESCRIPTION(4, "description"),
        SERIALIZER_CLASS(5, "serializerClass"),
        DESERIALIZER_CLASS(6, "deserializerClass"),
        SERDE_TYPE(7, "serdeType");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return SERIALIZATION_LIB;
                }
                case 3: {
                    return PARAMETERS;
                }
                case 4: {
                    return DESCRIPTION;
                }
                case 5: {
                    return SERIALIZER_CLASS;
                }
                case 6: {
                    return DESERIALIZER_CLASS;
                }
                case 7: {
                    return SERDE_TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

