/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.BinaryColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.BooleanColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DateColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DoubleColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.LongColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.StringColumnStatsMerger;

public class ColumnStatsMergerFactory {
    private ColumnStatsMergerFactory() {
    }

    public static ColumnStatsMerger getColumnStatsMerger(ColumnStatisticsObj statsObjNew, ColumnStatisticsObj statsObjOld) {
        ColumnStatsMerger agg;
        ColumnStatisticsData._Fields typeOld;
        ColumnStatisticsData._Fields typeNew = (ColumnStatisticsData._Fields)statsObjNew.getStatsData().getSetField();
        typeNew = typeNew == (typeOld = (ColumnStatisticsData._Fields)statsObjOld.getStatsData().getSetField()) ? typeNew : null;
        switch (typeNew) {
            case BOOLEAN_STATS: {
                agg = new BooleanColumnStatsMerger();
                break;
            }
            case LONG_STATS: {
                agg = new LongColumnStatsMerger();
                break;
            }
            case DOUBLE_STATS: {
                agg = new DoubleColumnStatsMerger();
                break;
            }
            case STRING_STATS: {
                agg = new StringColumnStatsMerger();
                break;
            }
            case BINARY_STATS: {
                agg = new BinaryColumnStatsMerger();
                break;
            }
            case DECIMAL_STATS: {
                agg = new DecimalColumnStatsMerger();
                break;
            }
            case DATE_STATS: {
                agg = new DateColumnStatsMerger();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stats type " + statsObjNew.getStatsData().getSetField());
            }
        }
        return agg;
    }

    public static ColumnStatisticsObj newColumnStaticsObj(String colName, String colType, ColumnStatisticsData._Fields type) {
        ColumnStatisticsObj cso = new ColumnStatisticsObj();
        ColumnStatisticsData csd = new ColumnStatisticsData();
        cso.setColName(colName);
        cso.setColType(colType);
        switch (type) {
            case BOOLEAN_STATS: {
                csd.setBooleanStats(new BooleanColumnStatsData());
                break;
            }
            case LONG_STATS: {
                csd.setLongStats(new LongColumnStatsDataInspector());
                break;
            }
            case DOUBLE_STATS: {
                csd.setDoubleStats(new DoubleColumnStatsDataInspector());
                break;
            }
            case STRING_STATS: {
                csd.setStringStats(new StringColumnStatsDataInspector());
                break;
            }
            case BINARY_STATS: {
                csd.setBinaryStats(new BinaryColumnStatsData());
                break;
            }
            case DECIMAL_STATS: {
                csd.setDecimalStats(new DecimalColumnStatsDataInspector());
                break;
            }
            case DATE_STATS: {
                csd.setDateStats(new DateColumnStatsDataInspector());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stats type");
            }
        }
        cso.setStatsData(csd);
        return cso;
    }
}

