/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.parser;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.DFA;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;

public class FilterLexer
extends Lexer {
    public static final int EOF = -1;
    public static final int BETWEEN = 4;
    public static final int COMMA = 5;
    public static final int DateString = 6;
    public static final int DateTimeLiteral = 7;
    public static final int Digit = 8;
    public static final int EQUAL = 9;
    public static final int GREATERTHAN = 10;
    public static final int GREATERTHANOREQUALTO = 11;
    public static final int IN = 12;
    public static final int Identifier = 13;
    public static final int IntegralLiteral = 14;
    public static final int KW_AND = 15;
    public static final int KW_CONST = 16;
    public static final int KW_DATE = 17;
    public static final int KW_LIKE = 18;
    public static final int KW_NOT = 19;
    public static final int KW_OR = 20;
    public static final int KW_STRUCT = 21;
    public static final int KW_TIMESTAMP = 22;
    public static final int LESSTHAN = 23;
    public static final int LESSTHANOREQUALTO = 24;
    public static final int LPAREN = 25;
    public static final int Letter = 26;
    public static final int NOTEQUAL = 27;
    public static final int RPAREN = 28;
    public static final int StringLiteral = 29;
    public static final int TimestampString = 30;
    public static final int WS = 31;
    public String errorMsg;
    private static final Pattern datePattern = Pattern.compile(".*(\\d\\d\\d\\d-\\d\\d-\\d\\d).*");
    private static final Pattern timestampPattern = Pattern.compile(".*(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d).*");
    private static final DateTimeFormatter dateFormat = FilterLexer.createDateTimeFormatter("uuuu-MM-dd");
    private static final DateTimeFormatter timestampFormat = FilterLexer.createDateTimeFormatter("uuuu-MM-dd HH:mm:ss");
    protected DFA12 dfa12 = new DFA12((BaseRecognizer)this);
    static final String DFA12_eotS = "\u0001\uffff\n\u0017\u0004\uffff\u0001$\u0001\uffff\u0001&\u0002\u0017\u0001\u0016\u0004\uffff\u0002\u0017\u0001,\u0007\u0017\u0004\uffff\u0001\u0017\u00015\u0001\u0016\u00017\u00018\u0001\uffff\b\u0017\u0001\uffff\u0001\u0016\u0002\uffff\u0001B\u0002C\u0005\u0017\u0001\u0016\u0003\uffff\u0002\u0017\u0001M\u0002\u0017\u0001\u0016\u0002\u0017\u0001\uffff\u0001R\u0003\u0017\u0001\uffff\u0001V\u0002\u0017\u0001\uffff\u0002Y\u0001\uffff";
    static final String DFA12_eofS = "Z\uffff";
    static final String DFA12_minS = "\u0001\t\u0001O\u0001N\u0001R\u0001I\u0001A\u0001a\u0001I\u0001i\u0001O\u0001T\u0004\uffff\u0001=\u0001\uffff\u0001=\u0001E\u0001N\u00010\u0004\uffff\u0001T\u0001D\u00010\u0001K\u0001T\u0001t\u0001M\u0001m\u0001N\u0001R\u0004\uffff\u0001T\u00040\u0001\uffff\u0002E\u0001e\u0001E\u0001e\u0001S\u0001U\u0001W\u0001\uffff\u00010\u0002\uffff\u00010\u0002'\u0001S\u0001s\u0001T\u0001C\u0001E\u0001-\u0003\uffff\u0001T\u0001t\u00010\u0001T\u0001E\u00010\u0001A\u0001a\u0001\uffff\u00010\u0001N\u0001M\u0001m\u0001\uffff\u00010\u0001P\u0001p\u0001\uffff\u0002'\u0001\uffff";
    static final String DFA12_maxS = "\u0001z\u0001O\u0001N\u0001R\u0001I\u0001A\u0001a\u0001I\u0001i\u0001O\u0001T\u0004\uffff\u0001>\u0001\uffff\u0001=\u0001E\u0001N\u0001z\u0004\uffff\u0001T\u0001D\u0001z\u0001K\u0001T\u0001t\u0001M\u0001m\u0001N\u0001R\u0004\uffff\u0001T\u0004z\u0001\uffff\u0002E\u0001e\u0001E\u0001e\u0001S\u0001U\u0001W\u0001\uffff\u0001z\u0002\uffff\u0003z\u0001S\u0001s\u0001T\u0001C\u0001E\u0001z\u0003\uffff\u0001T\u0001t\u0001z\u0001T\u0001E\u0001z\u0001A\u0001a\u0001\uffff\u0001z\u0001N\u0001M\u0001m\u0001\uffff\u0001z\u0001P\u0001p\u0001\uffff\u0002z\u0001\uffff";
    static final String DFA12_acceptS = "\u000b\uffff\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\uffff\u0001\r\u0004\uffff\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\n\uffff\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0005\uffff\u0001\u0003\b\uffff\u0001\u0013\u0001\uffff\u0001\u0001\u0001\u0002\t\uffff\u0001\u0004\u0001\u0005\u0001\u0014\b\uffff\u0001\u0007\u0004\uffff\u0001\b\u0003\uffff\u0001\u0012\u0002\uffff\u0001\u0006";
    static final String DFA12_specialS = "Z\uffff}>";
    static final String[] DFA12_transitionS = new String[]{"\u0002\u0018\u0002\uffff\u0001\u0018\u0012\uffff\u0001\u0018\u0001\u0010\u0001\u0015\u0004\uffff\u0001\u0015\u0001\u000b\u0001\f\u0002\uffff\u0001\r\u0001\u0016\u0002\uffff\n\u0014\u0002\uffff\u0001\u000f\u0001\u000e\u0001\u0011\u0002\uffff\u0001\u0002\u0001\u0012\u0001\t\u0001\u0005\u0004\u0017\u0001\u0013\u0002\u0017\u0001\u0004\u0001\u0017\u0001\u0001\u0001\u0003\u0003\u0017\u0001\n\u0001\u0007\u0006\u0017\u0006\uffff\u0003\u0017\u0001\u0006\u000f\u0017\u0001\b\u0006\u0017", "\u0001\u0019", "\u0001\u001a", "\u0001\u001b", "\u0001\u001c", "\u0001\u001d", "\u0001\u001e", "\u0001\u001f", "\u0001 ", "\u0001!", "\u0001\"", "", "", "", "", "\u0001#\u0001\u0010", "", "\u0001%", "\u0001'", "\u0001(", "\n)\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "", "", "", "", "\u0001*", "\u0001+", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001-", "\u0001.", "\u0001/", "\u00010", "\u00011", "\u00012", "\u00013", "", "", "", "", "\u00014", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\n6\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "", "\u00019", "\u0001:", "\u0001;", "\u0001<", "\u0001=", "\u0001>", "\u0001?", "\u0001@", "", "\nA\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "", "", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001D\b\uffff\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001D\b\uffff\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001E", "\u0001F", "\u0001G", "\u0001H", "\u0001I", "\u0001D\u0002\uffff\nJ\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "", "", "", "\u0001K", "\u0001L", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001N", "\u0001O", "\nJ\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001P", "\u0001Q", "", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001S", "\u0001T", "\u0001U", "", "\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001W", "\u0001X", "", "\u0001D\b\uffff\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", "\u0001D\b\uffff\n\u0017\u0007\uffff\u001a\u0017\u0004\uffff\u0001\u0017\u0001\uffff\u001a\u0017", ""};
    static final short[] DFA12_eot = DFA.unpackEncodedString((String)"\u0001\uffff\n\u0017\u0004\uffff\u0001$\u0001\uffff\u0001&\u0002\u0017\u0001\u0016\u0004\uffff\u0002\u0017\u0001,\u0007\u0017\u0004\uffff\u0001\u0017\u00015\u0001\u0016\u00017\u00018\u0001\uffff\b\u0017\u0001\uffff\u0001\u0016\u0002\uffff\u0001B\u0002C\u0005\u0017\u0001\u0016\u0003\uffff\u0002\u0017\u0001M\u0002\u0017\u0001\u0016\u0002\u0017\u0001\uffff\u0001R\u0003\u0017\u0001\uffff\u0001V\u0002\u0017\u0001\uffff\u0002Y\u0001\uffff");
    static final short[] DFA12_eof = DFA.unpackEncodedString((String)"Z\uffff");
    static final char[] DFA12_min = DFA.unpackEncodedStringToUnsignedChars((String)"\u0001\t\u0001O\u0001N\u0001R\u0001I\u0001A\u0001a\u0001I\u0001i\u0001O\u0001T\u0004\uffff\u0001=\u0001\uffff\u0001=\u0001E\u0001N\u00010\u0004\uffff\u0001T\u0001D\u00010\u0001K\u0001T\u0001t\u0001M\u0001m\u0001N\u0001R\u0004\uffff\u0001T\u00040\u0001\uffff\u0002E\u0001e\u0001E\u0001e\u0001S\u0001U\u0001W\u0001\uffff\u00010\u0002\uffff\u00010\u0002'\u0001S\u0001s\u0001T\u0001C\u0001E\u0001-\u0003\uffff\u0001T\u0001t\u00010\u0001T\u0001E\u00010\u0001A\u0001a\u0001\uffff\u00010\u0001N\u0001M\u0001m\u0001\uffff\u00010\u0001P\u0001p\u0001\uffff\u0002'\u0001\uffff");
    static final char[] DFA12_max = DFA.unpackEncodedStringToUnsignedChars((String)"\u0001z\u0001O\u0001N\u0001R\u0001I\u0001A\u0001a\u0001I\u0001i\u0001O\u0001T\u0004\uffff\u0001>\u0001\uffff\u0001=\u0001E\u0001N\u0001z\u0004\uffff\u0001T\u0001D\u0001z\u0001K\u0001T\u0001t\u0001M\u0001m\u0001N\u0001R\u0004\uffff\u0001T\u0004z\u0001\uffff\u0002E\u0001e\u0001E\u0001e\u0001S\u0001U\u0001W\u0001\uffff\u0001z\u0002\uffff\u0003z\u0001S\u0001s\u0001T\u0001C\u0001E\u0001z\u0003\uffff\u0001T\u0001t\u0001z\u0001T\u0001E\u0001z\u0001A\u0001a\u0001\uffff\u0001z\u0001N\u0001M\u0001m\u0001\uffff\u0001z\u0001P\u0001p\u0001\uffff\u0002z\u0001\uffff");
    static final short[] DFA12_accept = DFA.unpackEncodedString((String)"\u000b\uffff\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\uffff\u0001\r\u0004\uffff\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\n\uffff\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0005\uffff\u0001\u0003\b\uffff\u0001\u0013\u0001\uffff\u0001\u0001\u0001\u0002\t\uffff\u0001\u0004\u0001\u0005\u0001\u0014\b\uffff\u0001\u0007\u0004\uffff\u0001\b\u0003\uffff\u0001\u0012\u0002\uffff\u0001\u0006");
    static final short[] DFA12_special = DFA.unpackEncodedString((String)"Z\uffff}>");
    static final short[][] DFA12_transition;

    public static DateTimeFormatter createDateTimeFormatter(String format) {
        return DateTimeFormatter.ofPattern(format).withZone(TimeZone.getTimeZone("UTC").toZoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    public static Object extractDate(String input) {
        Timestamp res = FilterLexer.extractTimestamp(input);
        if (res != null) {
            return res;
        }
        Matcher m = datePattern.matcher(input);
        if (!m.matches()) {
            return null;
        }
        try {
            LocalDate val = LocalDate.parse(m.group(1), dateFormat);
            return Date.valueOf(val);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Timestamp extractTimestamp(String input) {
        Matcher m = timestampPattern.matcher(input);
        if (!m.matches()) {
            return null;
        }
        try {
            LocalDateTime val = LocalDateTime.from(timestampFormat.parse(m.group(1)));
            return Timestamp.valueOf(val);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void emitErrorMessage(String msg) {
        this.errorMsg = msg;
    }

    public Lexer[] getDelegates() {
        return new Lexer[0];
    }

    public FilterLexer() {
    }

    public FilterLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }

    public FilterLexer(CharStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public String getGrammarFileName() {
        return "org/apache/hadoop/hive/metastore/parser/Filter.g";
    }

    public final void mKW_NOT() throws RecognitionException {
        int _type = 19;
        int _channel = 0;
        this.match("NOT");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_AND() throws RecognitionException {
        int _type = 15;
        int _channel = 0;
        this.match("AND");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_OR() throws RecognitionException {
        int _type = 20;
        int _channel = 0;
        this.match("OR");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_LIKE() throws RecognitionException {
        int _type = 18;
        int _channel = 0;
        this.match("LIKE");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_DATE() throws RecognitionException {
        int _type = 17;
        int _channel = 0;
        int alt1 = 2;
        int LA1_0 = this.input.LA(1);
        if (LA1_0 == 68) {
            alt1 = 1;
        } else if (LA1_0 == 100) {
            alt1 = 2;
        } else {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            NoViableAltException nvae = new NoViableAltException("", 1, 0, (IntStream)this.input);
            throw nvae;
        }
        switch (alt1) {
            case 1: {
                this.match("DATE");
                if (!this.state.failed) break;
                return;
            }
            case 2: {
                this.match("date");
                if (!this.state.failed) break;
                return;
            }
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_TIMESTAMP() throws RecognitionException {
        int _type = 22;
        int _channel = 0;
        int alt2 = 2;
        int LA2_0 = this.input.LA(1);
        if (LA2_0 == 84) {
            alt2 = 1;
        } else if (LA2_0 == 116) {
            alt2 = 2;
        } else {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            NoViableAltException nvae = new NoViableAltException("", 2, 0, (IntStream)this.input);
            throw nvae;
        }
        switch (alt2) {
            case 1: {
                this.match("TIMESTAMP");
                if (!this.state.failed) break;
                return;
            }
            case 2: {
                this.match("timestamp");
                if (!this.state.failed) break;
                return;
            }
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_CONST() throws RecognitionException {
        int _type = 16;
        int _channel = 0;
        this.match("CONST");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mKW_STRUCT() throws RecognitionException {
        int _type = 21;
        int _channel = 0;
        this.match("STRUCT");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mLPAREN() throws RecognitionException {
        int _type = 25;
        int _channel = 0;
        this.match(40);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mRPAREN() throws RecognitionException {
        int _type = 28;
        int _channel = 0;
        this.match(41);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mCOMMA() throws RecognitionException {
        int _type = 5;
        int _channel = 0;
        this.match(44);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mEQUAL() throws RecognitionException {
        int _type = 9;
        int _channel = 0;
        this.match(61);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mNOTEQUAL() throws RecognitionException {
        int _type = 27;
        int _channel = 0;
        int alt3 = 2;
        int LA3_0 = this.input.LA(1);
        if (LA3_0 == 60) {
            alt3 = 1;
        } else if (LA3_0 == 33) {
            alt3 = 2;
        } else {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            NoViableAltException nvae = new NoViableAltException("", 3, 0, (IntStream)this.input);
            throw nvae;
        }
        switch (alt3) {
            case 1: {
                this.match("<>");
                if (!this.state.failed) break;
                return;
            }
            case 2: {
                this.match("!=");
                if (!this.state.failed) break;
                return;
            }
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mLESSTHANOREQUALTO() throws RecognitionException {
        int _type = 24;
        int _channel = 0;
        this.match("<=");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mLESSTHAN() throws RecognitionException {
        int _type = 23;
        int _channel = 0;
        this.match(60);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mGREATERTHANOREQUALTO() throws RecognitionException {
        int _type = 11;
        int _channel = 0;
        this.match(">=");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mGREATERTHAN() throws RecognitionException {
        int _type = 10;
        int _channel = 0;
        this.match(62);
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mBETWEEN() throws RecognitionException {
        int _type = 4;
        int _channel = 0;
        this.match("BETWEEN");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mIN() throws RecognitionException {
        int _type = 12;
        int _channel = 0;
        this.match("IN");
        if (this.state.failed) {
            return;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mLetter() throws RecognitionException {
        if (!(this.input.LA(1) >= 65 && this.input.LA(1) <= 90 || this.input.LA(1) >= 97 && this.input.LA(1) <= 122)) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public final void mDigit() throws RecognitionException {
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public final void mDateString() throws RecognitionException {
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(45);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(45);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public final void mTimestampString() throws RecognitionException {
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(45);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(45);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(32);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(58);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        this.match(58);
        if (this.state.failed) {
            return;
        }
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        if (this.input.LA(1) < 48 || this.input.LA(1) > 57) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public final void mDateTimeLiteral() throws RecognitionException {
        int _type = 7;
        int _channel = 0;
        int alt4 = 4;
        switch (this.input.LA(1)) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int LA4_1 = this.input.LA(2);
                if (LA4_1 >= 48 && LA4_1 <= 57) {
                    int LA4_4 = this.input.LA(3);
                    if (LA4_4 >= 48 && LA4_4 <= 57) {
                        int LA4_5 = this.input.LA(4);
                        if (LA4_5 >= 48 && LA4_5 <= 57) {
                            int LA4_6 = this.input.LA(5);
                            if (LA4_6 == 45) {
                                int LA4_7 = this.input.LA(6);
                                if (LA4_7 >= 48 && LA4_7 <= 57) {
                                    int LA4_8 = this.input.LA(7);
                                    if (LA4_8 >= 48 && LA4_8 <= 57) {
                                        int LA4_9 = this.input.LA(8);
                                        if (LA4_9 == 45) {
                                            int LA4_10 = this.input.LA(9);
                                            if (LA4_10 >= 48 && LA4_10 <= 57) {
                                                int LA4_11 = this.input.LA(10);
                                                if (LA4_11 >= 48 && LA4_11 <= 57) {
                                                    int LA4_12 = this.input.LA(11);
                                                    if (LA4_12 != 32 || !this.synpred1_Filter()) break;
                                                    alt4 = 1;
                                                    break;
                                                }
                                                if (this.state.backtracking > 0) {
                                                    this.state.failed = true;
                                                    return;
                                                }
                                                int nvaeMark = this.input.mark();
                                                try {
                                                    for (int nvaeConsume = 0; nvaeConsume < 9; ++nvaeConsume) {
                                                        this.input.consume();
                                                    }
                                                    NoViableAltException nvae = new NoViableAltException("", 4, 11, (IntStream)this.input);
                                                    throw nvae;
                                                }
                                                catch (Throwable throwable) {
                                                    this.input.rewind(nvaeMark);
                                                    throw throwable;
                                                }
                                            }
                                            if (this.state.backtracking > 0) {
                                                this.state.failed = true;
                                                return;
                                            }
                                            int nvaeMark = this.input.mark();
                                            try {
                                                for (int nvaeConsume = 0; nvaeConsume < 8; ++nvaeConsume) {
                                                    this.input.consume();
                                                }
                                                NoViableAltException nvae = new NoViableAltException("", 4, 10, (IntStream)this.input);
                                                throw nvae;
                                            }
                                            catch (Throwable throwable) {
                                                this.input.rewind(nvaeMark);
                                                throw throwable;
                                            }
                                        }
                                        if (this.state.backtracking > 0) {
                                            this.state.failed = true;
                                            return;
                                        }
                                        int nvaeMark = this.input.mark();
                                        try {
                                            for (int nvaeConsume = 0; nvaeConsume < 7; ++nvaeConsume) {
                                                this.input.consume();
                                            }
                                            NoViableAltException nvae = new NoViableAltException("", 4, 9, (IntStream)this.input);
                                            throw nvae;
                                        }
                                        catch (Throwable throwable) {
                                            this.input.rewind(nvaeMark);
                                            throw throwable;
                                        }
                                    }
                                    if (this.state.backtracking > 0) {
                                        this.state.failed = true;
                                        return;
                                    }
                                    int nvaeMark = this.input.mark();
                                    try {
                                        for (int nvaeConsume = 0; nvaeConsume < 6; ++nvaeConsume) {
                                            this.input.consume();
                                        }
                                        NoViableAltException nvae = new NoViableAltException("", 4, 8, (IntStream)this.input);
                                        throw nvae;
                                    }
                                    catch (Throwable throwable) {
                                        this.input.rewind(nvaeMark);
                                        throw throwable;
                                    }
                                }
                                if (this.state.backtracking > 0) {
                                    this.state.failed = true;
                                    return;
                                }
                                int nvaeMark = this.input.mark();
                                try {
                                    for (int nvaeConsume = 0; nvaeConsume < 5; ++nvaeConsume) {
                                        this.input.consume();
                                    }
                                    NoViableAltException nvae = new NoViableAltException("", 4, 7, (IntStream)this.input);
                                    throw nvae;
                                }
                                catch (Throwable throwable) {
                                    this.input.rewind(nvaeMark);
                                    throw throwable;
                                }
                            }
                            if (this.state.backtracking > 0) {
                                this.state.failed = true;
                                return;
                            }
                            int nvaeMark = this.input.mark();
                            try {
                                for (int nvaeConsume = 0; nvaeConsume < 4; ++nvaeConsume) {
                                    this.input.consume();
                                }
                                NoViableAltException nvae = new NoViableAltException("", 4, 6, (IntStream)this.input);
                                throw nvae;
                            }
                            catch (Throwable throwable) {
                                this.input.rewind(nvaeMark);
                                throw throwable;
                            }
                        }
                        if (this.state.backtracking > 0) {
                            this.state.failed = true;
                            return;
                        }
                        int nvaeMark = this.input.mark();
                        try {
                            for (int nvaeConsume = 0; nvaeConsume < 3; ++nvaeConsume) {
                                this.input.consume();
                            }
                            NoViableAltException nvae = new NoViableAltException("", 4, 5, (IntStream)this.input);
                            throw nvae;
                        }
                        catch (Throwable throwable) {
                            this.input.rewind(nvaeMark);
                            throw throwable;
                        }
                    }
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    int nvaeMark = this.input.mark();
                    try {
                        for (int nvaeConsume = 0; nvaeConsume < 2; ++nvaeConsume) {
                            this.input.consume();
                        }
                        NoViableAltException nvae = new NoViableAltException("", 4, 4, (IntStream)this.input);
                        throw nvae;
                    }
                    catch (Throwable throwable) {
                        this.input.rewind(nvaeMark);
                        throw throwable;
                    }
                }
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                int nvaeMark = this.input.mark();
                try {
                    this.input.consume();
                    NoViableAltException nvae = new NoViableAltException("", 4, 1, (IntStream)this.input);
                    throw nvae;
                }
                catch (Throwable throwable) {
                    this.input.rewind(nvaeMark);
                    throw throwable;
                }
            }
            case 84: 
            case 116: {
                alt4 = 2;
                break;
            }
            case 68: 
            case 100: {
                alt4 = 3;
                break;
            }
            default: {
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                NoViableAltException nvae = new NoViableAltException("", 4, 0, (IntStream)this.input);
                throw nvae;
            }
        }
        switch (alt4) {
            case 1: {
                this.mTimestampString();
                if (this.state.failed) {
                    return;
                }
                if (FilterLexer.extractTimestamp(this.getText()) != null) break;
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                throw new FailedPredicateException((IntStream)this.input, "DateTimeLiteral", " extractTimestamp(getText()) != null ");
            }
            case 2: {
                this.mKW_TIMESTAMP();
                if (this.state.failed) {
                    return;
                }
                this.match(39);
                if (this.state.failed) {
                    return;
                }
                this.mTimestampString();
                if (this.state.failed) {
                    return;
                }
                this.match(39);
                if (this.state.failed) {
                    return;
                }
                if (FilterLexer.extractTimestamp(this.getText()) != null) break;
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                throw new FailedPredicateException((IntStream)this.input, "DateTimeLiteral", " extractTimestamp(getText()) != null ");
            }
            case 3: {
                this.mKW_DATE();
                if (this.state.failed) {
                    return;
                }
                this.match(39);
                if (this.state.failed) {
                    return;
                }
                this.mDateString();
                if (this.state.failed) {
                    return;
                }
                this.match(39);
                if (this.state.failed) {
                    return;
                }
                if (FilterLexer.extractDate(this.getText()) != null) break;
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                throw new FailedPredicateException((IntStream)this.input, "DateTimeLiteral", " extractDate(getText()) != null ");
            }
            case 4: {
                this.mDateString();
                if (this.state.failed) {
                    return;
                }
                if (FilterLexer.extractDate(this.getText()) != null) break;
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                throw new FailedPredicateException((IntStream)this.input, "DateTimeLiteral", " extractDate(getText()) != null ");
            }
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mStringLiteral() throws RecognitionException {
        int _type = 29;
        int _channel = 0;
        int alt7 = 2;
        int LA7_0 = this.input.LA(1);
        if (LA7_0 == 39) {
            alt7 = 1;
        } else if (LA7_0 == 34) {
            alt7 = 2;
        } else {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            NoViableAltException nvae = new NoViableAltException("", 7, 0, (IntStream)this.input);
            throw nvae;
        }
        switch (alt7) {
            case 1: {
                this.match(39);
                if (this.state.failed) {
                    return;
                }
                block12: while (true) {
                    int alt5 = 3;
                    int LA5_0 = this.input.LA(1);
                    if (LA5_0 >= 0 && LA5_0 <= 38 || LA5_0 >= 40 && LA5_0 <= 91 || LA5_0 >= 93 && LA5_0 <= 65535) {
                        alt5 = 1;
                    } else if (LA5_0 == 92) {
                        alt5 = 2;
                    }
                    switch (alt5) {
                        case 1: {
                            if (this.input.LA(1) >= 0 && this.input.LA(1) <= 38 || this.input.LA(1) >= 40 && this.input.LA(1) <= 91 || this.input.LA(1) >= 93 && this.input.LA(1) <= 65535) {
                                this.input.consume();
                                this.state.failed = false;
                                continue block12;
                            }
                            if (this.state.backtracking > 0) {
                                this.state.failed = true;
                                return;
                            }
                            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                            this.recover((RecognitionException)mse);
                            throw mse;
                        }
                        case 2: {
                            this.match(92);
                            if (this.state.failed) {
                                return;
                            }
                            this.matchAny();
                            if (this.state.failed) return;
                            continue block12;
                        }
                    }
                    break;
                }
                this.match(39);
                if (!this.state.failed) break;
                return;
            }
            case 2: {
                this.match(34);
                if (this.state.failed) {
                    return;
                }
                block13: while (true) {
                    int alt6 = 3;
                    int LA6_0 = this.input.LA(1);
                    if (LA6_0 >= 0 && LA6_0 <= 33 || LA6_0 >= 35 && LA6_0 <= 91 || LA6_0 >= 93 && LA6_0 <= 65535) {
                        alt6 = 1;
                    } else if (LA6_0 == 92) {
                        alt6 = 2;
                    }
                    switch (alt6) {
                        case 1: {
                            if (this.input.LA(1) >= 0 && this.input.LA(1) <= 33 || this.input.LA(1) >= 35 && this.input.LA(1) <= 91 || this.input.LA(1) >= 93 && this.input.LA(1) <= 65535) {
                                this.input.consume();
                                this.state.failed = false;
                                continue block13;
                            }
                            if (this.state.backtracking > 0) {
                                this.state.failed = true;
                                return;
                            }
                            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                            this.recover((RecognitionException)mse);
                            throw mse;
                        }
                        case 2: {
                            this.match(92);
                            if (this.state.failed) {
                                return;
                            }
                            this.matchAny();
                            if (this.state.failed) return;
                            continue block13;
                        }
                    }
                    break;
                }
                this.match(34);
                if (!this.state.failed) break;
                return;
            }
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mIntegralLiteral() throws RecognitionException {
        int _type = 14;
        int _channel = 0;
        int alt8 = 2;
        int LA8_0 = this.input.LA(1);
        if (LA8_0 == 45) {
            alt8 = 1;
        }
        switch (alt8) {
            case 1: {
                this.match(45);
                if (!this.state.failed) break;
                return;
            }
        }
        int cnt9 = 0;
        block6: while (true) {
            int alt9 = 2;
            int LA9_0 = this.input.LA(1);
            if (LA9_0 >= 48 && LA9_0 <= 57) {
                alt9 = 1;
            }
            switch (alt9) {
                case 1: {
                    if (this.input.LA(1) >= 48 && this.input.LA(1) <= 57) {
                        this.input.consume();
                        this.state.failed = false;
                        break;
                    }
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                    this.recover((RecognitionException)mse);
                    throw mse;
                }
                default: {
                    if (cnt9 >= 1) break block6;
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    EarlyExitException eee = new EarlyExitException(9, (IntStream)this.input);
                    throw eee;
                }
            }
            ++cnt9;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mIdentifier() throws RecognitionException {
        int _type = 13;
        int _channel = 0;
        if (!(this.input.LA(1) >= 48 && this.input.LA(1) <= 57 || this.input.LA(1) >= 65 && this.input.LA(1) <= 90 || this.input.LA(1) >= 97 && this.input.LA(1) <= 122)) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
            this.recover((RecognitionException)mse);
            throw mse;
        }
        this.input.consume();
        this.state.failed = false;
        block3: while (true) {
            int alt10 = 2;
            int LA10_0 = this.input.LA(1);
            if (LA10_0 >= 48 && LA10_0 <= 57 || LA10_0 >= 65 && LA10_0 <= 90 || LA10_0 == 95 || LA10_0 >= 97 && LA10_0 <= 122) {
                alt10 = 1;
            }
            switch (alt10) {
                case 1: {
                    if (this.input.LA(1) >= 48 && this.input.LA(1) <= 57 || this.input.LA(1) >= 65 && this.input.LA(1) <= 90 || this.input.LA(1) == 95 || this.input.LA(1) >= 97 && this.input.LA(1) <= 122) {
                        this.input.consume();
                        this.state.failed = false;
                        continue block3;
                    }
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                    this.recover((RecognitionException)mse);
                    throw mse;
                }
            }
            break;
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public final void mWS() throws RecognitionException {
        int _type = 31;
        int _channel = 0;
        int cnt11 = 0;
        block3: while (true) {
            int alt11 = 2;
            int LA11_0 = this.input.LA(1);
            if (LA11_0 >= 9 && LA11_0 <= 10 || LA11_0 == 13 || LA11_0 == 32) {
                alt11 = 1;
            }
            switch (alt11) {
                case 1: {
                    if (this.input.LA(1) >= 9 && this.input.LA(1) <= 10 || this.input.LA(1) == 13 || this.input.LA(1) == 32) {
                        this.input.consume();
                        this.state.failed = false;
                        break;
                    }
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    MismatchedSetException mse = new MismatchedSetException(null, (IntStream)this.input);
                    this.recover((RecognitionException)mse);
                    throw mse;
                }
                default: {
                    if (cnt11 >= 1) break block3;
                    if (this.state.backtracking > 0) {
                        this.state.failed = true;
                        return;
                    }
                    EarlyExitException eee = new EarlyExitException(11, (IntStream)this.input);
                    throw eee;
                }
            }
            ++cnt11;
        }
        if (this.state.backtracking == 0) {
            this.skip();
        }
        this.state.type = _type;
        this.state.channel = _channel;
    }

    public void mTokens() throws RecognitionException {
        int alt12 = 24;
        alt12 = this.dfa12.predict((IntStream)this.input);
        switch (alt12) {
            case 1: {
                this.mKW_NOT();
                if (!this.state.failed) break;
                return;
            }
            case 2: {
                this.mKW_AND();
                if (!this.state.failed) break;
                return;
            }
            case 3: {
                this.mKW_OR();
                if (!this.state.failed) break;
                return;
            }
            case 4: {
                this.mKW_LIKE();
                if (!this.state.failed) break;
                return;
            }
            case 5: {
                this.mKW_DATE();
                if (!this.state.failed) break;
                return;
            }
            case 6: {
                this.mKW_TIMESTAMP();
                if (!this.state.failed) break;
                return;
            }
            case 7: {
                this.mKW_CONST();
                if (!this.state.failed) break;
                return;
            }
            case 8: {
                this.mKW_STRUCT();
                if (!this.state.failed) break;
                return;
            }
            case 9: {
                this.mLPAREN();
                if (!this.state.failed) break;
                return;
            }
            case 10: {
                this.mRPAREN();
                if (!this.state.failed) break;
                return;
            }
            case 11: {
                this.mCOMMA();
                if (!this.state.failed) break;
                return;
            }
            case 12: {
                this.mEQUAL();
                if (!this.state.failed) break;
                return;
            }
            case 13: {
                this.mNOTEQUAL();
                if (!this.state.failed) break;
                return;
            }
            case 14: {
                this.mLESSTHANOREQUALTO();
                if (!this.state.failed) break;
                return;
            }
            case 15: {
                this.mLESSTHAN();
                if (!this.state.failed) break;
                return;
            }
            case 16: {
                this.mGREATERTHANOREQUALTO();
                if (!this.state.failed) break;
                return;
            }
            case 17: {
                this.mGREATERTHAN();
                if (!this.state.failed) break;
                return;
            }
            case 18: {
                this.mBETWEEN();
                if (!this.state.failed) break;
                return;
            }
            case 19: {
                this.mIN();
                if (!this.state.failed) break;
                return;
            }
            case 20: {
                this.mDateTimeLiteral();
                if (!this.state.failed) break;
                return;
            }
            case 21: {
                this.mStringLiteral();
                if (!this.state.failed) break;
                return;
            }
            case 22: {
                this.mIntegralLiteral();
                if (!this.state.failed) break;
                return;
            }
            case 23: {
                this.mIdentifier();
                if (!this.state.failed) break;
                return;
            }
            case 24: {
                this.mWS();
                if (!this.state.failed) break;
                return;
            }
        }
    }

    public final void synpred1_Filter_fragment() throws RecognitionException {
        this.mTimestampString();
        if (this.state.failed) {
            return;
        }
    }

    public final boolean synpred1_Filter() {
        ++this.state.backtracking;
        int start = this.input.mark();
        try {
            this.synpred1_Filter_fragment();
        }
        catch (RecognitionException re) {
            System.err.println("impossible: " + (Object)((Object)re));
        }
        boolean success = !this.state.failed;
        this.input.rewind(start);
        --this.state.backtracking;
        this.state.failed = false;
        return success;
    }

    static {
        int numStates = DFA12_transitionS.length;
        DFA12_transition = new short[numStates][];
        for (int i = 0; i < numStates; ++i) {
            FilterLexer.DFA12_transition[i] = DFA.unpackEncodedString((String)DFA12_transitionS[i]);
        }
    }

    protected class DFA12
    extends DFA {
        public DFA12(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 12;
            this.eot = DFA12_eot;
            this.eof = DFA12_eof;
            this.min = DFA12_min;
            this.max = DFA12_max;
            this.accept = DFA12_accept;
            this.special = DFA12_special;
            this.transition = DFA12_transition;
        }

        public String getDescription() {
            return "1:1: Tokens : ( KW_NOT | KW_AND | KW_OR | KW_LIKE | KW_DATE | KW_TIMESTAMP | KW_CONST | KW_STRUCT | LPAREN | RPAREN | COMMA | EQUAL | NOTEQUAL | LESSTHANOREQUALTO | LESSTHAN | GREATERTHANOREQUALTO | GREATERTHAN | BETWEEN | IN | DateTimeLiteral | StringLiteral | IntegralLiteral | Identifier | WS );";
        }
    }
}

