/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class SQLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)SQLGenerator.class.getName());
    private final DatabaseProduct dbProduct;
    private final Configuration conf;

    public SQLGenerator(DatabaseProduct dbProduct, Configuration conf) {
        this.dbProduct = dbProduct;
        this.conf = conf;
    }

    public List<PreparedStatement> createInsertValuesPreparedStmt(Connection dbConn, String tblColumns, List<String> rows, List<List<String>> paramsList) throws SQLException {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        assert (paramsList == null || rows.size() == paramsList.size());
        ArrayList<Integer> rowsCountInStmts = new ArrayList<Integer>();
        List<String> insertStmts = this.createInsertValuesStmt(tblColumns, rows, rowsCountInStmts);
        assert (insertStmts.size() == rowsCountInStmts.size());
        ArrayList<PreparedStatement> preparedStmts = new ArrayList<PreparedStatement>();
        int paramsListFromIdx = 0;
        try {
            for (int stmtIdx = 0; stmtIdx < insertStmts.size(); ++stmtIdx) {
                String sql = insertStmts.get(stmtIdx);
                PreparedStatement pStmt = this.prepareStmtWithParameters(dbConn, sql, null);
                if (paramsList != null) {
                    int paramIdx = 1;
                    int paramsListToIdx = paramsListFromIdx + (Integer)rowsCountInStmts.get(stmtIdx);
                    for (int paramsListIdx = paramsListFromIdx; paramsListIdx < paramsListToIdx; ++paramsListIdx) {
                        List<String> params = paramsList.get(paramsListIdx);
                        int i = 0;
                        while (i < params.size()) {
                            pStmt.setString(paramIdx, params.get(i));
                            ++i;
                            ++paramIdx;
                        }
                    }
                    paramsListFromIdx = paramsListToIdx;
                }
                preparedStmts.add(pStmt);
            }
        }
        catch (SQLException e) {
            for (PreparedStatement pst : preparedStmts) {
                pst.close();
            }
            throw e;
        }
        return preparedStmts;
    }

    public List<String> createInsertValuesStmt(String tblColumns, List<String> rows) {
        return this.createInsertValuesStmt(tblColumns, rows, null);
    }

    private List<String> createInsertValuesStmt(String tblColumns, List<String> rows, List<Integer> rowsCountInStmts) {
        if (rows == null || rows.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> insertStmts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int numRowsInCurrentStmt = 0;
        switch (this.dbProduct) {
            case ORACLE: {
                if (rows.size() > 1) {
                    for (int numRows = 0; numRows < rows.size(); ++numRows) {
                        if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                            if (numRows > 0) {
                                sb.append(" select * from dual");
                                insertStmts.add(sb.toString());
                                if (rowsCountInStmts != null) {
                                    rowsCountInStmts.add(numRowsInCurrentStmt);
                                }
                                numRowsInCurrentStmt = 0;
                            }
                            sb.setLength(0);
                            sb.append("insert all ");
                        }
                        sb.append("into ").append(tblColumns).append(" values(").append(rows.get(numRows)).append(") ");
                        ++numRowsInCurrentStmt;
                    }
                    sb.append("select * from dual");
                    insertStmts.add(sb.toString());
                    if (rowsCountInStmts != null) {
                        rowsCountInStmts.add(numRowsInCurrentStmt);
                    }
                    return insertStmts;
                }
            }
            case DERBY: 
            case MYSQL: 
            case POSTGRES: 
            case SQLSERVER: {
                for (int numRows = 0; numRows < rows.size(); ++numRows) {
                    if (numRows % MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE) == 0) {
                        if (numRows > 0) {
                            insertStmts.add(sb.substring(0, sb.length() - 1));
                            if (rowsCountInStmts != null) {
                                rowsCountInStmts.add(numRowsInCurrentStmt);
                            }
                            numRowsInCurrentStmt = 0;
                        }
                        sb.setLength(0);
                        sb.append("insert into ").append(tblColumns).append(" values");
                    }
                    sb.append('(').append(rows.get(numRows)).append("),");
                    ++numRowsInCurrentStmt;
                }
                insertStmts.add(sb.substring(0, sb.length() - 1));
                if (rowsCountInStmts != null) {
                    rowsCountInStmts.add(numRowsInCurrentStmt);
                }
                return insertStmts;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    public String addForUpdateClause(String selectStatement) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return selectStatement;
            }
            case ORACLE: 
            case MYSQL: 
            case POSTGRES: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                String modifier = " with (updlock)";
                int wherePos = selectStatement.toUpperCase().indexOf(" WHERE ");
                if (wherePos < 0) {
                    return selectStatement + modifier;
                }
                return selectStatement.substring(0, wherePos) + modifier + selectStatement.substring(wherePos, selectStatement.length());
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        switch (this.dbProduct) {
            case DERBY: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)this.dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public PreparedStatement prepareStmtWithParameters(Connection dbConn, String sql, List<String> parameters) throws SQLException {
        PreparedStatement pst = dbConn.prepareStatement(this.addEscapeCharacters(sql));
        if (parameters == null || parameters.isEmpty()) {
            return pst;
        }
        try {
            for (int i = 1; i <= parameters.size(); ++i) {
                pst.setString(i, parameters.get(i - 1));
            }
        }
        catch (SQLException e) {
            pst.close();
            throw e;
        }
        return pst;
    }

    public DatabaseProduct getDbProduct() {
        return this.dbProduct;
    }

    public String addEscapeCharacters(String s) {
        if (this.dbProduct == DatabaseProduct.MYSQL) {
            return s.replaceAll("\\\\", "\\\\\\\\");
        }
        return s;
    }
}

