/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.LockTypeComparator;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InitializeTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ReplLastIdInfo;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.OpenTxn;
import org.apache.hadoop.hive.metastore.txn.OpenTxnList;
import org.apache.hadoop.hive.metastore.txn.OperationType;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.LockTypeUtil;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
abstract class TxnHandler
implements TxnStore,
TxnStore.MutexAPI {
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    static final char FAILED_STATE = 'f';
    static final char SUCCEEDED_STATE = 's';
    static final char ATTEMPTED_STATE = 'a';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char LOCK_ACQUIRED = 'a';
    protected static final char LOCK_WAITING = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 10;
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnHandler.class.getName());
    private static DataSource connPool;
    private static DataSource connPoolMutex;
    private static boolean doRetryOnConnPool;
    private static final String HIVE_LOCKS_INSERT_QRY = "INSERT INTO \"HIVE_LOCKS\" ( \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_LAST_HEARTBEAT\", \"HL_USER\", \"HL_HOST\", \"HL_AGENT_INFO\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, %s, ?, ?, ?)";
    private static final String TXN_COMPONENTS_INSERT_QUERY = "INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)";
    private static final String TXN_COMPONENTS_DP_DELETE_QUERY = "DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = ? AND \"TC_PARTITION\" IS NULL";
    private static final String INCREMENT_NEXT_LOCK_ID_QUERY = "UPDATE \"NEXT_LOCK_ID\" SET \"NL_NEXT\" = %s";
    private static final String UPDATE_HIVE_LOCKS_EXT_ID_QUERY = "UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_EXT_ID\" = %s WHERE \"HL_LOCK_EXT_ID\" = %s";
    private static final String SELECT_WRITE_ID_QUERY = "SELECT \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_TXNID\" = ?";
    private static final String COMPL_TXN_COMPONENTS_INSERT_QUERY = "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") VALUES (%s, ?, ?, ?, ?, %s)";
    private List<TransactionalMetaStoreEventListener> transactionalListeners;
    private static volatile int maxOpenTxns;
    private static volatile boolean tooManyOpenTxns;
    private int deadlockCnt;
    private long deadlockRetryInterval;
    protected Configuration conf;
    protected static DatabaseProduct dbProduct;
    private static SQLGenerator sqlGenerator;
    private long timeout;
    private long replicationTxnTimeout;
    private String identifierQuoteString;
    private long retryInterval;
    private int retryLimit;
    private int retryNum;
    private AtomicInteger numOpenTxns;
    private static final ReentrantLock derbyLock;
    private static final ConcurrentHashMap<String, Semaphore> derbyKey2Lock;
    private static final String hostname;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.checkQFileTestHack();
        Class<TxnHandler> clazz = TxnHandler.class;
        synchronized (TxnHandler.class) {
            if (connPool == null) {
                Connection dbConn = null;
                try {
                    int maxPoolSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
                    long getConnectionTimeoutMs = 30000L;
                    connPool = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize, getConnectionTimeoutMs);
                    connPoolMutex = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize + TxnStore.MUTEX_KEY.values().length, getConnectionTimeoutMs);
                    dbConn = this.getDbConn(2);
                    this.determineDatabaseProduct(dbConn);
                    sqlGenerator = new SQLGenerator(dbProduct, conf);
                }
                catch (SQLException e) {
                    try {
                        String msg = "Unable to instantiate JDBC connection pooling, " + e.getMessage();
                        LOG.error(msg);
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                TxnHandler.closeDbConn(dbConn);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.numOpenTxns = Metrics.getOrCreateGauge("num_open_transactions");
            this.timeout = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            this.replicationTxnTimeout = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.REPL_TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            this.retryInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, TimeUnit.MILLISECONDS);
            this.retryLimit = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
            this.deadlockRetryInterval = this.retryInterval / 10L;
            maxOpenTxns = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.MAX_OPEN_TXNS);
            try {
                this.transactionalListeners = MetaStoreUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, conf, MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS));
            }
            catch (MetaException e) {
                String msg = "Unable to get transaction listeners, " + e.getMessage();
                LOG.error(msg);
                throw new RuntimeException(e);
            }
            return;
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        return this.getOpenTxnsList(true).toOpenTxnsInfoResponse();
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        return this.getOpenTxnsList(false).toOpenTxnsResponse(Arrays.asList(TxnType.READ_ONLY));
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns(List<TxnType> excludeTxnTypes) throws MetaException {
        return this.getOpenTxnsList(false).toOpenTxnsResponse(excludeTxnTypes);
    }

    private GetOpenTxnsResponse getOpenTxns(Connection dbConn) throws MetaException {
        return this.getOpenTxnsList(false, dbConn).toOpenTxnsResponse(Arrays.asList(TxnType.READ_ONLY));
    }

    private OpenTxnList getOpenTxnsList(boolean infoFileds) throws MetaException {
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn(2);
            OpenTxnList openTxnList = this.getOpenTxnsList(infoFileds, dbConn);
            return openTxnList;
        }
        catch (SQLException e) {
            throw new MetaException("Unable to get a connection: " + TxnHandler.getMessage(e) + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
        finally {
            TxnHandler.closeDbConn(dbConn);
        }
    }

    private OpenTxnList getOpenTxnsList(boolean infoFields, Connection dbConn) throws MetaException {
        OpenTxnList openTxnList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            String s = "SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\"";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            ArrayList<OpenTxn> txnInfos = new ArrayList<OpenTxn>();
            String txnsQuery = String.format(infoFields ? "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\", \"TXN_USER\", \"TXN_HOST\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"" : "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"", hwm);
            LOG.debug("Going to execute query<" + txnsQuery + ">");
            rs = stmt.executeQuery(txnsQuery);
            while (rs.next()) {
                long txnId = rs.getLong(1);
                TxnStatus state = TxnStatus.fromString(rs.getString(2));
                OpenTxn txnInfo = new OpenTxn(txnId, state, TxnType.findByValue(rs.getInt(3)));
                if (infoFields) {
                    txnInfo.setUser(rs.getString(4));
                    txnInfo.setHost(rs.getString(5));
                    txnInfo.setStartedTime(rs.getLong(6));
                    txnInfo.setLastHeartBeatTime(rs.getLong(7));
                }
                txnInfos.add(txnInfo);
            }
            dbConn.rollback();
            LOG.debug("Got OpenTxnList with hwm: {} and openTxnList size {}.", (Object)hwm, (Object)txnInfos.size());
            openTxnList = new OpenTxnList(hwm, txnInfos);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxnsList");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, null);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxnsList(infoFields, dbConn);
            }
        }
        TxnHandler.close(rs, stmt, null);
        return openTxnList;
    }

    @Override
    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        OpenTxnsResponse openTxnsResponse;
        int numTxns;
        if (!tooManyOpenTxns && this.numOpenTxns.get() >= maxOpenTxns) {
            tooManyOpenTxns = true;
        }
        if (tooManyOpenTxns) {
            if ((double)this.numOpenTxns.get() < (double)maxOpenTxns * 0.9) {
                tooManyOpenTxns = false;
            } else {
                LOG.warn("Maximum allowed number of open transactions (" + maxOpenTxns + ") has been reached. Current number of open transactions: " + this.numOpenTxns);
                throw new MetaException("Maximum allowed number of open transactions has been reached. See hive.max.open.txns.");
            }
        }
        if ((numTxns = rqst.getNum_txns()) <= 0) {
            throw new MetaException("Invalid input for number of txns: " + numTxns);
        }
        Connection dbConn = null;
        Statement stmt = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            int maxTxns = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.TXN_MAX_OPEN_BATCH);
            if (numTxns > maxTxns) {
                numTxns = maxTxns;
            }
            stmt = dbConn.createStatement();
            List<Long> txnIds = this.openTxns(dbConn, stmt, rqst);
            LOG.debug("Going to commit");
            dbConn.commit();
            openTxnsResponse = new OpenTxnsResponse(txnIds);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "openTxns(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.openTxns(rqst);
            }
        }
        TxnHandler.close(null, stmt, dbConn);
        this.unlockInternal();
        return openTxnsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<Long> openTxns(Connection dbConn, Statement stmt, OpenTxnRequest rqst) throws SQLException, MetaException {
        ArrayList<Long> arrayList;
        ResultSet rs;
        block50: {
            boolean isHiveReplTxn;
            boolean isReplayedReplTxn;
            TxnType txnType;
            List<PreparedStatement> insertPreparedStmts;
            int numTxns;
            block46: {
                List<Long> list;
                block47: {
                    numTxns = rqst.getNum_txns();
                    rs = null;
                    insertPreparedStmts = null;
                    txnType = rqst.isSetTxn_type() ? rqst.getTxn_type() : TxnType.DEFAULT;
                    isReplayedReplTxn = txnType == TxnType.REPL_CREATED;
                    isHiveReplTxn = rqst.isSetReplPolicy() && txnType == TxnType.DEFAULT;
                    if (!isReplayedReplTxn) break block46;
                    assert (rqst.isSetReplPolicy());
                    List<Long> targetTxnIdList = this.getTargetTxnIdList(rqst.getReplPolicy(), rqst.getReplSrcTxnIds(), dbConn);
                    if (targetTxnIdList.isEmpty()) break block46;
                    if (targetTxnIdList.size() != rqst.getReplSrcTxnIds().size()) {
                        LOG.warn("target txn id number " + targetTxnIdList.toString() + " is not matching with source txn id number " + rqst.getReplSrcTxnIds().toString());
                    }
                    LOG.info("Target transactions " + targetTxnIdList.toString() + " are present for repl policy :" + rqst.getReplPolicy() + " and Source transaction id : " + rqst.getReplSrcTxnIds().toString());
                    list = targetTxnIdList;
                    if (insertPreparedStmts == null) break block47;
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                return list;
            }
            try {
                String s = sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" FROM \"NEXT_TXN_ID\"");
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                long first = rs.getLong(1);
                s = "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = " + (first + (long)numTxns);
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
                ArrayList<String> rows = new ArrayList<String>();
                ArrayList<String> params = new ArrayList<String>();
                params.add(rqst.getUser());
                params.add(rqst.getHostname());
                ArrayList<List<String>> paramsList = new ArrayList<List<String>>(numTxns);
                for (long i = first; i < first + (long)numTxns; ++i) {
                    txnIds.add(i);
                    rows.add(i + "," + (Object)((Object)TxnStatus.OPEN) + "," + TxnDbUtil.getEpochFn(dbProduct) + "," + TxnDbUtil.getEpochFn(dbProduct) + ",?,?," + txnType.getValue());
                    paramsList.add(params);
                }
                insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\", \"TXN_TYPE\")", rows, paramsList);
                for (PreparedStatement preparedStatement : insertPreparedStmts) {
                    preparedStatement.execute();
                }
                if (txnIds.size() == 1) {
                    s = "INSERT INTO \"MIN_HISTORY_LEVEL\" (\"MHL_TXNID\", \"MHL_MIN_OPEN_TXNID\") SELECT ?, MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
                    LOG.debug("Going to execute query <" + s + ">");
                    Throwable throwable = null;
                    try (PreparedStatement pstmt = dbConn.prepareStatement(s);){
                        pstmt.setLong(1, (Long)txnIds.get(0));
                        pstmt.execute();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    LOG.info("Added entries to MIN_HISTORY_LEVEL with a single query for current txn: " + txnIds);
                } else {
                    s = "SELECT MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
                    LOG.debug("Going to execute query <" + s + ">");
                    long minOpenTxnId = -1L;
                    ResultSet minOpenTxnIdRs = stmt.executeQuery(s);
                    Object object = null;
                    try {
                        if (!minOpenTxnIdRs.next()) {
                            throw new IllegalStateException("Scalar query returned no rows?!?!!");
                        }
                        minOpenTxnId = minOpenTxnIdRs.getLong(1);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (minOpenTxnIdRs != null) {
                            if (object != null) {
                                try {
                                    minOpenTxnIdRs.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                minOpenTxnIdRs.close();
                            }
                        }
                    }
                    rows.clear();
                    for (long txnId = first; txnId < first + (long)numTxns; ++txnId) {
                        rows.add(txnId + ", " + minOpenTxnId);
                    }
                    List<String> inserts = sqlGenerator.createInsertValuesStmt("\"MIN_HISTORY_LEVEL\" (\"MHL_TXNID\", \"MHL_MIN_OPEN_TXNID\")", rows);
                    for (String insert : inserts) {
                        LOG.debug("Going to execute insert <" + insert + ">");
                        stmt.execute(insert);
                    }
                    LOG.info("Added entries to MIN_HISTORY_LEVEL for current txns: (" + txnIds + ") with min_open_txn: " + minOpenTxnId);
                }
                if (isReplayedReplTxn) {
                    void var18_30;
                    ArrayList<String> rowsRepl = new ArrayList<String>();
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                    insertPreparedStmts.clear();
                    params.clear();
                    paramsList.clear();
                    params.add(rqst.getReplPolicy());
                    boolean bl = false;
                    while (var18_30 < numTxns) {
                        rowsRepl.add("?," + rqst.getReplSrcTxnIds().get((int)var18_30) + "," + txnIds.get((int)var18_30));
                        paramsList.add(params);
                        ++var18_30;
                    }
                    insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"REPL_TXN_MAP\" (\"RTM_REPL_POLICY\", \"RTM_SRC_TXN_ID\", \"RTM_TARGET_TXN_ID\")", rowsRepl, paramsList);
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.execute();
                    }
                }
                if (this.transactionalListeners != null && !isHiveReplTxn) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent(txnIds, txnType), dbConn, sqlGenerator);
                }
                arrayList = txnIds;
                if (insertPreparedStmts == null) break block50;
            }
            catch (Throwable throwable) {
                if (insertPreparedStmts != null) {
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                throw throwable;
            }
            for (PreparedStatement pst : insertPreparedStmts) {
                pst.close();
            }
        }
        TxnHandler.close(rs);
        return arrayList;
    }

    private List<Long> getTargetTxnIdList(String replPolicy, List<Long> sourceTxnIdList, Connection dbConn) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            ArrayList<String> inQueries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            ArrayList<Long> targetTxnIdList = new ArrayList<Long>();
            prefix.append("SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE ");
            suffix.append(" AND \"RTM_REPL_POLICY\" = ?");
            TxnUtils.buildQueryWithINClause(this.conf, inQueries, prefix, suffix, sourceTxnIdList, "\"RTM_SRC_TXN_ID\"", false, false);
            List<String> params = Arrays.asList(replPolicy);
            for (String query : inQueries) {
                LOG.debug("Going to execute select <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                rs = pst.executeQuery();
                while (rs.next()) {
                    targetTxnIdList.add(rs.getLong(1));
                }
                TxnHandler.closeStmt(pst);
            }
            LOG.debug("targetTxnid for srcTxnId " + sourceTxnIdList.toString() + " is " + ((Object)targetTxnIdList).toString());
            ArrayList<Long> arrayList = targetTxnIdList;
            return arrayList;
        }
        catch (SQLException e) {
            LOG.warn("failed to get target txn ids " + e.getMessage());
            throw e;
        }
        finally {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public long getTargetTxnId(String replPolicy, long sourceTxnId) throws MetaException {
        try {
            long l;
            List<Long> targetTxnIds;
            Connection dbConn;
            block8: {
                dbConn = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                targetTxnIds = this.getTargetTxnIdList(replPolicy, Collections.singletonList(sourceTxnId), dbConn);
                if (!targetTxnIds.isEmpty()) break block8;
                LOG.info("Txn {} not present for repl policy {}", (Object)sourceTxnId, (Object)replPolicy);
                long l2 = -1L;
                TxnHandler.closeDbConn(dbConn);
                this.unlockInternal();
                return l2;
            }
            try {
                assert (targetTxnIds.size() == 1);
                l = targetTxnIds.get(0);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getTargetTxnId(" + replPolicy + sourceTxnId + ")");
                    throw new MetaException("Unable to get target transaction id " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
            return l;
        }
        catch (RetryException e2) {
            return this.getTargetTxnId(replPolicy, sourceTxnId);
        }
    }

    private void deleteReplTxnMapEntry(Connection dbConn, long sourceTxnId, String replPolicy) throws SQLException {
        String s = "DELETE FROM \"REPL_TXN_MAP\" WHERE \"RTM_SRC_TXN_ID\" = " + sourceTxnId + " AND \"RTM_REPL_POLICY\" = ?";
        try (PreparedStatement pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(replPolicy));){
            LOG.info("Going to execute  <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
            pst.executeUpdate();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException, TxnAbortedException {
        txnid = rqst.getTxnid();
        sourceTxnId = -1L;
        isReplayedReplTxn = TxnType.REPL_CREATED.equals(rqst.getTxn_type());
        isHiveReplTxn = rqst.isSetReplPolicy() != false && TxnType.DEFAULT.equals(rqst.getTxn_type()) != false;
        try {
            block14: {
                block13: {
                    dbConn = null;
                    stmt = null;
                    this.lockInternal();
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    if (!isReplayedReplTxn) ** GOTO lbl27
                    if (!TxnHandler.$assertionsDisabled && !rqst.isSetReplPolicy()) {
                        throw new AssertionError();
                    }
                    sourceTxnId = rqst.getTxnid();
                    targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                    if (!targetTxnIds.isEmpty()) break block13;
                    TxnHandler.LOG.info("Target txn id is missing for source txn id : " + sourceTxnId + " and repl policy " + rqst.getReplPolicy());
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    return;
                }
                if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                    throw new AssertionError();
                }
                txnid = targetTxnIds.get(0);
lbl27:
                // 2 sources

                if ((txnType = this.getOpenTxnTypeAndLock(stmt, txnid)).isPresent()) ** GOTO lbl40
                status = this.findTxnState(txnid, stmt);
                if (status != TxnStatus.ABORTED) break block14;
                if (isReplayedReplTxn) {
                    TxnHandler.LOG.warn("Invalid state ABORTED for transactions started using replication replay task");
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                TxnHandler.LOG.info("abortTxn(" + JavaUtils.txnIdToString(txnid) + ") requested by it is already " + (Object)TxnStatus.ABORTED);
                TxnHandler.close(null, stmt, dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(status, txnid);
lbl40:
                // 2 sources

                this.abortTxns(dbConn, Collections.singletonList(txnid), true);
                if (isReplayedReplTxn) {
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                if (this.transactionalListeners != null && !isHiveReplTxn) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent((Long)txnid, txnType.get()), dbConn, TxnHandler.sqlGenerator);
                }
                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "abortTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var12_12) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw var12_12;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.abortTxn(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest rqst) throws MetaException {
        List<Long> txnIds = rqst.getTxn_ids();
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder("select \"TXN_ID\", \"TXN_TYPE\" from \"TXNS\" where \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" and \"TXN_TYPE\" != ").append(TxnType.READ_ONLY.getValue()).append(" and ");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
                HashMap<Long, TxnType> nonReadOnlyTxns = new HashMap<Long, TxnType>();
                for (String query : queries) {
                    LOG.debug("Going to execute query<" + query + ">");
                    ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));
                    Throwable throwable = null;
                    try {
                        while (rs.next()) {
                            TxnType txnType = TxnType.findByValue(rs.getInt(2));
                            nonReadOnlyTxns.put(rs.getLong(1), txnType);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                int numAborted = this.abortTxns(dbConn, txnIds, false);
                if (numAborted != txnIds.size()) {
                    LOG.warn("Abort Transactions command only aborted " + numAborted + " out of " + txnIds.size() + " transactions. It's possible that the other " + (txnIds.size() - numAborted) + " transactions have been aborted or committed, or the transaction ids are invalid.");
                }
                if (this.transactionalListeners != null) {
                    for (Long txnId : txnIds) {
                        MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(txnId, nonReadOnlyTxns.getOrDefault(txnId, TxnType.READ_ONLY)), dbConn, sqlGenerator);
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "abortTxns(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.abortTxns(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplId(Connection dbConn, ReplLastIdInfo replLastIdInfo) throws SQLException, MetaException {
        long tblId;
        List<String> params;
        String query;
        List<String> partList;
        String table;
        String db;
        String catalog;
        String lastReplId;
        Statement stmt;
        ResultSet rs;
        PreparedStatement pst;
        block15: {
            long dbId;
            block14: {
                pst = null;
                rs = null;
                stmt = null;
                lastReplId = TxnHandler.quoteString(Long.toString(replLastIdInfo.getLastReplId()));
                catalog = replLastIdInfo.isSetCatalog() ? StringUtils.normalizeIdentifier(replLastIdInfo.getCatalog()) : MetaStoreUtils.getDefaultCatalog(this.conf);
                db = StringUtils.normalizeIdentifier(replLastIdInfo.getDatabase());
                table = replLastIdInfo.isSetTable() ? StringUtils.normalizeIdentifier(replLastIdInfo.getTable()) : null;
                partList = replLastIdInfo.isSetPartitionList() ? replLastIdInfo.getPartitionList() : null;
                stmt = dbConn.createStatement();
                if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                    stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
                }
                query = "select \"DB_ID\" from \"DBS\" where \"NAME\" = ?  and \"CTLG_NAME\" = ?";
                params = Arrays.asList(db, catalog);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(db), (Object)TxnHandler.quoteString(catalog));
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new MetaException(" db with name " + db + " does not exist in catalog " + catalog);
                }
                dbId = rs.getLong(1);
                rs = stmt.executeQuery("SELECT \"PARAM_VALUE\" FROM \"DATABASE_PARAMS\" WHERE \"PARAM_KEY\" = 'repl.last.id' AND \"DB_ID\" = " + dbId);
                if (rs == null || !rs.next()) {
                    stmt.executeUpdate("INSERT INTO \"DATABASE_PARAMS\" VALUES ( " + dbId + " , 'repl.last.id' , " + lastReplId + ")");
                } else {
                    query = "UPDATE \"DATABASE_PARAMS\" SET \"PARAM_VALUE\" = ? WHERE \"DB_ID\" = " + dbId + " AND \"PARAM_KEY\" = 'repl.last.id'";
                }
                if (table != null) break block14;
                TxnHandler.closeStmt(stmt);
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                return;
            }
            query = "SELECT \"TBL_ID\" FROM \"TBLS\" WHERE \"TBL_NAME\" = ? AND \"DB_ID\" = " + dbId;
            params = Arrays.asList(table);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
            LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(table));
            rs = pst.executeQuery();
            if (rs == null || !rs.next()) {
                throw new MetaException(" table with name " + table + " does not exist in db " + catalog + "." + db);
            }
            tblId = rs.getLong(1);
            rs = stmt.executeQuery("SELECT \"PARAM_VALUE\" FROM \"TABLE_PARAMS\" WHERE \"PARAM_KEY\" = 'repl.last.id' AND \"TBL_ID\" = " + tblId);
            if (rs == null || !rs.next()) {
                stmt.executeUpdate("INSERT INTO \"TABLE_PARAMS\" VALUES ( " + tblId + " , 'repl.last.id' , " + lastReplId + ")");
            } else {
                stmt.executeUpdate("update \"TABLE_PARAMS\" set \"PARAM_VALUE\" = " + lastReplId + " where \"TBL_ID\" = " + tblId + " and \"PARAM_KEY\" = 'repl.last.id'");
            }
            if (partList != null && !partList.isEmpty()) break block15;
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            return;
        }
        try {
            for (String part : partList) {
                query = "SELECT \"PART_ID\" FROM \"PARTITIONS\" WHERE \"TBL_ID\" = " + tblId + " and \"PART_NAME\" = ? ";
                params = Arrays.asList(part);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(part));
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new MetaException(" partition with name " + part + " does not exist in table " + catalog + "." + db + "." + table);
                }
                long partId = rs.getLong(1);
                rs = stmt.executeQuery("SELECT \"PARAM_VALUE\" FROM \"PARTITION_PARAMS\" WHERE \"PARAM_KEY\"  = 'repl.last.id' AND \"PART_ID\" = " + partId);
                if (rs == null || !rs.next()) {
                    stmt.executeUpdate("INSERT INTO \"PARTITION_PARAMS\" VALUES ( " + partId + " , 'repl.last.id' , " + lastReplId + ")");
                    continue;
                }
                stmt.executeUpdate("UPDATE \"PARTITION_PARAMS\" SET \"PARAM_VALUE\" = " + lastReplId + " WHERE \"PART_ID\" = " + partId + " AND \"PARAM_KEY\" = 'repl.last.id'");
            }
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            throw throwable;
        }
        TxnHandler.closeStmt(stmt);
        TxnHandler.close(rs);
        TxnHandler.closeStmt(pst);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent(value={"No-op if already committed"})
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        isUpdateDelete = 'N';
        txnid = rqst.getTxnid();
        sourceTxnId = -1L;
        isReplayedReplTxn = TxnType.REPL_CREATED.equals(rqst.getTxn_type());
        isHiveReplTxn = rqst.isSetReplPolicy() != false && TxnType.DEFAULT.equals(rqst.getTxn_type()) != false;
        try {
            block63: {
                block62: {
                    dbConn = null;
                    stmt = null;
                    commitId = null;
                    this.lockInternal();
                    dbConn = this.getDbConn(2);
                    if (rqst.isSetReplLastIdInfo()) {
                        this.updateReplId(dbConn, rqst.getReplLastIdInfo());
                    }
                    stmt = dbConn.createStatement();
                    if (!isReplayedReplTxn) ** GOTO lbl32
                    if (!TxnHandler.$assertionsDisabled && !rqst.isSetReplPolicy()) {
                        throw new AssertionError();
                    }
                    sourceTxnId = rqst.getTxnid();
                    targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                    if (!targetTxnIds.isEmpty()) break block62;
                    TxnHandler.LOG.info("Target txn id is missing for source txn id : " + sourceTxnId + " and repl policy " + rqst.getReplPolicy());
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    return;
                }
                if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                    throw new AssertionError();
                }
                txnid = targetTxnIds.get(0);
lbl32:
                // 2 sources

                if ((txnType = this.getOpenTxnTypeAndLock(stmt, txnid)).isPresent()) ** GOTO lbl45
                actualTxnStatus = this.findTxnState(txnid, stmt);
                if (actualTxnStatus != TxnStatus.COMMITTED) break block63;
                if (isReplayedReplTxn) {
                    TxnHandler.LOG.warn("Invalid state COMMITTED for transactions started using replication replay task");
                }
                TxnHandler.LOG.info("Nth commitTxn(" + JavaUtils.txnIdToString(txnid) + ") msg");
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(actualTxnStatus, txnid);
lbl45:
                // 2 sources

                conflictSQLSuffix = "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\"=" + txnid + " AND \"TC_OPERATION_TYPE\" IN(" + (Object)OperationType.UPDATE + "," + (Object)OperationType.DELETE + ")";
                tempCommitId = this.generateTemporaryId();
                if (txnType.get() != TxnType.READ_ONLY && !isReplayedReplTxn && this.isUpdateOrDelete(stmt, conflictSQLSuffix)) {
                    isUpdateDelete = 'Y';
                    undoWriteSetForCurrentTxn = dbConn.setSavepoint();
                    stmt.executeUpdate("INSERT INTO \"WRITE_SET\" (\"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\", \"WS_TXNID\", \"WS_COMMIT_ID\", \"WS_OPERATION_TYPE\") SELECT DISTINCT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_TXNID\", " + tempCommitId + ", \"TC_OPERATION_TYPE\" " + conflictSQLSuffix);
                    commitIdRs = stmt.executeQuery(TxnHandler.sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\""));
                    var18_17 = null;
                    try {
                        if (!commitIdRs.next()) {
                            throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                        }
                        commitId = commitIdRs.getLong(1);
                    }
                    catch (Throwable var19_19) {
                        var18_17 = var19_19;
                        throw var19_19;
                    }
                    finally {
                        if (commitIdRs != null) {
                            if (var18_17 != null) {
                                try {
                                    commitIdRs.close();
                                }
                                catch (Throwable var19_18) {
                                    var18_17.addSuppressed(var19_18);
                                }
                            } else {
                                commitIdRs.close();
                            }
                        }
                    }
                    if (!rqst.isExclWriteEnabled()) {
                        rs = this.checkForWriteConflict(stmt, txnid);
                        var18_17 = null;
                        try {
                            if (rs.next()) {
                                committedTxn = "[" + JavaUtils.txnIdToString(rs.getLong(1)) + "," + rs.getLong(2) + "]";
                                resource = new StringBuilder(rs.getString(3)).append("/").append(rs.getString(4));
                                partitionName = rs.getString(5);
                                if (partitionName != null) {
                                    resource.append('/').append(partitionName);
                                }
                                msg = "Aborting [" + JavaUtils.txnIdToString(txnid) + "," + commitId + "] due to a write conflict on " + resource + " committed by " + committedTxn + " " + rs.getString(7) + "/" + rs.getString(8);
                                dbConn.rollback(undoWriteSetForCurrentTxn);
                                TxnHandler.LOG.info(msg);
                                if (this.abortTxns(dbConn, Collections.singletonList(txnid), true) != 1) {
                                    throw new IllegalStateException(msg + " FAILED!");
                                }
                                dbConn.commit();
                                throw new TxnAbortedException(msg);
                            }
                        }
                        catch (Throwable committedTxn) {
                            var18_17 = committedTxn;
                            throw committedTxn;
                        }
                        finally {
                            if (rs != null) {
                                if (var18_17 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable committedTxn) {
                                        var18_17.addSuppressed(committedTxn);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                }
                if (txnType.get() != TxnType.READ_ONLY && !isReplayedReplTxn) {
                    this.moveTxnComponentsToCompleted(stmt, txnid, isUpdateDelete);
                } else if (isReplayedReplTxn) {
                    if (rqst.isSetWriteEventInfos()) {
                        sql = String.format("INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") VALUES (%s, ?, ?, ?, ?, %s)", new Object[]{txnid, TxnHandler.quoteChar(isUpdateDelete)});
                        pstmt = dbConn.prepareStatement(sql);
                        var18_17 = null;
                        try {
                            insertCounter = 0;
                            batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE);
                            for (WriteEventInfo writeEventInfo : rqst.getWriteEventInfos()) {
                                pstmt.setString(1, writeEventInfo.getDatabase());
                                pstmt.setString(2, writeEventInfo.getTable());
                                pstmt.setString(3, writeEventInfo.getPartition());
                                pstmt.setLong(4, writeEventInfo.getWriteId());
                                pstmt.addBatch();
                                if (++insertCounter % batchSize != 0) continue;
                                TxnHandler.LOG.debug("Executing a batch of <" + sql + "> queries. Batch size: " + batchSize);
                                pstmt.executeBatch();
                            }
                            if (insertCounter % batchSize != 0) {
                                TxnHandler.LOG.debug("Executing a batch of <" + sql + "> queries. Batch size: " + insertCounter % batchSize);
                                pstmt.executeBatch();
                            }
                        }
                        catch (Throwable var19_26) {
                            var18_17 = var19_26;
                            throw var19_26;
                        }
                        finally {
                            if (pstmt != null) {
                                if (var18_17 != null) {
                                    try {
                                        pstmt.close();
                                    }
                                    catch (Throwable var19_25) {
                                        var18_17.addSuppressed(var19_25);
                                    }
                                } else {
                                    pstmt.close();
                                }
                            }
                        }
                    }
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                this.updateCommitIdAndCleanUpMetadata(stmt, txnid, txnType.get(), commitId, tempCommitId);
                if (rqst.isSetKeyValue()) {
                    this.updateKeyValueAssociatedWithTxn(rqst, stmt);
                }
                if (this.transactionalListeners != null && !isHiveReplTxn) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.COMMIT_TXN, new CommitTxnEvent((Long)txnid, txnType.get()), dbConn, TxnHandler.sqlGenerator);
                }
                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "commitTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var27_39) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw var27_39;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.commitTxn(rqst);
        }
    }

    private boolean isUpdateOrDelete(Statement stmt, String conflictSQLSuffix) throws SQLException, MetaException {
        try (ResultSet rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, "\"TC_OPERATION_TYPE\" " + conflictSQLSuffix));){
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public long getLatestTxnInConflict(long txnid) throws MetaException {
        long l;
        Connection dbConn = null;
        Statement stmt = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String writeConflictQuery = "SELECT MAX(\"COMMITTED\".\"WS_TXNID\") FROM \"WRITE_SET\" \"COMMITTED\"    INNER JOIN (SELECT DISTINCT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_TXNID\"  FROM \"TXN_COMPONENTS\"     WHERE \"TC_TXNID\" = " + txnid + "     AND \"TC_OPERATION_TYPE\" IN (" + (Object)((Object)OperationType.UPDATE) + ", " + (Object)((Object)OperationType.DELETE) + ")) \"CUR\"    ON \"COMMITTED\".\"WS_DATABASE\" = \"CUR\".\"TC_DATABASE\"      AND \"COMMITTED\".\"WS_TABLE\" = \"CUR\".\"TC_TABLE\"      AND (\"COMMITTED\".\"WS_PARTITION\" = \"CUR\".\"TC_PARTITION\" OR        \"CUR\".\"TC_PARTITION\" IS NULL)  WHERE \"CUR\".\"TC_TXNID\" <= \"COMMITTED\".\"WS_COMMIT_ID\"";
            LOG.debug("Going to execute query: <" + writeConflictQuery + ">");
            ResultSet rs = stmt.executeQuery(writeConflictQuery);
            l = rs.next() ? rs.getLong(1) : -1L;
        }
        catch (Exception e) {
            try {
                throw new MetaException(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            catch (Throwable throwable) {
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                throw throwable;
            }
        }
        TxnHandler.closeStmt(stmt);
        TxnHandler.closeDbConn(dbConn);
        return l;
    }

    private ResultSet checkForWriteConflict(Statement stmt, long txnid) throws SQLException, MetaException {
        String writeConflictQuery = sqlGenerator.addLimitClause(1, "\"COMMITTED\".\"WS_TXNID\", \"COMMITTED\".\"WS_COMMIT_ID\", \"COMMITTED\".\"WS_DATABASE\", \"COMMITTED\".\"WS_TABLE\", \"COMMITTED\".\"WS_PARTITION\", \"CUR\".\"WS_COMMIT_ID\" \"CUR_WS_COMMIT_ID\", \"CUR\".\"WS_OPERATION_TYPE\" \"CUR_OP\", \"COMMITTED\".\"WS_OPERATION_TYPE\" \"COMMITTED_OP\" FROM \"WRITE_SET\" \"COMMITTED\" INNER JOIN \"WRITE_SET\" \"CUR\" ON \"COMMITTED\".\"WS_DATABASE\"=\"CUR\".\"WS_DATABASE\" AND \"COMMITTED\".\"WS_TABLE\"=\"CUR\".\"WS_TABLE\" AND (\"COMMITTED\".\"WS_PARTITION\"=\"CUR\".\"WS_PARTITION\" OR (\"COMMITTED\".\"WS_PARTITION\" IS NULL AND \"CUR\".\"WS_PARTITION\" IS NULL)) WHERE \"CUR\".\"WS_TXNID\" <= \"COMMITTED\".\"WS_COMMIT_ID\" AND \"CUR\".\"WS_TXNID\"=" + txnid + " AND \"COMMITTED\".\"WS_TXNID\" <> " + txnid + " and (\"COMMITTED\".\"WS_OPERATION_TYPE\" IN(" + (Object)((Object)OperationType.UPDATE) + ", " + (Object)((Object)OperationType.DELETE) + ") AND \"CUR\".\"WS_OPERATION_TYPE\" IN(" + (Object)((Object)OperationType.UPDATE) + ", " + (Object)((Object)OperationType.DELETE) + "))");
        LOG.debug("Going to execute query: <" + writeConflictQuery + ">");
        return stmt.executeQuery(writeConflictQuery);
    }

    private void moveTxnComponentsToCompleted(Statement stmt, long txnid, char isUpdateDelete) throws SQLException {
        String s = "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") SELECT \"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_WRITEID\", '" + isUpdateDelete + "' FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = " + txnid + " AND \"TC_OPERATION_TYPE\" <> " + (Object)((Object)OperationType.COMPACT);
        LOG.debug("Going to execute insert <" + s + ">");
        if (stmt.executeUpdate(s) < 1) {
            LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! " + JavaUtils.txnIdToString(txnid));
        }
    }

    private void updateCommitIdAndCleanUpMetadata(Statement stmt, long txnid, TxnType txnType, Long commitId, long tempId) throws SQLException {
        ArrayList<String> queryBatch = new ArrayList<String>(5);
        if (commitId != null) {
            queryBatch.add("UPDATE \"WRITE_SET\" SET \"WS_COMMIT_ID\" = " + commitId + " WHERE \"WS_COMMIT_ID\" = " + tempId + " AND \"WS_TXNID\" = " + txnid);
        }
        if (txnType != TxnType.READ_ONLY) {
            queryBatch.add("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = " + txnid);
        }
        queryBatch.add("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_TXNID\" = " + txnid);
        queryBatch.add("DELETE FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid);
        queryBatch.add("DELETE FROM \"MIN_HISTORY_LEVEL\" WHERE \"MHL_TXNID\" = " + txnid);
        queryBatch.add("DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" = " + txnid);
        TxnDbUtil.executeQueriesInBatch(stmt, queryBatch, this.conf);
    }

    private void updateKeyValueAssociatedWithTxn(CommitTxnRequest rqst, Statement stmt) throws SQLException {
        if (!rqst.getKeyValue().getKey().startsWith("_meta")) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". key should start with " + "_meta" + ".";
            LOG.warn(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        String s = "UPDATE \"TABLE_PARAMS\" SET \"PARAM_VALUE\" = " + TxnHandler.quoteString(rqst.getKeyValue().getValue()) + " WHERE \"TBL_ID\" = " + rqst.getKeyValue().getTableId() + " AND \"PARAM_KEY\" = " + TxnHandler.quoteString(rqst.getKeyValue().getKey());
        LOG.debug("Going to execute update <" + s + ">");
        int affectedRows = stmt.executeUpdate(s);
        if (affectedRows != 1) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". Only one row should have been affected but " + affectedRows + " rows where affected.";
            LOG.warn(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    @Override
    @RetrySemantics.Idempotent(value={"No-op if already replicated the writeid state"})
    public void replTableWriteIdState(ReplTblWriteIdStateRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(rqst.getValidWriteIdlist());
        List<Long> abortedWriteIds = this.getAbortedWriteIds(validWriteIdList);
        int numAbortedWrites = abortedWriteIds.size();
        try {
            TxnStore.MutexAPI.LockHandle handle;
            ResultSet rs;
            PreparedStatement pStmt;
            Statement stmt;
            Connection dbConn;
            block25: {
                Object sql;
                List<String> params;
                List<PreparedStatement> insertPreparedStmts;
                block23: {
                    block24: {
                        dbConn = null;
                        stmt = null;
                        pStmt = null;
                        insertPreparedStmts = null;
                        rs = null;
                        handle = null;
                        params = Arrays.asList(dbName, tblName);
                        this.lockInternal();
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        sql = "SELECT \"NWI_NEXT\" FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                        LOG.debug("Going to execute query <" + ((String)sql).replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        rs = pStmt.executeQuery();
                        if (!rs.next()) break block23;
                        LOG.info("Idempotent flow: WriteId state <" + validWriteIdList + "> is already applied for the table: " + dbName + "." + tblName);
                        TxnHandler.rollbackDBConn(dbConn);
                        if (insertPreparedStmts == null) break block24;
                        for (PreparedStatement pst : insertPreparedStmts) {
                            TxnHandler.closeStmt(pst);
                        }
                    }
                    TxnHandler.closeStmt(pStmt);
                    TxnHandler.close(rs, stmt, dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    return;
                }
                try {
                    if (numAbortedWrites > 0) {
                        List<Long> txnIds = this.openTxns(dbConn, stmt, new OpenTxnRequest(numAbortedWrites, rqst.getUser(), rqst.getHostName()));
                        assert (numAbortedWrites == txnIds.size());
                        ArrayList<String> rows = new ArrayList<String>();
                        ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                        int i = 0;
                        Iterator<Object> iterator = txnIds.iterator();
                        while (iterator.hasNext()) {
                            long txn = iterator.next();
                            long writeId = abortedWriteIds.get(i++);
                            rows.add(txn + ", ?, ?, " + writeId);
                            paramsList.add(params);
                            LOG.info("Allocated writeID: " + writeId + " for txnId: " + txn);
                        }
                        insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\")", rows, paramsList);
                        for (PreparedStatement pst : insertPreparedStmts) {
                            pst.execute();
                        }
                        int numAborts = this.abortTxns(dbConn, txnIds, true);
                        assert (numAborts == numAbortedWrites);
                    }
                    handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                    long nextWriteId = validWriteIdList.getHighWatermark() + 1L;
                    sql = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + Long.toString(nextWriteId) + ")";
                    TxnHandler.closeStmt(pStmt);
                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                    LOG.debug("Going to execute insert <" + ((String)sql).replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                    pStmt.execute();
                    LOG.info("WriteId state <" + validWriteIdList + "> is applied for the table: " + dbName + "." + tblName);
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    if (insertPreparedStmts == null) break block25;
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "replTableWriteIdState(" + rqst + ")");
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.closeStmt(pStmt);
                        TxnHandler.close(rs, stmt, dbConn);
                        if (handle != null) {
                            handle.releaseLocks();
                        }
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.closeStmt(pStmt);
            TxnHandler.close(rs, stmt, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.replTableWriteIdState(rqst);
        }
        if (numAbortedWrites > 0) {
            CompactionRequest compactRqst = new CompactionRequest(rqst.getDbName(), rqst.getTableName(), CompactionType.MAJOR);
            if (rqst.isSetPartNames()) {
                for (String partName : rqst.getPartNames()) {
                    compactRqst.setPartitionname(partName);
                    this.compact(compactRqst);
                }
            } else {
                this.compact(compactRqst);
            }
        }
    }

    private List<Long> getAbortedWriteIds(ValidWriteIdList validWriteIdList) {
        ArrayList<Long> abortedWriteIds = new ArrayList<Long>();
        for (long writeId : validWriteIdList.getInvalidWriteIds()) {
            if (!validWriteIdList.isWriteIdAborted(writeId)) continue;
            abortedWriteIds.add(writeId);
        }
        return abortedWriteIds;
    }

    private ValidTxnList getValidTxnList(Connection dbConn, String fullTableName, Long writeId) throws MetaException, SQLException {
        block4: {
            ValidTxnList validTxnList;
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                String[] names = TxnUtils.getDbTableName(fullTableName);
                assert (names.length == 2);
                String s = "SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_WRITEID\" = ?";
                pst = dbConn.prepareStatement(sqlGenerator.addEscapeCharacters(s));
                pst.setString(1, names[0]);
                pst.setString(2, names[1]);
                pst.setLong(3, writeId);
                LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", new Object[]{TxnHandler.quoteString(names[0]), TxnHandler.quoteString(names[1]), writeId});
                rs = pst.executeQuery();
                if (!rs.next()) break block4;
                long txnId = rs.getLong(1);
                validTxnList = TxnUtils.createValidReadTxnList(this.getOpenTxns(), txnId);
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, null);
                throw throwable;
            }
            TxnHandler.close(rs, pst, null);
            return validTxnList;
        }
        throw new MetaException("invalid write id " + writeId + " for table " + fullTableName);
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest rqst) throws MetaException {
        GetValidWriteIdsResponse getValidWriteIdsResponse;
        Connection dbConn = null;
        ValidTxnList validTxnList = rqst.isSetValidTxnList() ? new ValidReadTxnList(rqst.getValidTxnList()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(), 0L);
        try {
            GetValidWriteIdsResponse owr;
            dbConn = this.getDbConn(2);
            if (rqst.isSetValidTxnList()) {
                assert (!rqst.isSetWriteId());
                validTxnList = new ValidReadTxnList(rqst.getValidTxnList());
            } else {
                validTxnList = rqst.isSetWriteId() ? this.getValidTxnList(dbConn, rqst.getFullTableNames().get(0), rqst.getWriteId()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(dbConn), 0L);
            }
            ArrayList<TableValidWriteIds> tblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
            for (String fullTableName : rqst.getFullTableNames()) {
                tblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, validTxnList));
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            getValidWriteIdsResponse = owr = new GetValidWriteIdsResponse(tblValidWriteIdsList);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getValidWriteIds");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getValidWriteIds(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return getValidWriteIdsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableValidWriteIds getValidWriteIdsForTable(Connection dbConn, String fullTableName, ValidTxnList validTxnList) throws SQLException {
        TableValidWriteIds tableValidWriteIds;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String[] names = TxnUtils.getDbTableName(fullTableName);
        assert (names.length == 2);
        List<String> params = Arrays.asList(names[0], names[1]);
        try {
            long writeIdHwm = 0L;
            ArrayList<Long> invalidWriteIdList = new ArrayList<Long>();
            long minOpenWriteId = Long.MAX_VALUE;
            BitSet abortedBits = new BitSet();
            long txnHwm = validTxnList.getHighWatermark();
            String s = "SELECT MAX(\"T2W_WRITEID\") FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" <= " + Long.toString(txnHwm) + " AND \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            rs = pst.executeQuery();
            if (rs.next()) {
                writeIdHwm = rs.getLong(1);
            }
            if (writeIdHwm <= 0L) {
                s = "SELECT \"NWI_NEXT\"-1 FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
                TxnHandler.closeStmt(pst);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
                rs = pst.executeQuery();
                if (rs.next()) {
                    writeIdHwm = rs.getLong(1);
                }
            }
            boolean foundValidUncompactedWrite = false;
            s = "SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_WRITEID\" <= " + Long.toString(writeIdHwm) + " AND \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? ORDER BY \"T2W_WRITEID\" ASC";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            LOG.debug("Going to execute query<" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            rs = pst.executeQuery();
            while (rs.next()) {
                long txnId = rs.getLong(1);
                long writeId = rs.getLong(2);
                if (validTxnList.isTxnValid(txnId)) {
                    foundValidUncompactedWrite = true;
                    continue;
                }
                invalidWriteIdList.add(writeId);
                if (validTxnList.isTxnAborted(txnId)) {
                    abortedBits.set(invalidWriteIdList.size() - 1);
                    continue;
                }
                minOpenWriteId = Math.min(minOpenWriteId, writeId);
            }
            if (!foundValidUncompactedWrite) {
                long writeId = invalidWriteIdList.isEmpty() ? -1L : (Long)invalidWriteIdList.get(0);
                invalidWriteIdList = new ArrayList();
                abortedBits = new BitSet();
                if (writeId != -1L) {
                    invalidWriteIdList.add(writeId);
                    writeIdHwm = writeId;
                    if (writeId != minOpenWriteId) {
                        abortedBits.set(0);
                    }
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
            TableValidWriteIds owi = new TableValidWriteIds(fullTableName, writeIdHwm, invalidWriteIdList, byteBuffer);
            if (minOpenWriteId < Long.MAX_VALUE) {
                owi.setMinOpenWriteId(minOpenWriteId);
            }
            tableValidWriteIds = owi;
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
            throw throwable;
        }
        TxnHandler.closeStmt(pst);
        TxnHandler.close(rs);
        return tableValidWriteIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public AllocateTableWriteIdsResponse allocateTableWriteIds(AllocateTableWriteIdsRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        boolean shouldReallocate = rqst.isReallocate();
        try {
            Object object;
            TxnStore.MutexAPI.LockHandle handle;
            ResultSet rs;
            List<PreparedStatement> insertPreparedStmts;
            PreparedStatement pStmt;
            Statement stmt;
            Connection dbConn;
            block45: {
                AllocateTableWriteIdsResponse txnId2;
                block43: {
                    Iterator iterator;
                    block44: {
                        dbConn = null;
                        stmt = null;
                        pStmt = null;
                        insertPreparedStmts = null;
                        rs = null;
                        handle = null;
                        ArrayList<TxnToWriteId> txnToWriteIds = new ArrayList<TxnToWriteId>();
                        List<TxnToWriteId> srcTxnToWriteIds = null;
                        try {
                            List<Long> txnIds;
                            this.lockInternal();
                            dbConn = this.getDbConn(2);
                            stmt = dbConn.createStatement();
                            if (rqst.isSetReplPolicy()) {
                                srcTxnToWriteIds = rqst.getSrcTxnToWriteIdList();
                                ArrayList<Long> srcTxnIds = new ArrayList<Long>();
                                assert (rqst.isSetSrcTxnToWriteIdList());
                                assert (!rqst.isSetTxnIds());
                                assert (!srcTxnToWriteIds.isEmpty());
                                for (TxnToWriteId txnToWriteId : srcTxnToWriteIds) {
                                    srcTxnIds.add(txnToWriteId.getTxnId());
                                }
                                txnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), srcTxnIds, dbConn);
                                if (srcTxnIds.size() != txnIds.size()) {
                                    LOG.info("Idempotent case: Target txn id is missing for source txn id : " + ((Object)srcTxnIds).toString() + " and repl policy " + rqst.getReplPolicy());
                                    AllocateTableWriteIdsResponse allocateTableWriteIdsResponse = new AllocateTableWriteIdsResponse(txnToWriteIds);
                                    return allocateTableWriteIdsResponse;
                                }
                            } else {
                                assert (!rqst.isSetSrcTxnToWriteIdList());
                                assert (rqst.isSetTxnIds());
                                txnIds = rqst.getTxnIds();
                            }
                            if (txnIds.size() > 1) {
                                Collections.sort(txnIds);
                            }
                            if (!this.isTxnsOpenAndNotReadOnly(txnIds, stmt)) {
                                String errorMsg = "Write ID allocation on " + TableName.getDbTable(dbName, tblName) + " failed for input txns: " + this.getAbortedAndReadOnlyTxns(txnIds, stmt) + this.getCommittedTxns(txnIds, stmt);
                                LOG.error(errorMsg);
                                throw new IllegalStateException("Write ID allocation failed on " + TableName.getDbTable(dbName, tblName) + " as not all input txns in open state or read-only");
                            }
                            ArrayList<String> queries = new ArrayList<String>();
                            StringBuilder prefix = new StringBuilder();
                            StringBuilder stringBuilder = new StringBuilder();
                            long writeId = 0L;
                            int allocatedTxnsCount = 0;
                            List<String> params = Arrays.asList(dbName, tblName);
                            if (shouldReallocate) {
                                prefix.append("DELETE FROM \"TXN_TO_WRITE_ID\" WHERE").append(" \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND ");
                                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, stringBuilder, txnIds, "\"T2W_TXNID\"", false, false);
                                for (String query : queries) {
                                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                                    LOG.debug("Going to execute delete <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                    int numRowsDeleted = pStmt.executeUpdate();
                                    LOG.info("Removed {} prior writeIds during reallocation", (Object)numRowsDeleted);
                                    TxnHandler.closeStmt(pStmt);
                                }
                            } else {
                                prefix.append("SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE").append(" \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND ");
                                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, stringBuilder, txnIds, "\"T2W_TXNID\"", false, false);
                                for (String query : queries) {
                                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                                    LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                    rs = pStmt.executeQuery();
                                    while (rs.next()) {
                                        long txnId2 = rs.getLong(1);
                                        writeId = rs.getLong(2);
                                        txnToWriteIds.add(new TxnToWriteId(txnId2, writeId));
                                        ++allocatedTxnsCount;
                                        LOG.info("Reused already allocated writeID: {} for txnId: {}", (Object)writeId, (Object)txnId2);
                                    }
                                    TxnHandler.closeStmt(pStmt);
                                }
                            }
                            long numOfWriteIds = txnIds.size();
                            assert (allocatedTxnsCount == 0 || numOfWriteIds == (long)allocatedTxnsCount);
                            if ((long)allocatedTxnsCount == numOfWriteIds) {
                                txnId2 = new AllocateTableWriteIdsResponse(txnToWriteIds);
                                if (insertPreparedStmts == null) break block43;
                                iterator = insertPreparedStmts.iterator();
                                break block44;
                            }
                            long srcWriteId = 0L;
                            if (rqst.isSetReplPolicy()) {
                                assert (srcTxnToWriteIds != null);
                                srcWriteId = srcTxnToWriteIds.get(0).getWriteId();
                            }
                            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                            String s = sqlGenerator.addForUpdateClause("SELECT \"NWI_NEXT\" FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?");
                            TxnHandler.closeStmt(pStmt);
                            pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                            LOG.debug("Going to execute query <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                            rs = pStmt.executeQuery();
                            if (!rs.next()) {
                                writeId = srcWriteId > 0L ? srcWriteId : 1L;
                                s = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + Long.toString(writeId + numOfWriteIds) + ")";
                                TxnHandler.closeStmt(pStmt);
                                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                LOG.debug("Going to execute insert <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                pStmt.execute();
                            } else {
                                long nextWriteId = rs.getLong(1);
                                writeId = srcWriteId > 0L ? srcWriteId : nextWriteId;
                                s = "UPDATE \"NEXT_WRITE_ID\" SET \"NWI_NEXT\" = " + Long.toString(writeId + numOfWriteIds) + " WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
                                TxnHandler.closeStmt(pStmt);
                                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                LOG.debug("Going to execute update <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                pStmt.executeUpdate();
                                if (srcWriteId > 0L && srcWriteId != nextWriteId) {
                                    s = "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ?";
                                    TxnHandler.closeStmt(pStmt);
                                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                                    LOG.debug("Going to execute delete <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                                    pStmt.executeUpdate();
                                }
                            }
                            ArrayList<String> rows = new ArrayList<String>();
                            ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                            object = txnIds.iterator();
                            while (object.hasNext()) {
                                long txn = object.next();
                                rows.add(txn + ", ?, ?, " + writeId);
                                txnToWriteIds.add(new TxnToWriteId(txn, writeId));
                                paramsList.add(params);
                                LOG.info("Allocated writeID: " + writeId + " for txnId: " + txn);
                                ++writeId;
                            }
                            insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\")", rows, paramsList);
                            for (PreparedStatement pst : insertPreparedStmts) {
                                pst.execute();
                            }
                            if (this.transactionalListeners != null) {
                                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(txnToWriteIds, dbName, tblName), dbConn, sqlGenerator);
                            }
                            LOG.info("Allocated write ids for the table: " + dbName + "." + tblName);
                            LOG.debug("Going to commit");
                            dbConn.commit();
                            object = new AllocateTableWriteIdsResponse(txnToWriteIds);
                            if (insertPreparedStmts != null) {
                            }
                            break block45;
                        }
                        catch (SQLException e) {
                            LOG.debug("Going to rollback");
                            TxnHandler.rollbackDBConn(dbConn);
                            this.checkRetryable(dbConn, e, "allocateTableWriteIds(" + rqst + ")");
                            throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                    }
                    while (iterator.hasNext()) {
                        PreparedStatement pst = (PreparedStatement)iterator.next();
                        TxnHandler.closeStmt(pst);
                    }
                }
                TxnHandler.closeStmt(pStmt);
                TxnHandler.close(rs, stmt, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                return txnId2;
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.closeStmt(pStmt);
            TxnHandler.close(rs, stmt, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return object;
            finally {
                if (insertPreparedStmts != null) {
                    for (PreparedStatement pst : insertPreparedStmts) {
                        TxnHandler.closeStmt(pst);
                    }
                }
                TxnHandler.closeStmt(pStmt);
                TxnHandler.close(rs, stmt, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
            }
        }
        catch (RetryException e) {
            return this.allocateTableWriteIds(rqst);
        }
    }

    @Override
    public void seedWriteIdOnAcidConversion(InitializeTableWriteIdsRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            PreparedStatement pst = null;
            TxnStore.MutexAPI.LockHandle handle = null;
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.WriteIdAllocator.name());
                String s = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + Long.toString(rqst.getSeeWriteId() + 1L) + ")";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(rqst.getDbName(), rqst.getTblName()));
                LOG.debug("Going to execute insert <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(rqst.getDbName()), (Object)TxnHandler.quoteString(rqst.getTblName()));
                pst.execute();
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "seedWriteIdOnAcidConversion(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.seedWriteIdOnAcidConversion(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void addWriteNotificationLog(AcidWriteEvent acidWriteEvent) throws MetaException {
        Connection dbConn = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ACID_WRITE, acidWriteEvent, dbConn, sqlGenerator);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    if (this.isDuplicateKeyError(e)) {
                        if (this.waitForRetry("addWriteNotificationLog(" + acidWriteEvent + ")", e.getMessage())) {
                            throw new RetryException();
                        }
                        this.retryNum = 0;
                        throw new MetaException(e.getMessage());
                    }
                    this.checkRetryable(dbConn, e, "addWriteNotificationLog(" + acidWriteEvent + ")");
                    throw new MetaException("Unable to add write notification event " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
            return;
        }
        catch (RetryException e) {
            this.addWriteNotificationLog(acidWriteEvent);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.SafeToRetry
    public void performWriteSetGC() {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\"");
            if (!rs.next()) {
                throw new IllegalStateException("NEXT_TXN_ID is empty: DB is corrupted");
            }
            long highestAllocatedTxnId = rs.getLong(1);
            TxnHandler.close(rs);
            rs = stmt.executeQuery("SELECT MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\"=" + (Object)((Object)TxnStatus.OPEN));
            if (!rs.next()) {
                throw new IllegalStateException("Scalar query returned no rows?!?!!");
            }
            long lowestOpenTxnId = rs.getLong(1);
            long commitHighWaterMark = rs.wasNull() ? highestAllocatedTxnId + 1L : lowestOpenTxnId;
            int delCnt = stmt.executeUpdate("DELETE FROM \"WRITE_SET\" WHERE \"WS_COMMIT_ID\" < " + commitHighWaterMark);
            LOG.info("Deleted " + delCnt + " obsolete rows from WRTIE_SET");
            dbConn.commit();
        }
        catch (SQLException ex) {
            try {
                LOG.warn("WriteSet GC failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, stmt, dbConn);
                throw throwable;
            }
            TxnHandler.close(rs, stmt, dbConn);
        }
        TxnHandler.close(rs, stmt, dbConn);
    }

    @Override
    @RetrySemantics.ReadOnly
    public Materialization getMaterializationInvalidationInfo(CreationMetadata creationMetadata, String validTxnListStr) throws MetaException {
        Materialization materialization;
        if (creationMetadata.getTablesUsed().isEmpty()) {
            LOG.warn("Materialization creation metadata does not contain any table");
            return null;
        }
        Connection dbConn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            ValidTxnWriteIdList validReaderWriteIdList = new ValidTxnWriteIdList(creationMetadata.getValidTxnList());
            ValidReadTxnList currentValidTxnList = new ValidReadTxnList(validTxnListStr);
            ArrayList<TableValidWriteIds> currentTblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
            for (String fullTableName : creationMetadata.getTablesUsed()) {
                currentTblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, currentValidTxnList));
            }
            ValidTxnWriteIdList currentValidReaderWriteIdList = TxnUtils.createValidTxnWriteIdList(currentValidTxnList.getHighWatermark(), currentTblValidWriteIdsList);
            ArrayList<String> params = new ArrayList<String>();
            StringBuilder query = new StringBuilder();
            query.append("SELECT \"CTC_UPDATE_DELETE\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_UPDATE_DELETE\" ='Y' AND (");
            int i = 0;
            for (String fullyQualifiedName : creationMetadata.getTablesUsed()) {
                Materialization materialization2;
                ValidWriteIdList tblValidWriteIdList = validReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
                if (tblValidWriteIdList == null) {
                    LOG.warn("ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                    Materialization materialization3 = null;
                    return materialization3;
                }
                ValidWriteIdList currentTblValidWriteIdList = currentValidReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
                if (currentTblValidWriteIdList == null) {
                    LOG.warn("Current ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                    materialization2 = null;
                    return materialization2;
                }
                if (!Objects.equals(currentTblValidWriteIdList.getMinOpenWriteId(), tblValidWriteIdList.getMinOpenWriteId())) {
                    LOG.debug("Minimum open write id do not match for table {}", (Object)fullyQualifiedName);
                    materialization2 = null;
                    TxnHandler.close(rs, pst, dbConn);
                    return materialization2;
                }
                if (i != 0) {
                    query.append("OR");
                }
                String[] names = TxnUtils.getDbTableName(fullyQualifiedName);
                assert (names.length == 2);
                query.append(" (\"CTC_DATABASE\"=? AND \"CTC_TABLE\"=?");
                params.add(names[0]);
                params.add(names[1]);
                query.append(" AND (\"CTC_WRITEID\" > " + tblValidWriteIdList.getHighWatermark());
                query.append(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR \"CTC_WRITEID\" IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject(tblValidWriteIdList.getInvalidWriteIds()))) + ") ");
                query.append(") ");
                ++i;
            }
            query.append(") AND \"CTC_TXNID\" <= " + currentValidTxnList.getHighWatermark());
            query.append(currentValidTxnList.getInvalidTransactions().length == 0 ? " " : " AND \"CTC_TXNID\" NOT IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject(currentValidTxnList.getInvalidTransactions()))) + ") ");
            String s = query.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + s + ">");
            }
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            pst.setMaxRows(1);
            rs = pst.executeQuery();
            materialization = new Materialization(rs.next());
            TxnHandler.close(rs, pst, dbConn);
        }
        catch (SQLException ex) {
            LOG.warn("getMaterializationInvalidationInfo failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            throw new MetaException("Unable to retrieve materialization invalidation information due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
        finally {
            TxnHandler.close(rs, pst, dbConn);
        }
        return materialization;
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        LockResponse lockResponse;
        List<String> params;
        ResultSet rs;
        PreparedStatement pst;
        Connection dbConn;
        TxnStore.MutexAPI.LockHandle handle;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquiring lock for materialization rebuild with txnId={} for {}", (Object)JavaUtils.txnIdToString(txnId), (Object)TableName.getDbTable(dbName, tableName));
            }
            handle = null;
            dbConn = null;
            pst = null;
            rs = null;
            this.lockInternal();
            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());
            dbConn = this.getDbConn(2);
            params = Arrays.asList(dbName, tableName);
            String selectQ = "SELECT \"MRL_TXN_ID\" FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_DB_NAME\" = ? AND \"MRL_TBL_NAME\" = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, selectQ, params);
            LOG.debug("Going to execute query <" + selectQ.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            rs = pst.executeQuery();
            if (!rs.next()) break block9;
            LOG.info("Ignoring request to rebuild " + dbName + "/" + tableName + " since it is already being rebuilt");
            LockResponse lockResponse2 = new LockResponse(txnId, LockState.NOT_ACQUIRED);
            TxnHandler.close(rs, pst, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return lockResponse2;
        }
        try {
            String insertQ = "INSERT INTO \"MATERIALIZATION_REBUILD_LOCKS\" (\"MRL_TXN_ID\", \"MRL_DB_NAME\", \"MRL_TBL_NAME\", \"MRL_LAST_HEARTBEAT\") VALUES (" + txnId + ", ?, ?, " + Instant.now().toEpochMilli() + ")";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, insertQ, params);
            LOG.debug("Going to execute update <" + insertQ.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            pst.executeUpdate();
            LOG.debug("Going to commit");
            dbConn.commit();
            lockResponse = new LockResponse(txnId, LockState.ACQUIRED);
        }
        catch (SQLException ex) {
            try {
                LOG.warn("lockMaterializationRebuild failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
                throw new MetaException("Unable to retrieve materialization invalidation information due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                throw throwable;
            }
        }
        TxnHandler.close(rs, pst, dbConn);
        if (handle != null) {
            handle.releaseLocks();
        }
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        try {
            boolean bl;
            PreparedStatement pst;
            Connection dbConn;
            block7: {
                dbConn = null;
                pst = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                String s = "UPDATE \"MATERIALIZATION_REBUILD_LOCKS\" SET \"MRL_LAST_HEARTBEAT\" = " + Instant.now().toEpochMilli() + " WHERE \"MRL_TXN_ID\" = " + txnId + " AND \"MRL_DB_NAME\" = ? AND \"MRL_TBL_NAME\" = ?";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(dbName, tableName));
                LOG.debug("Going to execute update <" + s.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
                int rc = pst.executeUpdate();
                if (rc >= 1) break block7;
                LOG.debug("Going to rollback");
                dbConn.rollback();
                LOG.info("No lock found for rebuild of " + TableName.getDbTable(dbName, tableName) + " when trying to heartbeat");
                boolean bl2 = false;
                TxnHandler.close(null, pst, dbConn);
                this.unlockInternal();
                return bl2;
            }
            try {
                LOG.debug("Going to commit");
                dbConn.commit();
                bl = true;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatLockMaterializationRebuild(" + TableName.getDbTable(dbName, tableName) + ", " + txnId + ")");
                    throw new MetaException("Unable to heartbeat rebuild lock due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
            this.unlockInternal();
            return bl;
        }
        catch (RetryException e2) {
            return this.heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
        }
    }

    @Override
    public long cleanupMaterializationRebuildLocks(ValidTxnList validTxnList, long timeout) throws MetaException {
        long l;
        long cnt = 0L;
        ArrayList<Long> txnIds = new ArrayList<Long>();
        long timeoutTime = Instant.now().toEpochMilli() - timeout;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String selectQ = "SELECT \"MRL_TXN_ID\", \"MRL_LAST_HEARTBEAT\" FROM \"MATERIALIZATION_REBUILD_LOCKS\"";
            LOG.debug("Going to execute query <" + selectQ + ">");
            rs = stmt.executeQuery(selectQ);
            while (rs.next()) {
                long txnId;
                long lastHeartbeat = rs.getLong(2);
                if (lastHeartbeat >= timeoutTime || !validTxnList.isTxnValid(txnId = rs.getLong(1)) && !validTxnList.isTxnAborted(txnId)) continue;
                txnIds.add(txnId);
            }
            if (!txnIds.isEmpty()) {
                String deleteQ = "DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", txnIds) + ") ";
                LOG.debug("Going to execute update <" + deleteQ + ">");
                cnt = stmt.executeUpdate(deleteQ);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            l = cnt;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanupMaterializationRebuildLocks");
                    throw new MetaException("Unable to clean rebuild locks due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.cleanupMaterializationRebuildLocks(validTxnList, timeout);
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        this.unlockInternal();
        return l;
    }

    @Override
    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connAndLockId = this.enqueueLockWithRetry(rqst);
        try {
            return this.checkLockWithRetry(connAndLockId.dbConn, connAndLockId.extLockId, rqst.getTxnid());
        }
        catch (NoSuchLockException e) {
            throw new MetaException("Couldn't find a lock we just created! " + e.getMessage());
        }
    }

    private Optional<TxnType> getOpenTxnTypeAndLock(Statement stmt, long txnId) throws SQLException, MetaException {
        String query = "SELECT \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnId + " AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
        try (ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));){
            Optional<TxnType> optional = rs.next() ? Optional.ofNullable(TxnType.findByValue(rs.getInt(1))) : Optional.empty();
            return optional;
        }
    }

    private ConnectionLockIdPair enqueueLockWithRetry(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connectionLockIdPair;
        boolean success = false;
        Connection dbConn = null;
        Statement stmt = null;
        try {
            Optional<TxnType> txnType;
            this.lockInternal();
            dbConn = this.getDbConn(2);
            long txnid = rqst.getTxnid();
            stmt = dbConn.createStatement();
            if (TxnHandler.isValidTxn(txnid) && !(txnType = this.getOpenTxnTypeAndLock(stmt, txnid)).isPresent()) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                TxnHandler.shouldNeverHappen(txnid);
            }
            this.insertTxnComponents(txnid, rqst, dbConn);
            long tempExtLockId = this.insertHiveLocksWithTemporaryExtLockId(txnid, dbConn, rqst);
            long extLockId = this.getNextLockIdForUpdate(dbConn, stmt);
            this.incrementLockIdAndUpdateHiveLocks(stmt, extLockId, tempExtLockId);
            dbConn.commit();
            success = true;
            connectionLockIdPair = new ConnectionLockIdPair(dbConn, extLockId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "enqueueLockWithRetry(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    if (!success) {
                        TxnHandler.closeDbConn(dbConn);
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.enqueueLockWithRetry(rqst);
            }
        }
        TxnHandler.closeStmt(stmt);
        if (!success) {
            TxnHandler.closeDbConn(dbConn);
        }
        this.unlockInternal();
        return connectionLockIdPair;
    }

    private long getNextLockIdForUpdate(Connection dbConn, Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("SELECT \"NL_NEXT\" FROM \"NEXT_LOCK_ID\"");
        LOG.debug("Going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
            }
            long l = rs.getLong(1);
            return l;
        }
    }

    private void incrementLockIdAndUpdateHiveLocks(Statement stmt, long extLockId, long tempId) throws SQLException {
        String incrCmd = String.format(INCREMENT_NEXT_LOCK_ID_QUERY, extLockId + 1L);
        String updateLocksCmd = String.format(UPDATE_HIVE_LOCKS_EXT_ID_QUERY, extLockId, tempId);
        LOG.debug("Going to execute updates in batch: <" + incrCmd + ">, and <" + updateLocksCmd + ">");
        stmt.addBatch(incrCmd);
        stmt.addBatch(updateLocksCmd);
        stmt.executeBatch();
    }

    private void insertTxnComponents(long txnid, LockRequest rqst, Connection dbConn) throws SQLException {
        if (txnid > 0L) {
            HashMap<Pair<String, String>, Optional<Long>> writeIdCache = new HashMap<Pair<String, String>, Optional<Long>>();
            try (PreparedStatement pstmt = dbConn.prepareStatement(TXN_COMPONENTS_INSERT_QUERY);){
                int insertCounter = 0;
                int batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE);
                for (LockComponent lc : rqst.getComponent()) {
                    if (lc.isSetIsTransactional() && !lc.isIsTransactional() || !this.shouldUpdateTxnComponent(txnid, rqst, lc)) continue;
                    String dbName = TxnHandler.normalizeCase(lc.getDbname());
                    String tblName = TxnHandler.normalizeCase(lc.getTablename());
                    String partName = TxnHandler.normalizePartitionCase(lc.getPartitionname());
                    if (lc.isSetIsDynamicPartitionWrite() && lc.isIsDynamicPartitionWrite()) {
                        partName = null;
                        if (writeIdCache.containsKey(Pair.of(dbName, tblName))) continue;
                    }
                    Optional<Long> writeId = this.getWriteId(writeIdCache, dbName, tblName, txnid, dbConn);
                    pstmt.setLong(1, txnid);
                    pstmt.setString(2, dbName);
                    pstmt.setString(3, tblName);
                    pstmt.setString(4, partName);
                    pstmt.setString(5, OperationType.fromDataOperationType(lc.getOperationType()).getSqlConst());
                    pstmt.setObject(6, writeId.orElse(null));
                    pstmt.addBatch();
                    if (++insertCounter % batchSize != 0) continue;
                    LOG.debug("Executing a batch of <INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)> queries. Batch size: " + batchSize);
                    pstmt.executeBatch();
                }
                if (insertCounter % batchSize != 0) {
                    LOG.debug("Executing a batch of <INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)> queries. Batch size: " + insertCounter % batchSize);
                    pstmt.executeBatch();
                }
            }
        }
    }

    private Optional<Long> getWriteId(Map<Pair<String, String>, Optional<Long>> writeIdCache, String dbName, String tblName, long txnid, Connection dbConn) throws SQLException {
        Pair<String, String> dbAndTable = Pair.of(dbName, tblName);
        if (writeIdCache.containsKey(dbAndTable)) {
            return writeIdCache.get(dbAndTable);
        }
        Optional<Long> writeId = this.getWriteIdFromDb(txnid, dbConn, dbName, tblName);
        writeIdCache.put(dbAndTable, writeId);
        return writeId;
    }

    private Optional<Long> getWriteIdFromDb(long txnid, Connection dbConn, String dbName, String tblName) throws SQLException {
        if (tblName != null) {
            try (PreparedStatement pstmt = dbConn.prepareStatement(SELECT_WRITE_ID_QUERY);){
                pstmt.setString(1, dbName);
                pstmt.setString(2, tblName);
                pstmt.setLong(3, txnid);
                LOG.debug("Going to execute query <SELECT \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_TXNID\" = ?>");
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong(1));
                        return optional;
                    }
                }
            }
        }
        return Optional.empty();
    }

    private boolean shouldUpdateTxnComponent(long txnid, LockRequest rqst, LockComponent lc) {
        if (!lc.isSetOperationType()) {
            return true;
        }
        switch (lc.getOperationType()) {
            case INSERT: {
                return !lc.isSetIsDynamicPartitionWrite() || !lc.isIsDynamicPartitionWrite();
            }
            case UPDATE: 
            case DELETE: {
                return true;
            }
            case SELECT: {
                return false;
            }
            case NO_TXN: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected DataOperationType: " + lc.getOperationType() + " agentInfo=" + rqst.getAgentInfo() + " " + JavaUtils.txnIdToString(txnid));
    }

    private long insertHiveLocksWithTemporaryExtLockId(long txnid, Connection dbConn, LockRequest rqst) throws MetaException, SQLException {
        String lastHB = TxnHandler.isValidTxn(txnid) ? "0" : TxnDbUtil.getEpochFn(dbProduct);
        String insertLocksQuery = String.format(HIVE_LOCKS_INSERT_QRY, lastHB);
        int batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE);
        long intLockId = 0L;
        long tempExtLockId = this.generateTemporaryId();
        try (PreparedStatement pstmt = dbConn.prepareStatement(insertLocksQuery);){
            for (LockComponent lc : rqst.getComponent()) {
                if (lc.isSetOperationType() && lc.getOperationType() == DataOperationType.UNSET && (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST))) {
                    throw new IllegalStateException("Bug: operationType=" + lc.getOperationType() + " for component " + lc + " agentInfo=" + rqst.getAgentInfo());
                }
                String lockType = LockTypeUtil.getEncodingAsStr(lc.getType());
                pstmt.setLong(1, tempExtLockId);
                pstmt.setLong(2, ++intLockId);
                pstmt.setLong(3, txnid);
                pstmt.setString(4, TxnHandler.normalizeCase(lc.getDbname()));
                pstmt.setString(5, TxnHandler.normalizeCase(lc.getTablename()));
                pstmt.setString(6, TxnHandler.normalizePartitionCase(lc.getPartitionname()));
                pstmt.setString(7, Character.toString('w'));
                pstmt.setString(8, lockType);
                pstmt.setString(9, rqst.getUser());
                pstmt.setString(10, rqst.getHostname());
                pstmt.setString(11, rqst.getAgentInfo());
                pstmt.addBatch();
                if (intLockId % (long)batchSize != 0L) continue;
                LOG.debug("Executing HIVE_LOCKS inserts in batch. Batch size: " + batchSize);
                pstmt.executeBatch();
            }
            if (intLockId % (long)batchSize != 0L) {
                LOG.debug("Executing HIVE_LOCKS inserts in batch. Batch size: " + intLockId % (long)batchSize);
                pstmt.executeBatch();
            }
        }
        return tempExtLockId;
    }

    private long generateTemporaryId() {
        return -1L * ThreadLocalRandom.current().nextLong();
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private static String normalizePartitionCase(String s) {
        if (s == null) {
            return null;
        }
        Map<String, String> map = Splitter.on("/").withKeyValueSeparator('=').split(s);
        return FileUtils.makePartName(new ArrayList<String>(map.keySet()), new ArrayList<String>(map.values()));
    }

    private LockResponse checkLockWithRetry(Connection dbConn, long extLockId, long txnId) throws NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        try {
            this.lockInternal();
            if (dbConn.isClosed()) {
                dbConn = this.getDbConn(2);
            }
            lockResponse = this.checkLock(dbConn, extLockId, txnId);
            this.unlockInternal();
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLockWithRetry(" + extLockId + "," + txnId + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.unlockInternal();
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLockWithRetry(dbConn, extLockId, txnId);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return lockResponse;
    }

    @Override
    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        Connection dbConn = null;
        long extLockId = rqst.getLockid();
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            LockInfo info = this.getTxnIdFromLockId(dbConn, extLockId);
            if (info == null) {
                throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString(extLockId));
            }
            if (info.txnId > 0L) {
                this.heartbeatTxn(dbConn, info.txnId);
            } else {
                this.heartbeatLock(dbConn, extLockId);
            }
            lockResponse = this.checkLock(dbConn, extLockId, info.txnId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLock(" + rqst + " )");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLock(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, MetaException {
        try {
            block9: {
                dbConn = null;
                stmt = null;
                extLockId = rqst.getLockid();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                s = "DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + " AND (\"HL_TXNID\" = 0 OR (\"HL_TXNID\" <> 0 AND \"HL_LOCK_STATE\" = '" + 'w' + "'))";
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                rc = stmt.executeUpdate(s);
                if (rc >= 1) ** GOTO lbl30
                TxnHandler.LOG.debug("Going to rollback");
                dbConn.rollback();
                info = this.getTxnIdFromLockId(dbConn, extLockId);
                if (info != null) break block9;
                TxnHandler.LOG.info("No lock in w mode found for unlock(" + JavaUtils.lockIdToString(rqst.getLockid()) + ")");
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                return;
            }
            try {
                if (LockInfo.access$300(info) != 0L) {
                    msg = "Unlocking locks associated with transaction not permitted.  " + info;
                    TxnHandler.LOG.error(msg);
                    throw new TxnOpenException(msg);
                }
                if (LockInfo.access$300(info) == 0L) {
                    msg = "Found lock in unexpected state " + info;
                    TxnHandler.LOG.error(msg);
                    throw new MetaException(msg);
                }
lbl30:
                // 3 sources

                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "unlock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var10_12) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw var10_12;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.unlock(rqst);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            ShowLocksResponse rsp = new ShowLocksResponse();
            ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
            ArrayList<LockInfoExt> sortedList = new ArrayList<LockInfoExt>();
            PreparedStatement pst = null;
            try {
                String whereClause;
                dbConn = this.getDbConn(2);
                String s = "SELECT \"HL_LOCK_EXT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_LAST_HEARTBEAT\", \"HL_ACQUIRED_AT\", \"HL_USER\", \"HL_HOST\", \"HL_LOCK_INT_ID\",\"HL_BLOCKEDBY_EXT_ID\", \"HL_BLOCKEDBY_INT_ID\", \"HL_AGENT_INFO\" FROM \"HIVE_LOCKS\"";
                String dbName = rqst.getDbname();
                String tableName = rqst.getTablename();
                String partName = rqst.getPartname();
                ArrayList<String> params = new ArrayList<String>();
                StringBuilder filter = new StringBuilder();
                if (dbName != null && !dbName.isEmpty()) {
                    filter.append("\"HL_DB\"=?");
                    params.add(dbName);
                }
                if (tableName != null && !tableName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_TABLE\"=?");
                    params.add(tableName);
                }
                if (partName != null && !partName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_PARTITION\"=?");
                    params.add(partName);
                }
                if (rqst.isSetTxnid()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_TXNID\"=" + rqst.getTxnid());
                }
                if (!(whereClause = filter.toString()).isEmpty()) {
                    s = s + " where " + whereClause;
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    ShowLocksResponseElement e = new ShowLocksResponseElement();
                    e.setLockid(rs.getLong(1));
                    long txnid = rs.getLong(2);
                    if (!rs.wasNull()) {
                        e.setTxnid(txnid);
                    }
                    e.setDbname(rs.getString(3));
                    e.setTablename(rs.getString(4));
                    String partition = rs.getString(5);
                    if (partition != null) {
                        e.setPartname(partition);
                    }
                    switch (rs.getString(6).charAt(0)) {
                        case 'a': {
                            e.setState(LockState.ACQUIRED);
                            break;
                        }
                        case 'w': {
                            e.setState(LockState.WAITING);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                        }
                    }
                    char lockChar = rs.getString(7).charAt(0);
                    LockType lockType = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
                    e.setType(lockType);
                    e.setLastheartbeat(rs.getLong(8));
                    long acquiredAt = rs.getLong(9);
                    if (!rs.wasNull()) {
                        e.setAcquiredat(acquiredAt);
                    }
                    e.setUser(rs.getString(10));
                    e.setHostname(rs.getString(11));
                    e.setLockIdInternal(rs.getLong(12));
                    long id = rs.getLong(13);
                    if (!rs.wasNull()) {
                        e.setBlockedByExtId(id);
                    }
                    id = rs.getLong(14);
                    if (!rs.wasNull()) {
                        e.setBlockedByIntId(id);
                    }
                    e.setAgentInfo(rs.getString(15));
                    sortedList.add(new LockInfoExt(e));
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(dbConn, e, "showLocks(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(pst);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(pst);
            TxnHandler.closeDbConn(dbConn);
            Collections.sort(sortedList, new LockInfoComparator());
            for (LockInfoExt lockInfoExt : sortedList) {
                elems.add(lockInfoExt.e);
            }
            rsp.setLocks(elems);
            return rsp;
        }
        catch (RetryException e) {
            return this.showLocks(rqst);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "heartbeat(" + ids + ")");
                throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.heartbeat(ids);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        try {
            HeartbeatTxnRangeResponse heartbeatTxnRangeResponse;
            HashSet<Long> aborted;
            HashSet<Long> nosuch;
            HeartbeatTxnRangeResponse rsp;
            Statement stmt;
            Connection dbConn;
            block13: {
                dbConn = null;
                stmt = null;
                rsp = new HeartbeatTxnRangeResponse();
                nosuch = new HashSet<Long>();
                aborted = new HashSet<Long>();
                rsp.setNosuch(nosuch);
                rsp.setAborted(aborted);
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                int numTxnsToHeartbeat = (int)(rqst.getMax() - rqst.getMin() + 1L);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxnsToHeartbeat);
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    txnIds.add(txn);
                }
                TxnUtils.buildQueryWithINClause(this.conf, queries, new StringBuilder("UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnDbUtil.getEpochFn(dbProduct) + " WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " AND "), new StringBuilder(""), txnIds, "\"TXN_ID\"", true, false);
                int updateCnt = 0;
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    updateCnt += stmt.executeUpdate(query);
                }
                if (updateCnt != numTxnsToHeartbeat) break block13;
                dbConn.commit();
                HeartbeatTxnRangeResponse heartbeatTxnRangeResponse2 = rsp;
                TxnHandler.close(null, stmt, dbConn);
                return heartbeatTxnRangeResponse2;
            }
            try {
                dbConn.rollback();
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    try {
                        this.heartbeatTxn(dbConn, txn);
                        continue;
                    }
                    catch (NoSuchTxnException e) {
                        nosuch.add(txn);
                        continue;
                    }
                    catch (TxnAbortedException e) {
                        aborted.add(txn);
                    }
                }
                heartbeatTxnRangeResponse = rsp;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatTxnRange(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            return heartbeatTxnRangeResponse;
        }
        catch (RetryException e2) {
            return this.heartbeatTxnRange(rqst);
        }
    }

    long generateCompactionQueueId(Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("SELECT \"NCQ_NEXT\" FROM \"NEXT_COMPACTION_QUEUE_ID\"");
        LOG.debug("going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                throw new IllegalStateException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
            }
            long id = rs.getLong(1);
            s = "UPDATE \"NEXT_COMPACTION_QUEUE_ID\" SET \"NCQ_NEXT\" = " + (id + 1L);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            long l = id;
            return l;
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public long getTxnIdForWriteId(String dbName, String tblName, long writeId) throws MetaException {
        long l;
        Connection dbConn = null;
        PreparedStatement pst = null;
        try {
            dbConn = this.getDbConn(2);
            String query = "SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_WRITEID\" = " + writeId;
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, Arrays.asList(dbName, tblName));
            LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
            ResultSet rs = pst.executeQuery();
            long txnId = -1L;
            if (rs.next()) {
                txnId = rs.getLong(1);
            }
            dbConn.rollback();
            l = txnId;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getTxnIdForWriteId");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getTxnIdForWriteId(dbName, tblName, writeId);
            }
        }
        TxnHandler.close(null, pst, dbConn);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest rqst) throws MetaException {
        try {
            CompactionResponse compactionResponse;
            ResultSet rs;
            ArrayList<String> params;
            long id;
            TxnStore.MutexAPI.LockHandle handle;
            PreparedStatement pst;
            Statement stmt;
            Connection dbConn;
            block23: {
                dbConn = null;
                stmt = null;
                pst = null;
                handle = null;
                this.lockInternal();
                handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                id = this.generateCompactionQueueId(stmt);
                params = new ArrayList<String>();
                StringBuilder sb = new StringBuilder("SELECT \"CQ_ID\", \"CQ_STATE\" FROM \"COMPACTION_QUEUE\" WHERE").append(" \"CQ_STATE\" IN(").append(TxnHandler.quoteChar('i')).append(",").append(TxnHandler.quoteChar('w')).append(") AND \"CQ_DATABASE\"=?").append(" AND \"CQ_TABLE\"=?").append(" AND ");
                params.add(rqst.getDbname());
                params.add(rqst.getTablename());
                if (rqst.getPartitionname() == null) {
                    sb.append("\"CQ_PARTITION\" is null");
                } else {
                    sb.append("\"CQ_PARTITION\"=?");
                    params.add(rqst.getPartitionname());
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, sb.toString(), params);
                LOG.debug("Going to execute query <" + sb.toString() + ">");
                rs = pst.executeQuery();
                if (!rs.next()) break block23;
                long enqueuedId = rs.getLong(1);
                String state = TxnHandler.compactorStateToResponse(rs.getString(2).charAt(0));
                LOG.info("Ignoring request to compact " + rqst.getDbname() + "/" + rqst.getTablename() + "/" + rqst.getPartitionname() + " since it is already " + TxnHandler.quoteString(state) + " with id=" + enqueuedId);
                CompactionResponse compactionResponse2 = new CompactionResponse(enqueuedId, state, false);
                TxnHandler.closeStmt(pst);
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                return compactionResponse2;
            }
            try {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                params.clear();
                StringBuilder buf = new StringBuilder("INSERT INTO \"COMPACTION_QUEUE\" (\"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", ");
                String partName = rqst.getPartitionname();
                if (partName != null) {
                    buf.append("\"CQ_PARTITION\", ");
                }
                buf.append("\"CQ_STATE\", \"CQ_TYPE\", \"CQ_ENQUEUE_TIME\"");
                if (rqst.getProperties() != null) {
                    buf.append(", \"CQ_TBLPROPERTIES\"");
                }
                if (rqst.getRunas() != null) {
                    buf.append(", \"CQ_RUN_AS\"");
                }
                buf.append(") values (");
                buf.append(id);
                buf.append(", ?");
                buf.append(", ?");
                buf.append(", ");
                params.add(rqst.getDbname());
                params.add(rqst.getTablename());
                if (partName != null) {
                    buf.append("?, '");
                    params.add(partName);
                } else {
                    buf.append("'");
                }
                buf.append('i');
                buf.append("', '");
                switch (rqst.getType()) {
                    case MAJOR: {
                        buf.append('a');
                        break;
                    }
                    case MINOR: {
                        buf.append('i');
                        break;
                    }
                    default: {
                        LOG.debug("Going to rollback");
                        dbConn.rollback();
                        throw new MetaException("Unexpected compaction type " + rqst.getType().toString());
                    }
                }
                buf.append("',");
                buf.append(TxnDbUtil.getEpochFn(dbProduct));
                if (rqst.getProperties() != null) {
                    buf.append(", ?");
                    params.add(new StringableMap(rqst.getProperties()).toString());
                }
                if (rqst.getRunas() != null) {
                    buf.append(", ?");
                    params.add(rqst.getRunas());
                }
                buf.append(")");
                String s = buf.toString();
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute update <" + s + ">");
                pst.executeUpdate();
                LOG.debug("Going to commit");
                dbConn.commit();
                compactionResponse = new CompactionResponse(id, "initiated", true);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "COMPACT(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(pst);
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(pst);
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return compactionResponse;
        }
        catch (RetryException e2) {
            return this.compact(rqst);
        }
    }

    private static String compactorStateToResponse(char s) {
        switch (s) {
            case 'i': {
                return "initiated";
            }
            case 'w': {
                return "working";
            }
            case 'r': {
                return "ready for cleaning";
            }
            case 'f': {
                return "failed";
            }
            case 's': {
                return "succeeded";
            }
            case 'a': {
                return "attempted";
            }
        }
        return Character.toString(s);
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        ShowCompactResponse response = new ShowCompactResponse(new ArrayList<ShowCompactResponseElement>());
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "SELECT \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_WORKER_ID\", \"CQ_START\", -1 \"CC_END\", \"CQ_RUN_AS\", \"CQ_HADOOP_JOB_ID\", \"CQ_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\" FROM \"COMPACTION_QUEUE\" UNION ALL SELECT \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HADOOP_JOB_ID\", \"CC_ID\", \"CC_ERROR_MESSAGE\", \"CC_ENQUEUE_TIME\" FROM \"COMPLETED_COMPACTIONS\"";
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    long endTime;
                    ShowCompactResponseElement e = new ShowCompactResponseElement();
                    e.setDbname(rs.getString(1));
                    e.setTablename(rs.getString(2));
                    e.setPartitionname(rs.getString(3));
                    e.setState(TxnHandler.compactorStateToResponse(rs.getString(4).charAt(0)));
                    switch (rs.getString(5).charAt(0)) {
                        case 'a': {
                            e.setType(CompactionType.MAJOR);
                            break;
                        }
                        case 'i': {
                            e.setType(CompactionType.MINOR);
                            break;
                        }
                    }
                    e.setWorkerid(rs.getString(6));
                    long start = rs.getLong(7);
                    if (!rs.wasNull()) {
                        e.setStart(start);
                    }
                    if ((endTime = rs.getLong(8)) != -1L) {
                        e.setEndTime(endTime);
                    }
                    e.setRunAs(rs.getString(9));
                    e.setHadoopJobId(rs.getString(10));
                    e.setId(rs.getLong(11));
                    e.setErrorMessage(rs.getString(12));
                    long enqueueTime = rs.getLong(13);
                    if (!rs.wasNull()) {
                        e.setEnqueueTime(enqueueTime);
                    }
                    response.addToCompacts(e);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "showCompact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            return response;
        }
        catch (RetryException e) {
            return this.showCompact(rqst);
        }
    }

    private static void shouldNeverHappen(long txnid) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid));
    }

    private static void shouldNeverHappen(long txnid, long extLockId, long intLockId) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid) + " " + JavaUtils.lockIdToString(extLockId) + " " + intLockId);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                Optional<TxnType> txnType = this.getOpenTxnTypeAndLock(stmt, rqst.getTxnid());
                if (!txnType.isPresent()) {
                    TxnHandler.ensureValidTxn(dbConn, rqst.getTxnid(), stmt);
                    TxnHandler.shouldNeverHappen(rqst.getTxnid());
                }
                OperationType ot = OperationType.UPDATE;
                if (rqst.isSetOperationType()) {
                    ot = OperationType.fromDataOperationType(rqst.getOperationType());
                }
                Long writeId = rqst.getWriteid();
                try (PreparedStatement pstmt = dbConn.prepareStatement(TXN_COMPONENTS_INSERT_QUERY);){
                    int insertCounter = 0;
                    int batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_VALUES_CLAUSE);
                    for (String partName : rqst.getPartitionnames()) {
                        pstmt.setLong(1, rqst.getTxnid());
                        pstmt.setString(2, TxnHandler.normalizeCase(rqst.getDbname()));
                        pstmt.setString(3, TxnHandler.normalizeCase(rqst.getTablename()));
                        pstmt.setString(4, partName);
                        pstmt.setString(5, ot.getSqlConst());
                        pstmt.setObject(6, writeId);
                        pstmt.addBatch();
                        if (++insertCounter % batchSize != 0) continue;
                        LOG.debug("Executing a batch of <INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)> queries. Batch size: " + batchSize);
                        pstmt.executeBatch();
                    }
                    if (insertCounter % batchSize != 0) {
                        LOG.debug("Executing a batch of <INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)> queries. Batch size: " + insertCounter % batchSize);
                        pstmt.executeBatch();
                    }
                }
                pstmt = dbConn.prepareStatement(TXN_COMPONENTS_DP_DELETE_QUERY);
                var8_10 = null;
                try {
                    pstmt.setLong(1, rqst.getTxnid());
                    pstmt.execute();
                }
                catch (Throwable throwable) {
                    var8_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (pstmt != null) {
                        if (var8_10 != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable) {
                                var8_10.addSuppressed(throwable);
                            }
                        } else {
                            pstmt.close();
                        }
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "addDynamicPartitions(" + rqst + ")");
                    throw new MetaException("Unable to insert into from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.addDynamicPartitions(rqst);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRename(String oldCatName, String oldDbName, String oldTabName, String oldPartName, String newCatName, String newDbName, String newTabName, String newPartName) throws MetaException {
        block33: {
            String callSig = "onRename(" + oldCatName + "," + oldDbName + "," + oldTabName + "," + oldPartName + "," + newCatName + "," + newDbName + "," + newTabName + "," + newPartName + ")";
            if (newPartName != null) assert (oldPartName != null && oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newTabName != null) assert (oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newDbName != null) assert (oldDbName != null && oldCatName != null) : callSig;
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    ArrayList<String> queries = new ArrayList<String>();
                    String update = "UPDATE \"TXN_COMPONENTS\" SET ";
                    String where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"TC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"TC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"TC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"TC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"TC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"TC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPLETED_TXN_COMPONENTS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CTC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CTC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CTC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CTC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CTC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CTC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"HIVE_LOCKS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"HL_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"HL_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"HL_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"HL_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"HL_DB\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"HL_DB\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPACTION_QUEUE\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CQ_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CQ_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CQ_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CQ_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CQ_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CQ_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPLETED_COMPACTIONS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"WRITE_SET\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"WS_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"WS_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"WS_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"WS_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"WS_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"WS_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"TXN_TO_WRITE_ID\" SET ";
                    where = " WHERE ";
                    if (oldTabName != null) {
                        update = update + "\"T2W_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"T2W_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"T2W_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"T2W_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"NEXT_WRITE_ID\" SET ";
                    where = " WHERE ";
                    if (oldTabName != null) {
                        update = update + "\"NWI_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"NWI_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"NWI_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"NWI_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    for (String query : queries) {
                        LOG.debug("Going to execute update <" + query + ">");
                        stmt.executeUpdate(query);
                    }
                    LOG.debug("Going to commit: " + callSig);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback: " + callSig);
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, callSig);
                        if (!e.getMessage().contains("does not exist")) {
                            throw new MetaException("Unable to " + callSig + ":" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                        LOG.warn("Cannot perform " + callSig + " since metastore table does not exist");
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    break block33;
                }
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
            }
            catch (RetryException e) {
                this.onRename(oldCatName, oldDbName, oldTabName, oldPartName, newCatName, newDbName, newTabName, newPartName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException {
        int n;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "SELECT COUNT(*) FROM \"HIVE_LOCKS\"";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            n = rc;
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, dbConn);
            throw throwable;
        }
        TxnHandler.close(rs, stmt, dbConn);
        return n;
    }

    @Override
    public long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    Connection getDbConn(int isolationLevel) throws SQLException {
        return this.getDbConn(isolationLevel, connPool);
    }

    private Connection getDbConn(int isolationLevel, DataSource connPool) throws SQLException {
        int rc = doRetryOnConnPool ? 10 : 1;
        Connection dbConn = null;
        while (true) {
            try {
                dbConn = connPool.getConnection();
                dbConn.setAutoCommit(false);
                dbConn.setTransactionIsolation(isolationLevel);
                return dbConn;
            }
            catch (SQLException e) {
                TxnHandler.closeDbConn(dbConn);
                if (--rc <= 0) {
                    throw e;
                }
                LOG.error("There is a problem with a connection from the pool, retrying(rc=" + rc + "): " + TxnHandler.getMessage(e), (Throwable)e);
                continue;
            }
            break;
        }
    }

    static void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(e));
        }
    }

    static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(ex));
        }
    }

    static void close(ResultSet rs, Statement stmt, Connection dbConn) {
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        TxnHandler.closeDbConn(dbConn);
    }

    private boolean waitForRetry(String caller, String errMsg) {
        if (this.retryNum++ < this.retryLimit) {
            LOG.warn("Retryable error detected in " + caller + ".  Will wait " + this.retryInterval + "ms and retry up to " + (this.retryLimit - this.retryNum + 1) + " times.  Error: " + errMsg);
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        LOG.error("Fatal error in " + caller + ". Retry limit (" + this.retryLimit + ") reached. Last error: " + errMsg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRetryable(Connection conn, SQLException e, String caller) throws RetryException, MetaException {
        boolean sendRetrySignal;
        block12: {
            sendRetrySignal = false;
            try {
                if (dbProduct == null) {
                    throw new IllegalStateException("DB Type not determined yet.");
                }
                if (DatabaseProduct.isDeadlock(dbProduct, e)) {
                    if (this.deadlockCnt++ < 10) {
                        long waitInterval = this.deadlockRetryInterval * (long)this.deadlockCnt;
                        LOG.warn("Deadlock detected in " + caller + ". Will wait " + waitInterval + "ms try again up to " + (10 - this.deadlockCnt + 1) + " times.");
                        try {
                            Thread.sleep(waitInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block12;
                    }
                    LOG.error("Too many repeated deadlocks in " + caller + ", giving up.");
                    break block12;
                }
                if (TxnHandler.isRetryable(this.conf, e)) {
                    sendRetrySignal = this.waitForRetry(caller, e.getMessage());
                } else {
                    LOG.info("Non-retryable error in " + caller + " : " + TxnHandler.getMessage(e));
                }
            }
            finally {
                if (!sendRetrySignal) {
                    this.deadlockCnt = 0;
                    this.retryNum = 0;
                }
            }
        }
        if (sendRetrySignal) {
            throw new RetryException();
        }
    }

    protected long getDbTime(Connection conn) throws MetaException {
        Statement stmt = null;
        try {
            String s;
            stmt = conn.createStatement();
            switch (dbProduct) {
                case DERBY: {
                    s = "values current_timestamp";
                    break;
                }
                case MYSQL: 
                case POSTGRES: 
                case SQLSERVER: {
                    s = "select current_timestamp";
                    break;
                }
                case ORACLE: {
                    s = "select current_timestamp from dual";
                    break;
                }
                default: {
                    String msg = "Unknown database product: " + dbProduct.toString();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("No results from date query");
            }
            long l = rs.getTimestamp(1).getTime();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to determine current time: " + e.getMessage();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    protected String isWithinCheckInterval(String expr, long interval) throws MetaException {
        String condition;
        switch (dbProduct) {
            case DERBY: {
                condition = " {fn TIMESTAMPDIFF(sql_tsi_second, " + expr + ", current_timestamp)} <= " + interval;
                break;
            }
            case MYSQL: 
            case POSTGRES: {
                condition = expr + " >= current_timestamp - interval '" + interval + "' second";
                break;
            }
            case SQLSERVER: {
                condition = "DATEDIFF(second, " + expr + ", current_timestamp) <= " + interval;
                break;
            }
            case ORACLE: {
                condition = expr + " >= current_timestamp - numtodsinterval(" + interval + " , 'second')";
                break;
            }
            default: {
                String msg = "Unknown database product: " + dbProduct.toString();
                LOG.error(msg);
                throw new MetaException(msg);
            }
        }
        return condition;
    }

    protected String getIdentifierQuoteString(Connection conn) throws SQLException {
        if (this.identifierQuoteString == null) {
            this.identifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
        }
        return this.identifierQuoteString;
    }

    private void determineDatabaseProduct(Connection conn) {
        if (dbProduct != null) {
            return;
        }
        try {
            String s = conn.getMetaData().getDatabaseProductName();
            dbProduct = DatabaseProduct.determineDatabaseProduct(s);
            if (dbProduct == DatabaseProduct.OTHER) {
                String msg = "Unrecognized database product name <" + s + ">";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        catch (SQLException e) {
            String msg = "Unable to get database product name";
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private void checkQFileTestHack() {
        block3: {
            boolean hackOn;
            boolean bl = hackOn = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
            if (hackOn) {
                LOG.info("Hacking in canned values for transaction manager");
                TxnDbUtil.setConfValues(this.conf);
                try {
                    TxnDbUtil.prepDb(this.conf);
                }
                catch (Exception e) {
                    if (e.getMessage() == null || e.getMessage().contains("already exists")) break block3;
                    throw new RuntimeException("Unable to set up transaction database for testing: " + e.getMessage(), e);
                }
            }
        }
    }

    private int abortTxns(Connection dbConn, List<Long> txnids, boolean isStrict) throws SQLException, MetaException {
        return this.abortTxns(dbConn, txnids, false, isStrict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTxns(Connection dbConn, List<Long> txnids, boolean checkHeartbeat, boolean isStrict) throws SQLException, MetaException {
        Statement stmt = null;
        if (txnids.isEmpty()) {
            return 0;
        }
        try {
            stmt = dbConn.createStatement();
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("UPDATE \"TXNS\" SET \"TXN_STATE\" = ").append((Object)TxnStatus.ABORTED).append(" WHERE \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" AND ");
            if (checkHeartbeat) {
                suffix.append(" AND \"TXN_LAST_HEARTBEAT\" < ").append(TxnDbUtil.getEpochFn(dbProduct)).append("-").append(this.timeout);
            }
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"TXN_ID\"", true, false);
            int numUpdateQueries = queries.size();
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("DELETE FROM \"MIN_HISTORY_LEVEL\" WHERE ");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"MHL_TXNID\"", false, false);
            prefix.setLength(0);
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE ");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"HL_TXNID\"", false, false);
            List<Integer> affectedRowsByQuery = TxnDbUtil.executeQueriesInBatch(stmt, queries, this.conf);
            LOG.info("Removed aborted transactions: (" + txnids + ") from MIN_HISTORY_LEVEL");
            int n = this.getUpdateCount(numUpdateQueries, affectedRowsByQuery);
            return n;
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    private int getUpdateCount(int numUpdateQueries, List<Integer> affectedRowsByQuery) {
        return affectedRowsByQuery.stream().limit(numUpdateQueries).mapToInt(Integer::intValue).sum();
    }

    private static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RetrySemantics.SafeToRetry(value={"See @SafeToRetry"})
    private LockResponse checkLock(Connection dbConn, long extLockId, long txnId) throws NoSuchLockException, TxnAbortedException, MetaException, SQLException {
        List<LockInfo> locksBeingChecked;
        LockResponse response;
        ResultSet rs;
        Statement stmt;
        block12: {
            LockResponse lockResponse;
            stmt = null;
            rs = null;
            response = new LockResponse();
            boolean isPartOfDynamicPartitionInsert = true;
            try {
                locksBeingChecked = this.getLockInfoFromLockId(dbConn, extLockId);
                response.setLockid(extLockId);
                ArrayList<LockInfo> writeSet = new ArrayList<LockInfo>();
                for (LockInfo lockInfo : locksBeingChecked) {
                    if (isPartOfDynamicPartitionInsert || lockInfo.type != LockType.SHARED_WRITE) continue;
                    writeSet.add(lockInfo);
                }
                if (!writeSet.isEmpty()) {
                    if (((LockInfo)writeSet.get(0)).txnId == 0L) {
                        throw new IllegalStateException("Found Write lock for " + JavaUtils.lockIdToString(extLockId) + " but no txnid");
                    }
                    stmt = dbConn.createStatement();
                    StringBuilder sb = new StringBuilder(" \"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\", \"WS_TXNID\", \"WS_COMMIT_ID\" FROM \"WRITE_SET\" WHERE WS_COMMIT_ID >= " + ((LockInfo)writeSet.get(0)).txnId + " AND (");
                    for (LockInfo info : writeSet) {
                        sb.append("(\"WS_DATABASE\" = ").append(TxnHandler.quoteString(info.db)).append(" AND \"WS_TABLE\" = ").append(TxnHandler.quoteString(info.table)).append(" AND \"WS_PARTITION\" ").append(info.partition == null ? "IS NULL" : "= " + TxnHandler.quoteString(info.partition)).append(") OR ");
                    }
                    sb.setLength(sb.length() - 4);
                    sb.append(")");
                    rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, sb.toString()));
                    if (rs.next()) {
                        void var13_15;
                        String string = rs.getString(1) + '/' + rs.getString(2);
                        String partName = rs.getString(3);
                        if (partName != null) {
                            String string2 = string + '/' + partName;
                        }
                        String msg = "Aborting " + JavaUtils.txnIdToString(((LockInfo)writeSet.get(0)).txnId) + " since a concurrent committed transaction [" + JavaUtils.txnIdToString(rs.getLong(4)) + "," + rs.getLong(5) + "] has already updated resource '" + (String)var13_15 + "'";
                        LOG.info(msg);
                        if (this.abortTxns(dbConn, Collections.singletonList(((LockInfo)writeSet.get(0)).txnId), true) != 1) {
                            throw new IllegalStateException(msg + " FAILED!");
                        }
                        dbConn.commit();
                        throw new TxnAbortedException(msg);
                    }
                    TxnHandler.close(rs, stmt, null);
                }
                String queryStr = " \"EX\".*, \"REQ\".\"HL_LOCK_INT_ID\" AS \"REQ_LOCK_INT_ID\" FROM ( SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" < " + extLockId + ") \"EX\" INNER JOIN ( SELECT \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + ") \"REQ\" ON \"EX\".\"HL_DB\" = \"REQ\".\"HL_DB\" AND (\"EX\".\"HL_TABLE\" IS NULL OR \"REQ\".\"HL_TABLE\" IS NULL OR \"EX\".\"HL_TABLE\" = \"REQ\".\"HL_TABLE\" AND (\"EX\".\"HL_PARTITION\" IS NULL OR \"REQ\".\"HL_PARTITION\" IS NULL OR \"EX\".\"HL_PARTITION\" = \"REQ\".\"HL_PARTITION\")) WHERE (\"REQ\".\"HL_TXNID\" = 0 OR \"EX\".\"HL_TXNID\" != \"REQ\".\"HL_TXNID\") AND ";
                String[] stringArray = new String[]{" \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NULL AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"REQ\".\"HL_TABLE\" IS NOT NULL)", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedWrite() + " AND \"EX\".\"HL_LOCK_TYPE\" IN (" + LockTypeUtil.exclWrite() + "," + LockTypeUtil.exclusive() + ")", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclWrite() + " AND \"EX\".\"HL_LOCK_TYPE\"!=" + LockTypeUtil.sharedRead(), " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NOT NULL AND \"REQ\".\"HL_TABLE\" IS NULL)"};
                ArrayList<String> subQuery = new ArrayList<String>();
                for (String subCond : stringArray) {
                    subQuery.add("(" + sqlGenerator.addLimitClause(1, queryStr + subCond) + ")");
                }
                String query = String.join((CharSequence)" UNION ALL ", subQuery);
                stmt = dbConn.createStatement();
                LOG.debug("Going to execute query <" + query + ">");
                rs = stmt.executeQuery(query);
                if (!rs.next()) break block12;
                LockInfo blockedBy = new LockInfo(rs);
                long intLockId = rs.getLong("REQ_LOCK_INT_ID");
                String sqlText = "UPDATE \"HIVE_LOCKS\" SET \"HL_BLOCKEDBY_EXT_ID\" = " + blockedBy.extLockId + ", \"HL_BLOCKEDBY_INT_ID\" = " + blockedBy.intLockId + " WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + " AND \"HL_LOCK_INT_ID\" = " + intLockId;
                LOG.debug("Executing sql: " + sqlText);
                int updCnt = stmt.executeUpdate(sqlText);
                if (updCnt != 1) {
                    TxnHandler.shouldNeverHappen(txnId, extLockId, intLockId);
                }
                LOG.debug("Going to commit");
                dbConn.commit();
                LOG.debug("Lock({} intLockId:{} {}) is blocked by Lock({}})", new Object[]{JavaUtils.lockIdToString(extLockId), intLockId, JavaUtils.txnIdToString(txnId), blockedBy});
                response.setState(LockState.WAITING);
                lockResponse = response;
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, stmt, null);
                throw throwable;
            }
            TxnHandler.close(rs, stmt, null);
            return lockResponse;
        }
        this.acquire(dbConn, stmt, locksBeingChecked);
        LOG.debug("Going to commit");
        dbConn.commit();
        response.setState(LockState.ACQUIRED);
        TxnHandler.close(rs, stmt, null);
        return response;
    }

    private void acquire(Connection dbConn, Statement stmt, List<LockInfo> locksBeingChecked) throws SQLException, NoSuchLockException, MetaException {
        if (locksBeingChecked == null || locksBeingChecked.isEmpty()) {
            return;
        }
        long txnId = locksBeingChecked.get(0).txnId;
        long extLockId = locksBeingChecked.get(0).extLockId;
        String s = "UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_STATE\" = 'a', \"HL_LAST_HEARTBEAT\" = " + (TxnHandler.isValidTxn(txnId) ? Integer.valueOf(0) : TxnDbUtil.getEpochFn(dbProduct)) + ",\"HL_ACQUIRED_AT\" = " + TxnDbUtil.getEpochFn(dbProduct) + ",\"HL_BLOCKEDBY_EXT_ID\"=NULL,\"HL_BLOCKEDBY_INT_ID\"=NULL WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
        LOG.debug("Going to execute update <" + s + ">");
        int rc = stmt.executeUpdate(s);
        if (rc < locksBeingChecked.size()) {
            LOG.debug("Going to rollback acquire(Connection dbConn, Statement stmt, List<LockInfo> locksBeingChecked)");
            dbConn.rollback();
            StringBuilder sb = new StringBuilder("No such lock(s): (" + JavaUtils.lockIdToString(extLockId) + ":");
            ResultSet rs = stmt.executeQuery("SELECT \"HL_LOCK_INT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId);
            block0: while (rs.next()) {
                int intLockId = rs.getInt(1);
                for (int idx = 0; idx < locksBeingChecked.size(); ++idx) {
                    LockInfo expectedLock = locksBeingChecked.get(idx);
                    if (expectedLock == null || expectedLock.intLockId != (long)intLockId) continue;
                    locksBeingChecked.set(idx, null);
                    continue block0;
                }
            }
            for (LockInfo expectedLock : locksBeingChecked) {
                if (expectedLock == null) continue;
                sb.append(expectedLock.intLockId).append(",");
            }
            sb.append(") ").append(JavaUtils.txnIdToString(txnId));
            TxnHandler.close(rs);
            throw new NoSuchLockException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException, MetaException {
        if (extLockId == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "UPDATE \"HIVE_LOCKS\" SET \"HL_LAST_HEARTBEAT\" = " + TxnDbUtil.getEpochFn(dbProduct) + " WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString(extLockId));
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException, MetaException {
        if (txnid == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnDbUtil.getEpochFn(dbProduct) + " WHERE \"TXN_ID\" = " + txnid + " AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                LOG.warn("Can neither heartbeat txn nor confirm it as invalid.");
                dbConn.rollback();
                throw new NoSuchTxnException("No such txn: " + txnid);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    private TxnStatus findTxnState(long txnid, Statement stmt) throws SQLException, MetaException {
        String s = "SELECT \"TXN_STATE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = sqlGenerator.addLimitClause(1, "1 FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_TXNID\" = " + txnid);
                LOG.debug("Going to execute query <" + s + ">");
                try (ResultSet rs2 = stmt.executeQuery(s);){
                    if (rs2.next()) {
                        TxnStatus txnStatus = TxnStatus.COMMITTED;
                        return txnStatus;
                    }
                }
                TxnStatus txnStatus = TxnStatus.UNKNOWN;
                return txnStatus;
            }
            TxnStatus txnStatus = TxnStatus.fromString(rs.getString(1));
            return txnStatus;
        }
    }

    private boolean isTxnsOpenAndNotReadOnly(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " AND \"TXN_TYPE\" != " + TxnType.READ_ONLY.getValue() + " AND ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        long count = 0L;
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                if (!rs.next()) continue;
                count += rs.getLong(1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return count == (long)txnIds.size();
    }

    private String getAbortedAndReadOnlyTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    TxnStatus txnState = TxnStatus.fromString(rs.getString(2));
                    TxnType txnType = TxnType.findByValue(rs.getInt(3));
                    if (txnState != TxnStatus.OPEN) {
                        txnInfo.append("{").append(txnId).append(",").append((Object)txnState).append("}");
                        continue;
                    }
                    if (txnType != TxnType.READ_ONLY) continue;
                    txnInfo.append("{").append(txnId).append(",read-only}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private String getCommittedTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"CTC_TXNID\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"CTC_TXNID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <" + query + ">");
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    txnInfo.append("{").append(txnId).append(",c}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private static void raiseTxnUnexpectedState(TxnStatus actualStatus, long txnid) throws NoSuchTxnException, TxnAbortedException {
        switch (actualStatus) {
            case ABORTED: {
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
            case COMMITTED: {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
            }
            case UNKNOWN: {
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
            }
            case OPEN: {
                throw new NoSuchTxnException(JavaUtils.txnIdToString(txnid) + " is " + (Object)((Object)TxnStatus.OPEN));
            }
        }
        throw new IllegalArgumentException("Unknown TxnStatus " + (Object)((Object)actualStatus));
    }

    private static void ensureValidTxn(Connection dbConn, long txnid, Statement stmt) throws SQLException, NoSuchTxnException, TxnAbortedException {
        String s = "SELECT \"TXN_STATE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = "SELECT COUNT(*) FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_TXNID\" = " + txnid;
                ResultSet rs2 = stmt.executeQuery(s);
                Throwable throwable = null;
                try {
                    try {
                        boolean alreadyCommitted = rs2.next() && rs2.getInt(1) > 0;
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        if (alreadyCommitted) {
                            throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
                        }
                        throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (TxnStatus.fromString(rs.getString(1)) == TxnStatus.ABORTED) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockInfo getTxnIdFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        ResultSet rs;
        Statement stmt;
        block3: {
            LockInfo lockInfo;
            stmt = null;
            rs = null;
            try {
                stmt = dbConn.createStatement();
                String s = "SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_TXNID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) break block3;
                lockInfo = null;
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                throw throwable;
            }
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
            return lockInfo;
        }
        LockInfo info = new LockInfo(rs);
        LOG.debug("getTxnIdFromLockId(" + extLockId + ") Return " + JavaUtils.txnIdToString(info.txnId));
        LockInfo lockInfo = info;
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        return lockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LockInfo> getLockInfoFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_TXNID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            boolean sawAtLeastOne = false;
            ArrayList<LockInfo> ourLockInfo = new ArrayList<LockInfo>();
            while (rs.next()) {
                ourLockInfo.add(new LockInfo(rs));
                sawAtLeastOne = true;
            }
            if (!sawAtLeastOne) {
                throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString(extLockId) + ") existed but now we can't find it!");
            }
            ArrayList<LockInfo> arrayList = ourLockInfo;
            return arrayList;
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void timeOutLocks(Connection dbConn) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            String s = "SELECT DISTINCT \"HL_LOCK_EXT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < " + TxnDbUtil.getEpochFn(dbProduct) + "-" + this.timeout + " AND \"HL_TXNID\" = 0";
            ArrayList<Long> extLockIDs = new ArrayList<Long>();
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                extLockIDs.add(rs.getLong(1));
            }
            rs.close();
            dbConn.commit();
            if (extLockIDs.size() <= 0) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                return;
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < ");
            prefix.append(TxnDbUtil.getEpochFn(dbProduct)).append("-").append(this.timeout);
            prefix.append(" AND \"HL_TXNID\" = 0 AND ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, extLockIDs, "\"HL_LOCK_EXT_ID\"", true, false);
            int deletedLocks = 0;
            for (String query : queries) {
                LOG.debug("Removing expired locks via: " + query);
                deletedLocks += stmt.executeUpdate(query);
            }
            if (deletedLocks > 0) {
                Collections.sort(extLockIDs);
                LOG.info("Deleted " + deletedLocks + " int locks from HIVE_LOCKS due to timeout (HL_LOCK_EXT_ID list:  " + extLockIDs + ")");
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            TxnHandler.close(rs);
        }
        catch (SQLException ex) {
            LOG.error("Failed to purge timedout locks due to: " + TxnHandler.getMessage(ex), (Throwable)ex);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                LOG.error("Failed to purge timedout locks due to: " + ex2.getMessage(), (Throwable)ex2);
                return;
            }
        }
        finally {
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
        }
        TxnHandler.closeStmt(stmt);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public void performTimeOuts() {
        dbConn = null;
        stmt = null;
        rs = null;
        try {
            dbConn = this.getDbConn(2);
            this.timeOutLocks(dbConn);
lbl7:
            // 2 sources

            while (true) {
                stmt = dbConn.createStatement();
                s = " \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)TxnStatus.OPEN + " AND (\"TXN_TYPE\" != " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnDbUtil.getEpochFn(TxnHandler.dbProduct) + "-" + this.timeout + " OR  \"TXN_TYPE\" = " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnDbUtil.getEpochFn(TxnHandler.dbProduct) + "-" + this.replicationTxnTimeout + ")";
                s = TxnHandler.sqlGenerator.addLimitClause(500000, s);
                TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) ** GOTO lbl-1000
                ** GOTO lbl26
                break;
            }
        }
        catch (SQLException ex) {
            TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
        catch (MetaException e) {
            try {
                TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable var10_12) {
                TxnHandler.close(rs, stmt, dbConn);
                throw var10_12;
            }
lbl26:
            // 1 sources

            TxnHandler.close(rs, stmt, dbConn);
            return;
lbl-1000:
            // 1 sources

            {
                timedOutTxns = new ArrayList<ArrayList<E>>();
                currentBatch = new ArrayList<Long>(50000);
                timedOutTxns.add(currentBatch);
                do {
                    if (currentBatch.size() == 50000) {
                        currentBatch = new ArrayList<E>(50000);
                        timedOutTxns.add(currentBatch);
                    }
                    currentBatch.add(rs.getLong(1));
                } while (rs.next());
                dbConn.commit();
                TxnHandler.close(rs, stmt, null);
                numTxnsAborted = 0;
                for (List var9_11 : timedOutTxns) {
                    if (this.abortTxns(dbConn, var9_11, true, true) == var9_11.size()) {
                        dbConn.commit();
                        numTxnsAborted += var9_11.size();
                        Collections.sort(var9_11);
                        TxnHandler.LOG.info("Aborted the following transactions due to timeout: " + var9_11.toString());
                        continue;
                    }
                    dbConn.rollback();
                }
                TxnHandler.LOG.info("Aborted " + numTxnsAborted + " transactions due to timeout");
                ** continue;
            }
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException {
        block9: {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                block8: {
                    try {
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        String s = "SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
                        LOG.debug("Going to execute query <" + s + ">");
                        rs = stmt.executeQuery(s);
                        if (!rs.next()) {
                            LOG.error("Transaction database not properly configured, can't find txn_state from TXNS.");
                            break block8;
                        }
                        Long numOpen = rs.getLong(1);
                        if (numOpen > Integer.MAX_VALUE) {
                            LOG.error("Open transaction count above 2147483647, can't count that high!");
                            break block8;
                        }
                        this.numOpenTxns.set(numOpen.intValue());
                    }
                    catch (SQLException e) {
                        try {
                            LOG.debug("Going to rollback");
                            TxnHandler.rollbackDBConn(dbConn);
                            LOG.info("Failed to update number of open transactions");
                            this.checkRetryable(dbConn, e, "countOpenTxns()");
                        }
                        catch (Throwable throwable) {
                            TxnHandler.close(rs, stmt, dbConn);
                            throw throwable;
                        }
                        TxnHandler.close(rs, stmt, dbConn);
                        break block9;
                    }
                }
                TxnHandler.close(rs, stmt, dbConn);
            }
            catch (RetryException e) {
                this.countOpenTxns();
            }
        }
    }

    private static synchronized DataSource setupJdbcConnectionPool(Configuration conf, int maxPoolSize, long getConnectionTimeoutMs) throws SQLException {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull(conf);
        if (dsp != null) {
            doRetryOnConnPool = dsp.mayReturnClosedConnection();
            return dsp.create(conf);
        }
        String connectionPooler = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        if ("none".equals(connectionPooler)) {
            LOG.info("Choosing not to pool JDBC connections");
            return new NoPoolConnectionPool(conf);
        }
        throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
    }

    static boolean isRetryable(Configuration conf, Exception ex) {
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            if ("08S01".equalsIgnoreCase(sqlException.getSQLState())) {
                return true;
            }
            if ("ORA-08176".equalsIgnoreCase(sqlException.getSQLState()) || sqlException.getMessage().contains("consistent read failure; rollback data not available")) {
                return true;
            }
            String regex = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TXN_RETRYABLE_SQLEX_REGEX);
            if (regex != null && !regex.isEmpty()) {
                String[] patterns = regex.split(",(?=\\S)");
                String message = TxnHandler.getMessage((SQLException)ex);
                for (String p : patterns) {
                    if (!Pattern.matches(p, message)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateKeyError(SQLException ex) {
        switch (dbProduct) {
            case DERBY: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            case MYSQL: {
                if (ex.getErrorCode() != 1022 && ex.getErrorCode() != 1062 && ex.getErrorCode() != 1586 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (ex.getErrorCode() != 2627 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case ORACLE: {
                if (ex.getErrorCode() != 1 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case POSTGRES: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected DB type: " + (Object)((Object)dbProduct) + "; " + TxnHandler.getMessage(ex));
            }
        }
        return false;
    }

    private static String getMessage(SQLException ex) {
        return ex.getMessage() + " (SQLState=" + ex.getSQLState() + ", ErrorCode=" + ex.getErrorCode() + ")";
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    static String quoteChar(char c) {
        return "'" + c + "'";
    }

    static CompactionType dbCompactionType2ThriftType(char dbValue) {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
        }
        LOG.warn("Unexpected compaction type " + dbValue);
        return null;
    }

    static Character thriftCompactionType2DbType(CompactionType ct) {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
        }
        LOG.warn("Unexpected compaction type " + ct);
        return null;
    }

    private void lockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.lock();
        }
    }

    private void unlockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.unlock();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public TxnStore.MutexAPI getMutexAPI() {
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean needToCloseConn = true;
        try {
            LockHandleImpl lockHandleImpl;
            block15: {
                try {
                    String sqlStmt = sqlGenerator.addForUpdateClause("SELECT \"MT_COMMENT\" FROM \"AUX_TABLE\" WHERE \"MT_KEY1\"=" + TxnHandler.quoteString(key) + " and \"MT_KEY2\"=0");
                    this.lockInternal();
                    dbConn = this.getDbConn(2, connPoolMutex);
                    stmt = dbConn.createStatement();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("About to execute SQL: " + sqlStmt);
                    }
                    if (!(rs = stmt.executeQuery(sqlStmt)).next()) {
                        TxnHandler.close(rs);
                        try {
                            stmt.executeUpdate("INSERT INTO \"AUX_TABLE\" (\"MT_KEY1\", \"MT_KEY2\") VALUES(" + TxnHandler.quoteString(key) + ", 0)");
                            dbConn.commit();
                        }
                        catch (SQLException ex) {
                            if (!this.isDuplicateKeyError(ex)) {
                                throw new RuntimeException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex), ex);
                            }
                            dbConn.rollback();
                        }
                        rs = stmt.executeQuery(sqlStmt);
                        if (!rs.next()) {
                            throw new IllegalStateException("Unable to lock " + TxnHandler.quoteString(key) + ".  Expected row in AUX_TABLE is missing.");
                        }
                    }
                    Semaphore derbySemaphore = null;
                    if (dbProduct == DatabaseProduct.DERBY) {
                        derbyKey2Lock.putIfAbsent(key, new Semaphore(1));
                        derbySemaphore = derbyKey2Lock.get(key);
                        derbySemaphore.acquire();
                    }
                    LOG.debug(TxnHandler.quoteString(key) + " locked by " + TxnHandler.quoteString(hostname));
                    needToCloseConn = false;
                    lockHandleImpl = new LockHandleImpl(dbConn, stmt, rs, key, derbySemaphore);
                    if (!needToCloseConn) break block15;
                }
                catch (SQLException ex) {
                    try {
                        this.checkRetryable(dbConn, ex, "acquireLock(" + key + ")");
                        throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex) + "; " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
                        catch (InterruptedException ex2) {
                            throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + ex2.getMessage() + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex2));
                        }
                    }
                    catch (Throwable throwable) {
                        if (needToCloseConn) {
                            TxnHandler.rollbackDBConn(dbConn);
                            TxnHandler.close(rs, stmt, dbConn);
                        }
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
            }
            this.unlockInternal();
            return lockHandleImpl;
        }
        catch (RetryException ex) {
            return this.acquireLock(key);
        }
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) {
        throw new NotImplementedException();
    }

    static {
        doRetryOnConnPool = false;
        maxOpenTxns = 0;
        tooManyOpenTxns = false;
        derbyLock = new ReentrantLock(true);
        derbyKey2Lock = new ConcurrentHashMap();
        hostname = JavaUtils.hostname();
    }

    private static class NoPoolConnectionPool
    implements DataSource {
        private final Configuration conf;
        private Driver driver;
        private String connString;
        private String user;
        private String passwd;

        public NoPoolConnectionPool(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.user == null) {
                this.user = DataSourceProvider.getMetastoreJdbcUser(this.conf);
                this.passwd = DataSourceProvider.getMetastoreJdbcPasswd(this.conf);
            }
            return this.getConnection(this.user, this.passwd);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.driver == null) {
                String driverName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECTION_DRIVER);
                if (driverName == null || driverName.equals("")) {
                    String msg = "JDBC driver for transaction db not set in configuration file, need to set " + MetastoreConf.ConfVars.CONNECTION_DRIVER.getVarname();
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                try {
                    LOG.info("Going to load JDBC driver " + driverName);
                    this.driver = (Driver)Class.forName(driverName).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unable to instantiate driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to access driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to find driver " + driverName + ", " + e.getMessage(), e);
                }
                this.connString = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECT_URL_KEY);
            }
            try {
                LOG.info("Connecting to transaction db with connection string " + this.connString);
                Properties connectionProps = new Properties();
                connectionProps.setProperty("user", username);
                connectionProps.setProperty("password", password);
                Connection conn = this.driver.connect(this.connString, connectionProps);
                conn.setAutoCommit(false);
                return conn;
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to connect to transaction manager using " + this.connString + ", " + e.getMessage(), e);
            }
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LockHandleImpl
    implements TxnStore.MutexAPI.LockHandle {
        private final Connection dbConn;
        private final Statement stmt;
        private final ResultSet rs;
        private final Semaphore derbySemaphore;
        private final List<String> keys = new ArrayList<String>();

        LockHandleImpl(Connection conn, Statement stmt, ResultSet rs, String key, Semaphore derbySemaphore) {
            this.dbConn = conn;
            this.stmt = stmt;
            this.rs = rs;
            this.derbySemaphore = derbySemaphore;
            if (derbySemaphore != null) assert (derbySemaphore.availablePermits() == 0) : "Expected locked Semaphore";
            this.keys.add(key);
        }

        void addKey(String key) {
            throw new NotImplementedException();
        }

        @Override
        public void releaseLocks() {
            TxnHandler.rollbackDBConn(this.dbConn);
            TxnHandler.close(this.rs, this.stmt, this.dbConn);
            if (this.derbySemaphore != null) {
                this.derbySemaphore.release();
            }
            for (String key : this.keys) {
                LOG.debug(TxnHandler.quoteString(key) + " unlocked by " + TxnHandler.quoteString(hostname));
            }
        }
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static class LockInfoComparator
    implements Comparator<LockInfo>,
    Serializable {
        private LockTypeComparator lockTypeComparator = new LockTypeComparator();

        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            int sortByType = this.lockTypeComparator.compare(info1.type, info2.type);
            if (sortByType != 0) {
                return sortByType;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        private final long extLockId;
        private final long intLockId;
        private final long txnId;
        private final String db;
        private final String table;
        private final String partition;
        private final LockState state;
        private final LockType type;

        LockInfo(ResultSet rs) throws SQLException, MetaException {
            this.extLockId = rs.getLong("HL_LOCK_EXT_ID");
            this.intLockId = rs.getLong("HL_LOCK_INT_ID");
            this.db = rs.getString("HL_DB");
            String t = rs.getString("HL_TABLE");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("HL_PARTITION");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("HL_LOCK_STATE").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock state " + rs.getString("HL_LOCK_STATE").charAt(0));
                }
            }
            char lockChar = rs.getString("HL_LOCK_TYPE").charAt(0);
            this.type = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
            this.txnId = rs.getLong("HL_TXNID");
        }

        LockInfo(ShowLocksResponseElement e) {
            this.extLockId = e.getLockid();
            this.intLockId = e.getLockIdInternal();
            this.txnId = e.getTxnid();
            this.db = e.getDbname();
            this.table = e.getTablename();
            this.partition = e.getPartname();
            this.state = e.getState();
            this.type = e.getType();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString(this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }

        private boolean isDbLock() {
            return this.db != null && this.table == null && this.partition == null;
        }

        private boolean isTableLock() {
            return this.db != null && this.table != null && this.partition == null;
        }

        private boolean isPartitionLock() {
            return !this.isDbLock() && !this.isTableLock();
        }
    }

    protected class RetryException
    extends Exception {
        protected RetryException() {
        }
    }

    private static class LockInfoExt
    extends LockInfo {
        private final ShowLocksResponseElement e;

        LockInfoExt(ShowLocksResponseElement e) {
            super(e);
            this.e = e;
        }
    }

    private static final class ConnectionLockIdPair {
        private final Connection dbConn;
        private final long extLockId;

        private ConnectionLockIdPair(Connection dbConn, long extLockId) {
            this.dbConn = dbConn;
            this.extLockId = extLockId;
        }
    }
}

