/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class HiveStrictManagedUtils {
    private static final String AVRO_SERDE_CLASSNAME = "org.apache.hadoop.hive.serde2.avro.AvroSerDe";
    private static final String AVRO_SCHEMA_URL_PROPERTY = "avro.schema.url";

    public static void validateStrictManagedTableWithThrow(Configuration conf, Table table) throws MetaException {
        String reason = HiveStrictManagedUtils.validateStrictManagedTable(conf, table);
        if (reason != null) {
            throw new MetaException(reason);
        }
    }

    public static String validateStrictManagedTable(Configuration conf, Table table) {
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.STRICT_MANAGED_TABLES)) {
            if (table.isTemporary()) {
                return null;
            }
            TableType tableType = TableType.valueOf(table.getTableType());
            if (tableType == TableType.MANAGED_TABLE) {
                if (!MetaStoreUtils.isTransactionalTable(table.getParameters())) {
                    return HiveStrictManagedUtils.createValidationError(table, "Table is marked as a managed table but is not transactional.");
                }
                if (MetaStoreUtils.isNonNativeTable(table)) {
                    return HiveStrictManagedUtils.createValidationError(table, "Table is marked as a managed table but is non-native.");
                }
                if (HiveStrictManagedUtils.isAvroTableWithExternalSchema(table)) {
                    return HiveStrictManagedUtils.createValidationError(table, "Managed Avro table has externally defined schema.");
                }
            } else if (tableType == TableType.EXTERNAL_TABLE && MetaStoreUtils.isTransactionalTable(table.getParameters())) {
                return HiveStrictManagedUtils.createValidationError(table, "Table is marked as a external table but it is transactional.");
            }
        }
        return null;
    }

    public static boolean isAvroTableWithExternalSchema(Table table) {
        String schemaUrl;
        return table.getSd().getSerdeInfo().getSerializationLib().equals(AVRO_SERDE_CLASSNAME) && (schemaUrl = table.getParameters().get(AVRO_SCHEMA_URL_PROPERTY)) != null && !schemaUrl.isEmpty();
    }

    public static boolean isListBucketedTable(Table table) {
        return table.getSd().isStoredAsSubDirectories();
    }

    private static String createValidationError(Table table, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("Table ");
        sb.append(table.getDbName());
        sb.append(".");
        sb.append(table.getTableName());
        sb.append(" failed strict managed table checks due to the following reason: ");
        sb.append(message);
        return sb.toString();
    }
}

