/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.session.SessionState;

public class DDLOperationContext {
    private final Hive db;
    private final HiveConf conf;
    private final Context context;
    private final MetaDataFormatter formatter;
    private final DDLTask task;
    private final DDLWork work;
    private final QueryState queryState;
    private final QueryPlan queryPlan;
    private final SessionState.LogHelper console;

    public DDLOperationContext(HiveConf conf, Context context, DDLTask task, DDLWork work, QueryState queryState, QueryPlan queryPlan, SessionState.LogHelper console) throws HiveException {
        this.db = Hive.get(conf);
        this.conf = conf;
        this.context = context;
        this.formatter = MetaDataFormatUtils.getFormatter(conf);
        this.task = task;
        this.work = work;
        this.queryState = queryState;
        this.queryPlan = queryPlan;
        this.console = console;
    }

    public Hive getDb() {
        return this.db;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Context getContext() {
        return this.context;
    }

    public MetaDataFormatter getFormatter() {
        return this.formatter;
    }

    public DDLTask getTask() {
        return this.task;
    }

    public DDLWork getWork() {
        return this.work;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public SessionState.LogHelper getConsole() {
        return this.console;
    }
}

