/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.function.macro.drop;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.macro.drop.DropMacroDesc;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={880})
public class DropMacroAnalyzer
extends BaseSemanticAnalyzer {
    public DropMacroAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean throwException;
        String macroName = root.getChild(0).getText();
        if (FunctionUtils.isQualifiedFunctionName(macroName)) {
            throw new SemanticException("Temporary macro name cannot be a qualified name.");
        }
        boolean ifExists = root.getFirstChildWithType(922) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        if (throwException && FunctionRegistry.getFunctionInfo(macroName) == null) {
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(macroName));
        }
        DropMacroDesc desc = new DropMacroDesc(macroName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        Database database = this.getDatabase("default");
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
    }
}

