/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.msck;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.AbstractFunctionAnalyzer;
import org.apache.hadoop.hive.ql.ddl.misc.msck.MsckDesc;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

@DDLSemanticAnalyzerFactory.DDLType(types={962})
public class MsckAnalyzer
extends AbstractFunctionAnalyzer {
    public MsckAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0) {
            throw new SemanticException("MSCK command must have arguments");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        boolean repair = root.getChild(0).getType() == 270;
        int offset = repair ? 1 : 0;
        String tableName = MsckAnalyzer.getUnescapedName((ASTNode)root.getChild(0 + offset));
        boolean addPartitions = true;
        boolean dropPartitions = false;
        if (root.getChildCount() > 1 + offset) {
            addPartitions = this.isMsckAddPartition(root.getChild(1 + offset).getType());
            dropPartitions = this.isMsckDropPartition(root.getChild(1 + offset).getType());
        }
        Table table = this.getTable(tableName);
        Map<Integer, List<ExprNodeGenericFuncDesc>> partitionSpecs = ParseUtils.getFullPartitionSpecs(root, table, this.conf, false);
        byte[] filterExp = null;
        if (partitionSpecs != null & !partitionSpecs.isEmpty()) {
            String expressionProxyClass = this.conf.get(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname());
            if (!PartitionExpressionForMetastore.class.getCanonicalName().equals(expressionProxyClass)) {
                throw new SemanticException("Invalid expression proxy class. The config metastore.expression.proxy needs to be set to org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore");
            }
            filterExp = SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)((List)partitionSpecs.values().toArray()[0]).get(0));
        }
        if (repair && AcidUtils.isTransactionalTable(table)) {
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
        } else {
            this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_SHARED));
        }
        MsckDesc desc = new MsckDesc(tableName, filterExp, this.ctx.getResFile(), repair, addPartitions, dropPartitions);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }

    private boolean isMsckAddPartition(int type) {
        return type == 315 || type == 29;
    }

    private boolean isMsckDropPartition(int type) {
        return type == 315 || type == 115;
    }
}

